/* wmpasman
 * Copyright © 1999-2014  Brad Jorsch <anomie@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SECUREENTRY_H
#define SECUREENTRY_H

#include <gtk/gtk.h>

#define SECRET_API_SUBJECT_TO_CHANGE "Grr..."
#include <libsecret/secret.h>

G_BEGIN_DECLS

#define TYPE_SECURE_ENTRY_BUFFER         (secure_entry_buffer_get_type())
#define SECURE_ENTRY_BUFFER(o)           (G_TYPE_CHECK_INSTANCE_CAST((o), TYPE_SECURE_ENTRY_BUFFER, SecureEntryBuffer))
#define SECURE_ENTRY_BUFFER_CLASS(c)     (G_TYPE_CHECK_CLASS_CAST((c), TYPE_SECURE_ENTRY_BUFFER, SecureEntryBufferClass))
#define IS_SECURE_ENTRY_BUFFER(o)        (G_TYPE_CHECK_INSTANCE_TYPE((o), TYPE_SECURE_ENTRY_BUFFER))
#define IS_SECURE_ENTRY_BUFFER_CLASS(c)  (G_TYPE_CHECK_CLASS_TYPE((c), TYPE_SECURE_ENTRY_BUFFER))
#define SECURE_ENTRY_BUFFER_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS((o), TYPE_SECURE_ENTRY_BUFFER, SecureEntryBufferClass))

typedef struct _SecureEntryBuffer        SecureEntryBuffer;
typedef struct _SecureEntryBufferClass   SecureEntryBufferClass;

struct _SecureEntryBuffer {
    GtkEntryBuffer parent;
    gboolean allow_insecure_memory;
    SecretValue *data;
    gsize datalen, blen, clen;
};

struct _SecureEntryBufferClass {
    GtkEntryBufferClass parent_class;
};

GType secure_entry_buffer_get_type(void) G_GNUC_CONST;

GtkEntryBuffer *secure_entry_buffer_new(void);
gboolean secure_entry_buffer_get_allow_insecure_memory(GtkEntryBuffer *buf);
void secure_entry_buffer_set_allow_insecure_memory(GtkEntryBuffer *buf, gboolean allow);
SecretValue *secure_entry_buffer_get_secret_value(SecureEntryBuffer *buf);

G_END_DECLS

#endif
