/*
 * Decompiled with CFR 0.152.
 */
package jwbroek.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogUtil {
    private static final Logger logger = Logger.getLogger(LogUtil.class.getCanonicalName());

    private LogUtil() {
        logger.entering(LogUtil.class.getCanonicalName(), "TrackCutterCommand()");
        logger.warning("jwbroek.util.LogUtil should not be instantiated.");
        logger.exiting(LogUtil.class.getCanonicalName(), "TrackCutterCommand()");
    }

    public static void logStacktrace(Logger logger, Level level, Throwable throwable) {
        LogUtil.logger.entering(LogUtil.class.getCanonicalName(), "logStacktrace(Logger,Level,Throwable)", new Object[]{logger, level, throwable});
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        logger.log(level, stringWriter.toString());
        LogUtil.logger.exiting(LogUtil.class.getCanonicalName(), "logStacktrace(Logger,Level,Throwable)");
    }

    public static Level getActiveLoggingLevel(Logger logger) {
        LogUtil.logger.entering(LogUtil.class.getCanonicalName(), "getActiveLoggingLevel(Logger)", logger);
        Logger logger2 = logger;
        Level level = null;
        do {
            level = logger.getLevel();
            logger2 = logger2.getUseParentHandlers() ? logger2.getParent() : null;
        } while (level == null && logger2 != null);
        LogUtil.logger.exiting(LogUtil.class.getCanonicalName(), "getActiveLoggingLevel(Logger)", level);
        return level;
    }

    public static boolean hasHandlerActive(Logger logger, Level level, Class clazz) {
        LogUtil.logger.entering(LogUtil.class.getCanonicalName(), "hasHandlerActive(Logger,Level,Class)", new Object[]{logger, level, clazz});
        Logger logger2 = logger;
        boolean bl = false;
        block0: while (logger2 != null && logger2.isLoggable(level)) {
            for (Handler handler : logger2.getHandlers()) {
                if (!clazz.isInstance(handler) || handler.getLevel().intValue() > level.intValue()) continue;
                bl = true;
                break block0;
            }
            if (logger2.getUseParentHandlers()) {
                logger2 = logger2.getParent();
                continue;
            }
            logger2 = null;
        }
        LogUtil.logger.exiting(LogUtil.class.getCanonicalName(), "hasHandlerActive(Logger,Level,Class)", bl);
        return bl;
    }

    public static Set<Handler> getAllActiveHandlers(Logger logger) {
        LogUtil.logger.entering(LogUtil.class.getCanonicalName(), "getAllActiveHandlers(Logger)", logger);
        HashSet<Handler> hashSet = new HashSet<Handler>();
        Logger logger2 = logger;
        while (logger2 != null) {
            hashSet.addAll(Arrays.asList(logger2.getHandlers()));
            if (logger2.getUseParentHandlers()) {
                logger2 = logger2.getParent();
                continue;
            }
            logger2 = null;
        }
        LogUtil.logger.exiting(LogUtil.class.getCanonicalName(), "getAllActiveHandlers(Logger)", hashSet);
        return hashSet;
    }
}

