/*
 * Decompiled with CFR 0.152.
 */
package net.pms;

import com.sun.jna.Platform;
import java.awt.Component;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.BindException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.LogManager;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.pms.Messages;
import net.pms.configuration.Build;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaDatabase;
import net.pms.dlna.RootFolder;
import net.pms.dlna.virtual.MediaLibrary;
import net.pms.encoders.Player;
import net.pms.encoders.PlayerFactory;
import net.pms.external.ExternalFactory;
import net.pms.external.ExternalListener;
import net.pms.formats.Format;
import net.pms.formats.FormatFactory;
import net.pms.io.BasicSystemUtils;
import net.pms.io.MacSystemUtils;
import net.pms.io.OutputParams;
import net.pms.io.OutputTextConsumer;
import net.pms.io.ProcessWrapperImpl;
import net.pms.io.SolarisUtils;
import net.pms.io.SystemUtils;
import net.pms.io.WinUtils;
import net.pms.logging.FrameAppender;
import net.pms.logging.LoggingConfigFileLoader;
import net.pms.network.HTTPServer;
import net.pms.network.ProxyServer;
import net.pms.network.UPNPHelper;
import net.pms.newgui.DummyFrame;
import net.pms.newgui.IFrame;
import net.pms.newgui.LooksFrame;
import net.pms.newgui.ProfileChooser;
import net.pms.update.AutoUpdater;
import net.pms.util.FileUtil;
import net.pms.util.ProcessUtil;
import net.pms.util.PropertiesUtil;
import net.pms.util.SystemErrWrapper;
import net.pms.util.TaskRunner;
import net.pms.util.Version;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMS {
    private static final String SCROLLBARS = "scrollbars";
    private static final String NATIVELOOK = "nativelook";
    private static final String CONSOLE = "console";
    private static final String NOCONSOLE = "noconsole";
    private static final String PROFILES = "profiles";
    private static Boolean isHeadless;
    @Deprecated
    public static String VERSION;
    public static final String AVS_SEPARATOR = "\u0001";
    private static final Logger logger;
    private static PmsConfiguration configuration;
    private String uuid;
    private static String helpPage;
    private static PMS instance;
    @Deprecated
    public static final SimpleDateFormat sdfDate;
    @Deprecated
    public static final SimpleDateFormat sdfHour;
    private final ArrayList<RendererConfiguration> foundRenderers = new ArrayList();
    private HTTPServer server;
    private String serverName;
    private ProxyServer proxyServer;
    public ArrayList<Process> currentProcesses = new ArrayList();
    private IFrame frame;
    private SystemUtils registry;
    private final PrintStream stderr = System.err;
    private DLNAMediaDatabase database;
    private MediaLibrary mediaLibrary;

    public IFrame getFrame() {
        return this.frame;
    }

    public RootFolder getRootFolder(RendererConfiguration renderer) {
        if (renderer == null) {
            renderer = RendererConfiguration.getDefaultConf();
        }
        return renderer.getRootFolder();
    }

    @Deprecated
    public void setRendererfound(RendererConfiguration renderer) {
        this.setRendererFound(renderer);
    }

    public void setRendererFound(RendererConfiguration renderer) {
        if (!this.foundRenderers.contains(renderer) && !renderer.isFDSSDP()) {
            this.foundRenderers.add(renderer);
            this.frame.addRendererIcon(renderer.getRank(), renderer.getRendererName(), renderer.getRendererIcon());
            this.frame.setStatusCode(0, Messages.getString("PMS.18"), "apply-220.png");
        }
    }

    public ProxyServer getProxy() {
        return this.proxyServer;
    }

    private PMS() {
    }

    public SystemUtils getRegistry() {
        return this.registry;
    }

    private boolean checkProcessExistence(String name, boolean error, File workDir, String ... params) throws Exception {
        logger.debug("launching: " + params[0]);
        try {
            ProcessBuilder pb = new ProcessBuilder(params);
            if (workDir != null) {
                pb.directory(workDir);
            }
            final Process process = pb.start();
            OutputTextConsumer stderrConsumer = new OutputTextConsumer(process.getErrorStream(), false);
            stderrConsumer.start();
            OutputTextConsumer outConsumer = new OutputTextConsumer(process.getInputStream(), false);
            outConsumer.start();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ProcessUtil.waitFor(process);
                }
            };
            Thread checkThread = new Thread(r, "PMS Checker");
            checkThread.start();
            checkThread.join(60000L);
            checkThread.interrupt();
            checkThread = null;
            if (params[0].equals("vlc") && stderrConsumer.getResults().get(0).startsWith("VLC")) {
                return true;
            }
            if (params[0].equals("ffmpeg") && stderrConsumer.getResults().get(0).startsWith("FF")) {
                return true;
            }
            int exit = process.exitValue();
            if (exit != 0) {
                if (error) {
                    logger.info("[" + exit + "] Cannot launch " + name + " / Check the presence of " + params[0] + " ...");
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            if (error) {
                logger.error("Cannot launch " + name + " / Check the presence of " + params[0] + " ...", e);
            }
            return false;
        }
    }

    private void initializeDatabase() {
        this.database = new DLNAMediaDatabase("medias");
        this.database.init(false);
    }

    public synchronized DLNAMediaDatabase getDatabase() {
        if (configuration.getUseCache()) {
            if (this.database == null) {
                this.initializeDatabase();
            }
            return this.database;
        }
        return null;
    }

    private String getPathPermissions(String path) {
        File file = new File(path);
        String permissions = file.exists() ? (file.isFile() ? String.format("%s%s", FileUtil.isFileReadable(file) ? "r" : "-", FileUtil.isFileWritable(file) ? "w" : "-") : String.format("%s%s", FileUtil.isDirectoryReadable(file) ? "r" : "-", FileUtil.isDirectoryWritable(file) ? "w" : "-")) : "file not found";
        return permissions;
    }

    private void displayBanner() throws IOException {
        logger.info("Starting " + PropertiesUtil.getProjectProperties().get("project.name") + " " + PMS.getVersion());
        logger.info("by shagrath / 2008-2013");
        logger.info("http://ps3mediaserver.org");
        logger.info("https://github.com/ps3mediaserver/ps3mediaserver");
        logger.info("");
        String commitId = PropertiesUtil.getProjectProperties().get("git.commit.id");
        String commitTime = PropertiesUtil.getProjectProperties().get("git.commit.time");
        String shortCommitId = commitId.substring(0, 9);
        logger.info("Build: " + shortCommitId + " (" + commitTime + ")");
        this.logSystemInfo();
        String cwd = new File("").getAbsolutePath();
        logger.info("Working directory: " + cwd);
        logger.info("Temp directory: " + configuration.getTempFolder());
        File javaTmpdir = new File(System.getProperty("java.io.tmpdir"));
        if (!FileUtil.isDirectoryWritable(javaTmpdir)) {
            logger.error("The Java temp directory \"{}\" is not writable for PMS!", (Object)javaTmpdir.getAbsolutePath());
            logger.error("Please make sure the directory is writable for user \"{}\"", (Object)System.getProperty("user.name"));
            throw new IOException("Cannot write to Java temp directory");
        }
        logger.info("Logging config file: {}", (Object)LoggingConfigFileLoader.getConfigFilePath());
        HashMap<String, String> lfps = LoggingConfigFileLoader.getLogFilePaths();
        if (lfps != null && lfps.size() > 0) {
            if (lfps.size() == 1) {
                Map.Entry<String, String> entry = lfps.entrySet().iterator().next();
                logger.info(String.format("%s: %s", entry.getKey(), entry.getValue()));
            } else {
                logger.info("Logging to multiple files:");
                for (Map.Entry<String, String> entry : lfps.entrySet()) {
                    logger.info(String.format("%s: %s", entry.getKey(), entry.getValue()));
                }
            }
        }
        String profilePath = configuration.getProfilePath();
        String profileDirectoryPath = configuration.getProfileDirectory();
        logger.info("");
        logger.info("Profile directory: {}", (Object)profileDirectoryPath);
        logger.info("Profile directory permissions: {}", (Object)this.getPathPermissions(profileDirectoryPath));
        logger.info("Profile path: {}", (Object)profilePath);
        logger.info("Profile permissions: {}", (Object)this.getPathPermissions(profilePath));
        logger.info("Profile name: {}", (Object)configuration.getProfileName());
        String webConfPath = configuration.getWebConfPath();
        logger.info("");
        logger.info("Web conf path: {}", (Object)webConfPath);
        logger.info("Web conf permissions: {}", (Object)this.getPathPermissions(webConfPath));
        logger.info("");
    }

    private boolean init() throws Exception {
        File dvrsMsffmpegmuxer;
        VERSION = PMS.getVersion();
        this.displayBanner();
        AutoUpdater autoUpdater = null;
        if (Build.isUpdatable()) {
            String serverURL = Build.getUpdateServerURL();
            autoUpdater = new AutoUpdater(serverURL, PMS.getVersion());
        }
        this.registry = this.createSystemUtils();
        if (!PMS.isHeadless()) {
            this.frame = new LooksFrame(autoUpdater, configuration);
        } else {
            logger.info("GUI environment not available");
            logger.info("Switching to console mode");
            this.frame = new DummyFrame();
        }
        FrameAppender.setFrame(this.frame);
        configuration.addConfigurationListener(new ConfigurationListener(){

            @Override
            public void configurationChanged(ConfigurationEvent event) {
                if (!event.isBeforeUpdate() && PmsConfiguration.NEED_RELOAD_FLAGS.contains(event.getPropertyName())) {
                    PMS.this.frame.setReloadable(true);
                }
            }
        });
        this.frame.setStatusCode(0, Messages.getString("PMS.130"), "connect_no-220.png");
        RendererConfiguration.loadRendererConfigurations(configuration);
        logger.info("Checking MPlayer font cache. It can take a minute or so.");
        this.checkProcessExistence("MPlayer", true, null, configuration.getMplayerPath(), "dummy");
        if (Platform.isWindows()) {
            this.checkProcessExistence("MPlayer", true, configuration.getTempFolder(), configuration.getMplayerPath(), "dummy");
        }
        logger.info("Done!");
        if (this.registry.isAvis() && this.registry.getAvsPluginsDir() != null) {
            logger.info("Found AviSynth plugins dir: " + this.registry.getAvsPluginsDir().getAbsolutePath());
            File vsFilterdll = new File(this.registry.getAvsPluginsDir(), "VSFilter.dll");
            if (!vsFilterdll.exists()) {
                logger.info("VSFilter.dll is not in the AviSynth plugins directory. This can cause problems when trying to play subtitled videos with AviSynth");
            }
        }
        String vlcVersion = this.registry.getVlcVersion();
        String vlcPath = this.registry.getVlcPath();
        if (vlcVersion != null && vlcPath != null) {
            logger.info("Found VLC version " + vlcVersion + " at: " + vlcPath);
            Version vlc = new Version(vlcVersion);
            Version requiredVersion = new Version("2.0.2");
            if (vlc.compareTo(requiredVersion) <= 0) {
                logger.error("Only VLC versions 2.0.2 and above are supported");
            }
        }
        if (this.registry.isKerioFirewall()) {
            logger.info("Detected Kerio firewall");
        }
        if ((dvrsMsffmpegmuxer = new File("win32/dvrms/ffmpeg_MPGMUX.exe")).exists()) {
            configuration.setFfmpegAlternativePath(dvrsMsffmpegmuxer.getAbsolutePath());
        }
        LogManager.getLogManager().readConfiguration(new ByteArrayInputStream("org.jaudiotagger.level=OFF".getBytes()));
        System.setErr(new PrintStream(new SystemErrWrapper(), true));
        this.server = new HTTPServer(configuration.getServerPort());
        try {
            ExternalFactory.lookup();
        }
        catch (Exception e) {
            logger.error("Error loading plugins", e);
        }
        Player.initializeFinalizeTranscoderArgsListeners();
        PlayerFactory.initialize(configuration);
        ExternalFactory.instantiateLateListeners();
        this.frame.addEngines();
        boolean binding = false;
        try {
            binding = this.server.start();
        }
        catch (BindException b) {
            logger.info("FATAL ERROR: Unable to bind on port: " + configuration.getServerPort() + ", because: " + b.getMessage());
            logger.info("Maybe another process is running or the hostname is wrong.");
        }
        new Thread("Connection Checker"){

            @Override
            public void run() {
                try {
                    Thread.sleep(7000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (PMS.this.foundRenderers.isEmpty()) {
                    PMS.this.frame.setStatusCode(0, Messages.getString("PMS.0"), "messagebox_critical-220.png");
                } else {
                    PMS.this.frame.setStatusCode(0, Messages.getString("PMS.18"), "apply-220.png");
                }
            }
        }.start();
        if (!binding) {
            return false;
        }
        if (configuration.getUseCache()) {
            this.initializeDatabase();
            this.mediaLibrary = new MediaLibrary();
            logger.info("A tiny cache admin interface is available at: http://" + this.server.getHost() + ":" + this.server.getPort() + "/console/home");
        }
        this.getRootFolder(RendererConfiguration.getDefaultConf());
        this.frame.serverReady();
        Runtime.getRuntime().addShutdownHook(new Thread("PMS Listeners Stopper"){

            @Override
            public void run() {
                try {
                    for (ExternalListener l : ExternalFactory.getExternalListeners()) {
                        l.shutdown();
                    }
                    UPNPHelper.shutDownListener();
                    UPNPHelper.sendByeBye();
                    logger.debug("Forcing shutdown of all active processes");
                    for (Process p : PMS.this.currentProcesses) {
                        try {
                            p.exitValue();
                        }
                        catch (IllegalThreadStateException ise) {
                            logger.trace("Forcing shutdown of process: " + p);
                            ProcessUtil.destroy(p);
                        }
                    }
                    PMS.get().getServer().stop();
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.debug("Caught exception", e);
                }
            }
        });
        UPNPHelper.sendAlive();
        logger.trace("Waiting 250 milliseconds...");
        Thread.sleep(250L);
        UPNPHelper.listen();
        return true;
    }

    public MediaLibrary getLibrary() {
        return this.mediaLibrary;
    }

    private SystemUtils createSystemUtils() {
        if (Platform.isWindows()) {
            return new WinUtils();
        }
        if (Platform.isMac()) {
            return new MacSystemUtils();
        }
        if (Platform.isSolaris()) {
            return new SolarisUtils();
        }
        return new BasicSystemUtils();
    }

    public boolean installWin32Service() {
        logger.info(Messages.getString("PMS.41"));
        String[] cmdArray = new String[]{"win32/service/wrapper.exe", "-r", "wrapper.conf"};
        OutputParams output = new OutputParams(configuration);
        output.noexitcheck = true;
        ProcessWrapperImpl pwuninstall = new ProcessWrapperImpl(cmdArray, output);
        pwuninstall.runInSameThread();
        cmdArray = new String[]{"win32/service/wrapper.exe", "-i", "wrapper.conf"};
        ProcessWrapperImpl pwInstall = new ProcessWrapperImpl(cmdArray, new OutputParams(configuration));
        pwInstall.runInSameThread();
        return pwInstall.isSuccess();
    }

    @Deprecated
    public File[] getFoldersConf(boolean log) {
        return this.getFoldersConf();
    }

    public File[] getFoldersConf() {
        String[] foldersArray;
        String folders = PMS.getConfiguration().getFolders();
        if (folders == null || folders.length() == 0) {
            return null;
        }
        ArrayList<File> directories = new ArrayList<File>();
        for (String folder : foldersArray = folders.split(",")) {
            folder = folder.replaceAll("&comma;", ",");
            logger.info("Checking shared folder: " + folder);
            File file = new File(folder);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    logger.warn("The file " + folder + " is not a directory! Please remove it from your Shared folders list on the Navigation/Share Settings tab");
                }
            } else {
                logger.warn("The directory " + folder + " does not exist. Please remove it from your Shared folders list on the Navigation/Share Settings tab");
            }
            directories.add(file);
        }
        File[] f = new File[directories.size()];
        directories.toArray(f);
        return f;
    }

    public void reset() {
        TaskRunner.getInstance().submitNamed("restart", true, new Runnable(){

            @Override
            public void run() {
                try {
                    logger.trace("Waiting 1 second...");
                    UPNPHelper.sendByeBye();
                    PMS.this.server.stop();
                    PMS.this.server = null;
                    RendererConfiguration.resetAllRenderers();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        logger.trace("Caught exception", e);
                    }
                    PMS.this.server = new HTTPServer(configuration.getServerPort());
                    PMS.this.server.start();
                    UPNPHelper.sendAlive();
                    PMS.this.frame.setReloadable(false);
                }
                catch (IOException e) {
                    logger.error("error during restart :" + e.getMessage(), e);
                }
            }
        });
    }

    @Deprecated
    public static void debug(String msg) {
        logger.trace(msg);
    }

    @Deprecated
    public static void info(String msg) {
        logger.debug(msg);
    }

    @Deprecated
    public static void minimal(String msg) {
        logger.info(msg);
    }

    @Deprecated
    public static void error(String msg, Throwable t) {
        logger.error(msg, t);
    }

    public synchronized String usn() {
        if (this.uuid == null) {
            this.uuid = PMS.getConfiguration().getUuid();
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID().toString();
                logger.info("Generated new random UUID: {}", (Object)this.uuid);
                PMS.getConfiguration().setUuid(this.uuid);
                try {
                    PMS.getConfiguration().save();
                }
                catch (ConfigurationException e) {
                    logger.error("Failed to save configuration with new UUID", e);
                }
            }
            logger.info("Using the following UUID configured in PMS.conf: {}", (Object)this.uuid);
        }
        return "uuid:" + this.uuid;
    }

    public String getServerName() {
        if (this.serverName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(System.getProperty("os.name").replace(" ", "_"));
            sb.append("-");
            sb.append(System.getProperty("os.arch").replace(" ", "_"));
            sb.append("-");
            sb.append(System.getProperty("os.version").replace(" ", "_"));
            sb.append(", UPnP/1.0, PMS/" + PMS.getVersion());
            this.serverName = sb.toString();
        }
        return this.serverName;
    }

    public static PMS get() {
        if (instance == null) {
            PMS.createInstance();
        }
        return instance;
    }

    private static synchronized void createInstance() {
        assert (instance == null);
        instance = new PMS();
        try {
            if (instance.init()) {
                logger.info("The server should now appear on your renderer");
            } else {
                logger.error("A serious error occurred during PMS init");
            }
        }
        catch (Exception e) {
            logger.error("A serious error occurred during PMS init", e);
        }
    }

    @Deprecated
    public Format getAssociatedFormat(String filename) {
        return FormatFactory.getAssociatedFormat(filename);
    }

    public static void main(String[] args) throws IOException, ConfigurationException {
        block14: {
            boolean displayProfileChooser;
            block13: {
                displayProfileChooser = false;
                if (args.length > 0) {
                    for (int a = 0; a < args.length; ++a) {
                        if (args[a].equals(CONSOLE)) {
                            System.setProperty(CONSOLE, Boolean.toString(true));
                            continue;
                        }
                        if (args[a].equals(NATIVELOOK)) {
                            System.setProperty(NATIVELOOK, Boolean.toString(true));
                            continue;
                        }
                        if (args[a].equals(SCROLLBARS)) {
                            System.setProperty(SCROLLBARS, Boolean.toString(true));
                            continue;
                        }
                        if (args[a].equals(NOCONSOLE)) {
                            System.setProperty(NOCONSOLE, Boolean.toString(true));
                            continue;
                        }
                        if (!args[a].equals(PROFILES)) continue;
                        displayProfileChooser = true;
                    }
                }
                try {
                    Toolkit.getDefaultToolkit();
                    if (PMS.isHeadless() && System.getProperty(NOCONSOLE) == null) {
                        System.setProperty(CONSOLE, Boolean.toString(true));
                    }
                }
                catch (Throwable t) {
                    System.err.println("Toolkit error: " + t.getClass().getName() + ": " + t.getMessage());
                    if (System.getProperty(NOCONSOLE) != null) break block13;
                    System.setProperty(CONSOLE, Boolean.toString(true));
                }
            }
            if (!PMS.isHeadless() && displayProfileChooser) {
                ProfileChooser.display();
            }
            try {
                PMS.setConfiguration(new PmsConfiguration());
                assert (PMS.getConfiguration() != null);
                LoggingConfigFileLoader.load();
                PMS.createInstance();
            }
            catch (Throwable t) {
                String errorMessage = String.format("Configuration error: %s: %s", t.getClass().getName(), t.getMessage());
                System.err.println(errorMessage);
                t.printStackTrace();
                if (PMS.isHeadless() || instance == null) break block14;
                JOptionPane.showMessageDialog((JFrame)SwingUtilities.getWindowAncestor((Component)((Object)instance.getFrame())), errorMessage, Messages.getString("PMS.42"), 0);
            }
        }
    }

    public HTTPServer getServer() {
        return this.server;
    }

    public void save() {
        try {
            configuration.save();
        }
        catch (ConfigurationException e) {
            logger.error("Could not save configuration", e);
        }
    }

    public void storeFileInCache(File file, int formatType) {
        if (PMS.getConfiguration().getUseCache() && !this.getDatabase().isDataExists(file.getAbsolutePath(), file.lastModified())) {
            this.getDatabase().insertData(file.getAbsolutePath(), file.lastModified(), formatType, null);
        }
    }

    public static PmsConfiguration getConfiguration() {
        return configuration;
    }

    public static void setConfiguration(PmsConfiguration conf) {
        configuration = conf;
    }

    public static String getVersion() {
        return PropertiesUtil.getProjectProperties().get("project.version");
    }

    private void logSystemInfo() {
        String osVersion;
        String[] versionNumbers;
        long memoryInMB = Runtime.getRuntime().maxMemory() / 0x100000L;
        logger.info("Java: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.version") + " by " + System.getProperty("java.vendor"));
        logger.info("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        logger.info("Encoding: " + System.getProperty("file.encoding"));
        logger.info("Memory: " + memoryInMB + " " + Messages.getString("StatusTab.12"));
        logger.info("");
        if (Platform.isMac() && (versionNumbers = (osVersion = System.getProperty("os.version")).split("\\.")).length > 1) {
            try {
                int osVersionMinor = Integer.parseInt(versionNumbers[1]);
                if (osVersionMinor < 6) {
                    logger.warn("-----------------------------------------------------------------");
                    logger.warn("WARNING!");
                    logger.warn("PMS ships with binaries compiled for Mac OS X 10.6 or higher.");
                    logger.warn("You are running an older version of Mac OS X so PMS may not work!");
                    logger.warn("More information in the FAQ:");
                    logger.warn("http://www.ps3mediaserver.org/forum/viewtopic.php?f=6&t=3507&p=66371#p66371");
                    logger.warn("-----------------------------------------------------------------");
                    logger.warn("");
                }
            }
            catch (NumberFormatException e) {
                logger.debug("Cannot parse minor os.version number");
            }
        }
    }

    public static synchronized boolean isHeadless() {
        if (isHeadless == null) {
            if (System.getProperty(CONSOLE) != null) {
                isHeadless = true;
            } else {
                try {
                    JDialog d = new JDialog();
                    d.dispose();
                    isHeadless = false;
                }
                catch (Throwable throwable) {
                    isHeadless = true;
                }
            }
        }
        return isHeadless;
    }

    public static void setHelpPage(String page) {
        helpPage = page;
    }

    public static String getHelpPage() {
        return helpPage;
    }

    static {
        logger = LoggerFactory.getLogger(PMS.class);
        helpPage = "index.html";
        instance = null;
        sdfDate = new SimpleDateFormat("HH:mm:ss.SSS", Locale.US);
        sdfHour = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
    }
}

