/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.ZippedEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZippedFile
extends DLNAResource {
    private static final Logger logger = LoggerFactory.getLogger(ZippedFile.class);
    private File file;
    private ZipFile zip;

    public ZippedFile(File file) {
        this.file = file;
        this.setLastModified(file.lastModified());
        try {
            this.zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> enm = this.zip.entries();
            while (enm.hasMoreElements()) {
                ZipEntry ze = enm.nextElement();
                this.addChild(new ZippedEntry(file, ze.getName(), ze.getSize()));
            }
            this.zip.close();
        }
        catch (ZipException e) {
            logger.error("Error reading zip file", e);
        }
        catch (IOException e) {
            logger.error("Error reading zip file", e);
        }
    }

    @Override
    protected String getThumbnailURL() {
        if (this.getType() == 2) {
            return null;
        }
        return super.getThumbnailURL();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new ZipInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Deprecated
    public long lastModified() {
        return 0L;
    }

    @Override
    public String getSystemName() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean isValid() {
        return this.file.exists();
    }
}

