/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.pms.io.BufferedOutputFile;
import net.pms.io.OutputConsumer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputTextLogger
extends OutputConsumer {
    private static final Logger logger = LoggerFactory.getLogger(OutputTextLogger.class);

    public OutputTextLogger(InputStream inputStream) {
        super(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        LineIterator it = null;
        try {
            it = IOUtils.lineIterator(this.inputStream, "UTF-8");
            while (it.hasNext()) {
                String line = it.nextLine();
                logger.debug(line);
            }
        }
        catch (IOException ioe) {
            logger.debug("Error consuming input stream: {}", (Object)ioe.getMessage());
            LineIterator.closeQuietly(it);
        }
        catch (IllegalStateException ise) {
            logger.debug("Error reading from closed input stream: {}", (Object)ise.getMessage());
            {
                catch (Throwable throwable) {
                    LineIterator.closeQuietly(it);
                    throw throwable;
                }
            }
            LineIterator.closeQuietly(it);
        }
        LineIterator.closeQuietly(it);
    }

    @Override
    public BufferedOutputFile getBuffer() {
        return null;
    }

    @Override
    public List<String> getResults() {
        return null;
    }
}

