/*
 * Decompiled with CFR 0.152.
 */
package net.pms.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.util.PropertiesUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class LoggingConfigFileLoader {
    private static String filepath = null;
    private static HashMap<String, String> logFilePaths = new HashMap();
    private static final PmsConfiguration configuration = PMS.getConfiguration();

    public static String getConfigFilePath() {
        if (filepath != null) {
            return filepath;
        }
        return "internal defaults";
    }

    public static void load() {
        String logFilePath;
        File logFile = null;
        if (PMS.isHeadless()) {
            logFilePath = StringUtils.replace(PropertiesUtil.getProjectProperties().get("project.logback.headless"), "[PROFILE_DIR]", configuration.getProfileDirectory());
            if (StringUtils.isNotBlank(logFilePath)) {
                logFile = new File(logFilePath);
            }
        } else {
            logFilePath = StringUtils.replace(PropertiesUtil.getProjectProperties().get("project.logback"), "[PROFILE_DIR]", configuration.getProfileDirectory());
            if (StringUtils.isNotBlank(logFilePath)) {
                logFile = new File(logFilePath);
            }
        }
        if (logFile == null || !logFile.canRead()) {
            logFile = PMS.isHeadless() ? new File("logback.headless.xml") : new File("logback.xml");
        }
        if (!logFile.canRead()) {
            return;
        }
        ILoggerFactory ilf = LoggerFactory.getILoggerFactory();
        if (!(ilf instanceof LoggerContext)) {
            return;
        }
        LoggerContext lc = (LoggerContext)ilf;
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(lc);
            lc.reset();
            configurator.doConfigure(logFile);
            filepath = logFile.getAbsolutePath();
        }
        catch (JoranException je) {
            je.printStackTrace();
        }
        for (Logger logger : lc.getLoggerList()) {
            Iterator<Appender<ILoggingEvent>> it = logger.iteratorForAppenders();
            while (it.hasNext()) {
                Appender<ILoggingEvent> ap = it.next();
                if (!(ap instanceof FileAppender)) continue;
                FileAppender fa = (FileAppender)ap;
                logFilePaths.put(fa.getName(), fa.getFile());
            }
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings(lc);
    }

    public static HashMap<String, String> getLogFilePaths() {
        return logFilePaths;
    }
}

