/*
 * Decompiled with CFR 0.152.
 */
package net.pms.newgui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.jna.Platform;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAMediaDatabase;
import net.pms.newgui.LooksFrame;
import net.pms.newgui.RestrictedFileSystemView;
import net.pms.util.FormLayoutUtil;
import net.pms.util.KeyedComboBoxModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavigationShareTab {
    private static final Logger logger = LoggerFactory.getLogger(NavigationShareTab.class);
    public static final String ALL_DRIVES = Messages.getString("FoldTab.0");
    private static final String PANEL_COL_SPEC = "left:pref, 50dlu, pref, 150dlu, pref, 25dlu, pref, 25dlu, pref, default:grow";
    private static final String PANEL_ROW_SPEC = "p, 3dlu,  p, 3dlu, p, 3dlu,  p, 3dlu, p, 3dlu, p, 8dlu, p, 3dlu,  p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 8dlu, fill:default:grow";
    private static final String SHARED_FOLDER_COL_SPEC = "left:pref, left:pref, pref, pref, pref, 0:grow";
    private static final String SHARED_FOLDER_ROW_SPEC = "p, 3dlu, p, 3dlu, fill:default:grow";
    private JList FList;
    private DefaultListModel df;
    private JCheckBox hidevideosettings;
    private JCheckBox hidetranscode;
    private JCheckBox hidemedialibraryfolder;
    private JCheckBox hideextensions;
    private JCheckBox hideemptyfolders;
    private JCheckBox hideengines;
    private JButton but5;
    private JTextField seekpos;
    private JCheckBox thumbgenCheckBox;
    private JCheckBox mplayer_thumb;
    private JCheckBox dvdiso_thumb;
    private JCheckBox image_thumb;
    private JCheckBox cacheenable;
    private JCheckBox archive;
    private JComboBox sortmethod;
    private JComboBox audiothumbnail;
    private JTextField defaultThumbFolder;
    private JCheckBox iphoto;
    private JCheckBox aperture;
    private JCheckBox itunes;
    private JButton select;
    private JButton cachereset;
    private final PmsConfiguration configuration;

    public DefaultListModel getDf() {
        return this.df;
    }

    NavigationShareTab(PmsConfiguration configuration) {
        this.configuration = configuration;
    }

    private void updateModel() {
        if (this.df.size() == 1 && this.df.getElementAt(0).equals(ALL_DRIVES)) {
            this.configuration.setFolders("");
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.df.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                String entry = (String)this.df.getElementAt(i);
                sb.append(entry.replace(",", "&comma;"));
            }
            this.configuration.setFolders(sb.toString());
        }
    }

    public JComponent build() {
        Locale locale = new Locale(this.configuration.getLanguage());
        ComponentOrientation orientation = ComponentOrientation.getOrientation(locale);
        String colSpec = FormLayoutUtil.getColSpec(PANEL_COL_SPEC, orientation);
        FormLayout layout = new FormLayout(colSpec, PANEL_ROW_SPEC);
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(Borders.DLU4_BORDER);
        builder.setOpaque(true);
        CellConstraints cc = new CellConstraints();
        this.initSimpleComponents(cc);
        PanelBuilder builderSharedFolder = this.initSharedFoldersGuiComponents(cc);
        JComponent cmp = builder.addSeparator(Messages.getString("FoldTab.13"), FormLayoutUtil.flip(cc.xyw(1, 1, 10), colSpec, orientation));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        builder.add((Component)this.thumbgenCheckBox, FormLayoutUtil.flip(cc.xyw(1, 3, 3), colSpec, orientation));
        builder.addLabel(Messages.getString("NetworkTab.16"), FormLayoutUtil.flip(cc.xyw(4, 3, 3), colSpec, orientation));
        builder.add((Component)this.seekpos, FormLayoutUtil.flip(cc.xyw(6, 3, 1), colSpec, orientation));
        builder.add((Component)this.mplayer_thumb, FormLayoutUtil.flip(cc.xyw(1, 5, 3), colSpec, orientation));
        builder.add((Component)this.dvdiso_thumb, FormLayoutUtil.flip(cc.xyw(3, 5, 3), colSpec, orientation));
        builder.add((Component)this.image_thumb, FormLayoutUtil.flip(cc.xyw(1, 7, 3), colSpec, orientation));
        builder.addLabel(Messages.getString("FoldTab.26"), FormLayoutUtil.flip(cc.xyw(1, 9, 3), colSpec, orientation));
        builder.add((Component)this.audiothumbnail, FormLayoutUtil.flip(cc.xyw(4, 9, 3), colSpec, orientation));
        builder.addLabel(Messages.getString("FoldTab.27"), FormLayoutUtil.flip(cc.xyw(1, 11, 1), colSpec, orientation));
        builder.add((Component)this.defaultThumbFolder, FormLayoutUtil.flip(cc.xyw(4, 11, 3), colSpec, orientation));
        builder.add((Component)this.select, FormLayoutUtil.flip(cc.xyw(7, 11, 1), colSpec, orientation));
        cmp = builder.addSeparator(Messages.getString("NetworkTab.15"), FormLayoutUtil.flip(cc.xyw(1, 13, 10), colSpec, orientation));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        builder.add((Component)this.archive, FormLayoutUtil.flip(cc.xyw(1, 15, 3), colSpec, orientation));
        builder.add((Component)this.hidevideosettings, FormLayoutUtil.flip(cc.xyw(4, 15, 2), colSpec, orientation));
        builder.add((Component)this.hidetranscode, FormLayoutUtil.flip(cc.xyw(7, 15, 4), colSpec, orientation));
        builder.add((Component)this.hideextensions, FormLayoutUtil.flip(cc.xyw(1, 17, 3), colSpec, orientation));
        builder.add((Component)this.hideengines, FormLayoutUtil.flip(cc.xyw(4, 17, 2), colSpec, orientation));
        builder.add((Component)this.hideemptyfolders, FormLayoutUtil.flip(cc.xyw(7, 17, 4), colSpec, orientation));
        builder.add((Component)this.itunes, FormLayoutUtil.flip(cc.xyw(1, 19, 3), colSpec, orientation));
        builder.add((Component)this.iphoto, FormLayoutUtil.flip(cc.xyw(4, 19, 2), colSpec, orientation));
        builder.add((Component)this.aperture, FormLayoutUtil.flip(cc.xyw(7, 19, 4), colSpec, orientation));
        builder.add((Component)this.cacheenable, FormLayoutUtil.flip(cc.xy(1, 21), colSpec, orientation));
        builder.add((Component)this.cachereset, FormLayoutUtil.flip(cc.xyw(4, 21, 2), colSpec, orientation));
        builder.add((Component)this.hidemedialibraryfolder, FormLayoutUtil.flip(cc.xyw(7, 21, 4), colSpec, orientation));
        builder.addLabel(Messages.getString("FoldTab.18"), FormLayoutUtil.flip(cc.xyw(1, 23, 3), colSpec, orientation));
        builder.add((Component)this.sortmethod, FormLayoutUtil.flip(cc.xyw(4, 23, 3), colSpec, orientation));
        builder.add((Component)builderSharedFolder.getPanel(), FormLayoutUtil.flip(cc.xyw(1, 27, 10), colSpec, orientation));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(orientation);
        JScrollPane scrollPane = new JScrollPane(panel, 20, 30);
        return scrollPane;
    }

    private void initSimpleComponents(CellConstraints cc) {
        this.thumbgenCheckBox = new JCheckBox(Messages.getString("NetworkTab.2"));
        this.thumbgenCheckBox.setContentAreaFilled(false);
        this.thumbgenCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setThumbnailGenerationEnabled(e.getStateChange() == 1);
            }
        });
        if (this.configuration.isThumbnailGenerationEnabled()) {
            this.thumbgenCheckBox.setSelected(true);
        }
        this.seekpos = new JTextField("" + this.configuration.getThumbnailSeekPos());
        this.seekpos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    int ab = Integer.parseInt(NavigationShareTab.this.seekpos.getText());
                    NavigationShareTab.this.configuration.setThumbnailSeekPos(ab);
                }
                catch (NumberFormatException nfe) {
                    logger.debug("Could not parse thumbnail seek position from \"" + NavigationShareTab.this.seekpos.getText() + "\"");
                }
            }
        });
        this.mplayer_thumb = new JCheckBox(Messages.getString("FoldTab.14"));
        this.mplayer_thumb.setContentAreaFilled(false);
        this.mplayer_thumb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setUseMplayerForVideoThumbs(e.getStateChange() == 1);
            }
        });
        if (this.configuration.isUseMplayerForVideoThumbs()) {
            this.mplayer_thumb.setSelected(true);
        }
        this.dvdiso_thumb = new JCheckBox(Messages.getString("FoldTab.19"));
        this.dvdiso_thumb.setContentAreaFilled(false);
        this.dvdiso_thumb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setDvdIsoThumbnails(e.getStateChange() == 1);
            }
        });
        if (this.configuration.isDvdIsoThumbnails()) {
            this.dvdiso_thumb.setSelected(true);
        }
        this.image_thumb = new JCheckBox(Messages.getString("FoldTab.21"));
        this.image_thumb.setContentAreaFilled(false);
        this.image_thumb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setImageThumbnailsEnabled(e.getStateChange() == 1);
            }
        });
        if (this.configuration.getImageThumbnailsEnabled()) {
            this.image_thumb.setSelected(true);
        }
        final KeyedComboBoxModel thumbKCBM = new KeyedComboBoxModel(new Object[]{"0", "1", "2"}, new Object[]{Messages.getString("FoldTab.35"), Messages.getString("FoldTab.23"), Messages.getString("FoldTab.24")});
        this.audiothumbnail = new JComboBox(thumbKCBM);
        this.audiothumbnail.setEditable(false);
        thumbKCBM.setSelectedKey("" + this.configuration.getAudioThumbnailMethod());
        this.audiothumbnail.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        NavigationShareTab.this.configuration.setAudioThumbnailMethod(Integer.parseInt((String)thumbKCBM.getSelectedKey()));
                    }
                    catch (NumberFormatException nfe) {
                        logger.debug("Could not parse audio thumbnail method from \"" + thumbKCBM.getSelectedKey() + "\"");
                    }
                }
            }
        });
        this.defaultThumbFolder = new JTextField(this.configuration.getAlternateThumbFolder());
        this.defaultThumbFolder.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                NavigationShareTab.this.configuration.setAlternateThumbFolder(NavigationShareTab.this.defaultThumbFolder.getText());
            }
        });
        this.select = new JButton("...");
        this.select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = null;
                try {
                    chooser = new JFileChooser();
                }
                catch (Exception ee) {
                    chooser = new JFileChooser(new RestrictedFileSystemView());
                }
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showDialog((Component)e.getSource(), Messages.getString("FoldTab.28"));
                if (returnVal == 0) {
                    NavigationShareTab.this.defaultThumbFolder.setText(chooser.getSelectedFile().getAbsolutePath());
                    NavigationShareTab.this.configuration.setAlternateThumbFolder(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.hidevideosettings = new JCheckBox(Messages.getString("FoldTab.6"));
        this.hidevideosettings.setContentAreaFilled(false);
        if (this.configuration.getHideVideoSettings()) {
            this.hidevideosettings.setSelected(true);
        }
        this.hidevideosettings.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setHideVideoSettings(e.getStateChange() == 1);
            }
        });
        this.hidetranscode = new JCheckBox(Messages.getString("FoldTab.33"));
        this.hidetranscode.setContentAreaFilled(false);
        if (this.configuration.getHideTranscodeEnabled()) {
            this.hidetranscode.setSelected(true);
        }
        this.hidetranscode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setHideTranscodeEnabled(e.getStateChange() == 1);
            }
        });
        this.hidemedialibraryfolder = new JCheckBox(Messages.getString("FoldTab.32"));
        this.hidemedialibraryfolder.setContentAreaFilled(false);
        if (this.configuration.isHideMediaLibraryFolder()) {
            this.hidemedialibraryfolder.setSelected(true);
        }
        this.hidemedialibraryfolder.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setHideMediaLibraryFolder(e.getStateChange() == 1);
            }
        });
        this.archive = new JCheckBox(Messages.getString("NetworkTab.1"));
        this.archive.setContentAreaFilled(false);
        this.archive.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setArchiveBrowsing(e.getStateChange() == 1);
            }
        });
        if (this.configuration.isArchiveBrowsing()) {
            this.archive.setSelected(true);
        }
        this.cachereset = new JButton(Messages.getString("NetworkTab.18"));
        this.cacheenable = new JCheckBox(Messages.getString("NetworkTab.17"));
        this.cacheenable.setContentAreaFilled(false);
        this.cacheenable.setSelected(this.configuration.getUseCache());
        this.cacheenable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setUseCache(e.getStateChange() == 1);
                NavigationShareTab.this.cachereset.setEnabled(NavigationShareTab.this.configuration.getUseCache());
                if ((LooksFrame)PMS.get().getFrame() != null) {
                    ((LooksFrame)PMS.get().getFrame()).getFt().setScanLibraryEnabled(NavigationShareTab.this.configuration.getUseCache());
                }
            }
        });
        this.cachereset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int option = JOptionPane.showConfirmDialog((Component)((Object)PMS.get().getFrame()), Messages.getString("NetworkTab.13") + Messages.getString("NetworkTab.19"), Messages.getString("Dialog.Question"), 0);
                if (option == 0) {
                    PMS.get().getDatabase().init(true);
                }
            }
        });
        this.cachereset.setEnabled(this.configuration.getUseCache());
        this.hideextensions = new JCheckBox(Messages.getString("FoldTab.5"));
        this.hideextensions.setContentAreaFilled(false);
        if (this.configuration.isHideExtensions()) {
            this.hideextensions.setSelected(true);
        }
        this.hideextensions.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setHideExtensions(e.getStateChange() == 1);
            }
        });
        this.hideengines = new JCheckBox(Messages.getString("FoldTab.8"));
        this.hideengines.setContentAreaFilled(false);
        if (this.configuration.isHideEngineNames()) {
            this.hideengines.setSelected(true);
        }
        this.hideengines.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setHideEngineNames(e.getStateChange() == 1);
            }
        });
        this.hideemptyfolders = new JCheckBox(Messages.getString("FoldTab.31"));
        this.hideemptyfolders.setContentAreaFilled(false);
        if (this.configuration.isHideEmptyFolders()) {
            this.hideemptyfolders.setSelected(true);
        }
        this.hideemptyfolders.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setHideEmptyFolders(e.getStateChange() == 1);
            }
        });
        this.itunes = new JCheckBox(Messages.getString("FoldTab.30"));
        this.itunes.setContentAreaFilled(false);
        if (this.configuration.isShowItunesLibrary()) {
            this.itunes.setSelected(true);
        }
        if (!Platform.isMac() && !Platform.isWindows()) {
            this.itunes.setEnabled(false);
        }
        this.itunes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setShowItunesLibrary(e.getStateChange() == 1);
            }
        });
        this.iphoto = new JCheckBox(Messages.getString("FoldTab.29"));
        this.iphoto.setContentAreaFilled(false);
        if (this.configuration.isShowIphotoLibrary()) {
            this.iphoto.setSelected(true);
        }
        if (!Platform.isMac()) {
            this.iphoto.setEnabled(false);
        }
        this.iphoto.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setShowIphotoLibrary(e.getStateChange() == 1);
            }
        });
        this.aperture = new JCheckBox(Messages.getString("FoldTab.34"));
        this.aperture.setContentAreaFilled(false);
        if (this.configuration.isShowApertureLibrary()) {
            this.aperture.setSelected(true);
        }
        if (!Platform.isMac()) {
            this.aperture.setEnabled(false);
        }
        this.aperture.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NavigationShareTab.this.configuration.setShowApertureLibrary(e.getStateChange() == 1);
            }
        });
        final KeyedComboBoxModel kcbm = new KeyedComboBoxModel(new Object[]{"0", "4", "3", "1", "2"}, new Object[]{Messages.getString("FoldTab.15"), Messages.getString("FoldTab.22"), Messages.getString("FoldTab.20"), Messages.getString("FoldTab.16"), Messages.getString("FoldTab.17")});
        this.sortmethod = new JComboBox(kcbm);
        this.sortmethod.setEditable(false);
        kcbm.setSelectedKey("" + this.configuration.getSortMethod());
        this.sortmethod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    try {
                        NavigationShareTab.this.configuration.setSortMethod(Integer.parseInt((String)kcbm.getSelectedKey()));
                    }
                    catch (NumberFormatException nfe) {
                        logger.debug("Could not parse sort method from \"" + kcbm.getSelectedKey() + "\"");
                    }
                }
            }
        });
    }

    private PanelBuilder initSharedFoldersGuiComponents(CellConstraints cc) {
        Locale locale = new Locale(this.configuration.getLanguage());
        ComponentOrientation orientation = ComponentOrientation.getOrientation(locale);
        String colSpec = FormLayoutUtil.getColSpec(SHARED_FOLDER_COL_SPEC, orientation);
        FormLayout layoutFolders = new FormLayout(colSpec, SHARED_FOLDER_ROW_SPEC);
        PanelBuilder builderFolder = new PanelBuilder(layoutFolders);
        builderFolder.setOpaque(true);
        JComponent cmp = builderFolder.addSeparator(Messages.getString("FoldTab.7"), FormLayoutUtil.flip(cc.xyw(1, 1, 6), colSpec, orientation));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        JButton but = new JButton(LooksFrame.readImageIcon("folder_new-32.png"));
        but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = null;
                try {
                    chooser = new JFileChooser();
                }
                catch (Exception ee) {
                    chooser = new JFileChooser(new RestrictedFileSystemView());
                }
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog((Component)e.getSource());
                if (returnVal == 0) {
                    ((DefaultListModel)NavigationShareTab.this.FList.getModel()).add(NavigationShareTab.this.FList.getModel().getSize(), chooser.getSelectedFile().getAbsolutePath());
                    if (NavigationShareTab.this.FList.getModel().getElementAt(0).equals(ALL_DRIVES)) {
                        ((DefaultListModel)NavigationShareTab.this.FList.getModel()).remove(0);
                    }
                    NavigationShareTab.this.updateModel();
                }
            }
        });
        builderFolder.add((Component)but, FormLayoutUtil.flip(cc.xy(1, 3), colSpec, orientation));
        JButton but2 = new JButton(LooksFrame.readImageIcon("button_cancel-32.png"));
        but2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NavigationShareTab.this.FList.getSelectedIndex() > -1) {
                    ((DefaultListModel)NavigationShareTab.this.FList.getModel()).remove(NavigationShareTab.this.FList.getSelectedIndex());
                    if (NavigationShareTab.this.FList.getModel().getSize() == 0) {
                        ((DefaultListModel)NavigationShareTab.this.FList.getModel()).add(0, ALL_DRIVES);
                    }
                    NavigationShareTab.this.updateModel();
                }
            }
        });
        builderFolder.add((Component)but2, FormLayoutUtil.flip(cc.xy(2, 3), colSpec, orientation));
        JButton but3 = new JButton(LooksFrame.readImageIcon("kdevelop_down-32.png"));
        but3.setToolTipText(Messages.getString("FoldTab.12"));
        but3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultListModel model = (DefaultListModel)NavigationShareTab.this.FList.getModel();
                for (int i = 0; i < model.size() - 1; ++i) {
                    if (!NavigationShareTab.this.FList.isSelectedIndex(i)) continue;
                    String value = model.get(i).toString();
                    model.set(i, model.get(i + 1));
                    model.set(i + 1, value);
                    NavigationShareTab.this.FList.setSelectedIndex(i + 1);
                    NavigationShareTab.this.updateModel();
                    break;
                }
            }
        });
        builderFolder.add((Component)but3, FormLayoutUtil.flip(cc.xy(3, 3), colSpec, orientation));
        JButton but4 = new JButton(LooksFrame.readImageIcon("up-32.png"));
        but4.setToolTipText(Messages.getString("FoldTab.12"));
        but4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultListModel model = (DefaultListModel)NavigationShareTab.this.FList.getModel();
                for (int i = 1; i < model.size(); ++i) {
                    if (!NavigationShareTab.this.FList.isSelectedIndex(i)) continue;
                    String value = model.get(i).toString();
                    model.set(i, model.get(i - 1));
                    model.set(i - 1, value);
                    NavigationShareTab.this.FList.setSelectedIndex(i - 1);
                    NavigationShareTab.this.updateModel();
                    break;
                }
            }
        });
        builderFolder.add((Component)but4, FormLayoutUtil.flip(cc.xy(4, 3), colSpec, orientation));
        this.but5 = new JButton(LooksFrame.readImageIcon("search-32.png"));
        this.but5.setToolTipText(Messages.getString("FoldTab.2"));
        this.but5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DLNAMediaDatabase database;
                if (NavigationShareTab.this.configuration.getUseCache() && (database = PMS.get().getDatabase()) != null) {
                    if (!database.isScanLibraryRunning()) {
                        int option = JOptionPane.showConfirmDialog((Component)((Object)PMS.get().getFrame()), Messages.getString("FoldTab.3") + Messages.getString("FoldTab.4"), Messages.getString("Dialog.Question"), 0);
                        if (option == 0) {
                            database.scanLibrary();
                            NavigationShareTab.this.but5.setIcon(LooksFrame.readImageIcon("viewmagfit-32.png"));
                        }
                    } else {
                        int option = JOptionPane.showConfirmDialog((Component)((Object)PMS.get().getFrame()), Messages.getString("FoldTab.10"), Messages.getString("Dialog.Question"), 0);
                        if (option == 0) {
                            database.stopScanLibrary();
                            PMS.get().getFrame().setStatusLine(null);
                            NavigationShareTab.this.but5.setIcon(LooksFrame.readImageIcon("search-32.png"));
                        }
                    }
                }
            }
        });
        builderFolder.add((Component)this.but5, FormLayoutUtil.flip(cc.xy(5, 3), colSpec, orientation));
        this.but5.setEnabled(this.configuration.getUseCache());
        this.df = new DefaultListModel();
        File[] folders = PMS.get().getFoldersConf();
        if (folders != null && folders.length > 0) {
            for (File file : folders) {
                this.df.addElement(file.getAbsolutePath());
            }
        } else {
            this.df.addElement(ALL_DRIVES);
        }
        this.FList = new JList();
        this.FList.setModel(this.df);
        JScrollPane pane = new JScrollPane(this.FList);
        builderFolder.add((Component)pane, FormLayoutUtil.flip(cc.xyw(1, 5, 6), colSpec, orientation));
        return builderFolder;
    }

    public void setScanLibraryEnabled(boolean enabled) {
        this.but5.setEnabled(enabled);
        this.but5.setIcon(LooksFrame.readImageIcon("search-32.png"));
    }
}

