/*
 * Decompiled with CFR 0.152.
 */
package net.pms.newgui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import net.pms.Messages;
import net.pms.configuration.PmsConfiguration;
import net.pms.newgui.ImagePanel;
import net.pms.newgui.LooksFrame;
import net.pms.util.FormLayoutUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusTab {
    private static final Logger logger = LoggerFactory.getLogger(StatusTab.class);
    private static final int MAX_RENDERERS = 10;
    private ImagePanel imagePanel;
    private PmsConfiguration configuration;
    private ImagePanel[] renderers = new ImagePanel[10];
    private JLabel[] rendererLabels = new JLabel[10];
    private int numRenderers;
    private JLabel jl;
    private JProgressBar jpb;
    private JLabel jio;
    private long rc = 0L;
    private long peak;
    private DecimalFormat formatter = new DecimalFormat("#,###");

    StatusTab(PmsConfiguration configuration) {
        this.configuration = configuration;
    }

    public JProgressBar getJpb() {
        return this.jpb;
    }

    public JLabel getJl() {
        return this.jl;
    }

    public ImagePanel getImagePanel() {
        return this.imagePanel;
    }

    public JComponent build() {
        Locale locale = new Locale(this.configuration.getLanguage());
        ComponentOrientation orientation = ComponentOrientation.getOrientation(locale);
        String colSpec = FormLayoutUtil.getColSpec("0:grow, pref, 0:grow", orientation);
        FormLayout layout = new FormLayout(colSpec, "pref, 9dlu, pref, 3dlu, pref, 15dlu, pref, 3dlu, p, 3dlu, p, 3dlu, p, 9dlu, p, 5dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.setOpaque(true);
        CellConstraints cc = new CellConstraints();
        JComponent cmp = builder.addSeparator(Messages.getString("StatusTab.2"), FormLayoutUtil.flip(cc.xy(2, 1), colSpec, orientation));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        this.jl = new JLabel(Messages.getString("StatusTab.3"));
        builder.add((Component)this.jl, FormLayoutUtil.flip(cc.xy(2, 3), colSpec, orientation));
        this.imagePanel = this.buildImagePanel("/resources/images/connect_no-220.png");
        builder.add((Component)this.imagePanel, FormLayoutUtil.flip(cc.xy(2, 5, "center, fill"), colSpec, orientation));
        this.jpb = new JProgressBar(0, 100);
        this.jpb.setStringPainted(true);
        this.jpb.setString(Messages.getString("StatusTab.5"));
        builder.addLabel(Messages.getString("StatusTab.6"), FormLayoutUtil.flip(cc.xy(2, 7), colSpec, orientation));
        builder.add((Component)this.jpb, FormLayoutUtil.flip(cc.xy(2, 9), colSpec, orientation));
        this.jio = new JLabel(Messages.getString("StatusTab.8"));
        builder.add((Component)this.jio, FormLayoutUtil.flip(cc.xy(2, 13), colSpec, orientation));
        cmp = builder.addSeparator(Messages.getString("StatusTab.9"), FormLayoutUtil.flip(cc.xy(2, 15), colSpec, orientation));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        FormLayout layoutRenderer = new FormLayout("0:grow, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, 0:grow", "pref, 3dlu, pref");
        PanelBuilder rendererBuilder = new PanelBuilder(layoutRenderer);
        rendererBuilder.setOpaque(true);
        for (int i = 0; i < 10; ++i) {
            this.renderers[i] = this.buildImagePanel(null);
            rendererBuilder.add((Component)this.renderers[i], cc.xy(2 + i, 1));
            this.rendererLabels[i] = new JLabel("");
            rendererBuilder.add((Component)this.rendererLabels[i], cc.xy(2 + i, 3, CellConstraints.CENTER, CellConstraints.DEFAULT));
        }
        builder.add((Component)rendererBuilder.getPanel(), cc.xy(2, 17));
        JPanel panel = builder.getPanel();
        panel.applyComponentOrientation(orientation);
        JScrollPane scrollPane = new JScrollPane(panel, 20, 30);
        return scrollPane;
    }

    public void setReadValue(long v, String msg) {
        if (v < this.rc) {
            this.rc = v;
        } else {
            int sizeinMb = (int)((v - this.rc) / 125L) / 1024;
            if ((long)sizeinMb > this.peak) {
                this.peak = sizeinMb;
            }
            this.jio.setText(Messages.getString("StatusTab.8") + this.formatter.format(sizeinMb) + " " + Messages.getString("StatusTab.11") + "    |    " + Messages.getString("StatusTab.10") + this.formatter.format(this.peak) + " " + Messages.getString("StatusTab.11"));
            this.rc = v;
        }
    }

    public ImagePanel buildImagePanel(String url) {
        BufferedImage bi = null;
        if (url != null) {
            try {
                bi = ImageIO.read(LooksFrame.class.getResourceAsStream(url));
            }
            catch (IOException e) {
                logger.debug("Caught exception", e);
            }
        }
        return new ImagePanel(bi);
    }

    public void addRendererIcon(int code, String msg, String icon) {
        BufferedImage bi = null;
        if (icon != null) {
            try {
                InputStream is = null;
                File f = new File(icon);
                if (!f.isAbsolute() && f.getParent() == null) {
                    f = new File("renderers", icon);
                }
                if (f.isFile()) {
                    is = new FileInputStream(f);
                }
                if (is == null) {
                    is = LooksFrame.class.getResourceAsStream("/resources/images/clients/" + icon);
                }
                if (is == null) {
                    is = LooksFrame.class.getResourceAsStream("/renderers/" + icon);
                }
                if (is != null) {
                    bi = ImageIO.read(is);
                }
            }
            catch (IOException e) {
                logger.debug("Caught exception", e);
            }
        }
        if (bi != null) {
            this.renderers[this.numRenderers].set(bi);
        }
        this.rendererLabels[this.numRenderers].setText(msg);
        ++this.numRenderers;
    }
}

