/*
 * Decompiled with CFR 0.152.
 */
package net.eyde.personalblog.struts.action;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.eyde.personalblog.global.GlobalData;
import net.eyde.personalblog.service.PersonalBlogService;
import net.eyde.personalblog.service.ServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public abstract class BlogGeneralAction
extends DispatchAction {
    private static Log log = LogFactory.getLog(BlogGeneralAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)"execute method at GeneralAction:");
        String state = (String)this.servlet.getServletContext().getAttribute("installation_state");
        log.debug((Object)("PersonalBlog State:" + state));
        if (state != null && !state.equals("ok")) {
            log.info((Object)"PersonalBlog needs to be initialized.");
            if (state.equals("database_off")) {
                log.info((Object)"Found database off");
                return mapping.findForward("database_off");
            }
            if (state.equals("tables_not_created_yet")) {
                log.info((Object)"tables not created yet");
                return mapping.findForward("tables_not_created");
            }
            if (state.equals("missing_properties")) {
                log.info((Object)"missing_properties");
                return mapping.findForward("missing_properties");
            }
            return mapping.findForward("initialize");
        }
        PersonalBlogService pblog = null;
        try {
            pblog = PersonalBlogService.getInstance();
        }
        catch (Exception e) {
            log.info((Object)"PersonalBlog Service couldn't be started.");
        }
        pblog.checkReferer(request.getHeader("Referer"));
        List<?> referrers = pblog.getReferrers();
        log.debug((Object)("qty of referrers:" + referrers.size()));
        this.getServlet().getServletContext().setAttribute("refer", referrers);
        List<?> comments = pblog.getRecentComments();
        if (comments != null) {
            request.setAttribute("recentcomments", comments);
        }
        this.prepareCalendar(request, pblog);
        this.setLastUsers(request);
        this.loadCategories(pblog);
        return this.executeSub(mapping, form, request, response);
    }

    private void loadCategories(PersonalBlogService pblog) {
        if (this.getServlet().getServletContext().getAttribute("cats") == null) {
            this.getServlet().getServletContext().setAttribute("cats", pblog.getCategories());
        }
    }

    private void prepareCalendar(HttpServletRequest request, PersonalBlogService pblog) throws ServiceException {
        request.setAttribute("cal", pblog.getCalendarActions(""));
        request.setAttribute("currMonth", (Object)pblog.getCurrMonth(""));
        request.setAttribute("prevMonth", (Object)pblog.getPrevMonth(""));
        request.setAttribute("nextMonth", (Object)pblog.getNextMonth(""));
        request.setAttribute("links", (Object)pblog.getLinks());
    }

    protected boolean isSignedIn(HttpServletRequest request) {
        String signedIn = (String)request.getSession().getAttribute("signedIn");
        return signedIn != null && signedIn.equals("true");
    }

    protected void setLastUsers(HttpServletRequest request) {
        int count;
        String host = request.getRemoteHost();
        if (GlobalData.getUsersMap().containsKey(host)) {
            count = GlobalData.getUsersMap().get(host);
            ++count;
        } else {
            count = 1;
        }
        GlobalData.getUsersMap().put(host, new Integer(count));
        log.info((Object)("host:" + request.getRemoteHost() + " / counter:" + count));
        request.setAttribute("iplog", GlobalData.getUsersMap());
    }

    protected String cleanNull(String val) {
        if (val == null || val.trim().equals("")) {
            return "";
        }
        return val;
    }

    public ActionForward executeSub(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String actionParameter = mapping.getParameter();
        String dispatch = request.getParameter(actionParameter);
        if (dispatch != null) {
            return this.dispatchMethod(mapping, form, request, response, dispatch);
        }
        return null;
    }

    protected void checkEmoticonsLoaded() throws Exception {
        PersonalBlogService pblog = PersonalBlogService.getInstance();
        if (this.getServlet().getServletContext().getAttribute("emoticons") == null) {
            this.getServlet().getServletContext().setAttribute("emoticons", pblog.getEmoticons());
        }
    }

    protected void removeFormBean(ActionMapping mapping, HttpServletRequest request) {
        if (mapping.getAttribute() != null) {
            if ("request".equals(mapping.getScope())) {
                request.removeAttribute(mapping.getAttribute());
            } else {
                HttpSession session = request.getSession();
                session.removeAttribute(mapping.getAttribute());
            }
        }
    }

    protected void updateFormBean(ActionMapping mapping, HttpServletRequest request, ActionForm form) {
        if (mapping.getAttribute() != null) {
            if ("request".equals(mapping.getScope())) {
                request.setAttribute(mapping.getAttribute(), (Object)form);
            } else {
                HttpSession session = request.getSession();
                session.setAttribute(mapping.getAttribute(), (Object)form);
            }
        }
    }

    protected ActionForm getActionForm(ActionMapping mapping, HttpServletRequest request) {
        ActionForm actionForm = null;
        if (mapping.getAttribute() != null) {
            if ("request".equals(mapping.getScope())) {
                actionForm = (ActionForm)request.getAttribute(mapping.getAttribute());
            } else {
                HttpSession session = request.getSession();
                actionForm = (ActionForm)session.getAttribute(mapping.getAttribute());
            }
        }
        return actionForm;
    }

    protected ActionForward forwardInput(ActionMapping mapping) {
        return new ActionForward(mapping.getInput());
    }

    protected ActionForward forwardSuccess(ActionMapping mapping) {
        return mapping.findForward("success");
    }

    protected ActionForward forwardFailure(ActionMapping mapping) {
        return mapping.findForward("failure");
    }

    protected ActionForward forwardCancel(ActionMapping mapping) {
        return mapping.findForward("cancel");
    }

    protected HttpServletResponse setCookies(HttpServletRequest request, HttpServletResponse response, String name, String value, int expiry) throws IOException {
        Cookie cookie = new Cookie(name, value);
        cookie.setSecure(false);
        cookie.setPath("/");
        cookie.setMaxAge(expiry);
        response.addCookie(cookie);
        return response;
    }

    protected HttpServletResponse deleteCookies(HttpServletRequest request, HttpServletResponse response, String name) {
        Cookie cookie = this.getCookies(request, response, name);
        if (cookie == null) {
            return response;
        }
        cookie.setMaxAge(0);
        cookie.setPath("/");
        response.addCookie(cookie);
        return response;
    }

    protected Cookie getCookies(HttpServletRequest request, HttpServletResponse response, String name) {
        Cookie[] cookies = request.getCookies();
        Cookie cookie = null;
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                Cookie thisCookie = cookies[i];
                if (thisCookie.getName().equals(name) && !thisCookie.getValue().equals("")) {
                    cookie = thisCookie;
                    break;
                }
                ++i;
            }
        }
        return cookie;
    }
}

