#include <stdio.h>
#include <stdlib.h>

static void out_of_memory(void);

/* Linux doesn't support fgetln() *sigh*
 * Credits of this implementation:  GED2HTML by Eugene W. Stark
 * http://www.gendex.com/ged2html/2.5b/Welcome.html
 *
 * Cygwin doesn't support it either...but it's also lacking a number
 * of other essential functions
 */

char *fgetln(FILE *f, size_t *size)
{
   static char *l = NULL;
   char *lp;
   static int max = 4;
   int s = 0, c;
   
    
   if(l == NULL) {
     if((l = malloc(max)) == NULL)
   	   out_of_memory();
   }
   if(feof(f) || ferror(f)) {
     *size = 0;
     return(NULL);
   }
   lp = l;
   while((c = fgetc(f)) != EOF) {
     if(s >= max-1) {
        max = 2*max;
        if((l = realloc(l, max)) == NULL)
          out_of_memory();
        lp = l + s;   
     }
     *lp++ = c;
     s++;
     if(c == '\n')
        break;
   }
   *lp++ = '\0';
   *size = s;
   if(s == 0)
     return(NULL);
   return(l);
}

static void out_of_memory(void)
{
  fprintf(stderr, "Insufficient memory available for processing.\n");
  exit(1);
}
