package depaware

import (
	"reflect"
	"strings"
	"testing"
)

func TestParsePreferredWhy(t *testing.T) {
	// in here is intentionally sloppy.
	// It is testing edge cases, etc.
	in := `
github.com/tailscale/depaware dependencies: (generated by github.com/tailscale/depaware)

	github.com/pkg/diff                                          from github.com/tailscale/depaware/depaware
github.com/pkg/diff/ctxt                                     from github.com/pkg/diff
	LW    github.com/go-multierror/multierror                          from tailscale.com/wgengine/router
	L 💣 github.com/godbus/dbus/v5                                    from tailscale.com/wgengine/router/dns
		 github.com/golang/groupcache/lru                             from tailscale.com/wgengine/filter+
	  💣 github.com/tailscale/wireguard-go/conn                       from github.com/tailscale/wireguard-go/device+
from
a from
from b
1234
gibberish and a half 
	`
	want := map[string]string{
		"github.com/pkg/diff":                    "github.com/tailscale/depaware/depaware",
		"github.com/pkg/diff/ctxt":               "github.com/pkg/diff",
		"github.com/go-multierror/multierror":    "tailscale.com/wgengine/router",
		"github.com/godbus/dbus/v5":              "tailscale.com/wgengine/router/dns",
		"github.com/golang/groupcache/lru":       "tailscale.com/wgengine/filter",
		"github.com/tailscale/wireguard-go/conn": "github.com/tailscale/wireguard-go/device",
	}

	got := parsePreferredWhy(strings.NewReader(in))
	if !reflect.DeepEqual(want, got) {
		t.Errorf("want=%v got=%v", want, got)
	}
}
