(*++

Copyright (C) 2019 ACT Developers


This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated Pascal export implementation file in order to allow easy
development of Optional Class Library. The functions in this file need to be implemented. It needs to be generated only once.

Interface version: 1.0.0

*)

{$MODE DELPHI}
unit optclass_exports;

interface

uses
  optclass_impl,
  optclass_types,
  optclass_interfaces,
  optclass_exception,
  Classes,
  sysutils;

(*************************************************************************************************************************
 Class export definition of Base 
**************************************************************************************************************************)

(*************************************************************************************************************************
 Global function export definition
**************************************************************************************************************************)

(**
* Acquire shared ownership of an Instance
*
* @param[in] pInstance - Instance Handle
* @return error code or 0 (success)
*)
function optclass_acquireinstance(pInstance: TOptClassHandle): TOptClassResult; cdecl;

(**
* Releases shared ownership of an Instance
*
* @param[in] pInstance - Instance Handle
* @return error code or 0 (success)
*)
function optclass_releaseinstance(pInstance: TOptClassHandle): TOptClassResult; cdecl;

(**
* retrieves the binary version of this library.
*
* @param[out] pMajor - returns the major version of this library
* @param[out] pMinor - returns the minor version of this library
* @param[out] pMicro - returns the micro version of this library
* @return error code or 0 (success)
*)
function optclass_getversion(pMajor: PCardinal; pMinor: PCardinal; pMicro: PCardinal): TOptClassResult; cdecl;

(**
* Returns the last error recorded on this object
*
* @param[in] pInstance - Instance Handle
* @param[in] nErrorMessageBufferSize - size of the buffer (including trailing 0)
* @param[out] pErrorMessageNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pErrorMessageBuffer -  buffer of Message of the last error, may be NULL
* @param[out] pHasError - Is there a last error to query
* @return error code or 0 (success)
*)
function optclass_getlasterror(pInstance: TOptClassHandle; nErrorMessageBufferSize: Cardinal; pErrorMessageNeededChars: PCardinal; pErrorMessageBuffer: PAnsiChar; pHasError: PByte): TOptClassResult; cdecl;

(**
* Handles Library Journaling
*
* @param[in] pFileName - Journal FileName
* @return error code or 0 (success)
*)
function optclass_setjournal(pFileName: PAnsiChar): TOptClassResult; cdecl;

(**
* Creates an instance of Base class with a given identifier (but does not return it)
*
* @param[in] pIdentifier - Identifier of the new instance
* @return error code or 0 (success)
*)
function optclass_createinstancewithname(pIdentifier: PAnsiChar): TOptClassResult; cdecl;

(**
* Finds a Base class instance by Identifier
*
* @param[in] pIdentifier - Identifier of the tnstance to query
* @param[out] pInstance - Base class instance
* @return error code or 0 (success)
*)
function optclass_findinstancea(pIdentifier: PAnsiChar; pInstance: POptClassHandle): TOptClassResult; cdecl;

(**
* Finds a Base class instance by Identifier
*
* @param[in] pIdentifier - Identifier of the tnstance to query
* @param[out] pInstance - Base class instance
* @return error code or 0 (success)
*)
function optclass_findinstanceb(pIdentifier: PAnsiChar; pInstance: POptClassHandle): TOptClassResult; cdecl;

(**
* Uses a Base class instance
*
* @param[in] pInstance - Base class instance
* @param[out] pIsUsed - Was the Instance used?
* @return error code or 0 (success)
*)
function optclass_useinstancemaybe(pInstance: TOptClassHandle; pIsUsed: PByte): TOptClassResult; cdecl;


(*************************************************************************************************************************
 Function table lookup implementation
**************************************************************************************************************************)

function _optclass_getprocaddress_internal(pProcName: PAnsiChar; out ppProcAddress: Pointer): TOptClassResult cdecl;

implementation

function optclass_acquireinstance(pInstance: TOptClassHandle): TOptClassResult; cdecl;
var
  ObjectInstance: TObject;
begin
  try
    ObjectInstance := TObject(pInstance);
    if (not Supports(ObjectInstance, IOptClassBase)) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDCAST);
    

    TOptClassWrapper.AcquireInstance(ObjectInstance);

    Result := OPTCLASS_SUCCESS;
  except
    On E: EOptClassException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := OPTCLASS_ERROR_GENERICEXCEPTION;
    end
  end;
end;

function optclass_releaseinstance(pInstance: TOptClassHandle): TOptClassResult; cdecl;
var
  ObjectInstance: TObject;
begin
  try
    ObjectInstance := TObject(pInstance);
    if (not Supports(ObjectInstance, IOptClassBase)) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDCAST);
    

    TOptClassWrapper.ReleaseInstance(ObjectInstance);

    Result := OPTCLASS_SUCCESS;
  except
    On E: EOptClassException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := OPTCLASS_ERROR_GENERICEXCEPTION;
    end
  end;
end;

function optclass_getversion(pMajor: PCardinal; pMinor: PCardinal; pMicro: PCardinal): TOptClassResult; cdecl;
begin
  try
    if (not Assigned(pMajor)) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDPARAM);

    if (not Assigned(pMinor)) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDPARAM);

    if (not Assigned(pMicro)) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDPARAM);


    TOptClassWrapper.GetVersion(pMajor^, pMinor^, pMicro^);

    Result := OPTCLASS_SUCCESS;
  except
    On E: EOptClassException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := OPTCLASS_ERROR_GENERICEXCEPTION;
    end
  end;
end;

function optclass_getlasterror(pInstance: TOptClassHandle; nErrorMessageBufferSize: Cardinal; pErrorMessageNeededChars: PCardinal; pErrorMessageBuffer: PAnsiChar; pHasError: PByte): TOptClassResult; cdecl;
var
  ObjectInstance: TObject;
  ResultErrorMessage: String;
  LenErrorMessage: Cardinal;
  ResultHasError: Boolean;
begin
  try
    ObjectInstance := TObject(pInstance);
    if (not Supports(ObjectInstance, IOptClassBase)) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDCAST);
    
    if ((not Assigned(pErrorMessageBuffer)) and (not Assigned(pErrorMessageNeededChars))) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDPARAM);
    if not Assigned(pHasError) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDPARAM);

    ResultHasError := TOptClassWrapper.GetLastError(ObjectInstance, ResultErrorMessage);

    LenErrorMessage := Length(ResultErrorMessage);
    if Assigned(pErrorMessageNeededChars) then
      pErrorMessageNeededChars^ := LenErrorMessage + 1;
    if Assigned(pErrorMessageBuffer) then begin
      if (LenErrorMessage >= nErrorMessageBufferSize) then
        raise EOptClassException.Create(OPTCLASS_ERROR_BUFFERTOOSMALL);
      Move(PAnsiChar(ResultErrorMessage)^, pErrorMessageBuffer^, LenErrorMessage);
      pErrorMessageBuffer[LenErrorMessage] := Char(0);
    end;
    pHasError^ := Ord(ResultHasError);
    Result := OPTCLASS_SUCCESS;
  except
    On E: EOptClassException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := OPTCLASS_ERROR_GENERICEXCEPTION;
    end
  end;
end;

function optclass_setjournal(pFileName: PAnsiChar): TOptClassResult; cdecl;
begin
  try
    if (not Assigned(pFileName)) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDPARAM);

    
    Result := OPTCLASS_SUCCESS;
  except
    On E: EOptClassException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := OPTCLASS_ERROR_GENERICEXCEPTION;
    end
  end;
end;

function optclass_createinstancewithname(pIdentifier: PAnsiChar): TOptClassResult; cdecl;
begin
  try
    if (not Assigned(pIdentifier)) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDPARAM);

    TOptClassWrapper.CreateInstanceWithName(StrPas(pIdentifier));

    Result := OPTCLASS_SUCCESS;
  except
    On E: EOptClassException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := OPTCLASS_ERROR_GENERICEXCEPTION;
    end
  end;
end;

function optclass_findinstancea(pIdentifier: PAnsiChar; pInstance: POptClassHandle): TOptClassResult; cdecl;
var
  ResultInstance: TObject;
begin
  try
    if (not Assigned(pIdentifier)) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDPARAM);
    if not Assigned(pInstance) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDPARAM);

    ResultInstance := TOptClassWrapper.FindInstanceA(StrPas(pIdentifier));

    pInstance^ := ResultInstance;
    Result := OPTCLASS_SUCCESS;
  except
    On E: EOptClassException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := OPTCLASS_ERROR_GENERICEXCEPTION;
    end
  end;
end;

function optclass_findinstanceb(pIdentifier: PAnsiChar; pInstance: POptClassHandle): TOptClassResult; cdecl;
var
  OutInstance: TObject;
begin
  try
    if (not Assigned(pIdentifier)) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDPARAM);
    if not Assigned(pInstance) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDPARAM);

    TOptClassWrapper.FindInstanceB(StrPas(pIdentifier), OutInstance);

    pInstance^ := OutInstance;
    Result := OPTCLASS_SUCCESS;
  except
    On E: EOptClassException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := OPTCLASS_ERROR_GENERICEXCEPTION;
    end
  end;
end;

function optclass_useinstancemaybe(pInstance: TOptClassHandle; pIsUsed: PByte): TOptClassResult; cdecl;
var
  ObjectInstance: TObject;
  ResultIsUsed: Boolean;
begin
  try
    ObjectInstance := TObject(pInstance);
    
    if not Assigned(pIsUsed) then
      raise EOptClassException.Create(OPTCLASS_ERROR_INVALIDPARAM);

    ResultIsUsed := TOptClassWrapper.UseInstanceMaybe(ObjectInstance);

    pIsUsed^ := Ord(ResultIsUsed);
    Result := OPTCLASS_SUCCESS;
  except
    On E: EOptClassException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := OPTCLASS_ERROR_GENERICEXCEPTION;
    end
  end;
end;



(*************************************************************************************************************************
 Function table lookup implementation
**************************************************************************************************************************)

function _optclass_getprocaddress_internal(pProcName: PAnsiChar; out ppProcAddress: Pointer): TOptClassResult cdecl;

begin
  result := OPTCLASS_SUCCESS;
  ppProcAddress := nil;
  
  if (pProcName = 'optclass_acquireinstance') then
    ppProcAddress := @optclass_acquireinstance
  else if (pProcName = 'optclass_releaseinstance') then
    ppProcAddress := @optclass_releaseinstance
  else if (pProcName = 'optclass_getversion') then
    ppProcAddress := @optclass_getversion
  else if (pProcName = 'optclass_getlasterror') then
    ppProcAddress := @optclass_getlasterror
  else if (pProcName = 'optclass_setjournal') then
    ppProcAddress := @optclass_setjournal
  else if (pProcName = 'optclass_createinstancewithname') then
    ppProcAddress := @optclass_createinstancewithname
  else if (pProcName = 'optclass_findinstancea') then
    ppProcAddress := @optclass_findinstancea
  else if (pProcName = 'optclass_findinstanceb') then
    ppProcAddress := @optclass_findinstanceb
  else if (pProcName = 'optclass_useinstancemaybe') then
    ppProcAddress := @optclass_useinstancemaybe
  else
    result := OPTCLASS_ERROR_COULDNOTFINDLIBRARYEXPORT;
end;

end.

