(*++

Copyright (C) 2019 ACT Developers


This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated Pascal implementation file in order to allow easy
development of Optional Class Library. It needs to be generated only once.

Interface version: 1.0.0

*)

// {$mode objfpc}
{$MODE DELPHI}
Unit optclass_impl;

interface

uses
  optclass_types,
  optclass_exception,
  optclass_interfaces,
  optclass_impl_base,
  Classes,
  fgl,
  sysutils;

type
  TOptClassWrapper = class(TObject)
    private
      class var FObjects: TFPGList<TOptClassBase>;
      // Cannot simply use TFPGMap<string, TOptClassBase>, since this does not know shared ownership
      class var FIdentifiers: TFPGList<string>;
      class procedure ClearObjects;
    public
      class procedure AcquireInstance(AInstance: TObject);
      class procedure ReleaseInstance(AInstance: TObject);
      class procedure GetVersion(out AMajor: Cardinal; out AMinor: Cardinal; out AMicro: Cardinal);
      class function GetLastError(AInstance: TObject; out AErrorMessage: String): Boolean;
      class procedure CreateInstanceWithName(const AIdentifier: String);
      class function FindInstanceA(const AIdentifier: String): TObject;
      class procedure FindInstanceB(const AIdentifier: String; out AInstance: TObject);
      class function UseInstanceMaybe(AInstance: TObject): Boolean;
  end;

implementation

class procedure TOptClassWrapper.ClearObjects;
var
  Index: Integer;
begin
  for Index := 0 to TOptClassWrapper.FObjects.Count-1 do begin
    TOptClassWrapper.FObjects.Items[Index].DecRefCount();
    TOptClassWrapper.FObjects.Items[Index] := nil;
  end;
  FreeAndNil(TOptClassWrapper.FObjects);
  FreeAndNil(TOptClassWrapper.FIdentifiers);
end;


class procedure TOptClassWrapper.AcquireInstance(AInstance: TObject);
begin
  (AInstance as IOptClassBase).IncRefCount(); 
end;

class procedure TOptClassWrapper.ReleaseInstance(AInstance: TObject);
begin
  (AInstance as IOptClassBase).DecRefCount(); 
end;

class procedure TOptClassWrapper.GetVersion(out AMajor: Cardinal; out AMinor: Cardinal; out AMicro: Cardinal);
begin
  AMajor := OPTCLASS_VERSION_MAJOR;
  AMinor := OPTCLASS_VERSION_MINOR;
  AMicro := OPTCLASS_VERSION_MICRO;
end;

class function TOptClassWrapper.GetLastError(AInstance: TObject; out AErrorMessage: String): Boolean;
begin
  raise EOptClassException.Create(OPTCLASS_ERROR_NOTIMPLEMENTED);
end;

class procedure TOptClassWrapper.CreateInstanceWithName(const AIdentifier: String);
begin
  TOptClassWrapper.FObjects.Add(TOptClassBase.Create());
  TOptClassWrapper.FIdentifiers.Add(AIdentifier);
end;

class function TOptClassWrapper.FindInstanceA(const AIdentifier: String): TObject;
var
  AIndex: Integer;
begin
  AIndex := TOptClassWrapper.FIdentifiers.IndexOf(AIdentifier);
  if (AIndex >= 0) then
    result := TOptClassWrapper.FObjects.Items[AIndex]
  else
    result := nil;
end;

class procedure TOptClassWrapper.FindInstanceB(const AIdentifier: String; out AInstance: TObject);
var
  AIndex: Integer;
begin
  AIndex := TOptClassWrapper.FIdentifiers.IndexOf(AIdentifier);
  if (AIndex >= 0) then
    AInstance := TOptClassWrapper.FObjects.Items[AIndex]
  else
    AInstance := nil;
end;

class function TOptClassWrapper.UseInstanceMaybe(AInstance: TObject): Boolean;
begin
  result := assigned(AInstance);
end;

initialization
TOptClassWrapper.FObjects := TFPGList<TOptClassBase>.Create();
TOptClassWrapper.FIdentifiers := TFPGList<String>.Create();
finalization;
  TOptClassWrapper.ClearObjects();
end.
