pub const ext = @import("ext.zig");
const gstpbutils = @This();

const std = @import("std");
const compat = @import("compat");
const gstvideo = @import("gstvideo1");
const gstbase = @import("gstbase1");
const gst = @import("gst1");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
const gstaudio = @import("gstaudio1");
pub const DiscovererAudioInfoClass = gobject.ObjectClass;

pub const DiscovererContainerInfoClass = gobject.ObjectClass;

pub const DiscovererInfoClass = gobject.ObjectClass;

pub const DiscovererStreamInfoClass = gobject.ObjectClass;

pub const DiscovererSubtitleInfoClass = gobject.ObjectClass;

pub const DiscovererVideoInfoClass = gobject.ObjectClass;

pub const EncodingTargetClass = gobject.ObjectClass;

/// A baseclass for scopes (visualizers). It takes care of re-fitting the
/// audio-rate to video-rate and handles renegotiation (downstream video size
/// changes).
///
/// It also provides several background shading effects. These effects are
/// applied to a previous picture before the ``render`` implementation can draw a
/// new frame.
pub const AudioVisualizer = extern struct {
    pub const Parent = gst.Element;
    pub const Implements = [_]type{};
    pub const Class = gstpbutils.AudioVisualizerClass;
    f_parent: gst.Element,
    f_req_spf: c_uint,
    f_vinfo: gstvideo.VideoInfo,
    f_ainfo: gstaudio.AudioInfo,
    f_priv: ?*gstpbutils.AudioVisualizerPrivate,

    pub const virtual_methods = struct {
        pub const decide_allocation = struct {
            pub fn call(p_class: anytype, p_scope: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_query: *gst.Query) c_int {
                return gobject.ext.as(AudioVisualizer.Class, p_class).f_decide_allocation.?(gobject.ext.as(AudioVisualizer, p_scope), p_query);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_scope: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_query: *gst.Query) callconv(.C) c_int) void {
                gobject.ext.as(AudioVisualizer.Class, p_class).f_decide_allocation = @ptrCast(p_implementation);
            }
        };

        pub const render = struct {
            pub fn call(p_class: anytype, p_scope: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_audio: *gst.Buffer, p_video: *gstvideo.VideoFrame) c_int {
                return gobject.ext.as(AudioVisualizer.Class, p_class).f_render.?(gobject.ext.as(AudioVisualizer, p_scope), p_audio, p_video);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_scope: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_audio: *gst.Buffer, p_video: *gstvideo.VideoFrame) callconv(.C) c_int) void {
                gobject.ext.as(AudioVisualizer.Class, p_class).f_render = @ptrCast(p_implementation);
            }
        };

        pub const setup = struct {
            pub fn call(p_class: anytype, p_scope: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) c_int {
                return gobject.ext.as(AudioVisualizer.Class, p_class).f_setup.?(gobject.ext.as(AudioVisualizer, p_scope));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_scope: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) c_int) void {
                gobject.ext.as(AudioVisualizer.Class, p_class).f_setup = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        pub const shade_amount = struct {
            pub const name = "shade-amount";

            pub const Type = c_uint;
        };

        pub const shader = struct {
            pub const name = "shader";

            pub const Type = gstpbutils.AudioVisualizerShader;
        };
    };

    pub const signals = struct {};

    extern fn gst_audio_visualizer_get_type() usize;
    pub const getGObjectType = gst_audio_visualizer_get_type;

    extern fn g_object_ref(p_self: *gstpbutils.AudioVisualizer) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstpbutils.AudioVisualizer) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *AudioVisualizer, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The `gstpbutils.Discoverer` is a utility object which allows to get as much
/// information as possible from one or many URIs.
///
/// It provides two APIs, allowing usage in blocking or non-blocking mode.
///
/// The blocking mode just requires calling `gstpbutils.Discoverer.discoverUri`
/// with the URI one wishes to discover.
///
/// The non-blocking mode requires a running `glib.MainLoop` iterating a
/// `glib.MainContext`, where one connects to the various signals, appends the
/// URIs to be processed (through `gstpbutils.Discoverer.discoverUriAsync`) and then
/// asks for the discovery to begin (through `gstpbutils.Discoverer.start`).
/// By default this will use the GLib default main context unless you have
/// set a custom context using `glib.MainContext.pushThreadDefault`.
///
/// All the information is returned in a `gstpbutils.DiscovererInfo` structure.
pub const Discoverer = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gstpbutils.DiscovererClass;
    f_parent: gobject.Object,
    f_priv: ?*gstpbutils.DiscovererPrivate,
    f__reserved: [4]*anyopaque,

    pub const virtual_methods = struct {
        pub const discovered = struct {
            pub fn call(p_class: anytype, p_discoverer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_info: *gstpbutils.DiscovererInfo, p_err: *const glib.Error) void {
                return gobject.ext.as(Discoverer.Class, p_class).f_discovered.?(gobject.ext.as(Discoverer, p_discoverer), p_info, p_err);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_discoverer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_info: *gstpbutils.DiscovererInfo, p_err: *const glib.Error) callconv(.C) void) void {
                gobject.ext.as(Discoverer.Class, p_class).f_discovered = @ptrCast(p_implementation);
            }
        };

        pub const finished = struct {
            pub fn call(p_class: anytype, p_discoverer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(Discoverer.Class, p_class).f_finished.?(gobject.ext.as(Discoverer, p_discoverer));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_discoverer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(Discoverer.Class, p_class).f_finished = @ptrCast(p_implementation);
            }
        };

        /// Loads the serialized info from the given uri.
        pub const load_serialize_info = struct {
            pub fn call(p_class: anytype, p_dc: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_uri: [*:0]u8) *gstpbutils.DiscovererInfo {
                return gobject.ext.as(Discoverer.Class, p_class).f_load_serialize_info.?(gobject.ext.as(Discoverer, p_dc), p_uri);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_dc: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_uri: [*:0]u8) callconv(.C) *gstpbutils.DiscovererInfo) void {
                gobject.ext.as(Discoverer.Class, p_class).f_load_serialize_info = @ptrCast(p_implementation);
            }
        };

        pub const source_setup = struct {
            pub fn call(p_class: anytype, p_discoverer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_source: *gst.Element) void {
                return gobject.ext.as(Discoverer.Class, p_class).f_source_setup.?(gobject.ext.as(Discoverer, p_discoverer), p_source);
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_discoverer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance, p_source: *gst.Element) callconv(.C) void) void {
                gobject.ext.as(Discoverer.Class, p_class).f_source_setup = @ptrCast(p_implementation);
            }
        };

        pub const starting = struct {
            pub fn call(p_class: anytype, p_discoverer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(Discoverer.Class, p_class).f_starting.?(gobject.ext.as(Discoverer, p_discoverer));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_discoverer: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(Discoverer.Class, p_class).f_starting = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {
        /// The duration (in nanoseconds) after which the discovery of an individual
        /// URI will timeout.
        ///
        /// If the discovery of a URI times out, the `GST_DISCOVERER_TIMEOUT` will be
        /// set on the result flags.
        pub const timeout = struct {
            pub const name = "timeout";

            pub const Type = u64;
        };

        pub const use_cache = struct {
            pub const name = "use-cache";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {
        /// Will be emitted in async mode when all information on a URI could be
        /// discovered, or an error occurred.
        ///
        /// When an error occurs, `info` might still contain some partial information,
        /// depending on the circumstances of the error.
        pub const discovered = struct {
            pub const name = "discovered";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_info: *gstpbutils.DiscovererInfo, p_error: ?*glib.Error, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Discoverer, p_instance))),
                    gobject.signalLookup("discovered", Discoverer.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Will be emitted in async mode when all pending URIs have been processed.
        pub const finished = struct {
            pub const name = "finished";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Discoverer, p_instance))),
                    gobject.signalLookup("finished", Discoverer.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Retrieves information about a URI from and external source of information,
        /// like a cache file. This is used by the discoverer to speed up the
        /// discovery.
        pub const load_serialized_info = struct {
            pub const name = "load-serialized-info";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_uri: [*:0]u8, P_Data) callconv(.C) ?*gstpbutils.DiscovererInfo, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Discoverer, p_instance))),
                    gobject.signalLookup("load-serialized-info", Discoverer.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// This signal is emitted after the source element has been created for, so
        /// the URI being discovered, so it can be configured by setting additional
        /// properties (e.g. set a proxy server for an http source, or set the device
        /// and read speed for an audio cd source).
        ///
        /// This signal is usually emitted from the context of a GStreamer streaming
        /// thread.
        pub const source_setup = struct {
            pub const name = "source-setup";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), p_source: *gst.Element, P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Discoverer, p_instance))),
                    gobject.signalLookup("source-setup", Discoverer.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };

        /// Will be emitted when the discover starts analyzing the pending URIs
        pub const starting = struct {
            pub const name = "starting";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Discoverer, p_instance))),
                    gobject.signalLookup("starting", Discoverer.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `gstpbutils.Discoverer` with the provided timeout.
    extern fn gst_discoverer_new(p_timeout: gst.ClockTime, p_error: ?*?*glib.Error) ?*gstpbutils.Discoverer;
    pub const new = gst_discoverer_new;

    /// Synchronously discovers the given `uri`.
    ///
    /// A copy of `uri` will be made internally, so the caller can safely `glib.free`
    /// afterwards.
    extern fn gst_discoverer_discover_uri(p_discoverer: *Discoverer, p_uri: [*:0]const u8, p_error: ?*?*glib.Error) ?*gstpbutils.DiscovererInfo;
    pub const discoverUri = gst_discoverer_discover_uri;

    /// Appends the given `uri` to the list of URIs to discoverer. The actual
    /// discovery of the `uri` will only take place if `gstpbutils.Discoverer.start` has
    /// been called.
    ///
    /// A copy of `uri` will be made internally, so the caller can safely `glib.free`
    /// afterwards.
    extern fn gst_discoverer_discover_uri_async(p_discoverer: *Discoverer, p_uri: [*:0]const u8) c_int;
    pub const discoverUriAsync = gst_discoverer_discover_uri_async;

    /// Allow asynchronous discovering of URIs to take place.
    /// A `glib.MainLoop` must be available for `gstpbutils.Discoverer` to properly work in
    /// asynchronous mode.
    extern fn gst_discoverer_start(p_discoverer: *Discoverer) void;
    pub const start = gst_discoverer_start;

    /// Stop the discovery of any pending URIs and clears the list of
    /// pending URIS (if any).
    extern fn gst_discoverer_stop(p_discoverer: *Discoverer) void;
    pub const stop = gst_discoverer_stop;

    extern fn gst_discoverer_get_type() usize;
    pub const getGObjectType = gst_discoverer_get_type;

    extern fn g_object_ref(p_self: *gstpbutils.Discoverer) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstpbutils.Discoverer) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Discoverer, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `gstpbutils.DiscovererStreamInfo` specific to audio streams.
pub const DiscovererAudioInfo = opaque {
    pub const Parent = gstpbutils.DiscovererStreamInfo;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = DiscovererAudioInfo;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_discoverer_audio_info_get_bitrate(p_info: *const DiscovererAudioInfo) c_uint;
    pub const getBitrate = gst_discoverer_audio_info_get_bitrate;

    extern fn gst_discoverer_audio_info_get_channel_mask(p_info: *const DiscovererAudioInfo) u64;
    pub const getChannelMask = gst_discoverer_audio_info_get_channel_mask;

    extern fn gst_discoverer_audio_info_get_channels(p_info: *const DiscovererAudioInfo) c_uint;
    pub const getChannels = gst_discoverer_audio_info_get_channels;

    extern fn gst_discoverer_audio_info_get_depth(p_info: *const DiscovererAudioInfo) c_uint;
    pub const getDepth = gst_discoverer_audio_info_get_depth;

    extern fn gst_discoverer_audio_info_get_language(p_info: *const DiscovererAudioInfo) ?[*:0]const u8;
    pub const getLanguage = gst_discoverer_audio_info_get_language;

    extern fn gst_discoverer_audio_info_get_max_bitrate(p_info: *const DiscovererAudioInfo) c_uint;
    pub const getMaxBitrate = gst_discoverer_audio_info_get_max_bitrate;

    extern fn gst_discoverer_audio_info_get_sample_rate(p_info: *const DiscovererAudioInfo) c_uint;
    pub const getSampleRate = gst_discoverer_audio_info_get_sample_rate;

    extern fn gst_discoverer_audio_info_get_type() usize;
    pub const getGObjectType = gst_discoverer_audio_info_get_type;

    extern fn g_object_ref(p_self: *gstpbutils.DiscovererAudioInfo) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstpbutils.DiscovererAudioInfo) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DiscovererAudioInfo, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `gstpbutils.DiscovererStreamInfo` specific to container streams.
pub const DiscovererContainerInfo = opaque {
    pub const Parent = gstpbutils.DiscovererStreamInfo;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = DiscovererContainerInfo;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_discoverer_container_info_get_streams(p_info: *DiscovererContainerInfo) *glib.List;
    pub const getStreams = gst_discoverer_container_info_get_streams;

    extern fn gst_discoverer_container_info_get_tags(p_info: *const DiscovererContainerInfo) ?*const gst.TagList;
    pub const getTags = gst_discoverer_container_info_get_tags;

    extern fn gst_discoverer_container_info_get_type() usize;
    pub const getGObjectType = gst_discoverer_container_info_get_type;

    extern fn g_object_ref(p_self: *gstpbutils.DiscovererContainerInfo) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstpbutils.DiscovererContainerInfo) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DiscovererContainerInfo, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Structure containing the information of a URI analyzed by `gstpbutils.Discoverer`.
pub const DiscovererInfo = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = DiscovererInfo;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Parses a `glib.Variant` as produced by `gstpbutils.DiscovererInfo.toVariant`
    /// back to a `gstpbutils.DiscovererInfo`.
    extern fn gst_discoverer_info_from_variant(p_variant: *glib.Variant) *gstpbutils.DiscovererInfo;
    pub const fromVariant = gst_discoverer_info_from_variant;

    extern fn gst_discoverer_info_copy(p_ptr: *DiscovererInfo) *gstpbutils.DiscovererInfo;
    pub const copy = gst_discoverer_info_copy;

    /// Finds all the `gstpbutils.DiscovererAudioInfo` contained in `info`
    extern fn gst_discoverer_info_get_audio_streams(p_info: *DiscovererInfo) *glib.List;
    pub const getAudioStreams = gst_discoverer_info_get_audio_streams;

    /// Finds all the `gstpbutils.DiscovererContainerInfo` contained in `info`
    extern fn gst_discoverer_info_get_container_streams(p_info: *DiscovererInfo) *glib.List;
    pub const getContainerStreams = gst_discoverer_info_get_container_streams;

    extern fn gst_discoverer_info_get_duration(p_info: *const DiscovererInfo) gst.ClockTime;
    pub const getDuration = gst_discoverer_info_get_duration;

    extern fn gst_discoverer_info_get_live(p_info: *const DiscovererInfo) c_int;
    pub const getLive = gst_discoverer_info_get_live;

    extern fn gst_discoverer_info_get_misc(p_info: *const DiscovererInfo) ?*const gst.Structure;
    pub const getMisc = gst_discoverer_info_get_misc;

    /// Get the installer details for missing elements
    extern fn gst_discoverer_info_get_missing_elements_installer_details(p_info: *const DiscovererInfo) [*][*:0]const u8;
    pub const getMissingElementsInstallerDetails = gst_discoverer_info_get_missing_elements_installer_details;

    extern fn gst_discoverer_info_get_result(p_info: *const DiscovererInfo) gstpbutils.DiscovererResult;
    pub const getResult = gst_discoverer_info_get_result;

    extern fn gst_discoverer_info_get_seekable(p_info: *const DiscovererInfo) c_int;
    pub const getSeekable = gst_discoverer_info_get_seekable;

    extern fn gst_discoverer_info_get_stream_info(p_info: *DiscovererInfo) ?*gstpbutils.DiscovererStreamInfo;
    pub const getStreamInfo = gst_discoverer_info_get_stream_info;

    extern fn gst_discoverer_info_get_stream_list(p_info: *DiscovererInfo) *glib.List;
    pub const getStreamList = gst_discoverer_info_get_stream_list;

    /// Finds the `gstpbutils.DiscovererStreamInfo` contained in `info` that match the
    /// given `streamtype`.
    extern fn gst_discoverer_info_get_streams(p_info: *DiscovererInfo, p_streamtype: usize) *glib.List;
    pub const getStreams = gst_discoverer_info_get_streams;

    /// Finds all the `gstpbutils.DiscovererSubtitleInfo` contained in `info`
    extern fn gst_discoverer_info_get_subtitle_streams(p_info: *DiscovererInfo) *glib.List;
    pub const getSubtitleStreams = gst_discoverer_info_get_subtitle_streams;

    extern fn gst_discoverer_info_get_tags(p_info: *const DiscovererInfo) ?*const gst.TagList;
    pub const getTags = gst_discoverer_info_get_tags;

    extern fn gst_discoverer_info_get_toc(p_info: *const DiscovererInfo) ?*const gst.Toc;
    pub const getToc = gst_discoverer_info_get_toc;

    extern fn gst_discoverer_info_get_uri(p_info: *const DiscovererInfo) [*:0]const u8;
    pub const getUri = gst_discoverer_info_get_uri;

    /// Finds all the `gstpbutils.DiscovererVideoInfo` contained in `info`
    extern fn gst_discoverer_info_get_video_streams(p_info: *DiscovererInfo) *glib.List;
    pub const getVideoStreams = gst_discoverer_info_get_video_streams;

    /// Serializes `info` to a `glib.Variant` that can be parsed again
    /// through `gstpbutils.DiscovererInfo.fromVariant`.
    ///
    /// Note that any `gst.Toc` (s) that might have been discovered will not be serialized
    /// for now.
    extern fn gst_discoverer_info_to_variant(p_info: *DiscovererInfo, p_flags: gstpbutils.DiscovererSerializeFlags) *glib.Variant;
    pub const toVariant = gst_discoverer_info_to_variant;

    extern fn gst_discoverer_info_get_type() usize;
    pub const getGObjectType = gst_discoverer_info_get_type;

    extern fn g_object_ref(p_self: *gstpbutils.DiscovererInfo) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstpbutils.DiscovererInfo) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DiscovererInfo, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Base structure for information concerning a media stream. Depending on the
/// stream type, one can find more media-specific information in
/// `gstpbutils.DiscovererAudioInfo`, `gstpbutils.DiscovererVideoInfo`, and
/// `gstpbutils.DiscovererContainerInfo`.
///
/// The `gstpbutils.DiscovererStreamInfo` represents the topology of the stream. Siblings
/// can be iterated over with `gstpbutils.DiscovererStreamInfo.getNext` and
/// `gstpbutils.DiscovererStreamInfo.getPrevious`. Children (sub-streams) of a
/// stream can be accessed using the `gstpbutils.DiscovererContainerInfo` API.
///
/// As a simple example, if you run `gstpbutils.Discoverer` on an AVI file with one audio
/// and one video stream, you will get a `gstpbutils.DiscovererContainerInfo`
/// corresponding to the AVI container, which in turn will have a
/// `gstpbutils.DiscovererAudioInfo` sub-stream and a `gstpbutils.DiscovererVideoInfo` sub-stream
/// for the audio and video streams respectively.
pub const DiscovererStreamInfo = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = DiscovererStreamInfo;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Decrements the reference count of all contained `gstpbutils.DiscovererStreamInfo`
    /// and fress the `glib.List`.
    extern fn gst_discoverer_stream_info_list_free(p_infos: *glib.List) void;
    pub const listFree = gst_discoverer_stream_info_list_free;

    extern fn gst_discoverer_stream_info_get_caps(p_info: *DiscovererStreamInfo) ?*gst.Caps;
    pub const getCaps = gst_discoverer_stream_info_get_caps;

    extern fn gst_discoverer_stream_info_get_misc(p_info: *DiscovererStreamInfo) ?*const gst.Structure;
    pub const getMisc = gst_discoverer_stream_info_get_misc;

    extern fn gst_discoverer_stream_info_get_next(p_info: *DiscovererStreamInfo) ?*gstpbutils.DiscovererStreamInfo;
    pub const getNext = gst_discoverer_stream_info_get_next;

    extern fn gst_discoverer_stream_info_get_previous(p_info: *DiscovererStreamInfo) ?*gstpbutils.DiscovererStreamInfo;
    pub const getPrevious = gst_discoverer_stream_info_get_previous;

    extern fn gst_discoverer_stream_info_get_stream_id(p_info: *DiscovererStreamInfo) ?[*:0]const u8;
    pub const getStreamId = gst_discoverer_stream_info_get_stream_id;

    extern fn gst_discoverer_stream_info_get_stream_number(p_info: *DiscovererStreamInfo) c_int;
    pub const getStreamNumber = gst_discoverer_stream_info_get_stream_number;

    extern fn gst_discoverer_stream_info_get_stream_type_nick(p_info: *DiscovererStreamInfo) [*:0]const u8;
    pub const getStreamTypeNick = gst_discoverer_stream_info_get_stream_type_nick;

    extern fn gst_discoverer_stream_info_get_tags(p_info: *DiscovererStreamInfo) ?*const gst.TagList;
    pub const getTags = gst_discoverer_stream_info_get_tags;

    extern fn gst_discoverer_stream_info_get_toc(p_info: *DiscovererStreamInfo) ?*const gst.Toc;
    pub const getToc = gst_discoverer_stream_info_get_toc;

    extern fn gst_discoverer_stream_info_get_type() usize;
    pub const getGObjectType = gst_discoverer_stream_info_get_type;

    extern fn g_object_ref(p_self: *gstpbutils.DiscovererStreamInfo) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstpbutils.DiscovererStreamInfo) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DiscovererStreamInfo, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `gstpbutils.DiscovererStreamInfo` specific to subtitle streams (this includes text and
/// image based ones).
pub const DiscovererSubtitleInfo = opaque {
    pub const Parent = gstpbutils.DiscovererStreamInfo;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = DiscovererSubtitleInfo;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_discoverer_subtitle_info_get_language(p_info: *const DiscovererSubtitleInfo) ?[*:0]const u8;
    pub const getLanguage = gst_discoverer_subtitle_info_get_language;

    extern fn gst_discoverer_subtitle_info_get_type() usize;
    pub const getGObjectType = gst_discoverer_subtitle_info_get_type;

    extern fn g_object_ref(p_self: *gstpbutils.DiscovererSubtitleInfo) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstpbutils.DiscovererSubtitleInfo) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DiscovererSubtitleInfo, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `gstpbutils.DiscovererStreamInfo` specific to video streams (this includes images).
pub const DiscovererVideoInfo = opaque {
    pub const Parent = gstpbutils.DiscovererStreamInfo;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = DiscovererVideoInfo;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    extern fn gst_discoverer_video_info_get_bitrate(p_info: *const DiscovererVideoInfo) c_uint;
    pub const getBitrate = gst_discoverer_video_info_get_bitrate;

    extern fn gst_discoverer_video_info_get_depth(p_info: *const DiscovererVideoInfo) c_uint;
    pub const getDepth = gst_discoverer_video_info_get_depth;

    extern fn gst_discoverer_video_info_get_framerate_denom(p_info: *const DiscovererVideoInfo) c_uint;
    pub const getFramerateDenom = gst_discoverer_video_info_get_framerate_denom;

    extern fn gst_discoverer_video_info_get_framerate_num(p_info: *const DiscovererVideoInfo) c_uint;
    pub const getFramerateNum = gst_discoverer_video_info_get_framerate_num;

    extern fn gst_discoverer_video_info_get_height(p_info: *const DiscovererVideoInfo) c_uint;
    pub const getHeight = gst_discoverer_video_info_get_height;

    extern fn gst_discoverer_video_info_get_max_bitrate(p_info: *const DiscovererVideoInfo) c_uint;
    pub const getMaxBitrate = gst_discoverer_video_info_get_max_bitrate;

    extern fn gst_discoverer_video_info_get_par_denom(p_info: *const DiscovererVideoInfo) c_uint;
    pub const getParDenom = gst_discoverer_video_info_get_par_denom;

    extern fn gst_discoverer_video_info_get_par_num(p_info: *const DiscovererVideoInfo) c_uint;
    pub const getParNum = gst_discoverer_video_info_get_par_num;

    extern fn gst_discoverer_video_info_get_width(p_info: *const DiscovererVideoInfo) c_uint;
    pub const getWidth = gst_discoverer_video_info_get_width;

    extern fn gst_discoverer_video_info_is_image(p_info: *const DiscovererVideoInfo) c_int;
    pub const isImage = gst_discoverer_video_info_is_image;

    extern fn gst_discoverer_video_info_is_interlaced(p_info: *const DiscovererVideoInfo) c_int;
    pub const isInterlaced = gst_discoverer_video_info_is_interlaced;

    extern fn gst_discoverer_video_info_get_type() usize;
    pub const getGObjectType = gst_discoverer_video_info_get_type;

    extern fn g_object_ref(p_self: *gstpbutils.DiscovererVideoInfo) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstpbutils.DiscovererVideoInfo) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *DiscovererVideoInfo, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Variant of `gstpbutils.EncodingProfile` for audio streams.
pub const EncodingAudioProfile = opaque {
    pub const Parent = gstpbutils.EncodingProfile;
    pub const Implements = [_]type{};
    pub const Class = gstpbutils.EncodingAudioProfileClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `gstpbutils.EncodingAudioProfile`
    ///
    /// All provided allocatable arguments will be internally copied, so can be
    /// safely freed/unreferenced after calling this method.
    extern fn gst_encoding_audio_profile_new(p_format: *gst.Caps, p_preset: ?[*:0]const u8, p_restriction: ?*gst.Caps, p_presence: c_uint) *gstpbutils.EncodingAudioProfile;
    pub const new = gst_encoding_audio_profile_new;

    extern fn gst_encoding_audio_profile_get_type() usize;
    pub const getGObjectType = gst_encoding_audio_profile_get_type;

    extern fn g_object_ref(p_self: *gstpbutils.EncodingAudioProfile) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstpbutils.EncodingAudioProfile) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EncodingAudioProfile, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Encoding profiles for containers. Keeps track of a list of `gstpbutils.EncodingProfile`
pub const EncodingContainerProfile = opaque {
    pub const Parent = gstpbutils.EncodingProfile;
    pub const Implements = [_]type{};
    pub const Class = gstpbutils.EncodingContainerProfileClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `gstpbutils.EncodingContainerProfile`.
    extern fn gst_encoding_container_profile_new(p_name: ?[*:0]const u8, p_description: ?[*:0]const u8, p_format: *gst.Caps, p_preset: ?[*:0]const u8) *gstpbutils.EncodingContainerProfile;
    pub const new = gst_encoding_container_profile_new;

    /// Add a `gstpbutils.EncodingProfile` to the list of profiles handled by `container`.
    ///
    /// No copy of `profile` will be made, if you wish to use it elsewhere after this
    /// method you should increment its reference count.
    extern fn gst_encoding_container_profile_add_profile(p_container: *EncodingContainerProfile, p_profile: *gstpbutils.EncodingProfile) c_int;
    pub const addProfile = gst_encoding_container_profile_add_profile;

    /// Checks if `container` contains a `gstpbutils.EncodingProfile` identical to
    /// `profile`.
    extern fn gst_encoding_container_profile_contains_profile(p_container: *EncodingContainerProfile, p_profile: *gstpbutils.EncodingProfile) c_int;
    pub const containsProfile = gst_encoding_container_profile_contains_profile;

    extern fn gst_encoding_container_profile_get_profiles(p_profile: *EncodingContainerProfile) *const glib.List;
    pub const getProfiles = gst_encoding_container_profile_get_profiles;

    extern fn gst_encoding_container_profile_get_type() usize;
    pub const getGObjectType = gst_encoding_container_profile_get_type;

    extern fn g_object_ref(p_self: *gstpbutils.EncodingContainerProfile) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstpbutils.EncodingContainerProfile) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EncodingContainerProfile, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The opaque base class object for all encoding profiles. This contains generic
/// information like name, description, format and preset.
pub const EncodingProfile = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = gstpbutils.EncodingProfileClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// A `gst.Structure` defining the properties to be set to the element
        /// the profile represents.
        ///
        /// For example for `av1enc`:
        ///
        /// ```
        /// element-properties,row-mt=true, end-usage=vbr
        /// ```
        pub const element_properties = struct {
            pub const name = "element-properties";

            pub const Type = ?*gst.Structure;
        };

        pub const restriction_caps = struct {
            pub const name = "restriction-caps";

            pub const Type = ?*gst.Caps;
        };
    };

    pub const signals = struct {};

    /// Find the `gstpbutils.EncodingProfile` with the specified name and category.
    extern fn gst_encoding_profile_find(p_targetname: [*:0]const u8, p_profilename: ?[*:0]const u8, p_category: ?[*:0]const u8) ?*gstpbutils.EncodingProfile;
    pub const find = gst_encoding_profile_find;

    /// Creates a `gstpbutils.EncodingProfile` matching the formats from the given
    /// `gstpbutils.DiscovererInfo`. Streams other than audio or video (eg,
    /// subtitles), are currently ignored.
    extern fn gst_encoding_profile_from_discoverer(p_info: *gstpbutils.DiscovererInfo) ?*gstpbutils.EncodingProfile;
    pub const fromDiscoverer = gst_encoding_profile_from_discoverer;

    /// Makes a deep copy of `self`
    extern fn gst_encoding_profile_copy(p_self: *EncodingProfile) *gstpbutils.EncodingProfile;
    pub const copy = gst_encoding_profile_copy;

    /// Get whether the format that has been negotiated in at some point can be renegotiated
    /// later during the encoding.
    extern fn gst_encoding_profile_get_allow_dynamic_output(p_profile: *EncodingProfile) c_int;
    pub const getAllowDynamicOutput = gst_encoding_profile_get_allow_dynamic_output;

    extern fn gst_encoding_profile_get_description(p_profile: *EncodingProfile) ?[*:0]const u8;
    pub const getDescription = gst_encoding_profile_get_description;

    extern fn gst_encoding_profile_get_element_properties(p_self: *EncodingProfile) ?*gst.Structure;
    pub const getElementProperties = gst_encoding_profile_get_element_properties;

    extern fn gst_encoding_profile_get_file_extension(p_profile: *EncodingProfile) ?[*:0]const u8;
    pub const getFileExtension = gst_encoding_profile_get_file_extension;

    extern fn gst_encoding_profile_get_format(p_profile: *EncodingProfile) *gst.Caps;
    pub const getFormat = gst_encoding_profile_get_format;

    /// Computes the full output caps that this `profile` will be able to consume.
    extern fn gst_encoding_profile_get_input_caps(p_profile: *EncodingProfile) *gst.Caps;
    pub const getInputCaps = gst_encoding_profile_get_input_caps;

    extern fn gst_encoding_profile_get_name(p_profile: *EncodingProfile) ?[*:0]const u8;
    pub const getName = gst_encoding_profile_get_name;

    extern fn gst_encoding_profile_get_presence(p_profile: *EncodingProfile) c_uint;
    pub const getPresence = gst_encoding_profile_get_presence;

    extern fn gst_encoding_profile_get_preset(p_profile: *EncodingProfile) ?[*:0]const u8;
    pub const getPreset = gst_encoding_profile_get_preset;

    extern fn gst_encoding_profile_get_preset_name(p_profile: *EncodingProfile) ?[*:0]const u8;
    pub const getPresetName = gst_encoding_profile_get_preset_name;

    extern fn gst_encoding_profile_get_restriction(p_profile: *EncodingProfile) ?*gst.Caps;
    pub const getRestriction = gst_encoding_profile_get_restriction;

    extern fn gst_encoding_profile_get_single_segment(p_profile: *EncodingProfile) c_int;
    pub const getSingleSegment = gst_encoding_profile_get_single_segment;

    extern fn gst_encoding_profile_get_type_nick(p_profile: *EncodingProfile) [*:0]const u8;
    pub const getTypeNick = gst_encoding_profile_get_type_nick;

    extern fn gst_encoding_profile_is_enabled(p_profile: *EncodingProfile) c_int;
    pub const isEnabled = gst_encoding_profile_is_enabled;

    /// Checks whether the two `gstpbutils.EncodingProfile` are equal
    extern fn gst_encoding_profile_is_equal(p_a: *EncodingProfile, p_b: *gstpbutils.EncodingProfile) c_int;
    pub const isEqual = gst_encoding_profile_is_equal;

    /// Sets whether the format that has been negotiated in at some point can be renegotiated
    /// later during the encoding.
    extern fn gst_encoding_profile_set_allow_dynamic_output(p_profile: *EncodingProfile, p_allow_dynamic_output: c_int) void;
    pub const setAllowDynamicOutput = gst_encoding_profile_set_allow_dynamic_output;

    /// Set `description` as the given description for the `profile`. A copy of
    /// `description` will be made internally.
    extern fn gst_encoding_profile_set_description(p_profile: *EncodingProfile, p_description: ?[*:0]const u8) void;
    pub const setDescription = gst_encoding_profile_set_description;

    /// This allows setting the muxing/encoding element properties.
    ///
    /// **Set properties generically**
    ///
    /// ``` properties
    ///  [element-properties, boolean-prop=true, string-prop="hi"]
    /// ```
    ///
    /// **Mapping properties with well known element factories**
    ///
    /// ``` properties
    /// element-properties-map, map = {
    ///      [openh264enc, gop-size=32, ],
    ///      [x264enc, key-int-max=32, tune=zerolatency],
    ///  }
    /// ```
    extern fn gst_encoding_profile_set_element_properties(p_self: *EncodingProfile, p_element_properties: *gst.Structure) void;
    pub const setElementProperties = gst_encoding_profile_set_element_properties;

    /// Set whether the profile should be used or not.
    extern fn gst_encoding_profile_set_enabled(p_profile: *EncodingProfile, p_enabled: c_int) void;
    pub const setEnabled = gst_encoding_profile_set_enabled;

    /// Sets the media format used in the profile.
    extern fn gst_encoding_profile_set_format(p_profile: *EncodingProfile, p_format: *gst.Caps) void;
    pub const setFormat = gst_encoding_profile_set_format;

    /// Set `name` as the given name for the `profile`. A copy of `name` will be made
    /// internally.
    extern fn gst_encoding_profile_set_name(p_profile: *EncodingProfile, p_name: ?[*:0]const u8) void;
    pub const setName = gst_encoding_profile_set_name;

    /// Set the number of time the profile is used in its parent
    /// container profile. If 0, it is not a mandatory stream
    extern fn gst_encoding_profile_set_presence(p_profile: *EncodingProfile, p_presence: c_uint) void;
    pub const setPresence = gst_encoding_profile_set_presence;

    /// Sets the name of the `gst.Element` that implements the `gst.Preset` interface
    /// to use for the profile.
    /// This is the name that has been set when saving the preset.
    extern fn gst_encoding_profile_set_preset(p_profile: *EncodingProfile, p_preset: ?[*:0]const u8) void;
    pub const setPreset = gst_encoding_profile_set_preset;

    /// Sets the name of the `gst.Preset`'s factory to be used in the profile.
    extern fn gst_encoding_profile_set_preset_name(p_profile: *EncodingProfile, p_preset_name: ?[*:0]const u8) void;
    pub const setPresetName = gst_encoding_profile_set_preset_name;

    /// Set the restriction `gst.Caps` to apply before the encoder
    /// that will be used in the profile. See `gstpbutils.EncodingProfile.getRestriction`
    /// for more about restrictions. Does not apply to `gstpbutils.EncodingContainerProfile`.
    extern fn gst_encoding_profile_set_restriction(p_profile: *EncodingProfile, p_restriction: ?*gst.Caps) void;
    pub const setRestriction = gst_encoding_profile_set_restriction;

    /// If using a single segment, buffers will be retimestamped and segments will be
    /// eat so as to appear as one segment.
    ///
    /// > *NOTE*: Single segment is not property supported when using
    /// > `encodebin.properties.avoid`-reencoding
    extern fn gst_encoding_profile_set_single_segment(p_profile: *EncodingProfile, p_single_segment: c_int) void;
    pub const setSingleSegment = gst_encoding_profile_set_single_segment;

    extern fn gst_encoding_profile_get_type() usize;
    pub const getGObjectType = gst_encoding_profile_get_type;

    extern fn g_object_ref(p_self: *gstpbutils.EncodingProfile) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstpbutils.EncodingProfile) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EncodingProfile, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Collection of `gstpbutils.EncodingProfile` for a specific target or use-case.
///
/// When being stored/loaded, targets come from a specific category, like
/// `GST_ENCODING_CATEGORY_DEVICE`.
pub const EncodingTarget = opaque {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = opaque {
        pub const Instance = EncodingTarget;
    };
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Searches for the `gstpbutils.EncodingTarget` with the given name, loads it
    /// and returns it.
    ///
    /// If the category name is specified only targets from that category will be
    /// searched for.
    extern fn gst_encoding_target_load(p_name: [*:0]const u8, p_category: ?[*:0]const u8, p_error: ?*?*glib.Error) ?*gstpbutils.EncodingTarget;
    pub const load = gst_encoding_target_load;

    /// Opens the provided file and returns the contained `gstpbutils.EncodingTarget`.
    extern fn gst_encoding_target_load_from_file(p_filepath: [*:0]const u8, p_error: ?*?*glib.Error) ?*gstpbutils.EncodingTarget;
    pub const loadFromFile = gst_encoding_target_load_from_file;

    /// Creates a new `gstpbutils.EncodingTarget`.
    ///
    /// The name and category can only consist of lowercase ASCII letters for the
    /// first character, followed by either lowercase ASCII letters, digits or
    /// hyphens ('-').
    ///
    /// The `category` *should* be one of the existing
    /// well-defined categories, like `GST_ENCODING_CATEGORY_DEVICE`, but it
    /// *can* be a application or user specific category if
    /// needed.
    extern fn gst_encoding_target_new(p_name: [*:0]const u8, p_category: [*:0]const u8, p_description: [*:0]const u8, p_profiles: *const glib.List) ?*gstpbutils.EncodingTarget;
    pub const new = gst_encoding_target_new;

    /// Adds the given `profile` to the `target`. Each added profile must have
    /// a unique name within the profile.
    ///
    /// The `target` will steal a reference to the `profile`. If you wish to use
    /// the profile after calling this method, you should increase its reference
    /// count.
    extern fn gst_encoding_target_add_profile(p_target: *EncodingTarget, p_profile: *gstpbutils.EncodingProfile) c_int;
    pub const addProfile = gst_encoding_target_add_profile;

    extern fn gst_encoding_target_get_category(p_target: *EncodingTarget) [*:0]const u8;
    pub const getCategory = gst_encoding_target_get_category;

    extern fn gst_encoding_target_get_description(p_target: *EncodingTarget) [*:0]const u8;
    pub const getDescription = gst_encoding_target_get_description;

    extern fn gst_encoding_target_get_name(p_target: *EncodingTarget) [*:0]const u8;
    pub const getName = gst_encoding_target_get_name;

    extern fn gst_encoding_target_get_path(p_target: *EncodingTarget) ?[*:0]const u8;
    pub const getPath = gst_encoding_target_get_path;

    extern fn gst_encoding_target_get_profile(p_target: *EncodingTarget, p_name: [*:0]const u8) ?*gstpbutils.EncodingProfile;
    pub const getProfile = gst_encoding_target_get_profile;

    extern fn gst_encoding_target_get_profiles(p_target: *EncodingTarget) *const glib.List;
    pub const getProfiles = gst_encoding_target_get_profiles;

    /// Saves the `target` to a default user-local directory.
    extern fn gst_encoding_target_save(p_target: *EncodingTarget, p_error: ?*?*glib.Error) c_int;
    pub const save = gst_encoding_target_save;

    /// Saves the `target` to the provided file location.
    extern fn gst_encoding_target_save_to_file(p_target: *EncodingTarget, p_filepath: [*:0]const u8, p_error: ?*?*glib.Error) c_int;
    pub const saveToFile = gst_encoding_target_save_to_file;

    extern fn gst_encoding_target_get_type() usize;
    pub const getGObjectType = gst_encoding_target_get_type;

    extern fn g_object_ref(p_self: *gstpbutils.EncodingTarget) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstpbutils.EncodingTarget) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EncodingTarget, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Variant of `gstpbutils.EncodingProfile` for video streams, allows specifying the `pass`.
pub const EncodingVideoProfile = opaque {
    pub const Parent = gstpbutils.EncodingProfile;
    pub const Implements = [_]type{};
    pub const Class = gstpbutils.EncodingVideoProfileClass;
    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `gstpbutils.EncodingVideoProfile`
    ///
    /// All provided allocatable arguments will be internally copied, so can be
    /// safely freed/unreferenced after calling this method.
    ///
    /// If you wish to control the pass number (in case of multi-pass scenarios),
    /// please refer to the `gstpbutils.EncodingVideoProfile.setPass` documentation.
    ///
    /// If you wish to use/force a constant framerate please refer to the
    /// `gstpbutils.EncodingVideoProfile.setVariableframerate` documentation.
    extern fn gst_encoding_video_profile_new(p_format: *gst.Caps, p_preset: ?[*:0]const u8, p_restriction: ?*gst.Caps, p_presence: c_uint) *gstpbutils.EncodingVideoProfile;
    pub const new = gst_encoding_video_profile_new;

    /// Get the pass number if this is part of a multi-pass profile.
    extern fn gst_encoding_video_profile_get_pass(p_prof: *EncodingVideoProfile) c_uint;
    pub const getPass = gst_encoding_video_profile_get_pass;

    /// > *NOTE*: Fixed framerate won't be enforced when `encodebin.properties.avoid`-reencoding
    /// > is set.
    extern fn gst_encoding_video_profile_get_variableframerate(p_prof: *EncodingVideoProfile) c_int;
    pub const getVariableframerate = gst_encoding_video_profile_get_variableframerate;

    /// Sets the pass number of this video profile. The first pass profile should have
    /// this value set to 1. If this video profile isn't part of a multi-pass profile,
    /// you may set it to 0 (the default value).
    extern fn gst_encoding_video_profile_set_pass(p_prof: *EncodingVideoProfile, p_pass: c_uint) void;
    pub const setPass = gst_encoding_video_profile_set_pass;

    /// If set to `TRUE`, then the incoming stream will be allowed to have non-constant
    /// framerate. If set to `FALSE` (default value), then the incoming stream will
    /// be normalized by dropping/duplicating frames in order to produce a
    /// constance framerate.
    extern fn gst_encoding_video_profile_set_variableframerate(p_prof: *EncodingVideoProfile, p_variableframerate: c_int) void;
    pub const setVariableframerate = gst_encoding_video_profile_set_variableframerate;

    extern fn gst_encoding_video_profile_get_type() usize;
    pub const getGObjectType = gst_encoding_video_profile_get_type;

    extern fn g_object_ref(p_self: *gstpbutils.EncodingVideoProfile) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstpbutils.EncodingVideoProfile) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *EncodingVideoProfile, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const AudioVisualizerClass = extern struct {
    pub const Instance = gstpbutils.AudioVisualizer;

    f_parent_class: gst.ElementClass,
    f_setup: ?*const fn (p_scope: *gstpbutils.AudioVisualizer) callconv(.C) c_int,
    f_render: ?*const fn (p_scope: *gstpbutils.AudioVisualizer, p_audio: *gst.Buffer, p_video: *gstvideo.VideoFrame) callconv(.C) c_int,
    f_decide_allocation: ?*const fn (p_scope: *gstpbutils.AudioVisualizer, p_query: *gst.Query) callconv(.C) c_int,

    pub fn as(p_instance: *AudioVisualizerClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const AudioVisualizerPrivate = opaque {};

pub const DiscovererClass = extern struct {
    pub const Instance = gstpbutils.Discoverer;

    f_parentclass: gobject.ObjectClass,
    f_finished: ?*const fn (p_discoverer: *gstpbutils.Discoverer) callconv(.C) void,
    f_starting: ?*const fn (p_discoverer: *gstpbutils.Discoverer) callconv(.C) void,
    f_discovered: ?*const fn (p_discoverer: *gstpbutils.Discoverer, p_info: *gstpbutils.DiscovererInfo, p_err: *const glib.Error) callconv(.C) void,
    f_source_setup: ?*const fn (p_discoverer: *gstpbutils.Discoverer, p_source: *gst.Element) callconv(.C) void,
    f_load_serialize_info: ?*const fn (p_dc: *gstpbutils.Discoverer, p_uri: [*:0]u8) callconv(.C) *gstpbutils.DiscovererInfo,
    f__reserved: [3]*anyopaque,

    pub fn as(p_instance: *DiscovererClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DiscovererPrivate = opaque {};

pub const EncodingAudioProfileClass = opaque {
    pub const Instance = gstpbutils.EncodingAudioProfile;

    pub fn as(p_instance: *EncodingAudioProfileClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const EncodingContainerProfileClass = opaque {
    pub const Instance = gstpbutils.EncodingContainerProfile;

    pub fn as(p_instance: *EncodingContainerProfileClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const EncodingProfileClass = opaque {
    pub const Instance = gstpbutils.EncodingProfile;

    pub fn as(p_instance: *EncodingProfileClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const EncodingVideoProfileClass = opaque {
    pub const Instance = gstpbutils.EncodingVideoProfile;

    pub fn as(p_instance: *EncodingVideoProfileClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Opaque context structure for the plugin installation. Use the provided
/// API to set details on it.
pub const InstallPluginsContext = opaque {
    /// Creates a new `gstpbutils.InstallPluginsContext`.
    extern fn gst_install_plugins_context_new() *gstpbutils.InstallPluginsContext;
    pub const new = gst_install_plugins_context_new;

    /// Copies a `gstpbutils.InstallPluginsContext`.
    extern fn gst_install_plugins_context_copy(p_ctx: *InstallPluginsContext) *gstpbutils.InstallPluginsContext;
    pub const copy = gst_install_plugins_context_copy;

    /// Frees a `gstpbutils.InstallPluginsContext`.
    extern fn gst_install_plugins_context_free(p_ctx: *InstallPluginsContext) void;
    pub const free = gst_install_plugins_context_free;

    /// This function is used to tell the external installer process whether it
    /// should ask for confirmation or not before searching for missing plugins.
    ///
    /// If set, this option will be passed to the installer via a
    /// --interaction=[show-confirm-search|hide-confirm-search] command line option.
    extern fn gst_install_plugins_context_set_confirm_search(p_ctx: *InstallPluginsContext, p_confirm_search: c_int) void;
    pub const setConfirmSearch = gst_install_plugins_context_set_confirm_search;

    /// This function is used to pass the calling application's desktop file ID to
    /// the external installer process.
    ///
    /// A desktop file ID is the basename of the desktop file, including the
    /// .desktop extension.
    ///
    /// If set, the desktop file ID will be passed to the installer via a
    /// --desktop-id= command line option.
    extern fn gst_install_plugins_context_set_desktop_id(p_ctx: *InstallPluginsContext, p_desktop_id: [*:0]const u8) void;
    pub const setDesktopId = gst_install_plugins_context_set_desktop_id;

    /// Sets the startup notification ID for the launched process.
    ///
    /// This is typically used to to pass the current X11 event timestamp to the
    /// external installer process.
    ///
    /// Startup notification IDs are defined in the
    /// [FreeDesktop.Org Startup Notifications standard](http://standards.freedesktop.org/startup-notification-spec/startup-notification-latest.txt).
    ///
    /// If set, the ID will be passed to the installer via a
    /// --startup-notification-id= command line option.
    ///
    /// GTK+/GNOME applications should be able to create a startup notification ID
    /// like this:
    /// ```
    ///   timestamp = gtk_get_current_event_time ();
    ///   startup_id = g_strdup_printf ("_TIME`u`", timestamp);
    /// ...
    /// ```
    extern fn gst_install_plugins_context_set_startup_notification_id(p_ctx: *InstallPluginsContext, p_startup_id: [*:0]const u8) void;
    pub const setStartupNotificationId = gst_install_plugins_context_set_startup_notification_id;

    /// This function is for X11-based applications (such as most Gtk/Qt
    /// applications on linux/unix) only. You can use it to tell the external
    /// installer the XID of your main application window. That way the installer
    /// can make its own window transient to your application window during the
    /// installation.
    ///
    /// If set, the XID will be passed to the installer via a --transient-for=XID
    /// command line option.
    ///
    /// Gtk+/Gnome application should be able to obtain the XID of the top-level
    /// window like this:
    /// ```
    /// #`include` <gtk/gtk.h>
    /// #`ifdef` GDK_WINDOWING_X11
    /// #`include` <gdk/gdkx.h>
    /// #`endif`
    /// ...
    /// #`ifdef` GDK_WINDOWING_X11
    ///   xid = GDK_WINDOW_XWINDOW (GTK_WIDGET (application_window)->window);
    /// #`endif`
    /// ...
    /// ```
    extern fn gst_install_plugins_context_set_xid(p_ctx: *InstallPluginsContext, p_xid: c_uint) void;
    pub const setXid = gst_install_plugins_context_set_xid;

    extern fn gst_install_plugins_context_get_type() usize;
    pub const getGObjectType = gst_install_plugins_context_get_type;
};

/// Different types of supported background shading functions.
pub const AudioVisualizerShader = enum(c_int) {
    none = 0,
    fade = 1,
    fade_and_move_up = 2,
    fade_and_move_down = 3,
    fade_and_move_left = 4,
    fade_and_move_right = 5,
    fade_and_move_horiz_out = 6,
    fade_and_move_horiz_in = 7,
    fade_and_move_vert_out = 8,
    fade_and_move_vert_in = 9,
    _,

    extern fn gst_audio_visualizer_shader_get_type() usize;
    pub const getGObjectType = gst_audio_visualizer_shader_get_type;
};

/// Result values for the discovery process.
pub const DiscovererResult = enum(c_int) {
    ok = 0,
    uri_invalid = 1,
    @"error" = 2,
    timeout = 3,
    busy = 4,
    missing_plugins = 5,
    _,

    extern fn gst_discoverer_result_get_type() usize;
    pub const getGObjectType = gst_discoverer_result_get_type;
};

/// Result codes returned by `gstpbutils.installPluginsAsync` and
/// `gstpbutils.installPluginsSync`, and also the result code passed to the
/// `gstpbutils.InstallPluginsResultFunc` specified with `gstpbutils.installPluginsAsync`.
///
/// These codes indicate success or failure of starting an external installer
/// program and to what extent the requested plugins could be installed.
pub const InstallPluginsReturn = enum(c_int) {
    success = 0,
    not_found = 1,
    @"error" = 2,
    partial_success = 3,
    user_abort = 4,
    crashed = 100,
    invalid = 101,
    started_ok = 200,
    internal_failure = 201,
    helper_missing = 202,
    install_in_progress = 203,
    _,

    /// Convenience function to return the descriptive string associated
    /// with a status code.  This function returns English strings and
    /// should not be used for user messages. It is here only to assist
    /// in debugging.
    extern fn gst_install_plugins_return_get_name(p_ret: gstpbutils.InstallPluginsReturn) [*:0]const u8;
    pub const getName = gst_install_plugins_return_get_name;

    extern fn gst_install_plugins_return_get_type() usize;
    pub const getGObjectType = gst_install_plugins_return_get_type;
};

/// You can use these flags to control what is serialized by
/// `gstpbutils.DiscovererInfo.toVariant`
pub const DiscovererSerializeFlags = packed struct(c_uint) {
    caps: bool = false,
    tags: bool = false,
    misc: bool = false,
    _padding3: bool = false,
    _padding4: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_basic: DiscovererSerializeFlags = @bitCast(@as(c_uint, 0));
    const flags_caps: DiscovererSerializeFlags = @bitCast(@as(c_uint, 1));
    const flags_tags: DiscovererSerializeFlags = @bitCast(@as(c_uint, 2));
    const flags_misc: DiscovererSerializeFlags = @bitCast(@as(c_uint, 4));
    const flags_all: DiscovererSerializeFlags = @bitCast(@as(c_uint, 7));
    extern fn gst_discoverer_serialize_flags_get_type() usize;
    pub const getGObjectType = gst_discoverer_serialize_flags_get_type;
};

/// Flags that are returned by `gstpbutils.pbUtilsGetCapsDescriptionFlags` and
/// describe the format of the caps.
pub const PbUtilsCapsDescriptionFlags = packed struct(c_uint) {
    container: bool = false,
    audio: bool = false,
    video: bool = false,
    image: bool = false,
    subtitle: bool = false,
    tag: bool = false,
    generic: bool = false,
    metadata: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_container: PbUtilsCapsDescriptionFlags = @bitCast(@as(c_uint, 1));
    const flags_audio: PbUtilsCapsDescriptionFlags = @bitCast(@as(c_uint, 2));
    const flags_video: PbUtilsCapsDescriptionFlags = @bitCast(@as(c_uint, 4));
    const flags_image: PbUtilsCapsDescriptionFlags = @bitCast(@as(c_uint, 8));
    const flags_subtitle: PbUtilsCapsDescriptionFlags = @bitCast(@as(c_uint, 16));
    const flags_tag: PbUtilsCapsDescriptionFlags = @bitCast(@as(c_uint, 32));
    const flags_generic: PbUtilsCapsDescriptionFlags = @bitCast(@as(c_uint, 64));
    const flags_metadata: PbUtilsCapsDescriptionFlags = @bitCast(@as(c_uint, 128));
    extern fn gst_pb_utils_caps_description_flags_get_type() usize;
    pub const getGObjectType = gst_pb_utils_caps_description_flags_get_type;
};

/// Sets the level and profile on `caps` if it can be determined from
/// `audio_config`. See `gstpbutils.codecUtilsAacGetLevel` and
/// `gstpbutils.codecUtilsAacGetProfile` for more details on the parameters.
/// `caps` must be audio/mpeg caps with an "mpegversion" field of either 2 or 4.
/// If mpegversion is 4, the "base-profile" field is also set in `caps`.
extern fn gst_codec_utils_aac_caps_set_level_and_profile(p_caps: *gst.Caps, p_audio_config: [*]const u8, p_len: c_uint) c_int;
pub const codecUtilsAacCapsSetLevelAndProfile = gst_codec_utils_aac_caps_set_level_and_profile;

/// Returns the channels of the given AAC stream.
extern fn gst_codec_utils_aac_get_channels(p_audio_config: [*]const u8, p_len: c_uint) c_uint;
pub const codecUtilsAacGetChannels = gst_codec_utils_aac_get_channels;

/// Translates the sample rate to the index corresponding to it in AAC spec.
extern fn gst_codec_utils_aac_get_index_from_sample_rate(p_rate: c_uint) c_int;
pub const codecUtilsAacGetIndexFromSampleRate = gst_codec_utils_aac_get_index_from_sample_rate;

/// Determines the level of a stream as defined in ISO/IEC 14496-3. For AAC LC
/// streams, the constraints from the AAC audio profile are applied. For AAC
/// Main, LTP, SSR and others, the Main profile is used.
///
/// The `audio_config` parameter follows the following format, starting from the
/// most significant bit of the first byte:
///
///   * Bit 0:4 contains the AudioObjectType (if this is 0x5, then the
///     real AudioObjectType is carried after the rate and channel data)
///   * Bit 5:8 contains the sample frequency index (if this is 0xf, then the
///     next 24 bits define the actual sample frequency, and subsequent
///     fields are appropriately shifted).
///   * Bit 9:12 contains the channel configuration
extern fn gst_codec_utils_aac_get_level(p_audio_config: [*]const u8, p_len: c_uint) ?[*:0]const u8;
pub const codecUtilsAacGetLevel = gst_codec_utils_aac_get_level;

/// Returns the profile of the given AAC stream as a string. The profile is
/// normally determined using the AudioObjectType field which is in the first
/// 5 bits of `audio_config`
extern fn gst_codec_utils_aac_get_profile(p_audio_config: [*]const u8, p_len: c_uint) ?[*:0]const u8;
pub const codecUtilsAacGetProfile = gst_codec_utils_aac_get_profile;

/// Translates the sample rate index found in AAC headers to the actual sample
/// rate.
extern fn gst_codec_utils_aac_get_sample_rate(p_audio_config: [*]const u8, p_len: c_uint) c_uint;
pub const codecUtilsAacGetSampleRate = gst_codec_utils_aac_get_sample_rate;

/// Translates the sample rate index found in AAC headers to the actual sample
/// rate.
extern fn gst_codec_utils_aac_get_sample_rate_from_index(p_sr_idx: c_uint) c_uint;
pub const codecUtilsAacGetSampleRateFromIndex = gst_codec_utils_aac_get_sample_rate_from_index;

/// Converts a RFC 6381 compatible codec string to `gst.Caps`. More than one codec
/// string can be present (separated by `,`).
///
/// Registered codecs can be found at http://mp4ra.org/#/codecs
extern fn gst_codec_utils_caps_from_mime_codec(p_codecs_field: [*:0]const u8) ?*gst.Caps;
pub const codecUtilsCapsFromMimeCodec = gst_codec_utils_caps_from_mime_codec;

/// Converts `caps` to a RFC 6381 compatible codec string if possible.
///
/// Useful for providing the 'codecs' field inside the 'Content-Type' HTTP
/// header for containerized formats, such as mp4 or matroska.
///
/// Registered codecs can be found at http://mp4ra.org/#/codecs
extern fn gst_codec_utils_caps_get_mime_codec(p_caps: *gst.Caps) ?[*:0]u8;
pub const codecUtilsCapsGetMimeCodec = gst_codec_utils_caps_get_mime_codec;

/// Sets the level and profile in `caps` if it can be determined from `sps`. See
/// `gstpbutils.codecUtilsH264GetLevel` and `gstpbutils.codecUtilsH264GetProfile`
/// for more details on the parameters.
extern fn gst_codec_utils_h264_caps_set_level_and_profile(p_caps: *gst.Caps, p_sps: [*]const u8, p_len: c_uint) c_int;
pub const codecUtilsH264CapsSetLevelAndProfile = gst_codec_utils_h264_caps_set_level_and_profile;

/// Converts the level indication (level_idc) in the stream's
/// sequence parameter set into a string. The SPS is expected to have the
/// same format as for `gstpbutils.codecUtilsH264GetProfile`.
extern fn gst_codec_utils_h264_get_level(p_sps: [*]const u8, p_len: c_uint) ?[*:0]const u8;
pub const codecUtilsH264GetLevel = gst_codec_utils_h264_get_level;

/// Transform a level string from the caps into the level_idc
extern fn gst_codec_utils_h264_get_level_idc(p_level: [*:0]const u8) u8;
pub const codecUtilsH264GetLevelIdc = gst_codec_utils_h264_get_level_idc;

/// Converts the profile indication (profile_idc) in the stream's
/// sequence parameter set into a string. The SPS is expected to have the
/// following format, as defined in the H.264 specification. The SPS is viewed
/// as a bitstream here, with bit 0 being the most significant bit of the first
/// byte.
///
/// * Bit 0:7   - Profile indication
/// * Bit 8     - constraint_set0_flag
/// * Bit 9     - constraint_set1_flag
/// * Bit 10    - constraint_set2_flag
/// * Bit 11    - constraint_set3_flag
/// * Bit 12    - constraint_set3_flag
/// * Bit 13:15 - Reserved
/// * Bit 16:24 - Level indication
extern fn gst_codec_utils_h264_get_profile(p_sps: [*]const u8, p_len: c_uint) ?[*:0]const u8;
pub const codecUtilsH264GetProfile = gst_codec_utils_h264_get_profile;

/// Parses profile, flags, and level from a H264 AVCC extradata/sequence_header.
/// These are most commonly retrieved from a video/x-h264 caps with a codec_data
/// buffer.
///
/// The format of H264 AVCC extradata/sequence_header is documented in the
/// ITU-T H.264 specification section 7.3.2.1.1 as well as in ISO/IEC 14496-15
/// section 5.3.3.1.2.
extern fn gst_codec_utils_h264_get_profile_flags_level(p_codec_data: [*]const u8, p_len: c_uint, p_profile: ?*u8, p_flags: ?*u8, p_level: ?*u8) c_int;
pub const codecUtilsH264GetProfileFlagsLevel = gst_codec_utils_h264_get_profile_flags_level;

/// Sets the level, tier and profile in `caps` if it can be determined from
/// `profile_tier_level`. See `gstpbutils.codecUtilsH265GetLevel`,
/// `gstpbutils.codecUtilsH265GetTier` and `gstpbutils.codecUtilsH265GetProfile`
/// for more details on the parameters.
extern fn gst_codec_utils_h265_caps_set_level_tier_and_profile(p_caps: *gst.Caps, p_profile_tier_level: [*]const u8, p_len: c_uint) c_int;
pub const codecUtilsH265CapsSetLevelTierAndProfile = gst_codec_utils_h265_caps_set_level_tier_and_profile;

/// Converts the level indication (general_level_idc) in the stream's
/// profile_tier_level structure into a string. The profiel_tier_level is
/// expected to have the same format as for `gstpbutils.codecUtilsH264GetProfile`.
extern fn gst_codec_utils_h265_get_level(p_profile_tier_level: [*]const u8, p_len: c_uint) ?[*:0]const u8;
pub const codecUtilsH265GetLevel = gst_codec_utils_h265_get_level;

/// Transform a level string from the caps into the level_idc
extern fn gst_codec_utils_h265_get_level_idc(p_level: [*:0]const u8) u8;
pub const codecUtilsH265GetLevelIdc = gst_codec_utils_h265_get_level_idc;

/// Converts the profile indication (general_profile_idc) in the stream's
/// profile_level_tier structure into a string. The profile_tier_level is
/// expected to have the following format, as defined in the H.265
/// specification. The profile_tier_level is viewed as a bitstream here,
/// with bit 0 being the most significant bit of the first byte.
///
/// * Bit 0:1   - general_profile_space
/// * Bit 2     - general_tier_flag
/// * Bit 3:7   - general_profile_idc
/// * Bit 8:39  - gernal_profile_compatibility_flags
/// * Bit 40    - general_progressive_source_flag
/// * Bit 41    - general_interlaced_source_flag
/// * Bit 42    - general_non_packed_constraint_flag
/// * Bit 43    - general_frame_only_constraint_flag
/// * Bit 44:87 - See below
/// * Bit 88:95 - general_level_idc
extern fn gst_codec_utils_h265_get_profile(p_profile_tier_level: [*]const u8, p_len: c_uint) ?[*:0]const u8;
pub const codecUtilsH265GetProfile = gst_codec_utils_h265_get_profile;

/// Converts the tier indication (general_tier_flag) in the stream's
/// profile_tier_level structure into a string. The profile_tier_level
/// is expected to have the same format as for `gstpbutils.codecUtilsH264GetProfile`.
extern fn gst_codec_utils_h265_get_tier(p_profile_tier_level: [*]const u8, p_len: c_uint) ?[*:0]const u8;
pub const codecUtilsH265GetTier = gst_codec_utils_h265_get_tier;

/// Sets the level and profile in `caps` if it can be determined from
/// `vis_obj_seq`. See `gstpbutils.codecUtilsMpeg4videoGetLevel` and
/// `gstpbutils.codecUtilsMpeg4videoGetProfile` for more details on the
/// parameters.
extern fn gst_codec_utils_mpeg4video_caps_set_level_and_profile(p_caps: *gst.Caps, p_vis_obj_seq: [*]const u8, p_len: c_uint) c_int;
pub const codecUtilsMpeg4videoCapsSetLevelAndProfile = gst_codec_utils_mpeg4video_caps_set_level_and_profile;

/// Converts the level indication in the stream's visual object sequence into
/// a string. `vis_obj_seq` is expected to be the data following the visual
/// object sequence start code. Only the first byte
/// (profile_and_level_indication) is used.
extern fn gst_codec_utils_mpeg4video_get_level(p_vis_obj_seq: [*]const u8, p_len: c_uint) ?[*:0]const u8;
pub const codecUtilsMpeg4videoGetLevel = gst_codec_utils_mpeg4video_get_level;

/// Converts the profile indication in the stream's visual object sequence into
/// a string. `vis_obj_seq` is expected to be the data following the visual
/// object sequence start code. Only the first byte
/// (profile_and_level_indication) is used.
extern fn gst_codec_utils_mpeg4video_get_profile(p_vis_obj_seq: [*]const u8, p_len: c_uint) ?[*:0]const u8;
pub const codecUtilsMpeg4videoGetProfile = gst_codec_utils_mpeg4video_get_profile;

/// Creates Opus caps from the given parameters.
extern fn gst_codec_utils_opus_create_caps(p_rate: u32, p_channels: u8, p_channel_mapping_family: u8, p_stream_count: u8, p_coupled_count: u8, p_channel_mapping: ?[*]const u8) ?*gst.Caps;
pub const codecUtilsOpusCreateCaps = gst_codec_utils_opus_create_caps;

/// Creates Opus caps from the given OpusHead `header` and comment header
/// `comments`.
extern fn gst_codec_utils_opus_create_caps_from_header(p_header: *gst.Buffer, p_comments: ?*gst.Buffer) ?*gst.Caps;
pub const codecUtilsOpusCreateCapsFromHeader = gst_codec_utils_opus_create_caps_from_header;

/// Creates OpusHead header from the given parameters.
extern fn gst_codec_utils_opus_create_header(p_rate: u32, p_channels: u8, p_channel_mapping_family: u8, p_stream_count: u8, p_coupled_count: u8, p_channel_mapping: ?[*]const u8, p_pre_skip: u16, p_output_gain: i16) ?*gst.Buffer;
pub const codecUtilsOpusCreateHeader = gst_codec_utils_opus_create_header;

/// Parses Opus caps and fills the different fields with defaults if possible.
extern fn gst_codec_utils_opus_parse_caps(p_caps: *gst.Caps, p_rate: ?*u32, p_channels: ?*u8, p_channel_mapping_family: ?*u8, p_stream_count: ?*u8, p_coupled_count: ?*u8, p_channel_mapping: ?*[256]u8) c_int;
pub const codecUtilsOpusParseCaps = gst_codec_utils_opus_parse_caps;

/// Parses the OpusHead header.
extern fn gst_codec_utils_opus_parse_header(p_header: *gst.Buffer, p_rate: ?*u32, p_channels: ?*u8, p_channel_mapping_family: ?*u8, p_stream_count: ?*u8, p_coupled_count: ?*u8, p_channel_mapping: ?*[256]u8, p_pre_skip: ?*u16, p_output_gain: ?*i16) c_int;
pub const codecUtilsOpusParseHeader = gst_codec_utils_opus_parse_header;

/// List all available `gstpbutils.EncodingTarget` for the specified category, or all categories
/// if `categoryname` is `NULL`.
extern fn gst_encoding_list_all_targets(p_categoryname: ?[*:0]const u8) *glib.List;
pub const encodingListAllTargets = gst_encoding_list_all_targets;

/// Lists all `gstpbutils.EncodingTarget` categories present on disk.
extern fn gst_encoding_list_available_categories() *glib.List;
pub const encodingListAvailableCategories = gst_encoding_list_available_categories;

/// Requests plugin installation without blocking. Once the plugins have been
/// installed or installation has failed, `func` will be called with the result
/// of the installation and your provided `user_data` pointer.
///
/// This function requires a running GLib/Gtk main loop. If you are not
/// running a GLib/Gtk main loop, make sure to regularly call
/// g_main_context_iteration(NULL,FALSE).
///
/// The installer strings that make up `detail` are typically obtained by
/// calling `gstpbutils.missingPluginMessageGetInstallerDetail` on missing-plugin
/// messages that have been caught on a pipeline's bus or created by the
/// application via the provided API, such as `gstpbutils.missingElementMessageNew`.
///
/// It is possible to request the installation of multiple missing plugins in
/// one go (as might be required if there is a demuxer for a certain format
/// installed but no suitable video decoder and no suitable audio decoder).
extern fn gst_install_plugins_async(p_details: [*]const [*:0]const u8, p_ctx: ?*gstpbutils.InstallPluginsContext, p_func: gstpbutils.InstallPluginsResultFunc, p_user_data: ?*anyopaque) gstpbutils.InstallPluginsReturn;
pub const installPluginsAsync = gst_install_plugins_async;

/// Checks whether plugin installation (initiated by this application only)
/// is currently in progress.
extern fn gst_install_plugins_installation_in_progress() c_int;
pub const installPluginsInstallationInProgress = gst_install_plugins_installation_in_progress;

/// Checks whether plugin installation is likely to be supported by the
/// current environment. This currently only checks whether the helper script
/// that is to be provided by the distribution or operating system vendor
/// exists.
extern fn gst_install_plugins_supported() c_int;
pub const installPluginsSupported = gst_install_plugins_supported;

/// Requests plugin installation and block until the plugins have been
/// installed or installation has failed.
///
/// This function should almost never be used, it only exists for cases where
/// a non-GLib main loop is running and the user wants to run it in a separate
/// thread and marshal the result back asynchronously into the main thread
/// using the other non-GLib main loop. You should almost always use
/// `gstpbutils.installPluginsAsync` instead of this function.
extern fn gst_install_plugins_sync(p_details: [*]const [*:0]const u8, p_ctx: ?*gstpbutils.InstallPluginsContext) gstpbutils.InstallPluginsReturn;
pub const installPluginsSync = gst_install_plugins_sync;

/// Checks whether `msg` is a missing plugins message.
extern fn gst_is_missing_plugin_message(p_msg: *gst.Message) c_int;
pub const isMissingPluginMessage = gst_is_missing_plugin_message;

/// Returns an opaque string containing all the details about the missing
/// element to be passed to an external installer called via
/// `gstpbutils.installPluginsAsync` or `gstpbutils.installPluginsSync`.
///
/// This function is mainly for applications that call external plugin
/// installation mechanisms using one of the two above-mentioned functions in
/// the case where the application knows exactly what kind of plugin it is
/// missing.
extern fn gst_missing_decoder_installer_detail_new(p_decode_caps: *const gst.Caps) [*:0]u8;
pub const missingDecoderInstallerDetailNew = gst_missing_decoder_installer_detail_new;

/// Creates a missing-plugin message for `element` to notify the application
/// that a decoder element for a particular set of (fixed) caps is missing.
/// This function is mainly for use in plugins.
extern fn gst_missing_decoder_message_new(p_element: *gst.Element, p_decode_caps: *const gst.Caps) *gst.Message;
pub const missingDecoderMessageNew = gst_missing_decoder_message_new;

/// Returns an opaque string containing all the details about the missing
/// element to be passed to an external installer called via
/// `gstpbutils.installPluginsAsync` or `gstpbutils.installPluginsSync`.
///
/// This function is mainly for applications that call external plugin
/// installation mechanisms using one of the two above-mentioned functions in
/// the case where the application knows exactly what kind of plugin it is
/// missing.
extern fn gst_missing_element_installer_detail_new(p_factory_name: [*:0]const u8) [*:0]u8;
pub const missingElementInstallerDetailNew = gst_missing_element_installer_detail_new;

/// Creates a missing-plugin message for `element` to notify the application
/// that a certain required element is missing. This function is mainly for
/// use in plugins.
extern fn gst_missing_element_message_new(p_element: *gst.Element, p_factory_name: [*:0]const u8) *gst.Message;
pub const missingElementMessageNew = gst_missing_element_message_new;

/// Returns an opaque string containing all the details about the missing
/// element to be passed to an external installer called via
/// `gstpbutils.installPluginsAsync` or `gstpbutils.installPluginsSync`.
///
/// This function is mainly for applications that call external plugin
/// installation mechanisms using one of the two above-mentioned functions in
/// the case where the application knows exactly what kind of plugin it is
/// missing.
extern fn gst_missing_encoder_installer_detail_new(p_encode_caps: *const gst.Caps) [*:0]u8;
pub const missingEncoderInstallerDetailNew = gst_missing_encoder_installer_detail_new;

/// Creates a missing-plugin message for `element` to notify the application
/// that an encoder element for a particular set of (fixed) caps is missing.
/// This function is mainly for use in plugins.
extern fn gst_missing_encoder_message_new(p_element: *gst.Element, p_encode_caps: *const gst.Caps) *gst.Message;
pub const missingEncoderMessageNew = gst_missing_encoder_message_new;

/// Returns a localised string describing the missing feature, for use in
/// error dialogs and the like. Should never return NULL unless `msg` is not
/// a valid missing-plugin message.
///
/// This function is mainly for applications that need a human-readable string
/// describing a missing plugin, given a previously collected missing-plugin
/// message
extern fn gst_missing_plugin_message_get_description(p_msg: *gst.Message) [*:0]u8;
pub const missingPluginMessageGetDescription = gst_missing_plugin_message_get_description;

/// Returns an opaque string containing all the details about the missing
/// element to be passed to an external installer called via
/// `gstpbutils.installPluginsAsync` or `gstpbutils.installPluginsSync`.
///
/// This function is mainly for applications that call external plugin
/// installation mechanisms using one of the two above-mentioned functions.
extern fn gst_missing_plugin_message_get_installer_detail(p_msg: *gst.Message) ?[*:0]u8;
pub const missingPluginMessageGetInstallerDetail = gst_missing_plugin_message_get_installer_detail;

/// Returns an opaque string containing all the details about the missing
/// element to be passed to an external installer called via
/// `gstpbutils.installPluginsAsync` or `gstpbutils.installPluginsSync`.
///
/// This function is mainly for applications that call external plugin
/// installation mechanisms using one of the two above-mentioned functions in
/// the case where the application knows exactly what kind of plugin it is
/// missing.
extern fn gst_missing_uri_sink_installer_detail_new(p_protocol: [*:0]const u8) [*:0]u8;
pub const missingUriSinkInstallerDetailNew = gst_missing_uri_sink_installer_detail_new;

/// Creates a missing-plugin message for `element` to notify the application
/// that a sink element for a particular URI protocol is missing. This
/// function is mainly for use in plugins.
extern fn gst_missing_uri_sink_message_new(p_element: *gst.Element, p_protocol: [*:0]const u8) *gst.Message;
pub const missingUriSinkMessageNew = gst_missing_uri_sink_message_new;

/// Returns an opaque string containing all the details about the missing
/// element to be passed to an external installer called via
/// `gstpbutils.installPluginsAsync` or `gstpbutils.installPluginsSync`.
///
/// This function is mainly for applications that call external plugin
/// installation mechanisms using one of the two above-mentioned functions in
/// the case where the application knows exactly what kind of plugin it is
/// missing.
extern fn gst_missing_uri_source_installer_detail_new(p_protocol: [*:0]const u8) [*:0]u8;
pub const missingUriSourceInstallerDetailNew = gst_missing_uri_source_installer_detail_new;

/// Creates a missing-plugin message for `element` to notify the application
/// that a source element for a particular URI protocol is missing. This
/// function is mainly for use in plugins.
extern fn gst_missing_uri_source_message_new(p_element: *gst.Element, p_protocol: [*:0]const u8) *gst.Message;
pub const missingUriSourceMessageNew = gst_missing_uri_source_message_new;

/// Adds a codec tag describing the format specified by `caps` to `taglist`.
extern fn gst_pb_utils_add_codec_description_to_tag_list(p_taglist: *gst.TagList, p_codec_tag: ?[*:0]const u8, p_caps: *const gst.Caps) c_int;
pub const pbUtilsAddCodecDescriptionToTagList = gst_pb_utils_add_codec_description_to_tag_list;

/// Returns flags that describe the format of the caps if known. No flags are
/// set for unknown caps.
extern fn gst_pb_utils_get_caps_description_flags(p_caps: *const gst.Caps) gstpbutils.PbUtilsCapsDescriptionFlags;
pub const pbUtilsGetCapsDescriptionFlags = gst_pb_utils_get_caps_description_flags;

/// Returns a localised (as far as this is possible) string describing the
/// media format specified in `caps`, for use in error dialogs or other messages
/// to be seen by the user. Should never return NULL unless `caps` is invalid.
///
/// Also see the convenience function
/// `gstpbutils.pbUtilsAddCodecDescriptionToTagList`.
extern fn gst_pb_utils_get_codec_description(p_caps: *const gst.Caps) ?[*:0]u8;
pub const pbUtilsGetCodecDescription = gst_pb_utils_get_codec_description;

/// Returns a localised string describing an decoder for the format specified
/// in `caps`, for use in error dialogs or other messages to be seen by the user.
///
/// This function is mainly for internal use, applications would typically
/// use `gstpbutils.missingPluginMessageGetDescription` to get a description of
/// a missing feature from a missing-plugin message.
extern fn gst_pb_utils_get_decoder_description(p_caps: *const gst.Caps) [*:0]u8;
pub const pbUtilsGetDecoderDescription = gst_pb_utils_get_decoder_description;

/// Returns a localised string describing the given element, for use in
/// error dialogs or other messages to be seen by the user.
///
/// This function is mainly for internal use, applications would typically
/// use `gstpbutils.missingPluginMessageGetDescription` to get a description of
/// a missing feature from a missing-plugin message.
extern fn gst_pb_utils_get_element_description(p_factory_name: [*:0]const u8) [*:0]u8;
pub const pbUtilsGetElementDescription = gst_pb_utils_get_element_description;

/// Returns a localised string describing an encoder for the format specified
/// in `caps`, for use in error dialogs or other messages to be seen by the user.
///
/// This function is mainly for internal use, applications would typically
/// use `gstpbutils.missingPluginMessageGetDescription` to get a description of
/// a missing feature from a missing-plugin message.
extern fn gst_pb_utils_get_encoder_description(p_caps: *const gst.Caps) [*:0]u8;
pub const pbUtilsGetEncoderDescription = gst_pb_utils_get_encoder_description;

/// Returns a possible file extension for the given caps, if known.
extern fn gst_pb_utils_get_file_extension_from_caps(p_caps: *const gst.Caps) ?[*:0]u8;
pub const pbUtilsGetFileExtensionFromCaps = gst_pb_utils_get_file_extension_from_caps;

/// Returns a localised string describing a sink element handling the protocol
/// specified in `protocol`, for use in error dialogs or other messages to be
/// seen by the user.
///
/// This function is mainly for internal use, applications would typically
/// use `gstpbutils.missingPluginMessageGetDescription` to get a description of
/// a missing feature from a missing-plugin message.
extern fn gst_pb_utils_get_sink_description(p_protocol: [*:0]const u8) [*:0]u8;
pub const pbUtilsGetSinkDescription = gst_pb_utils_get_sink_description;

/// Returns a localised string describing a source element handling the protocol
/// specified in `protocol`, for use in error dialogs or other messages to be
/// seen by the user.
///
/// This function is mainly for internal use, applications would typically
/// use `gstpbutils.missingPluginMessageGetDescription` to get a description of
/// a missing feature from a missing-plugin message.
extern fn gst_pb_utils_get_source_description(p_protocol: [*:0]const u8) [*:0]u8;
pub const pbUtilsGetSourceDescription = gst_pb_utils_get_source_description;

/// Initialises the base utils support library. This function is not
/// thread-safe. Applications should call it after calling `gst.init`,
/// plugins should call it from their plugin_init function.
///
/// This function may be called multiple times. It will do nothing if the
/// library has already been initialised.
extern fn gst_pb_utils_init() void;
pub const pbUtilsInit = gst_pb_utils_init;

/// Gets the version number of the GStreamer Plugins Base libraries.
extern fn gst_plugins_base_version(p_major: *c_uint, p_minor: *c_uint, p_micro: *c_uint, p_nano: *c_uint) void;
pub const pluginsBaseVersion = gst_plugins_base_version;

/// This function returns a string that is useful for describing this version
/// of GStreamer's gst-plugins-base libraries to the outside world: user agent
/// strings, logging, about dialogs ...
extern fn gst_plugins_base_version_string() [*:0]u8;
pub const pluginsBaseVersionString = gst_plugins_base_version_string;

pub const AudioVisualizerShaderFunc = *const fn (p_scope: *gstpbutils.AudioVisualizer, p_s: *const gstvideo.VideoFrame, p_d: *gstvideo.VideoFrame) callconv(.C) void;

/// The prototype of the callback function that will be called once the
/// external plugin installer program has returned. You only need to provide
/// a callback function if you are using the asynchronous interface.
pub const InstallPluginsResultFunc = *const fn (p_result: gstpbutils.InstallPluginsReturn, p_user_data: ?*anyopaque) callconv(.C) void;

/// `gstpbutils.EncodingTarget` category for recording and capture.
/// Targets within this category are optimized for low latency encoding.
pub const ENCODING_CATEGORY_CAPTURE = "capture";
/// `gstpbutils.EncodingTarget` category for device-specific targets.
/// The name of the target will usually be the constructor and model of the device,
/// and that target will contain `GstEncodingProfiles` suitable for that device.
pub const ENCODING_CATEGORY_DEVICE = "device";
/// `gstpbutils.EncodingTarget` category for file extensions.
/// The name of the target will be the name of the file extensions possible
/// for a particular target. Those targets are defining like 'default' formats
/// usually used for a particular file extension.
pub const ENCODING_CATEGORY_FILE_EXTENSION = "file-extension";
/// `gstpbutils.EncodingTarget` category for online-services.
/// The name of the target will usually be the name of the online service
/// and that target will contain `GstEncodingProfiles` suitable for that online
/// service.
pub const ENCODING_CATEGORY_ONLINE_SERVICE = "online-service";
/// `gstpbutils.EncodingTarget` category for storage, archiving and editing targets.
/// Those targets can be lossless and/or provide very fast random access content.
/// The name of the target will usually be the container type or editing target,
/// and that target will contain `GstEncodingProfiles` suitable for editing or
/// storage.
pub const ENCODING_CATEGORY_STORAGE_EDITING = "storage-editing";
/// The major version of GStreamer's gst-plugins-base libraries at compile time.
pub const PLUGINS_BASE_VERSION_MAJOR = 1;
/// The micro version of GStreamer's gst-plugins-base libraries at compile time.
pub const PLUGINS_BASE_VERSION_MICRO = 7;
/// The minor version of GStreamer's gst-plugins-base libraries at compile time.
pub const PLUGINS_BASE_VERSION_MINOR = 24;
/// The nano version of GStreamer's gst-plugins-base libraries at compile time.
/// Actual releases have 0, GIT versions have 1, prerelease versions have 2-...
pub const PLUGINS_BASE_VERSION_NANO = 0;
