/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// disable data conversion warnings

#pragma warning(disable : 4244)     // MIPS
#pragma warning(disable : 4136)     // X86
#pragma warning(disable : 4051)     // ALPHA
  
#ifdef _WIN32
#include <windows.h>
#endif

#if defined (__APPLE__) || defined (MACOSX)
#include <OpenGL/gl.h>
#include <OpenGL/glu.h>
#include <OpenGL/glext.h>
#else
#include <GL/gl.h>
#include <GL/glu.h>
#endif /* __APPLE__ ||MACOSX */

/* use the correct dynamic function address binder */  
#if defined (SDL)
#define SAFE_GET_PROC( func, type, name)     \
   func = (type) SDL_GL_GetProcAddress (name)
#elif defined (__glx__)
#define SAFE_GET_PROC( func, type, name)     \
   func = (type) glXGetProcAddressARB (name)
#else
#define SAFE_GET_PROC( func, type, name)     \
   func = (type) wglGetProcAddress( name)
#endif


// - DC -
#if defined (SDL) 
#include <SDL/SDL_opengl.h>
#endif

#if defined (__glx__)
#include <GL/glx.h>
#endif

void GL_BeginRendering (int *x, int *y, int *width, int *height);
void GL_EndRendering (void);


#ifdef _WIN32
// Function prototypes for the Texture Object Extension routines
typedef GLboolean (APIENTRY *ARETEXRESFUNCPTR)(GLsizei, const GLuint *,
                    const GLboolean *);
typedef void (APIENTRY *BINDTEXFUNCPTR)(GLenum, GLuint);
typedef void (APIENTRY *DELTEXFUNCPTR)(GLsizei, const GLuint *);
typedef void (APIENTRY *GENTEXFUNCPTR)(GLsizei, GLuint *);
typedef GLboolean (APIENTRY *ISTEXFUNCPTR)(GLuint);
typedef void (APIENTRY *PRIORTEXFUNCPTR)(GLsizei, const GLuint *,
                    const GLclampf *);
typedef void (APIENTRY *TEXSUBIMAGEPTR)(int, int, int, int, int, int, int, int, void *);

extern	BINDTEXFUNCPTR bindTexFunc;
extern	DELTEXFUNCPTR delTexFunc;
extern	TEXSUBIMAGEPTR TexSubImage2DFunc;
#endif

extern	int texture_extension_number;
extern	int		texture_mode;
extern	int	glow_texture_object;	//PENTA: gl texture object of the glow texture
extern	int normcube_texture_object;//PENTA: gl texture object of the normalization cubemap 
extern	int halo_texture_object;	//PENTA: Halo light texture
extern  int	atten1d_texture_object;
extern  int	atten2d_texture_object;
extern  int	atten3d_texture_object;
extern	float	gldepthmin, gldepthmax;

void GL_Upload32 (unsigned *data, int width, int height,  qboolean mipmap, qboolean alpha);
void GL_Upload8 (byte *data,char *identifier, int width, int height,  qboolean mipmap, qboolean alpha, qboolean bump);
int GL_LoadTexture (char *identifier, int width, int height, byte *data, qboolean mipmap, qboolean alpha, qboolean bump);
int GL_FindTexture (char *identifier);

typedef struct
{
	float	x, y, z;
	float	s, t;
	float	r, g, b;
} glvert_t;

extern glvert_t glv;

extern	int glx, gly, glwidth, glheight;

#ifdef _WIN32
extern	PROC glArrayElementEXT;
extern	PROC glColorPointerEXT;
extern	PROC glTexturePointerEXT;
extern	PROC glVertexPointerEXT;
#endif

// r_local.h -- private refresh defs

#define ALIAS_BASE_SIZE_RATIO		(1.0 / 11.0)
					// normalizing factor so player model works out to about
					//  1 pixel per triangle
#define	MAX_LBM_HEIGHT		480

#define TILE_SIZE		128		// size of textures generated by R_GenTiledSurf

#define SKYSHIFT		7
#define	SKYSIZE			(1 << SKYSHIFT)
#define SKYMASK			(SKYSIZE - 1)

#define BACKFACE_EPSILON	0.01


void R_TimeRefresh_f (void);
void R_ReadPointFile_f (void);
texture_t *R_TextureAnimation (texture_t *base);

typedef struct surfcache_s
{
	struct surfcache_s	*next;
	struct surfcache_s 	**owner;		// NULL is an empty chunk of memory
	int					lightadj[MAXLIGHTMAPS]; // checked for strobe flush
	int					dlight;
	int					size;		// including header
	unsigned			width;
	unsigned			height;		// DEBUG only needed for debug
	float				mipscale;
	struct texture_s	*texture;	// checked for animating textures
	byte				data[4];	// width*height elements
} surfcache_t;


typedef struct
{
	pixel_t		*surfdat;	// destination for generated surface
	int			rowbytes;	// destination logical width in bytes
	msurface_t	*surf;		// description for surface to generate
	fixed8_t	lightadj[MAXLIGHTMAPS];
							// adjust for lightmap levels for dynamic lighting
	texture_t	*texture;	// corrected for animating textures
	int			surfmip;	// mipmapped ratio of surface texels / world pixels
	int			surfwidth;	// in mipmapped texels
	int			surfheight;	// in mipmapped texels
} drawsurf_t;


typedef enum {
	pt_static, pt_grav, pt_slowgrav, pt_fire, pt_explode, pt_explode2, pt_blob, pt_blob2
} ptype_t;

typedef enum {
	pb_add, pb_subtract
} pblend_t;


typedef enum {
	emt_box
} emtype_t;

typedef enum {
	align_view, align_vel, align_surf
} align_t;

typedef struct ParticleEffect_s {
	char name[64];
	vec3_t emmiterParams1, emmiterParams2; //mins maxs of emmiter box
	emtype_t emmiterType; //currently only box is supported
	vec3_t startcolormin, startcolormax, endcolormin, endcolormax;
	vec3_t velocitymin, velocitymax; //min max velocity
	float	lifemin, lifemax; //min max life
	int	movetype; //how it moves (gravity/collision...)
	vec3_t	gravity;
	float	rotmin, rotmax;//rotaiton speed
	float	growmin, growmax;//scale speed (make second smaller to shrink)
	float	sizemin, sizemax;//scale speed (make second smaller to shrink)
	vec3_t	drag; //drag of particle (how fast it looses it's speed)
	int	srcblend, dstblend; // gl enums for blend modes
	int	numbounces; //number of bounces before particle is deleted
	int	texture; //gl object of the texture	
	align_t	align;//particle is aligned with its velocity
	float	velscale;
	struct ParticleEffect_s *spawn; //particle effect to spawn on hit
	struct ParticleEffect_s *next;
} ParticleEffect_t;

// !!! if this is changed, it must be changed in d_ifacea.h too !!!
typedef struct particle_s
{
// driver-usable fields
	vec3_t		org;
	vec3_t		color;
// drivers never touch the following fields
	struct particle_s	*next;
	vec3_t		vel;
        //float		ramp;
	float		die, lifetime;
        //ptype_t		type;
//PENTA: Nicer particles (tm)
	int			texture; //texture object of particle
	int			numbounces; //number of bounces left before deletion set to zero for no bounce
	float		rot;
	float		rspeed;
	float		size;
	float		growspeed;
	qboolean	velaligned;
	//pblend_t	blendfunc;
	vec3_t		startcolor, endcolor;
	int			srcblend, dstblend;
	vec3_t		gravity;
	vec3_t		drag;
	float		velscale;
	ParticleEffect_t *spawn; 
} particle_t;

typedef enum {
	dt_blood
} dtype_t;

#define MAX_DECAL_VERTICES 128
#define MAX_DECAL_TRIANGLES 64
//PENTA: Decals
typedef struct decal_s
{
	vec3_t		origin;
	vec3_t		normal;
	vec3_t		tangent;
	float		radius;

	float		color[4], startcolor[4], endcolor[4];
	struct decal_s	*next;
	float		die;
	float		lifetime;
	dtype_t		type;
	int			texture; //texture object of particle
	int			srcblend;
	int			dstblend;

	//geometry of decail
	int	vertexCount, triangleCount;
	vec3_t		vertexArray[MAX_DECAL_VERTICES];
	float		texcoordArray[MAX_DECAL_VERTICES][2];
	int			triangleArray[MAX_DECAL_TRIANGLES][3];
} decal_t;

void R_SpawnDecal(vec3_t center, vec3_t normal, vec3_t tangent, ParticleEffect_t *effect);
float RandomMinMax(float min, float max);

//====================================================


extern	entity_t	r_worldentity;
extern	qboolean	r_cache_thrash;		// compatability
extern	vec3_t		modelorg, r_entorigin;
extern	entity_t	*currententity;
extern	int			r_visframecount;	// ??? what difs?
extern	int			r_framecount;
extern	int			r_lightTimestamp;//PENTA: we need this in different files
extern	mplane_t	frustum[4];
extern	int		c_brush_polys, c_alias_polys;


//
// view origin
//
extern	vec3_t	vup;
extern	vec3_t	vpn;
extern	vec3_t	vright;
extern	vec3_t	r_origin;

//
// screen size info
//
extern	refdef_t	r_refdef;
extern	mleaf_t		*r_viewleaf, *r_oldviewleaf;
extern	texture_t	*r_notexture_mip;
extern	int		d_lightstylevalue[256];	// 8.8 fraction of base light value

extern	qboolean	envmap;
extern	int	currenttexture;
extern	int	cnttextures[16];
extern	int	particletexture;
extern	int	particletexture_smoke;
extern	int	particletexture_glow;
extern	int	particletexture_glow2;
extern	int	particletexture_tele;
extern	int	particletexture_blood;
extern	int	particletexture_dirblood;
extern	int	playertextures;
extern	int	gl_filter_min;
extern	int	gl_filter_max;

extern	int	skytexturenum;		// index in cl.loadmodel, not gl texture object

extern	cvar_t	r_norefresh;
extern	cvar_t	r_drawentities;
extern	cvar_t	r_drawworld;
extern	cvar_t	r_drawviewmodel;
extern	cvar_t	r_waterwarp;
extern	cvar_t	r_fullbright;
extern	cvar_t	r_lightmap;
extern	cvar_t	r_shadows;
extern	cvar_t	r_mirroralpha;
extern	cvar_t	r_wateralpha;
extern	cvar_t	r_dynamic;
extern	cvar_t	r_novis;

extern	cvar_t	gl_clear;
extern	cvar_t	gl_cull;
extern	cvar_t	gl_poly;
//extern	cvar_t	gl_texsort;
extern	cvar_t	gl_smoothmodels;
extern	cvar_t	gl_affinemodels;
extern	cvar_t	gl_polyblend;
//extern	cvar_t	gl_keeptjunctions; PENTA: dont remove t-junctions
extern	cvar_t	gl_reporttjunctions;
extern	cvar_t	gl_flashblend;
extern	cvar_t	gl_nocolors;
extern	cvar_t	gl_doubleeyes;

extern	int		gl_lightmap_format;
extern	int		gl_solid_format;
extern	int		gl_alpha_format;

extern	cvar_t	gl_max_size;
extern	cvar_t	gl_playermip;

extern  cvar_t	gl_watershader; //PENTA:
extern  cvar_t	gl_calcdepth;

extern  cvar_t	sh_lightmapbright; //PENTA:
extern  cvar_t	sh_radiusscale;
extern  cvar_t	sh_visiblevolumes;
extern  cvar_t  sh_entityshadows;
extern  cvar_t  sh_worldshadows;
extern  cvar_t  sh_showlightnum;
extern  cvar_t  sh_glows;
extern	cvar_t  sh_fps;	// set for running times - muff
extern	cvar_t  sh_debuginfo;
extern	cvar_t	sh_norevis; //PENTA: no recalculating the vis for light positions
extern	cvar_t	sh_nosvbsp; //PENTA: no shadow bsp
extern	cvar_t	sh_noeclip; //PENTA: no entity/leaf clipping for shadows
extern  cvar_t  sh_infinitevolumes;//PENTA:
extern  cvar_t  sh_noscissor;
extern	cvar_t	sh_nocleversave;
extern	cvar_t	sh_bumpmaps;//PENTA: enable disable bump mapping
extern	cvar_t	sh_colormaps;//PENTA: enable disable textures on the world (light will remain)
extern	cvar_t	sh_playershadow;//PENTA: the player casts a shadow (the one YOU are playing with, others always cast shadows)
extern	cvar_t	sh_nocache;
extern	cvar_t	sh_glares;
extern	cvar_t	sh_noefrags;
extern  cvar_t  sh_showtangent;
extern  cvar_t	sh_noshadowpopping;
extern	cvar_t	fog_waterfog;
extern	cvar_t	gl_caustics;
extern	cvar_t	gl_truform;
extern	cvar_t	gl_truform_tesselation;
extern	cvar_t	gl_transformlerp;
extern	cvar_t	gl_compress_textures;
extern  cvar_t	scr_fov;	// 10 - 170
extern	cvar_t	mir_detail; //PENTA: mirror detail level
							//0: no mirrors
							//1: World only
							//2: World & player
							//3: Full
extern	cvar_t	mir_frameskip; //PENTA: mirror is updated every i'th frame
extern	cvar_t	mir_forcewater; //Forces all quake's water to be reflecting.
extern	cvar_t	mir_distance; //maximum drawing distance
extern  cvar_t	gl_wireframe;
extern  cvar_t	fog_r;
extern  cvar_t	fog_g;
extern  cvar_t	fog_b;
extern  cvar_t	fog_start;
extern  cvar_t	fog_end;
extern  cvar_t	fog_enabled;
extern	float	fog_color[4];

extern	int			mirrortexturenum;	// quake texturenum, not gltexturenum
extern	qboolean	mirror;
extern	qboolean	glare;
extern	mplane_t	*mirror_plane;
extern  mplane_t	mirror_far_plane;
extern	int			mirror_clipside;
extern  float vid_gamma;

extern	float	r_world_matrix[16];
extern	double	r_Dproject_matrix[16];			//PENTA	<AWE> added "extern".
extern	double	r_Dworld_matrix[16];			//PENTA	<AWE> added "extern".
extern  int 	r_Iviewport[4];				//PENTA

extern	float color_black[4];

#define NUMVERTEXNORMALS	162

extern float	r_avertexnormals[NUMVERTEXNORMALS][3];


extern	const char *gl_vendor;
extern	const char *gl_renderer;
extern	const char *gl_version;
extern	const char *gl_extensions;

void R_TranslatePlayerSkin (int playernum);
void GL_Bind (int texnum);

#ifndef _WIN32
#define APIENTRY /* */
#endif

#if !defined (__APPLE__) && !defined (MACOSX)


// Multitexture
//#define    TEXTURE0_SGIS				0x835E
//#define    TEXTURE1_SGIS				0x835F

/* ARB_multitexture defines and prototypes from <GL/gl.h> */
#define GL_ACTIVE_TEXTURE_ARB               0x84E0
#define GL_CLIENT_ACTIVE_TEXTURE_ARB        0x84E1
#define GL_MAX_ACTIVE_TEXTURES_ARB          0x84E2
#define GL_TEXTURE0_ARB                     0x84C0
#define GL_TEXTURE1_ARB                     0x84C1
#define GL_TEXTURE2_ARB                     0x84C2
#define GL_TEXTURE3_ARB                     0x84C3
#define GL_TEXTURE4_ARB                     0x84C4
#define GL_TEXTURE5_ARB                     0x84C5
#define GL_TEXTURE6_ARB                     0x84C6
#define GL_TEXTURE7_ARB                     0x84C7
#define GL_TEXTURE8_ARB                     0x84C8
#define GL_TEXTURE9_ARB                     0x84C9
#define GL_TEXTURE10_ARB                    0x84CA
#define GL_TEXTURE11_ARB                    0x84CB
#define GL_TEXTURE12_ARB                    0x84CC
#define GL_TEXTURE13_ARB                    0x84CD
#define GL_TEXTURE14_ARB                    0x84CE
#define GL_TEXTURE15_ARB                    0x84CF
#define GL_TEXTURE16_ARB                    0x84D0
#define GL_TEXTURE17_ARB                    0x84D1
#define GL_TEXTURE18_ARB                    0x84D2
#define GL_TEXTURE19_ARB                    0x84D3
#define GL_TEXTURE20_ARB                    0x84D4
#define GL_TEXTURE21_ARB                    0x84D5
#define GL_TEXTURE22_ARB                    0x84D6
#define GL_TEXTURE23_ARB                    0x84D7
#define GL_TEXTURE24_ARB                    0x84D8
#define GL_TEXTURE25_ARB                    0x84D9
#define GL_TEXTURE26_ARB                    0x84DA
#define GL_TEXTURE27_ARB                    0x84DB
#define GL_TEXTURE28_ARB                    0x84DC
#define GL_TEXTURE29_ARB                    0x84DD
#define GL_TEXTURE30_ARB                    0x84DE
#define GL_TEXTURE31_ARB                    0x84DF

// ARB_texture_compression defines
#define GL_COMPRESSED_RGBA_ARB                0x84EE

#define GL_STENCIL_BACK_FUNC_ATI                    0x8800
#define GL_STENCIL_BACK_FAIL_ATI                    0x8801
#define GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI         0x8802
#define GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI         0x8803

typedef void (APIENTRY *PFNGLSTENCILOPSEPARATEATIPROC)(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);
typedef void (APIENTRY *PFNGLSTENCILFUNCSEPARATEATIPROC)(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask);

extern PFNGLSTENCILOPSEPARATEATIPROC qglStencilOpSeparateATI;
extern PFNGLSTENCILFUNCSEPARATEATIPROC qglStencilFuncSeparateATI;

#endif /* !__APPLE__ && !MACOSX */


typedef void (APIENTRY * PFNGLACTIVETEXTUREARBPROC) (GLenum texture);
typedef void (APIENTRY * PFNGLCLIENTACTIVETEXTUREARBPROC) (GLenum texture);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1DARBPROC) (GLenum target, GLdouble s);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1DVARBPROC) (GLenum target, const GLdouble *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1FARBPROC) (GLenum target, GLfloat s);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1FVARBPROC) (GLenum target, const GLfloat *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1IARBPROC) (GLenum target, GLint s);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1IVARBPROC) (GLenum target, const GLint *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1SARBPROC) (GLenum target, GLshort s);
typedef void (APIENTRY * PFNGLMULTITEXCOORD1SVARBPROC) (GLenum target, const GLshort *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2DARBPROC) (GLenum target, GLdouble s, GLdouble t);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2DVARBPROC) (GLenum target, const GLdouble *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2FARBPROC) (GLenum target, GLfloat s, GLfloat t);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2FVARBPROC) (GLenum target, const GLfloat *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2IARBPROC) (GLenum target, GLint s, GLint t);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2IVARBPROC) (GLenum target, const GLint *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2SARBPROC) (GLenum target, GLshort s, GLshort t);
typedef void (APIENTRY * PFNGLMULTITEXCOORD2SVARBPROC) (GLenum target, const GLshort *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3DARBPROC) (GLenum target, GLdouble s, GLdouble t, GLdouble r);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3DVARBPROC) (GLenum target, const GLdouble *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3FARBPROC) (GLenum target, GLfloat s, GLfloat t, GLfloat r);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3FVARBPROC) (GLenum target, const GLfloat *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3IARBPROC) (GLenum target, GLint s, GLint t, GLint r);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3IVARBPROC) (GLenum target, const GLint *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3SARBPROC) (GLenum target, GLshort s, GLshort t, GLshort r);
typedef void (APIENTRY * PFNGLMULTITEXCOORD3SVARBPROC) (GLenum target, const GLshort *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4DARBPROC) (GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4DVARBPROC) (GLenum target, const GLdouble *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4FARBPROC) (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4FVARBPROC) (GLenum target, const GLfloat *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4IARBPROC) (GLenum target, GLint s, GLint t, GLint r, GLint q);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4IVARBPROC) (GLenum target, const GLint *v);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4SARBPROC) (GLenum target, GLshort s, GLshort t, GLshort r, GLshort q);
typedef void (APIENTRY * PFNGLMULTITEXCOORD4SVARBPROC) (GLenum target, const GLshort *v);

extern PFNGLACTIVETEXTUREARBPROC qglActiveTextureARB;
extern PFNGLCLIENTACTIVETEXTUREARBPROC qglClientActiveTextureARB;
extern PFNGLMULTITEXCOORD1FARBPROC qglMultiTexCoord1fARB;
extern PFNGLMULTITEXCOORD2FARBPROC qglMultiTexCoord2fARB;
extern PFNGLMULTITEXCOORD2FVARBPROC qglMultiTexCoord2fvARB;
extern PFNGLMULTITEXCOORD3FARBPROC qglMultiTexCoord3fARB;
extern PFNGLMULTITEXCOORD3FVARBPROC qglMultiTexCoord3fvARB;

// <AWE> : MacOS X 10.2: defined in <OpenGL/glext.h>
#if !defined (__APPLE__) && !defined (MACOSX) 

//PENTA: Texture env combine/ Texture env dot3
#define GL_COMBINE_ARB                    0x8570
#define GL_COMBINE_RGB_ARB                0x8571
#define GL_COMBINE_ALPHA_ARB              0x8572
#define GL_RGB_SCALE_ARB                  0x8573
#define GL_ADD_SIGNED_ARB                 0x8574
#define GL_INTERPOLATE_ARB                0x8575
#define GL_SUBTRACT_ARB                   0x84E7
#define GL_CONSTANT_ARB                   0x8576
#define GL_PRIMARY_COLOR_ARB              0x8577
#define GL_PREVIOUS_ARB                   0x8578
#define GL_SOURCE0_RGB_ARB                0x8580
#define GL_SOURCE1_RGB_ARB                0x8581
#define GL_SOURCE2_RGB_ARB                0x8582
#define GL_SOURCE3_RGB_ARB                0x8583
#define GL_SOURCE4_RGB_ARB                0x8584
#define GL_SOURCE5_RGB_ARB                0x8585
#define GL_SOURCE6_RGB_ARB                0x8586
#define GL_SOURCE7_RGB_ARB                0x8587
#define GL_SOURCE0_ALPHA_ARB              0x8588
#define GL_SOURCE1_ALPHA_ARB              0x8589
#define GL_SOURCE2_ALPHA_ARB              0x858A
#define GL_SOURCE3_ALPHA_ARB              0x858B
#define GL_SOURCE4_ALPHA_ARB              0x858C
#define GL_SOURCE5_ALPHA_ARB              0x858D
#define GL_SOURCE6_ALPHA_ARB              0x858E
#define GL_SOURCE7_ALPHA_ARB              0x858F
#define GL_OPERAND0_RGB_ARB               0x8590
#define GL_OPERAND1_RGB_ARB               0x8591
#define GL_OPERAND2_RGB_ARB               0x8592
#define GL_OPERAND3_RGB_ARB               0x8593
#define GL_OPERAND4_RGB_ARB               0x8594
#define GL_OPERAND5_RGB_ARB               0x8595
#define GL_OPERAND6_RGB_ARB               0x8596
#define GL_OPERAND7_RGB_ARB               0x8597
#define GL_OPERAND0_ALPHA_ARB             0x8598
#define GL_OPERAND1_ALPHA_ARB             0x8599
#define GL_OPERAND2_ALPHA_ARB             0x859A
#define GL_OPERAND3_ALPHA_ARB             0x859B
#define GL_OPERAND4_ALPHA_ARB             0x859C
#define GL_OPERAND5_ALPHA_ARB             0x859D
#define GL_OPERAND6_ALPHA_ARB             0x859E
#define GL_OPERAND7_ALPHA_ARB             0x859F

/*
#define	GL_DOT3_RGB_EXT					  0x8740
#define	GL_DOT3_RGBA_EXT				  0x8741
*/
#define GL_DOT3_RGB_ARB					0x86AE
#define GL_DOT3_RGBA_ARB				0x86AF


//PENTA: Cube mapping
#define GL_NORMAL_MAP_ARB                 0x8511
#define GL_REFLECTION_MAP_ARB             0x8512
#define GL_TEXTURE_CUBE_MAP_ARB           0x8513
#define GL_TEXTURE_BINDING_CUBE_MAP_ARB   0x8514
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB 0x8515
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB 0x8516
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB 0x8517
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB 0x8518
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB 0x8519
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB 0x851A
#define GL_PROXY_TEXTURE_CUBE_MAP_ARB     0x851B
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB  0x851C

//PENTA: NV register combiners
#define GL_REGISTER_COMBINERS_NV          0x8522
#define GL_VARIABLE_A_NV                  0x8523
#define GL_VARIABLE_B_NV                  0x8524
#define GL_VARIABLE_C_NV                  0x8525
#define GL_VARIABLE_D_NV                  0x8526
#define GL_VARIABLE_E_NV                  0x8527
#define GL_VARIABLE_F_NV                  0x8528
#define GL_VARIABLE_G_NV                  0x8529
#define GL_CONSTANT_COLOR0_NV             0x852A
#define GL_CONSTANT_COLOR1_NV             0x852B
#define GL_PRIMARY_COLOR_NV               0x852C
#define GL_SECONDARY_COLOR_NV             0x852D
#define GL_SPARE0_NV                      0x852E
#define GL_SPARE1_NV                      0x852F
#define GL_DISCARD_NV                     0x8530
#define GL_E_TIMES_F_NV                   0x8531
#define GL_SPARE0_PLUS_SECONDARY_COLOR_NV 0x8532
#define GL_UNSIGNED_IDENTITY_NV           0x8536
#define GL_UNSIGNED_INVERT_NV             0x8537
#define GL_EXPAND_NORMAL_NV               0x8538
#define GL_EXPAND_NEGATE_NV               0x8539
#define GL_HALF_BIAS_NORMAL_NV            0x853A
#define GL_HALF_BIAS_NEGATE_NV            0x853B
#define GL_SIGNED_IDENTITY_NV             0x853C
#define GL_SIGNED_NEGATE_NV               0x853D
#define GL_SCALE_BY_TWO_NV                0x853E
#define GL_SCALE_BY_FOUR_NV               0x853F
#define GL_SCALE_BY_ONE_HALF_NV           0x8540
#define GL_BIAS_BY_NEGATIVE_ONE_HALF_NV   0x8541
#define GL_COMBINER_INPUT_NV              0x8542
#define GL_COMBINER_MAPPING_NV            0x8543
#define GL_COMBINER_COMPONENT_USAGE_NV    0x8544
#define GL_COMBINER_AB_DOT_PRODUCT_NV     0x8545
#define GL_COMBINER_CD_DOT_PRODUCT_NV     0x8546
#define GL_COMBINER_MUX_SUM_NV            0x8547
#define GL_COMBINER_SCALE_NV              0x8548
#define GL_COMBINER_BIAS_NV               0x8549
#define GL_COMBINER_AB_OUTPUT_NV          0x854A
#define GL_COMBINER_CD_OUTPUT_NV          0x854B
#define GL_COMBINER_SUM_OUTPUT_NV         0x854C
#define GL_MAX_GENERAL_COMBINERS_NV       0x854D
#define GL_NUM_GENERAL_COMBINERS_NV       0x854E
#define GL_COLOR_SUM_CLAMP_NV             0x854F
#define GL_COMBINER0_NV                   0x8550
#define GL_COMBINER1_NV                   0x8551
#define GL_COMBINER2_NV                   0x8552
#define GL_COMBINER3_NV                   0x8553
#define GL_COMBINER4_NV                   0x8554
#define GL_COMBINER5_NV                   0x8555
#define GL_COMBINER6_NV                   0x8556
#define GL_COMBINER7_NV                   0x8557

#define GL_TEXTURE_MAX_ANISOTROPY_EXT		0x84FE
#define GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT	0x84FF


#endif /* !__APPLE__ && !MACOSX */

// - DC - 
#if !defined(SDL) && !defined (__glx__)
typedef void (APIENTRY * PFNGLCOMBINERPARAMETERFVNVPROC) (GLenum pname, const GLfloat *params);
typedef void (APIENTRY * PFNGLCOMBINERPARAMETERFNVPROC) (GLenum pname, GLfloat param);
typedef void (APIENTRY * PFNGLCOMBINERPARAMETERIVNVPROC) (GLenum pname, const GLint *params);
typedef void (APIENTRY * PFNGLCOMBINERPARAMETERINVPROC) (GLenum pname, GLint param);
typedef void (APIENTRY * PFNGLCOMBINERINPUTNVPROC) (GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage);
typedef void (APIENTRY * PFNGLCOMBINEROUTPUTNVPROC) (GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum);
typedef void (APIENTRY * PFNGLFINALCOMBINERINPUTNVPROC) (GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage);
typedef void (APIENTRY * PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC) (GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat *params);
typedef void (APIENTRY * PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC) (GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint *params);
typedef void (APIENTRY * PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC) (GLenum stage, GLenum portion, GLenum pname, GLfloat *params);
typedef void (APIENTRY * PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC) (GLenum stage, GLenum portion, GLenum pname, GLint *params);
typedef void (APIENTRY * PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC) (GLenum variable, GLenum pname, GLfloat *params);
typedef void (APIENTRY * PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC) (GLenum variable, GLenum pname, GLint *params);
#endif

extern PFNGLCOMBINERPARAMETERFVNVPROC qglCombinerParameterfvNV;
extern PFNGLCOMBINERPARAMETERIVNVPROC qglCombinerParameterivNV;
extern PFNGLCOMBINERPARAMETERFNVPROC qglCombinerParameterfNV;
extern PFNGLCOMBINERPARAMETERINVPROC qglCombinerParameteriNV;
extern PFNGLCOMBINERINPUTNVPROC qglCombinerInputNV;
extern PFNGLCOMBINEROUTPUTNVPROC qglCombinerOutputNV;
extern PFNGLFINALCOMBINERINPUTNVPROC qglFinalCombinerInputNV;
extern PFNGLGETCOMBINERINPUTPARAMETERFVNVPROC qglGetCombinerInputParameterfvNV;
extern PFNGLGETCOMBINERINPUTPARAMETERIVNVPROC qglGetCombinerInputParameterivNV;
extern PFNGLGETCOMBINEROUTPUTPARAMETERFVNVPROC qglGetCombinerOutputParameterfvNV;
extern PFNGLGETCOMBINEROUTPUTPARAMETERIVNVPROC qglGetCombinerOutputParameterivNV;
extern PFNGLGETFINALCOMBINERINPUTPARAMETERFVNVPROC qglGetFinalCombinerInputParameterfvNV;
extern PFNGLGETFINALCOMBINERINPUTPARAMETERIVNVPROC qglGetFinalCombinerInputParameterivNV;


// <AWE> : MacOS X 10.2: defined in <OpenGL/glext.h>
#if !defined (__APPLE__) && !defined (MACOSX) && !defined(SDL) && !defined (__glx__)

//PENTA: texture3d
#define GL_PACK_SKIP_IMAGES               0x806B
#define GL_PACK_SKIP_IMAGES_EXT           0x806B
#define GL_PACK_IMAGE_HEIGHT              0x806C
#define GL_PACK_IMAGE_HEIGHT_EXT          0x806C
#define GL_UNPACK_SKIP_IMAGES             0x806D
#define GL_UNPACK_SKIP_IMAGES_EXT         0x806D
#define GL_UNPACK_IMAGE_HEIGHT            0x806E
#define GL_UNPACK_IMAGE_HEIGHT_EXT        0x806E
#define GL_TEXTURE_3D                     0x806F
#define GL_TEXTURE_3D_EXT                 0x806F
#define GL_PROXY_TEXTURE_3D               0x8070
#define GL_PROXY_TEXTURE_3D_EXT           0x8070
#define GL_TEXTURE_DEPTH                  0x8071
#define GL_TEXTURE_DEPTH_EXT              0x8071
#define GL_TEXTURE_WRAP_R                 0x8072
#define GL_TEXTURE_WRAP_R_EXT             0x8072
#define GL_MAX_3D_TEXTURE_SIZE            0x8073
#define GL_MAX_3D_TEXTURE_SIZE_EXT        0x8073

#endif /* !__APPLE__ && !MACOSX && !SDL && !__glx__ */

typedef void (APIENTRY * PFNGLTEXIMAGE3DEXT)(GLenum target, GLint level, GLenum internalformat,
											 GLsizei width, GLsizei height, GLsizei depth,
											 GLint border, GLenum format, GLenum type,
											 const GLvoid* pixels);
extern PFNGLTEXIMAGE3DEXT qglTexImage3DEXT;

//gldepthbounds stuff
typedef void (APIENTRY * PFNGLDEPTHBOUNDSNV)(GLclampd zmin, GLclampd zmax);

extern PFNGLDEPTHBOUNDSNV qglDepthBoundsNV;



// <AWE> : NV_vertex_program will never be supported under any other OS than Windows, because it got
//	   replaced by the official ARB spec "ARB_vertex_program".
//
//	   Todo: - Add hybrid support for NV & ARB vertex_programs.
//		 - Port the current vertex program from NV to ARB.

/* ARB_vertex_program */
/*
#define GL_VERTEX_PROGRAM_ARB                            0x8620
#define GL_VERTEX_PROGRAM_POINT_SIZE_ARB                 0x8642
#define GL_VERTEX_PROGRAM_TWO_SIDE_ARB                   0x8643
#define GL_PROGRAM_FORMAT_ASCII_ARB                      0x8875
#define GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB               0x8622
#define GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB                  0x8623
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB                0x8624
#define GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB                  0x8625
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB            0x886A
#define GL_CURRENT_VERTEX_ATTRIB_ARB                     0x8626
#define GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB               0x8645
#define GL_PROGRAM_LENGTH_ARB                            0x8627
#define GL_PROGRAM_FORMAT_ARB                            0x8876
#define GL_PROGRAM_NAME_ARB                              0x8677
#define GL_PROGRAM_INSTRUCTIONS_ARB                      0x88A0
#define GL_MAX_PROGRAM_INSTRUCTIONS_ARB                  0x88A1
#define GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB               0x88A2
#define GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB           0x88A3
#define GL_PROGRAM_TEMPORARIES_ARB                       0x88A4
#define GL_MAX_PROGRAM_TEMPORARIES_ARB                   0x88A5
#define GL_PROGRAM_NATIVE_TEMPORARIES_ARB                0x88A6
#define GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB            0x88A7
#define GL_PROGRAM_PARAMETERS_ARB                        0x88A8
#define GL_MAX_PROGRAM_PARAMETERS_ARB                    0x88A9
#define GL_PROGRAM_NATIVE_PARAMETERS_ARB                 0x88AA
#define GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB             0x88AB
#define GL_PROGRAM_ATTRIBS_ARB                           0x88AC
#define GL_MAX_PROGRAM_ATTRIBS_ARB                       0x88AD
#define GL_PROGRAM_NATIVE_ATTRIBS_ARB                    0x88AE
#define GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB                0x88AF
#define GL_PROGRAM_ADDRESS_REGISTERS_ARB                 0x88B0
#define GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB             0x88B1
#define GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB          0x88B2
#define GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB      0x88B3
#define GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB              0x88B4
#define GL_MAX_PROGRAM_ENV_PARAMETERS_ARB                0x88B5
#define GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB               0x88B6
#define GL_PROGRAM_STRING_ARB                            0x8628
#define GL_PROGRAM_ERROR_POSITION_ARB                    0x864B
#define GL_CURRENT_MATRIX_ARB                            0x8641
#define GL_TRANSPOSE_CURRENT_MATRIX_ARB                  0x88B7
#define GL_CURRENT_MATRIX_STACK_DEPTH_ARB                0x8640
#define GL_MAX_VERTEX_ATTRIBS_ARB                        0x8869
#define GL_MAX_PROGRAM_MATRICES_ARB                      0x862F
#define GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB            0x862E
#define GL_PROGRAM_ERROR_STRING_ARB                      0x8874

#define GL_MATRIX0_ARB                                   0x88C0
#define GL_MATRIX1_ARB                                   0x88C1
#define GL_MATRIX2_ARB                                   0x88C2
#define GL_MATRIX3_ARB                                   0x88C3
#define GL_MATRIX4_ARB                                   0x88C4
#define GL_MATRIX5_ARB                                   0x88C5
#define GL_MATRIX6_ARB                                   0x88C6
#define GL_MATRIX7_ARB                                   0x88C7
#define GL_MATRIX8_ARB                                   0x88C8
#define GL_MATRIX9_ARB                                   0x88C9
#define GL_MATRIX10_ARB                                  0x88CA
#define GL_MATRIX11_ARB                                  0x88CB
#define GL_MATRIX12_ARB                                  0x88CC
#define GL_MATRIX13_ARB                                  0x88CD
#define GL_MATRIX14_ARB                                  0x88CE
#define GL_MATRIX15_ARB                                  0x88CF
#define GL_MATRIX16_ARB                                  0x88D0
#define GL_MATRIX17_ARB                                  0x88D1
#define GL_MATRIX18_ARB                                  0x88D2
#define GL_MATRIX19_ARB                                  0x88D3
#define GL_MATRIX20_ARB                                  0x88D4
#define GL_MATRIX21_ARB                                  0x88D5
#define GL_MATRIX22_ARB                                  0x88D6
#define GL_MATRIX23_ARB                                  0x88D7
#define GL_MATRIX24_ARB                                  0x88D8
#define GL_MATRIX25_ARB                                  0x88D9
#define GL_MATRIX26_ARB                                  0x88DA
#define GL_MATRIX27_ARB                                  0x88DB
#define GL_MATRIX28_ARB                                  0x88DC
#define GL_MATRIX29_ARB                                  0x88DD
#define GL_MATRIX30_ARB                                  0x88DE
#define GL_MATRIX31_ARB                                  0x88DF

typedef void (APIENTRY * PFNGLBINDPROGRAMARBPROC) (GLenum target, GLuint id);
typedef void (APIENTRY * PFNGLDELETEPROGRAMSARBPROC) (GLsizei n, const GLuint *programs);
typedef void (APIENTRY * PFNGLGENPROGRAMSARBPROC) (GLsizei n, GLuint *programs);
typedef void (APIENTRY * PFNGLGETPROGRAMIVARBPROC) (GLenum target, GLenum pname, GLint *params);
typedef void (APIENTRY * PFNGLGETPROGRAMSTRINGARBPROC) (GLenum target, GLenum pname, GLvoid *string);
typedef void (APIENTRY * PFNGLGETVERTEXATTRIBDVARBPROC) (GLuint index, GLenum pname, GLdouble *params);
typedef void (APIENTRY * PFNGLGETVERTEXATTRIBFVARBPROC) (GLuint index, GLenum pname, GLfloat *params);
typedef void (APIENTRY * PFNGLGETVERTEXATTRIBIVARBPROC) (GLuint index, GLenum pname, GLint *params);
typedef void (APIENTRY * PFNGLGETVERTEXATTRIBPOINTERVARBPROC) (GLuint index, GLenum pname, GLvoid **pointer);
typedef GLboolean (APIENTRY * PFNGLISPROGRAMARBPROC) (GLuint program);
typedef void (APIENTRY * PFNGPROGRAMSTRINGARBPROC) (GLenum target, GLenum format, GLsizei len, const GLvoid *string);
typedef void (APIENTRY * PFNGLTRACKMATRIXNVPROC) (GLenum target, GLuint address, GLenum matrix, GLenum transform);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1DARBPROC) (GLuint index, GLdouble x);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1DVARBPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1FARBPROC) (GLuint index, GLfloat x);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1FVARBPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1SARBPROC) (GLuint index, GLshort x);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1SVARBPROC) (GLuint index, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2DARBPROC) (GLuint index, GLdouble x, GLdouble y);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2DVARBPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2FARBPROC) (GLuint index, GLfloat x, GLfloat y);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2FVARBPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2SARBPROC) (GLuint index, GLshort x, GLshort y);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2SVARBPROC) (GLuint index, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3DARBPROC) (GLuint index, GLdouble x, GLdouble y, GLdouble z);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3DVARBPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3FARBPROC) (GLuint index, GLfloat x, GLfloat y, GLfloat z);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3FVARBPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3SARBPROC) (GLuint index, GLshort x, GLshort y, GLshort z);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3SVARBPROC) (GLuint index, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4DARBPROC) (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4DVARBPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4FARBPROC) (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4FVARBPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4SARBPROC) (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4SVARBPROC) (GLuint index, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4UBVARBPROC) (GLuint index, const GLubyte *v);

extern PFNGLBINDPROGRAMARBPROC 			qglBindProgramARB;
extern PFNGLDELETEPROGRAMSARBPROC 		qglDeleteProgramsARB;
extern PFNGLGENPROGRAMSARBPROC 			qglGenProgramsARB;
extern PFNGLGETPROGRAMIVARBPROC 		qglGetProgramivARB;
extern PFNGLGETPROGRAMSTRINGARBPROC 		qglGetProgramStringARB;
extern PFNGLGETVERTEXATTRIBDVARBPROC 		qglGetVertexAttribdvARB;
extern PFNGLGETVERTEXATTRIBFVARBPROC 		qglGetVertexAttribfvARB;
extern PFNGLGETVERTEXATTRIBIVARBPROC 		qglGetVertexAttribivARB;
extern PFNGLGETVERTEXATTRIBPOINTERVARBPROC	qglGetVertexAttribPointervARB;
extern PFNGLISPROGRAMARBPROC 			qglIsProgramARB;
extern PFNGPROGRAMSTRINGARBPROC 		qglProgramStringARB;
extern PFNGLVERTEXATTRIB1DARBPROC		qglVertexAttrib1dARB;
extern PFNGLVERTEXATTRIB1DVARBPROC 		qglVertexAttrib1dvARB;
extern PFNGLVERTEXATTRIB1FARBPROC		qglVertexAttrib1fARB;
extern PFNGLVERTEXATTRIB1FVARBPROC		qglVertexAttrib1fvARB;
extern PFNGLVERTEXATTRIB1SARBPROC		qglVertexAttrib1sARB;
extern PFNGLVERTEXATTRIB1SVARBPROC		qglVertexAttrib1svARB;
extern PFNGLVERTEXATTRIB2DARBPROC		qglVertexAttrib2dARB;
extern PFNGLVERTEXATTRIB2DVARBPROC		qglVertexAttrib2dvARB;
extern PFNGLVERTEXATTRIB2FARBPROC		qglVertexAttrib2fARB;
extern PFNGLVERTEXATTRIB2FVARBPROC		qglVertexAttrib2fvARB;
extern PFNGLVERTEXATTRIB2SARBPROC		qglVertexAttrib2sARB;
extern PFNGLVERTEXATTRIB2SVARBPROC		qglVertexAttrib2svARB;
extern PFNGLVERTEXATTRIB3DARBPROC		qglVertexAttrib3dARB;
extern PFNGLVERTEXATTRIB3DVARBPROC		qglVertexAttrib3dvARB;
extern PFNGLVERTEXATTRIB3FARBPROC		qglVertexAttrib3fARB;
extern PFNGLVERTEXATTRIB3FVARBPROC		qglVertexAttrib3fvARB;
extern PFNGLVERTEXATTRIB3SARBPROC		qglVertexAttrib3sARB;
extern PFNGLVERTEXATTRIB3SVARBPROC		qglVertexAttrib3svARB;
extern PFNGLVERTEXATTRIB4DARBPROC		qglVertexAttrib4dARB;
extern PFNGLVERTEXATTRIB4DVARBPROC		qglVertexAttrib4dvARB;
extern PFNGLVERTEXATTRIB4FARBPROC		qglVertexAttrib4fARB;
extern PFNGLVERTEXATTRIB4FVARBPROC		qglVertexAttrib4fvARB;
extern PFNGLVERTEXATTRIB4SARBPROC		qglVertexAttrib4sARB;
extern PFNGLVERTEXATTRIB4SVARBPROC		qglVertexAttrib4svARB;
extern PFNGLVERTEXATTRIB4UBVARBPROC		qglVertexAttrib4ubvARB;
*/

//PENTA: VERTEX_PROGRAM

/* NV_vertex_program */
#define GL_VERTEX_PROGRAM_NV              0x8620
#define GL_VERTEX_STATE_PROGRAM_NV        0x8621
#define GL_ATTRIB_ARRAY_SIZE_NV           0x8623
#define GL_ATTRIB_ARRAY_STRIDE_NV         0x8624
#define GL_ATTRIB_ARRAY_TYPE_NV           0x8625
#define GL_CURRENT_ATTRIB_NV              0x8626
#define GL_PROGRAM_LENGTH_NV              0x8627
#define GL_PROGRAM_STRING_NV              0x8628
#define GL_MODELVIEW_PROJECTION_NV        0x8629
#define GL_IDENTITY_NV                    0x862A
#define GL_INVERSE_NV                     0x862B
#define GL_TRANSPOSE_NV                   0x862C
#define GL_INVERSE_TRANSPOSE_NV           0x862D
#define GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV 0x862E
#define GL_MAX_TRACK_MATRICES_NV          0x862F
#define GL_MATRIX0_NV                     0x8630
#define GL_MATRIX1_NV                     0x8631
#define GL_MATRIX2_NV                     0x8632
#define GL_MATRIX3_NV                     0x8633
#define GL_MATRIX4_NV                     0x8634
#define GL_MATRIX5_NV                     0x8635
#define GL_MATRIX6_NV                     0x8636
#define GL_MATRIX7_NV                     0x8637
#define GL_CURRENT_MATRIX_STACK_DEPTH_NV  0x8640
#define GL_CURRENT_MATRIX_NV              0x8641
#define GL_VERTEX_PROGRAM_POINT_SIZE_NV   0x8642
#define GL_VERTEX_PROGRAM_TWO_SIDE_NV     0x8643
#define GL_PROGRAM_PARAMETER_NV           0x8644
#define GL_ATTRIB_ARRAY_POINTER_NV        0x8645
#define GL_PROGRAM_TARGET_NV              0x8646
#define GL_PROGRAM_RESIDENT_NV            0x8647
#define GL_TRACK_MATRIX_NV                0x8648
#define GL_TRACK_MATRIX_TRANSFORM_NV      0x8649
#define GL_VERTEX_PROGRAM_BINDING_NV      0x864A
#define GL_PROGRAM_ERROR_POSITION_NV      0x864B
#define GL_VERTEX_ATTRIB_ARRAY0_NV        0x8650
#define GL_VERTEX_ATTRIB_ARRAY1_NV        0x8651
#define GL_VERTEX_ATTRIB_ARRAY2_NV        0x8652
#define GL_VERTEX_ATTRIB_ARRAY3_NV        0x8653
#define GL_VERTEX_ATTRIB_ARRAY4_NV        0x8654
#define GL_VERTEX_ATTRIB_ARRAY5_NV        0x8655
#define GL_VERTEX_ATTRIB_ARRAY6_NV        0x8656
#define GL_VERTEX_ATTRIB_ARRAY7_NV        0x8657
#define GL_VERTEX_ATTRIB_ARRAY8_NV        0x8658
#define GL_VERTEX_ATTRIB_ARRAY9_NV        0x8659
#define GL_VERTEX_ATTRIB_ARRAY10_NV       0x865A
#define GL_VERTEX_ATTRIB_ARRAY11_NV       0x865B
#define GL_VERTEX_ATTRIB_ARRAY12_NV       0x865C
#define GL_VERTEX_ATTRIB_ARRAY13_NV       0x865D
#define GL_VERTEX_ATTRIB_ARRAY14_NV       0x865E
#define GL_VERTEX_ATTRIB_ARRAY15_NV       0x865F
#define GL_MAP1_VERTEX_ATTRIB0_4_NV       0x8660
#define GL_MAP1_VERTEX_ATTRIB1_4_NV       0x8661
#define GL_MAP1_VERTEX_ATTRIB2_4_NV       0x8662
#define GL_MAP1_VERTEX_ATTRIB3_4_NV       0x8663
#define GL_MAP1_VERTEX_ATTRIB4_4_NV       0x8664
#define GL_MAP1_VERTEX_ATTRIB5_4_NV       0x8665
#define GL_MAP1_VERTEX_ATTRIB6_4_NV       0x8666
#define GL_MAP1_VERTEX_ATTRIB7_4_NV       0x8667
#define GL_MAP1_VERTEX_ATTRIB8_4_NV       0x8668
#define GL_MAP1_VERTEX_ATTRIB9_4_NV       0x8669
#define GL_MAP1_VERTEX_ATTRIB10_4_NV      0x866A
#define GL_MAP1_VERTEX_ATTRIB11_4_NV      0x866B
#define GL_MAP1_VERTEX_ATTRIB12_4_NV      0x866C
#define GL_MAP1_VERTEX_ATTRIB13_4_NV      0x866D
#define GL_MAP1_VERTEX_ATTRIB14_4_NV      0x866E
#define GL_MAP1_VERTEX_ATTRIB15_4_NV      0x866F
#define GL_MAP2_VERTEX_ATTRIB0_4_NV       0x8670
#define GL_MAP2_VERTEX_ATTRIB1_4_NV       0x8671
#define GL_MAP2_VERTEX_ATTRIB2_4_NV       0x8672
#define GL_MAP2_VERTEX_ATTRIB3_4_NV       0x8673
#define GL_MAP2_VERTEX_ATTRIB4_4_NV       0x8674
#define GL_MAP2_VERTEX_ATTRIB5_4_NV       0x8675
#define GL_MAP2_VERTEX_ATTRIB6_4_NV       0x8676
#define GL_MAP2_VERTEX_ATTRIB7_4_NV       0x8677
#define GL_MAP2_VERTEX_ATTRIB8_4_NV       0x8678
#define GL_MAP2_VERTEX_ATTRIB9_4_NV       0x8679
#define GL_MAP2_VERTEX_ATTRIB10_4_NV      0x867A
#define GL_MAP2_VERTEX_ATTRIB11_4_NV      0x867B
#define GL_MAP2_VERTEX_ATTRIB12_4_NV      0x867C
#define GL_MAP2_VERTEX_ATTRIB13_4_NV      0x867D
#define GL_MAP2_VERTEX_ATTRIB14_4_NV      0x867E
#define GL_MAP2_VERTEX_ATTRIB15_4_NV      0x867F

/* NV_vertex_program */
typedef GLboolean (APIENTRY * PFNGLAREPROGRAMSRESIDENTNVPROC) (GLsizei n, const GLuint *programs, GLboolean *residences);
typedef void (APIENTRY * PFNGLBINDPROGRAMNVPROC) (GLenum target, GLuint id);
typedef void (APIENTRY * PFNGLDELETEPROGRAMSNVPROC) (GLsizei n, const GLuint *programs);
typedef void (APIENTRY * PFNGLEXECUTEPROGRAMNVPROC) (GLenum target, GLuint id, const GLfloat *params);
typedef void (APIENTRY * PFNGLGENPROGRAMSNVPROC) (GLsizei n, GLuint *programs);
typedef void (APIENTRY * PFNGLGETPROGRAMPARAMETERDVNVPROC) (GLenum target, GLuint index, GLenum pname, GLdouble *params);
typedef void (APIENTRY * PFNGLGETPROGRAMPARAMETERFVNVPROC) (GLenum target, GLuint index, GLenum pname, GLfloat *params);
typedef void (APIENTRY * PFNGLGETPROGRAMIVNVPROC) (GLuint id, GLenum pname, GLint *params);
typedef void (APIENTRY * PFNGLGETPROGRAMSTRINGNVPROC) (GLuint id, GLenum pname, GLubyte *program);
typedef void (APIENTRY * PFNGLGETTRACKMATRIXIVNVPROC) (GLenum target, GLuint address, GLenum pname, GLint *params);
typedef void (APIENTRY * PFNGLGETVERTEXATTRIBDVNVPROC) (GLuint index, GLenum pname, GLdouble *params);
typedef void (APIENTRY * PFNGLGETVERTEXATTRIBFVNVPROC) (GLuint index, GLenum pname, GLfloat *params);
typedef void (APIENTRY * PFNGLGETVERTEXATTRIBIVNVPROC) (GLuint index, GLenum pname, GLint *params);
typedef void (APIENTRY * PFNGLGETVERTEXATTRIBPOINTERVNVPROC) (GLuint index, GLenum pname, GLvoid* *pointer);
typedef GLboolean (APIENTRY * PFNGLISPROGRAMNVPROC) (GLuint id);
typedef void (APIENTRY * PFNGLLOADPROGRAMNVPROC) (GLenum target, GLuint id, GLsizei len, const GLubyte *program);
typedef void (APIENTRY * PFNGLPROGRAMPARAMETER4DNVPROC) (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
typedef void (APIENTRY * PFNGLPROGRAMPARAMETER4DVNVPROC) (GLenum target, GLuint index, const GLdouble *v);
typedef void (APIENTRY * PFNGLPROGRAMPARAMETER4FNVPROC) (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef void (APIENTRY * PFNGLPROGRAMPARAMETER4FVNVPROC) (GLenum target, GLuint index, const GLfloat *v);
typedef void (APIENTRY * PFNGLPROGRAMPARAMETERS4DVNVPROC) (GLenum target, GLuint index, GLuint count, const GLdouble *v);
typedef void (APIENTRY * PFNGLPROGRAMPARAMETERS4FVNVPROC) (GLenum target, GLuint index, GLuint count, const GLfloat *v);
typedef void (APIENTRY * PFNGLREQUESTRESIDENTPROGRAMSNVPROC) (GLsizei n, const GLuint *programs);
typedef void (APIENTRY * PFNGLTRACKMATRIXNVPROC) (GLenum target, GLuint address, GLenum matrix, GLenum transform);
typedef void (APIENTRY * PFNGLVERTEXATTRIBPOINTERNVPROC) (GLuint index, GLint fsize, GLenum type, GLsizei stride, const GLvoid *pointer);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1DNVPROC) (GLuint index, GLdouble x);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1DVNVPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1FNVPROC) (GLuint index, GLfloat x);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1FVNVPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1SNVPROC) (GLuint index, GLshort x);
typedef void (APIENTRY * PFNGLVERTEXATTRIB1SVNVPROC) (GLuint index, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2DNVPROC) (GLuint index, GLdouble x, GLdouble y);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2DVNVPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2FNVPROC) (GLuint index, GLfloat x, GLfloat y);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2FVNVPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2SNVPROC) (GLuint index, GLshort x, GLshort y);
typedef void (APIENTRY * PFNGLVERTEXATTRIB2SVNVPROC) (GLuint index, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3DNVPROC) (GLuint index, GLdouble x, GLdouble y, GLdouble z);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3DVNVPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3FNVPROC) (GLuint index, GLfloat x, GLfloat y, GLfloat z);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3FVNVPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3SNVPROC) (GLuint index, GLshort x, GLshort y, GLshort z);
typedef void (APIENTRY * PFNGLVERTEXATTRIB3SVNVPROC) (GLuint index, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4DNVPROC) (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4DVNVPROC) (GLuint index, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4FNVPROC) (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4FVNVPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4SNVPROC) (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4SVNVPROC) (GLuint index, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIB4UBVNVPROC) (GLuint index, const GLubyte *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS1DVNVPROC) (GLuint index, GLsizei count, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS1FVNVPROC) (GLuint index, GLsizei count, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS1SVNVPROC) (GLuint index, GLsizei count, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS2DVNVPROC) (GLuint index, GLsizei count, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS2FVNVPROC) (GLuint index, GLsizei count, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS2SVNVPROC) (GLuint index, GLsizei count, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS3DVNVPROC) (GLuint index, GLsizei count, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS3FVNVPROC) (GLuint index, GLsizei count, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS3SVNVPROC) (GLuint index, GLsizei count, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS4DVNVPROC) (GLuint index, GLsizei count, const GLdouble *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS4FVNVPROC) (GLuint index, GLsizei count, const GLfloat *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS4SVNVPROC) (GLuint index, GLsizei count, const GLshort *v);
typedef void (APIENTRY * PFNGLVERTEXATTRIBS4UBVNVPROC) (GLuint index, GLsizei count, const GLubyte *v);

extern PFNGLAREPROGRAMSRESIDENTNVPROC qglAreProgramsResidentNV ;
extern PFNGLBINDPROGRAMNVPROC qglBindProgramNV ;
extern PFNGLDELETEPROGRAMSNVPROC qglDeleteProgramsNV ;
extern PFNGLEXECUTEPROGRAMNVPROC qglExecuteProgramNV ;
extern PFNGLGENPROGRAMSNVPROC qglGenProgramsNV ;
extern PFNGLGETPROGRAMPARAMETERDVNVPROC qglGetProgramParameterdvNV ;
extern PFNGLGETPROGRAMPARAMETERFVNVPROC qglGetProgramParameterfvNV ;
extern PFNGLGETPROGRAMIVNVPROC qglGetProgramivNV ;
extern PFNGLGETPROGRAMSTRINGNVPROC qglGetProgramStringNV ;
extern PFNGLGETTRACKMATRIXIVNVPROC qglGetTrackMatrixivNV ;
extern PFNGLGETVERTEXATTRIBDVNVPROC qglGetVertexAttribdvNV ;
extern PFNGLGETVERTEXATTRIBFVNVPROC qglGetVertexAttribfvNV ;
extern PFNGLGETVERTEXATTRIBIVNVPROC qglGetVertexAttribivNV ;
extern PFNGLGETVERTEXATTRIBPOINTERVNVPROC qglGetVertexAttribPointervNV ;
extern PFNGLISPROGRAMNVPROC qglIsProgramNV ;
extern PFNGLLOADPROGRAMNVPROC qglLoadProgramNV ;
extern PFNGLPROGRAMPARAMETER4DNVPROC qglProgramParameter4dNV ;
extern PFNGLPROGRAMPARAMETER4DVNVPROC qglProgramParameter4dvNV ;
extern PFNGLPROGRAMPARAMETER4FNVPROC qglProgramParameter4fNV ;
extern PFNGLPROGRAMPARAMETER4FVNVPROC qglProgramParameter4fvNV ;
extern PFNGLPROGRAMPARAMETERS4DVNVPROC qglProgramParameters4dvNV ;
extern PFNGLPROGRAMPARAMETERS4FVNVPROC qglProgramParameters4fvNV ;
extern PFNGLREQUESTRESIDENTPROGRAMSNVPROC qglRequestResidentProgramsNV ;
extern PFNGLTRACKMATRIXNVPROC qglTrackMatrixNV ;
extern PFNGLVERTEXATTRIBPOINTERNVPROC qglVertexAttribPointerNV ;
extern PFNGLVERTEXATTRIB1DNVPROC qglVertexAttrib1dNV ;
extern PFNGLVERTEXATTRIB1DVNVPROC qglVertexAttrib1dvNV ;
extern PFNGLVERTEXATTRIB1FNVPROC qglVertexAttrib1fNV ;
extern PFNGLVERTEXATTRIB1FVNVPROC qglVertexAttrib1fvNV ;
extern PFNGLVERTEXATTRIB1SNVPROC qglVertexAttrib1sNV ;
extern PFNGLVERTEXATTRIB1SVNVPROC qglVertexAttrib1svNV ;
extern PFNGLVERTEXATTRIB2DNVPROC qglVertexAttrib2dNV ;
extern PFNGLVERTEXATTRIB2DVNVPROC qglVertexAttrib2dvNV ;
extern PFNGLVERTEXATTRIB2FNVPROC qglVertexAttrib2fNV ;
extern PFNGLVERTEXATTRIB2FVNVPROC qglVertexAttrib2fvNV ;
extern PFNGLVERTEXATTRIB2SNVPROC qglVertexAttrib2sNV ;
extern PFNGLVERTEXATTRIB2SVNVPROC qglVertexAttrib2svNV ;
extern PFNGLVERTEXATTRIB3DNVPROC qglVertexAttrib3dNV ;
extern PFNGLVERTEXATTRIB3DVNVPROC qglVertexAttrib3dvNV ;
extern PFNGLVERTEXATTRIB3FNVPROC qglVertexAttrib3fNV ;
extern PFNGLVERTEXATTRIB3FVNVPROC qglVertexAttrib3fvNV ;
extern PFNGLVERTEXATTRIB3SNVPROC qglVertexAttrib3sNV ;
extern PFNGLVERTEXATTRIB3SVNVPROC qglVertexAttrib3svNV ;
extern PFNGLVERTEXATTRIB4DNVPROC qglVertexAttrib4dNV ;
extern PFNGLVERTEXATTRIB4DVNVPROC qglVertexAttrib4dvNV ;
extern PFNGLVERTEXATTRIB4FNVPROC qglVertexAttrib4fNV ;
extern PFNGLVERTEXATTRIB4FVNVPROC qglVertexAttrib4fvNV ;
extern PFNGLVERTEXATTRIB4SNVPROC qglVertexAttrib4sNV ;
extern PFNGLVERTEXATTRIB4SVNVPROC qglVertexAttrib4svNV ;
extern PFNGLVERTEXATTRIB4UBVNVPROC qglVertexAttrib4ubvNV ;
extern PFNGLVERTEXATTRIBS1DVNVPROC qglVertexAttribs1dvNV ;
extern PFNGLVERTEXATTRIBS1FVNVPROC qglVertexAttribs1fvNV ;
extern PFNGLVERTEXATTRIBS1SVNVPROC qglVertexAttribs1svNV ;
extern PFNGLVERTEXATTRIBS2DVNVPROC qglVertexAttribs2dvNV ;
extern PFNGLVERTEXATTRIBS2FVNVPROC qglVertexAttribs2fvNV ;
extern PFNGLVERTEXATTRIBS2SVNVPROC qglVertexAttribs2svNV ;
extern PFNGLVERTEXATTRIBS3DVNVPROC qglVertexAttribs3dvNV ;
extern PFNGLVERTEXATTRIBS3FVNVPROC qglVertexAttribs3fvNV ;
extern PFNGLVERTEXATTRIBS3SVNVPROC qglVertexAttribs3svNV ;
extern PFNGLVERTEXATTRIBS4DVNVPROC qglVertexAttribs4dvNV ;
extern PFNGLVERTEXATTRIBS4FVNVPROC qglVertexAttribs4fvNV ;
extern PFNGLVERTEXATTRIBS4SVNVPROC qglVertexAttribs4svNV ;
extern PFNGLVERTEXATTRIBS4UBVNVPROC qglVertexAttribs4ubvNV ;

// <AWE> : MacOS X 10.2: defined in <OpenGL/glext.h> as APPLE extension:
#if defined (__APPLE__) || defined (MACOSX)

// GL_NV_vertex_array_range = GL_APPLE_vertex_array_range
#define GL_VERTEX_ARRAY_RANGE_NV		GL_VERTEX_ARRAY_RANGE_APPLE
#define GL_VERTEX_ARRAY_RANGE_LENGTH_NV		GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE
#define GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV	GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_APPLE
#define GL_VERTEX_ARRAY_RANGE_POINTER_NV	GL_VERTEX_ARRAY_RANGE_POINTER_APPLE
#define GL_VERTEX_ARRAY_RANGE_VALID_NV		GL_VERTEX_ARRAY_STORAGE_HINT_APPLE

#else

#define GL_CLAMP_TO_EDGE                	0x812F

// GL_NV_vertex_array_range
#define GL_VERTEX_ARRAY_RANGE_NV          	0x851D
#define GL_VERTEX_ARRAY_RANGE_LENGTH_NV   	0x851E
#define GL_VERTEX_ARRAY_RANGE_VALID_NV    	0x851F
#define GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV 	0x8520
#define GL_VERTEX_ARRAY_RANGE_POINTER_NV  	0x8521

#endif /* !__APPLE__ && !MACOSX */

// <AWE> There are some diffs with the function parameters. wgl stuff not present with MacOS X. -DC- and SDL 
#if defined (__APPLE__) || defined (MACOSX) || defined(SDL) || defined (__glx__)

typedef void (APIENTRY * PFNGLFLUSHVERTEXARRAYRANGEAPPLEPROC) (GLsizei length, const GLvoid *pointer);
typedef void (APIENTRY * PFNGLVERTEXARRAYRANGEAPPLEPROC) (GLsizei size, const GLvoid *pointer);

extern PFNGLFLUSHVERTEXARRAYRANGEAPPLEPROC qglFlushVertexArrayRangeAPPLE;
extern PFNGLVERTEXARRAYRANGEAPPLEPROC qglVertexArrayRangeAPPLE;

#define qglVertexArrayRangeNV	qglVertexArrayRangeAPPLE

#else

typedef void (APIENTRY * PFNGLFLUSHVERTEXARRAYRANGENVPROC) (void);
typedef void (APIENTRY * PFNGLVERTEXARRAYRANGENVPROC) (GLsizei size, const GLvoid *pointer);
typedef void * (APIENTRY * PFNWGLALLOCATEMEMORYNVPROC) (int size, float readfreq, float writefreq, float priority);
typedef void (APIENTRY * PFNWGLFREEMEMORYNVPROC) (void *pointer);

extern PFNGLFLUSHVERTEXARRAYRANGENVPROC qglFlushVertexArrayRangeNV;
extern PFNGLVERTEXARRAYRANGENVPROC glVertexArrayRangeNV;
extern PFNWGLALLOCATEMEMORYNVPROC wglAllocateMemoryNV;
extern PFNWGLFREEMEMORYNVPROC wglFreeMemoryNV;

#endif /* __APPLE__ || MACOSX */

/*

*/

typedef void (APIENTRY *lpMTexFUNC) (GLenum, GLfloat, GLfloat);
typedef void (APIENTRY *lpSelTexFUNC) (GLenum);
//extern lpMTexFUNC qglMTexCoord2fSGIS;
//extern lpSelTexFUNC qglSelectTextureSGIS;

extern qboolean gl_mtexable;
extern qboolean gl_palettedtex; // <AWE>: true if EXT_paletted_texture present [for GL_Upload8_EXT ()].
extern qboolean gl_texturefilteranisotropic; // <AWE> true if anisotropic texture filtering available.

typedef enum
{
	GENERIC = 0,
	GEFORCE,
	GEFORCE3,
	RADEON,
	PARHELIA,
	ARB
} qcardtype;
extern qcardtype gl_cardtype;

//extern qboolean gl_nvcombiner; //PENTA: true if nvdida texture shaders are present
//extern qboolean gl_geforce3;
//extern qboolean gl_radeon;//PA:
extern qboolean gl_var;
extern qboolean gl_texcomp;

extern GLfloat	gl_textureanisotropylevel; // <AWE> required for anisotropic textures.

void GL_DisableMultitexture(void);
void GL_EnableMultitexture(void);

//PENTA: Stencil shadows

typedef struct screenrect_s {
	int coords [4];
	struct screenrect_s *next;
} screenrect_t;


typedef union lightcmd_u {
  int asInt;
  float asFloat;
  vec_t asVec;
  void *asVoid;
} lightcmd_t;


typedef struct shadowlight_s {
	vec3_t	origin;		//position of light source
	vec3_t	baseColor, color;		//light color, animated color
	float	radius;		//radius of light source (doesn't light anyting out of that circle)
						//so we can "clip" our shadowvolumes against that circle
	float	brightness;
	qboolean visible;	//light is "visible" this frame
	qboolean isStatic;	//light is static and has a precalc volume
	qboolean castShadow;//lights casts shadows
	qboolean halo;		//light has a halo
	mleaf_t	*leaf;		//leaf this light is in
	byte vis[MAX_MAP_LEAFS/8];//redone pvs for light, only poly's in nodes
	byte entvis[MAX_MAP_LEAFS/8];//original pvs a light origin
	msurface_t	**visSurf; //the surfaces that should cast shadows for this light (only when static)
	int		*volumeCmds;  //gl commands to draw the shadow volume
	float	*volumeVerts;
	int		numVolumeVerts;
	lightcmd_t	*lightCmds;	//gl commands to draw the cap/lighted volumes
	int		 numVisSurf;
	int		style;
	entity_t *owner;
	screenrect_t scizz;
	int		filtercube;	//texture object of this light's cubemap filter
	vec3_t	angles; //angles of the cubemap filter
	float	rspeed; //rotation speed of cube map;
	float	cubescale; //scale factor of cube map;
	float	haloalpha; //alpha of halo
	vec3_t	oldlightorigin; 
} shadowlight_t;

//PENTA: new
typedef struct aliaslightinstant_s {

	int lockframe;	//number of the frame when it was last locked.
	vec3_t lasteorg, lastlorg, lasteangles, lastvorg;
	float lastlradius;
	entity_t	*lastent;
	aliashdr_t * lasthdr;
	shadowlight_t *lastlight;
	vec3_t	lightpos, vieworg; //Object space light position
	void *lastframeinstant;

	//Per light stuff
	vec3_t	extvertices[MAXALIASVERTS]; //extruded vertices (volumes)
	vec3_t	tslights[MAXALIASVERTS]; //per vertex tangent space light vector
	vec3_t	tshalfangles[MAXALIASVERTS]; //per vertex half angle vector
	vec3_t	colors[MAXALIASVERTS]; //per vertex attenuation for non gf3 cards
	qboolean triangleVis[MAXALIASTRIS]; //triangle facingness for lights
	
	int		indecies[MAXALIASTRIS*3];//light visibility list
	int numtris;
	
} aliaslightinstant_t;

typedef struct aliasframeinstant_s {
	
     // chain of frameinstant for multiple surfaces
        struct aliasframeinstant_s *_next;
	
	int lockframe;	//number of the frame when it was last locked.
	int	updateframe; //number of the fame when it was last recalculated
	aliashdr_t *paliashdr;
	int lastpose1, lastpose2;
	float lastblend;
	entity_t	*lastent;
	qboolean lastshadowonly;
	aliashdr_t *lastpaliashdr;

	qboolean	shadowonly; //We only need the instant for shadow volume drawing
							//we use this for ents out of the frustum but e.g. behind the player
	//Per entity stuff
	vec3_t	vertices[MAXALIASVERTS]; //interpolated vertices
	vec3_t	normals[MAXALIASVERTS]; //interpolated vertex normals
	vec3_t	tangents[MAXALIASVERTS]; //interpolated vertex tangents
	vec3_t	binomials[MAXALIASVERTS]; //interpolated vertex binomials
	plane_t	triplanes[MAXALIASTRIS]; //triangle plane equatations

	aliaslightinstant_t *lightinstant;
} aliasframeinstant_t;

typedef struct brushlightinstant_s {

	int lockframe;	//number of the frame when it was last locked.
	vec3_t lasteorg, lastlorg, lasteangles, lastvorg;
	float lastlradius;
	entity_t	*lastent;
	shadowlight_t *lastlight;
	vec3_t	lightpos, vieworg; //Object space light position
	qboolean shadowonly, lastshadowonly;

	//Per light stuff
	vec3_t	extvertices[MAXALIASVERTS]; //extruded vertices (volumes)
	vec3_t	tslights[MAXALIASVERTS]; //per vertex tangent space light vector
	vec3_t	tshalfangles[MAXALIASVERTS]; //per vertex half angle vector
	float	atencoords[MAXALIASVERTS][2]; //per vertex attenuation texture coords for non gf3 cards
	float	colorscales[MAXALIASVERTS]; //per vertex attenuation texture coords for non gf3 cards
	qboolean polygonVis[MAXALIASTRIS]; //polygon facingness for lights
	qboolean neighbourVis[MAXALIASTRIS]; //polygon facingness for lights
} brushlightinstant_t;



#define	MAXSHADOWLIGHTS	256 //Maximum number of (client side) lights in a map
#define MAX_VOLUME_VERTICES 10000 //should be multiple of 4 because this is used as a vertex array
								 //with GL_QUADS
#define MAXUSEDSHADOWLIGHS 64 //Maximum number of lights that can be used in a single frame

extern int numShadowLights;	//number of lights currently on client
extern int numStaticShadowLights; //number of static lights on client
extern int numUsedShadowLights;
extern shadowlight_t shadowlights[MAXSHADOWLIGHTS];
extern shadowlight_t *usedshadowlights[MAXUSEDSHADOWLIGHS];
extern shadowlight_t *currentshadowlight;
extern msurface_t *shadowchain; //linked list of polygons that are shadowed
extern float frustumPlanes[6][4];

extern mmvertex_t *globalVertexTable;

#define MAX_VOLUME_COMMANDS 131072 //Thats 0.5 meg storage for commands, insane
#define MAX_VOLUME_VERTS 87381 //1 Meg storage for vertices
#define MAX_LIGHT_COMMANDS 65536 //0.25 meg for light commands
extern lightcmd_t	lightCmdsBuff[MAX_LIGHT_COMMANDS+128];

//XYZ
extern int	numNormals[MAXALIASTRIS]; //Used during tangent space calc
extern char	loadname[32];	// for hunk tags

//64 kb should be enough
#define AGP_BUFFER_SIZE 2048*4
extern void *AGP_Buffer;

//view origin in object space
extern vec3_t object_vieworg;
extern vec3_t tsLightVects[MAXALIASTRIS*3];
extern vec3_t tsHalfAngles[MAXALIASTRIS*3];

//PENTA: Shadow bsp's

typedef struct svnode_s {
	plane_t			*splitplane;
	struct svnode_s	*children[2];
} svnode_t;


extern int svBsp_NumCutPolys;
extern int svBsp_NumKeptPolys;
extern int svBsp_NumAddedPolys;
extern int svBsp_NumMissedPlanes;
extern int svBsp_NumMissedNodes;
extern int numClearsSaved;

extern int planesusedpool;
extern int nodesusedpool;

extern int aliasCacheRequests, aliasFullCacheHits, aliasPartialCacheHits;	// <AWE> added "extern".
extern int brushCacheRequests, brushFullCacheHits, brushPartialCacheHits;	// <AWE> added "extern".

//Don't cast shadows with this light
#define PFLAG_NOSHADOW 1
//Draw a halo around the light
#define PFLAG_HALO 2
/*
	It seems in c you can only return structs when you prototype them first
	well I don't now for sure since I'm actually not c a specialist.
	If you know the answer mail me please.
*/

svnode_t *R_CreateEmptyTree(void);
svnode_t *R_AddShadowCaster(svnode_t *node, vec3_t *v, int vnum, msurface_t *surf,int depth);
svnode_t *ExpandVolume(vec3_t *v,int *sign, int vnum, msurface_t *surf);
plane_t *AllocPlane(plane_t *tryplane);
svnode_t *AllocNode(void);
svnode_t *NodeFromEdge(vec3_t *v,int vnum, int edgeindex);
float CalcFov (float fov_x, float width, float height);

/* other c twists (i'm pascal-core and java-used)*/
// <AWE> added misc function prototypes, fixed functions without return type.
void		Mod_LoadMd3Model (model_t *mod, void *buffer);
void		R_AddRectList (screenrect_t *rec);
void		R_AllocateMirror (msurface_t *surf);
void		R_AnimateLight (void);
void		R_AutomaticLightPos (void);
void		R_CalcSvBsp (entity_t *ent);
qboolean	R_CheckRectList (screenrect_t *rec);
void		R_ClearBrushInstantCaches (void);
void		R_ClearInstantCaches (void);
void		R_ClearParticles (void);
void		R_ClearDecals(void);
void		R_ClearRectList (void);
void		R_ConstructShadowVolume (shadowlight_t *light);
qboolean	R_ContributeFrame (shadowlight_t *light);
int		R_CubeMapLookup (int i);
qboolean	R_CullBox (vec3_t mins, vec3_t maxs);
void		R_DrawAliasBumped (aliashdr_t *paliashdr, aliasframeinstant_t *instant);
void		R_DrawAliasBumpedGF3 (aliashdr_t *paliashdr, aliasframeinstant_t *instant);
void		R_DrawAliasBumpedRadeon(aliashdr_t *paliashdr, aliasframeinstant_t *instant);//PA:
void		R_DrawBrushBumpedRadeon(entity_t *e);//PA:
void		R_DrawAliasBumpedParhelia(aliashdr_t *paliashdr, aliasframeinstant_t *instant);//PA:
void		R_DrawBrushBumpedParhelia(entity_t *e);//PA:
void		R_DrawAliasBumpedARB(aliashdr_t *paliashdr, aliasframeinstant_t *instant);//PA:
void		R_DrawBrushBumpedARB(entity_t *e);//PA:
void		R_DrawAliasFrameWV (aliashdr_t *paliashdr, aliasframeinstant_t *instant, qboolean specular);
void		R_DrawAliasObjectLight (entity_t *e, void (*AliasGeoSender) (aliashdr_t *paliashdr,
                                                                             aliasframeinstant_t* instant));
void		R_DrawBrushATT (entity_t *ent);
void		R_DrawBrushBumped (entity_t *e);
void		R_DrawBrushBumpedGF3 (entity_t *e);
void		R_DrawBrushBumpedRadeon (entity_t *e);
void		R_DrawBrushBumpedParhelia (entity_t *e);
void		R_DrawBrushBumpedARB (entity_t *e);
void		R_DrawBrushModel (entity_t *e);
void		R_DrawBrushModelVolumes(entity_t *e);
void		R_DrawBrushObjectLight (entity_t *e,void (*BrushGeoSender) (entity_t *e));
void		R_DrawBrushWV (entity_t *e, qboolean specular);
void		R_DrawGlare (void);
void		R_DrawLightEntities (shadowlight_t *l);
void		R_DrawParticles (void);
void		R_DrawDecals (void);
void		R_DrawShadowVolume (shadowlight_t *light);
void		R_DrawSkyChain (msurface_t *s);
void		R_DrawSpriteModelWV (entity_t *e);
void		R_DrawWaterSurfaces (void);
void		R_DrawWorldBumped (/* shadowlight_t *l */);
void		R_DrawWorldBumpedGEN (void);
void 		R_DrawWorldBumpedGF (void);
void		R_DrawWorldBumpedGF3 (void);
void		R_DrawWorldBumpedRadeon (void);
void		R_DrawWorldBumpedParhelia (void);
void		R_DrawWorldBumpedARB (void);
void		R_DrawWorldWV (lightcmd_t *lightCmds, qboolean specular);
qboolean	R_FillShadowChain (shadowlight_t *light);
mspriteframe_t *R_GetSpriteFrame (entity_t *currententity);
void		R_Glare (void);
void		R_InitDrawWorld (void);
void		R_InitGlare (void);
void		R_InitMirrorChains (void);
void		R_InitParticles (void);
void		R_InitDecals (void);
void		R_InitShadowsForFrame (void);
int		R_LightPoint (vec3_t p);
void		R_LoadVertexProgram (void);
void		R_NewMirrorChains (void);
void		R_ParticleGunHits (vec3_t org, int type);
void		R_RenderGlow (shadowlight_t *light);
void		R_RenderScene (void);
void		R_RotateForEntity (entity_t *e);
void		R_UnlerpedRotateForEntity (entity_t *e);
void		R_SetTotalRect (void);
void		R_SetupBrushInstantForLight(entity_t *e);
void		R_SetupInstantForLight(entity_t *e);
void		R_SetupInstantForFrame(entity_t *e, qboolean forcevis);
void		R_SetupInstants (void);
qboolean	R_ShouldDrawViewModel (void);
void		R_StoreEfrags (efrag_t **ppefrag);
void		R_FillEntityLeafs (entity_t *ent);
void		R_WorldMultiplyTextures (void);
void		R_WorldToObjectMatrix(entity_t *e, matrix_4x4 result);

int		EasyTgaLoad (char *filename);
void		EmitBothSkyLayers (msurface_t *fa);
void		EmitMirrorPolys (msurface_t *fa);
void		EmitMirrorWaterPolys (msurface_t *fa);
void		EmitSkyPolys (msurface_t *fa);
void		EmitWaterPolys (msurface_t *fa);
void		InitShaderTex (void);
void 		LoadColorTGA (FILE *fin, byte *pixels, int *width, int *height, char *fname);
void		LoadGrayTGA (FILE *fin,byte *pixels,int *width, int *height, char *fname);
int             LoadTextureInPlace(char* filename, int size, byte* mem, int* width, int* height);
void            LoadTGA (FILE *fin);
qboolean	OverrideFluidTex (char *name);
void		ProjectPlane (const vec3_t src,const vec3_t v1,const vec3_t v2,vec3_t dst);
void		TraceLine (vec3_t start, vec3_t end, vec3_t impact);

void		GL_AddColor (void);
void		GL_BuildLightmaps (void);
void		GL_DisableColorShader (qboolean specular);
void 		GL_DrawAlpha (void);
void		GL_EnableColorShader (qboolean specular);
void		GL_GetOverrideName (char *identifier, char *tail, char *dest);
int		GL_LoadCubeMap (int identifier);
void		GL_MakeAliasModelDisplayLists (model_t *m, aliashdr_t *hdr);
void		R_DrawAliasModel ( float bright);
void		GL_ModulateAlphaDrawColor (void);
void		GL_SelectTexture (GLenum target);
void		GL_Set2D (void);
void		GL_SetupCubeMapMatrix (qboolean world);
void		GL_SubdivideSurface (msurface_t *fa);
void		GL_Upload8_EXT (byte *data, int width, int height,  qboolean mipmap, qboolean alpha);
int		GL_LoadLuma(char *identifier, qboolean mipmap);
void		R_DrawCaustics(void);
int			CL_PointContents (vec3_t p);
void		V_CalcBlend (void);

#define VERTEX_TEXTURE 1
#define VERTEX_LIGHTMAP 2

int R_GetNextVertexIndex(void);
int R_AllocateVertexInTemp(vec3_t pos, float texture [2], float lightmap[2]);
void R_CopyVerticesToHunk(void);
void R_EnableVertexTable(int fields);
void R_DisableVertexTable(int fields);

qboolean 	VID_Is8bit (void);

typedef struct mirrorplane_s {
	int texture_object;  //Object we should render to and use for drawing
	int	lockframe, updateframe;		//Index of frame when it was last updated
	mplane_t	plane;		//Plane equatation of mirror face
	msurface_t *chain;	//Chain of mirror poly's
	float	matrix[16];
} mirrorplane_t;

#define NUM_MIRROR_PLANES 8
extern mirrorplane_t mirrorplanes[NUM_MIRROR_PLANES];
extern int mirror_contents;
extern int newenvmap;

msurface_t	*causticschain;
extern int	caustics_textures[8];
extern qboolean	busy_caustics;

extern char	skybox_name[64];
extern float skybox_cloudspeed;
extern qboolean skybox_hasclouds;

#include "gl_md3.h"
