Name: scsirastools
%define Version 1.6.6
Version: %Version
Release: 1
Summary: A package that adds several SCSI Serviceability Tools
License: BSD
Group: Applications/System
Source: http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
URL:  http://scsirastools.sourceforge.net
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
%ifarch x86_pentium3 x86_pentium4
AutoReqProv: No
%endif

%description
The scsirastools package adds several Linux SCSI tools that can be used to 
service and maintain SCSI devices.  These are the tools provided:
sgdskfl   - to load disk firmware to disks under Linux
sgmode    - to get and set SCSI mode pages
sgdefects - to read the primary and grown defect lists
sgdiag    - to perform format & other test functions   
sgraidmon - to monitor software RAID disks for hot-insertion/removal
sgdiskmon - to monitor SCSI disks for hot-insertion/removal
getmd     - to parse /etc/raidtab for devices (used in mdmon only)
mdadm     - to administer the md raid configuration
ialarms   - to set disk fault LEDs on mBMC platforms (see ipmiutil.sf.net)

See  http://scsirastools.sourceforge.net for more information.

%prep
%setup -q

%build
sh configure
make 

%install
# Use %{buildroot} macro instead of $RPM_BUILD_ROOT now.
# %{buildroot} is set above in the header so it will never be "/"
rm -rf %{buildroot}
make install DESTDIR=%{buildroot}
( cd %{buildroot}/usr/share/man/man8; gzip -f *.8 )
( cd %{buildroot}%{_datadir}/scsirastools; gzip -f *.8 )
 
%clean
# %{buildroot} is set above in the header so it will never be "/"
rm -rf %{buildroot}

%files
%defattr(0755,root,root)
/sbin/sgdefects
/sbin/sgdskfl
/sbin/sgmode
/sbin/sgdiag
/sbin/sgraidmon
/sbin/sgdiskmon
/sbin/sgsafte
/sbin/sgevt
/sbin/mdevt
/sbin/getmd
/etc/init.d/sgraid
/etc/init.d/sgdisk
%{_datadir}/scsirastools/mdadm
%{_datadir}/scsirastools/rescan-scsi-bus.sh
%defattr(0664,root,root)
%{_datadir}/scsirastools/UserGuide
%{_datadir}/scsirastools/COPYING
%{_datadir}/scsirastools/README
%{_datadir}/scsirastools/SCSIRAS
%{_datadir}/scsirastools/mdadm.8.gz
/usr/share/man/man8/sgdefects.8.gz
/usr/share/man/man8/sgdskfl.8.gz
/usr/share/man/man8/sgmode.8.gz
/usr/share/man/man8/sgdiag.8.gz
/usr/share/man/man8/sgraidmon.8.gz
/usr/share/man/man8/sgdiskmon.8.gz
/usr/share/man/man8/sgsafte.8.gz
# %defattr(-,root,root)
# %doc README TODO COPYING ChangeLog
%defattr(0644,root,root)
%{_datadir}/scsirastools/atlasu32.mdf
%{_datadir}/scsirastools/dpss-309.mdf
%{_datadir}/scsirastools/ddys-t09.mdf
%{_datadir}/scsirastools/st318452.mdf
%{_datadir}/scsirastools/st336752.mdf
%{_datadir}/scsirastools/st39173l.mdf
%{_datadir}/scsirastools/st39173w.mdf
%{_datadir}/scsirastools/man3184m.mdf
%{_datadir}/scsirastools/man3367m.mdf
%{_datadir}/scsirastools/dk32dj-1.mdf
%{_datadir}/scsirastools/dk32dj-3.mdf 
%{_datadir}/scsirastools/map3147n.mdf
%{_datadir}/scsirastools/st318406.mdf
%{_datadir}/scsirastools/st336605.mdf
%{_datadir}/scsirastools/st336607.mdf
%{_datadir}/scsirastools/st373405.mdf


%pre
# before install
echo "Installing the scsirastools %Version package ..."
mkdir -p %{_datadir}/scsirastools
# If mkdir has a non-zero exit status, do something else.
echo " "

if [ ! -d /usr/share/man ]
then
    if [ -d /usr/man ]
    then
        ln -s /usr/man /usr/share/man
    fi
fi

%post
# after install
odir=/sbin
tmpf=/tmp/getmd.out
mdir=%{_datadir}/scsirastools

# mdadm may already be installed with the OS.
# if so, fine, but if it doesn't exist, use the one we brought.
which mdadm >/dev/null 2>&1
if [ $? -ne 0 ]
then
   ln -s $mdir/mdadm /sbin/mdadm
   cp $mdir/mdadm.8.gz  %{_mandir}/man8
fi
# alarms may already be installed from ipmiutil.sf.net, 
# if so, fine, but if it doesn't exist, use the one we brought.
which ialarms >/dev/null 2>&1
if [ $? -ne 0 ]
then
   echo "mdevt uses ialarms from ipmiutil.sf.net, please install ipmiutil."
fi

$odir/getmd /dev/md0 >$tmpf
if [ $? -eq 0 ]
then
   rdev=`cut -f2 -d' ' $tmpf |sed -e 's/[0-9]//'`
   # This is done by /etc/init.d/sgraid now.
   # echo "$odir/mdevt Save $rdev"
   $odir/mdevt Save $rdev
fi           

echo "done"
echo "If you wish to start sgraidmon, run '/etc/init.d/sgraid start'."

%preun
# before uninstall
echo "Uninstalling the scsirastools %Version package ..."
/etc/init.d/sgraid stop
/etc/init.d/sgdisk stop

%postun
# after uninstall
symmd=/sbin/mdadm
symal=/usr/sbin/ialarms

if [ "$1" = "0" ]
then
   # if arg1 = 0, we are in rpm -e, not rpm -U, so clean up.

   # remove mdadm if we put it there (symlink)
   ls -l $symmd 2>/dev/null |grep "^lr" >/dev/null
   if [ $? -eq 0 ]
   then
      rm -f $symmd
   fi
   # remove ialarms if we put it there (symlink)
   #ls -l $symal 2>/dev/null |grep "^lr" >/dev/null
   #if [ $? -eq 0 ]
   #then
      #rm -f $symal
   #fi
   # remove any other extra files
   rm -rf %{_datadir}/scsirastools
   echo "done"
fi

%changelog
* Wed Aug 03 2011 Andrew Cress <arcress@users.sf.net> 
  no longer include ialarms binary, reference ipmiutil for it.
* Wed Oct 14 2009 Andrew Cress <arcress@users.sf.net> 
  changed Copyright to License, fixed Source and URL
* Thu Feb 03 2005 Andrew Cress <arcress@users.sf.net> 
  changed to /usr/share/man, added check for rpm -U/-e
* Thu Oct 02 2003 Andrew Cress <arcress@users.sf.net> 
  removed mdmon, since it is not updated
* Mon Mar 24 2003 Andrew Cress <arcress@users.sf.net> 
- added prep, build, install sections for new make env (1.3.8)
* Wed Sep 11 2002 Andrew Cress <arcress@users.sf.net> 
- dynamically download and build mdadm
* Thu Sep 05 2002 Andrew Cress <arcress@users.sf.net> 
- do sgraid stop in preun
* Fri Aug 16 2002 Andrew Cress <arcress@users.sf.net> 
- added sgcommon.c, moved common routines there
* Thu Jun 27 2002 Andrew Cress <arcress@users.sf.net> 
- added sgraid script, updated UserGuide & SCSIRAS
* Tue Jun 11 2002 Andrew Cress <arcress@users.sf.net> 
- added sgraidmon, sgraidmon.8, mdadm.8 to files for 1.2.0-2
* Thu May 30 2002 Andrew Cress <arcress@users.sf.net> 
- added mdadm for 1.2.0
* Thu Apr 11 2002 Andrew Cress <arcress@users.sf.net> 
- Changed pathnames for 1.1.2
* Tue Mar 05 2002 Andrew Cress <arcress@users.sf.net>
- changed package name from scsitools to scsirastools ver 1.1.0
* Tue Oct 30 2001 Andrew Cress <arcress@users.sf.net>
- eliminated extra include files, etc. for ver 0.9.8
* Fri Oct 26 2001 Andrew Cress <arcress@users.sf.net>
- Cosmetic changes to sgerr.c, added scsierr.h for ver 0.9.8
* Thu Sep 27 2001 Andrew Cress <arcress@users.sf.net> 
- Cosmetic source changes, added Fujitsu disk files
* Thu Sep 06 2001 Andrew Cress <arcress@users.sf.net> 
- Added mdctl, mdmon, mdevt tools
* Thu Aug 14 2001 Andrew Cress <arcress@users.sf.net> 
- Added the rest of the man pages.
* Thu Jul 19 2001 Andrew Cress <arcress@users.sf.net> 
- SCSI Servicabilty Tools included.

