/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.validator;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorUtil;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.validator.Resources;

public class FieldChecks
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$struts$validator$FieldChecks == null ? (class$org$apache$struts$validator$FieldChecks = FieldChecks.class$("org.apache.struts.validator.FieldChecks")) : class$org$apache$struts$validator$FieldChecks));
    public static final String FIELD_TEST_NULL = "NULL";
    public static final String FIELD_TEST_NOTNULL = "NOTNULL";
    public static final String FIELD_TEST_EQUAL = "EQUAL";
    static /* synthetic */ Class class$org$apache$struts$validator$FieldChecks;
    static /* synthetic */ Class class$java$lang$String;

    public static boolean validateRequired(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (GenericValidator.isBlankOrNull((String)value)) {
            errors.add(field.getKey(), Resources.getActionError(request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateRequiredIf(Object bean, ValidatorAction va, Field field, ActionErrors errors, Validator validator, HttpServletRequest request) {
        Object form = validator.getResource(Validator.BEAN_KEY);
        String value = null;
        boolean required = false;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        int i = 0;
        String fieldJoin = "AND";
        if (!GenericValidator.isBlankOrNull((String)field.getVarValue("fieldJoin"))) {
            fieldJoin = field.getVarValue("fieldJoin");
        }
        if (fieldJoin.equalsIgnoreCase("AND")) {
            required = true;
        }
        while (!GenericValidator.isBlankOrNull((String)field.getVarValue("field[" + i + "]"))) {
            String key;
            String dependProp = field.getVarValue("field[" + i + "]");
            String dependTest = field.getVarValue("fieldTest[" + i + "]");
            String dependTestValue = field.getVarValue("fieldValue[" + i + "]");
            String dependIndexed = field.getVarValue("fieldIndexed[" + i + "]");
            if (dependIndexed == null) {
                dependIndexed = "false";
            }
            String dependVal = null;
            boolean thisRequired = false;
            if (field.isIndexed() && dependIndexed.equalsIgnoreCase("true") && (key = field.getKey()).indexOf("[") > -1 && key.indexOf("]") > -1) {
                String ind = key.substring(0, key.indexOf(".") + 1);
                dependProp = ind + dependProp;
            }
            dependVal = ValidatorUtil.getValueAsString((Object)form, (String)dependProp);
            if (dependTest.equals(FIELD_TEST_NULL)) {
                thisRequired = dependVal == null || dependVal.length() <= 0;
            }
            if (dependTest.equals(FIELD_TEST_NOTNULL)) {
                thisRequired = dependVal != null && dependVal.length() > 0;
            }
            if (dependTest.equals(FIELD_TEST_EQUAL)) {
                thisRequired = dependTestValue.equalsIgnoreCase(dependVal);
            }
            required = fieldJoin.equalsIgnoreCase("AND") ? required && thisRequired : required || thisRequired;
            ++i;
        }
        if (required) {
            if (GenericValidator.isBlankOrNull((String)value)) {
                errors.add(field.getKey(), Resources.getActionError(request, va, field));
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean validateMask(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String mask = field.getVarValue("mask");
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        try {
            if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.matchRegexp((String)value, (String)mask)) {
                errors.add(field.getKey(), Resources.getActionError(request, va, field));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
    }

    public static Byte validateByte(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        Byte result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && (result = GenericTypeValidator.formatByte((String)value)) == null) {
            errors.add(field.getKey(), Resources.getActionError(request, va, field));
        }
        return result;
    }

    public static Short validateShort(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        Short result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && (result = GenericTypeValidator.formatShort((String)value)) == null) {
            errors.add(field.getKey(), Resources.getActionError(request, va, field));
        }
        return result;
    }

    public static Integer validateInteger(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        Integer result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && (result = GenericTypeValidator.formatInt((String)value)) == null) {
            errors.add(field.getKey(), Resources.getActionError(request, va, field));
        }
        return result;
    }

    public static Long validateLong(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        Long result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && (result = GenericTypeValidator.formatLong((String)value)) == null) {
            errors.add(field.getKey(), Resources.getActionError(request, va, field));
        }
        return result;
    }

    public static Float validateFloat(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        Float result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && (result = GenericTypeValidator.formatFloat((String)value)) == null) {
            errors.add(field.getKey(), Resources.getActionError(request, va, field));
        }
        return result;
    }

    public static Double validateDouble(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        Double result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && (result = GenericTypeValidator.formatDouble((String)value)) == null) {
            errors.add(field.getKey(), Resources.getActionError(request, va, field));
        }
        return result;
    }

    public static Date validateDate(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        Date result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        String datePattern = field.getVarValue("datePattern");
        String datePatternStrict = field.getVarValue("datePatternStrict");
        Locale locale = Resources.getLocale(request);
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                result = datePattern != null && datePattern.length() > 0 ? GenericTypeValidator.formatDate((String)value, (String)datePattern, (boolean)false) : (datePatternStrict != null && datePatternStrict.length() > 0 ? GenericTypeValidator.formatDate((String)value, (String)datePatternStrict, (boolean)true) : GenericTypeValidator.formatDate((String)value, (Locale)locale));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (result == null) {
                errors.add(field.getKey(), Resources.getActionError(request, va, field));
            }
        }
        return result;
    }

    public static boolean validateRange(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        return FieldChecks.validateIntRange(bean, va, field, errors, request);
    }

    public static boolean validateIntRange(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                int intValue = Integer.parseInt(value);
                int min = Integer.parseInt(field.getVarValue("min"));
                int max = Integer.parseInt(field.getVarValue("max"));
                if (!GenericValidator.isInRange((int)intValue, (int)min, (int)max)) {
                    errors.add(field.getKey(), Resources.getActionError(request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), Resources.getActionError(request, va, field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateDoubleRange(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                double doubleValue = Double.parseDouble(value);
                double min = Double.parseDouble(field.getVarValue("min"));
                double max = Double.parseDouble(field.getVarValue("max"));
                if (!GenericValidator.isInRange((double)doubleValue, (double)min, (double)max)) {
                    errors.add(field.getKey(), Resources.getActionError(request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), Resources.getActionError(request, va, field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateFloatRange(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                float floatValue = Float.parseFloat(value);
                float min = Float.parseFloat(field.getVarValue("min"));
                float max = Float.parseFloat(field.getVarValue("max"));
                if (!GenericValidator.isInRange((float)floatValue, (float)min, (float)max)) {
                    errors.add(field.getKey(), Resources.getActionError(request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), Resources.getActionError(request, va, field));
                return false;
            }
        }
        return true;
    }

    public static Long validateCreditCard(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        Long result = null;
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && (result = GenericTypeValidator.formatCreditCard((String)value)) == null) {
            errors.add(field.getKey(), Resources.getActionError(request, va, field));
        }
        return result;
    }

    public static boolean validateEmail(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value) && !GenericValidator.isEmail((String)value)) {
            errors.add(field.getKey(), Resources.getActionError(request, va, field));
            return false;
        }
        return true;
    }

    public static boolean validateMaxLength(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (value != null) {
            try {
                int max = Integer.parseInt(field.getVarValue("maxlength"));
                if (!GenericValidator.maxLength((String)value, (int)max)) {
                    errors.add(field.getKey(), Resources.getActionError(request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), Resources.getActionError(request, va, field));
                return false;
            }
        }
        return true;
    }

    public static boolean validateMinLength(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request) {
        String value = null;
        value = FieldChecks.isString(bean) ? (String)bean : ValidatorUtil.getValueAsString((Object)bean, (String)field.getProperty());
        if (!GenericValidator.isBlankOrNull((String)value)) {
            try {
                int min = Integer.parseInt(field.getVarValue("minlength"));
                if (!GenericValidator.minLength((String)value, (int)min)) {
                    errors.add(field.getKey(), Resources.getActionError(request, va, field));
                    return false;
                }
            }
            catch (Exception e) {
                errors.add(field.getKey(), Resources.getActionError(request, va, field));
                return false;
            }
        }
        return true;
    }

    protected static boolean isString(Object o) {
        return o == null ? true : (class$java$lang$String == null ? (class$java$lang$String = FieldChecks.class$("java.lang.String")) : class$java$lang$String).isInstance(o);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

