# InfluxDB Support

Trickster 1.0 provides support for accelerating InfluxDB queries that return time series data normally visualized on a dashboard. Acceleration works by using the Time Series Delta Proxy Cache to minimize the number and time range of queries to the upstream InfluxDB server.

## Scope of Support

Trickster is tested with the built-in [InfluxDB DataSource Plugin for Grafana](https://grafana.com/grafana/plugins/influxdb) v5.0.0.

Trickster uses pre-compiled Regular Expression pattern matches on the incoming InfluxDB query to deconstruct its components, determine if it is cacheable and, if so, what elements are factored into the cache key derivation. We also determine what parts of the query are template-able (e.g., `time >= $ts1 AND <= $ts2`) based on the provided absolute values, in order to normalize the query before hashing the cache key.

If you find query or response structures that are not yet supported, or providing inconsistent or unexpected results, we'd love for you to report those. We also always welcome any contributions around this functionality. The regular expression patterns we currently use will likely grow in complexity as support for more query patterns is added. Thus, we may need to find a more robust query parsing solution, and welcome any assistance with that as well.

Trickster currently supports the following InfluxDB query patterns (case-insensitive), which align with queries generated by the InfluxDB Data Source Plugin for Grafana:

```sql
SELECT field1 [, field2, field3...]
FROM "exampledb"."example_table"
    WHERE ("some_field" = "some_val")
    AND $timeExpression
GROUP BY time($duration) [, group2, group3...]
```

The `$timeExpression` section must be in the format of `time <operator1> $ts1 [AND <operator2> $ts2]`

Example `$timeExpression` strings:

* `time >= now()`
* `time >= 1574699000000ms`
* `time >= 1574699000000ms AND time <= 1574699900000ms`

$duration must be in the format of `<integer>ms` such as `60s`.

The InfluxDB `epoch` HTTP request query parameter is currently required to be set to `ms`.
