// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: config/zone.proto

package config

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"

import bytes "bytes"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type Constraint_Type int32

const (
	// DEPRECATED_POSITIVE has no effect on a replica's placement.
	Constraint_DEPRECATED_POSITIVE Constraint_Type = 0
	// REQUIRED ensures all replicas are placed on stores that match the
	// constraint. Replication will fail if there aren't any such stores.
	Constraint_REQUIRED Constraint_Type = 1
	// PROHIBITED will prevent replicas from having this key, value.
	Constraint_PROHIBITED Constraint_Type = 2
)

var Constraint_Type_name = map[int32]string{
	0: "DEPRECATED_POSITIVE",
	1: "REQUIRED",
	2: "PROHIBITED",
}
var Constraint_Type_value = map[string]int32{
	"DEPRECATED_POSITIVE": 0,
	"REQUIRED":            1,
	"PROHIBITED":          2,
}

func (x Constraint_Type) Enum() *Constraint_Type {
	p := new(Constraint_Type)
	*p = x
	return p
}
func (x Constraint_Type) String() string {
	return proto.EnumName(Constraint_Type_name, int32(x))
}
func (x *Constraint_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Constraint_Type_value, data, "Constraint_Type")
	if err != nil {
		return err
	}
	*x = Constraint_Type(value)
	return nil
}
func (Constraint_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_zone_09a0ac64b8ce7ce1, []int{1, 0}
}

// GCPolicy defines garbage collection policies which apply to MVCC
// values within a zone.
//
// TODO(spencer): flesh this out to include maximum number of values
//   as well as whether there's an intersection between max values
//   and TTL or a union.
type GCPolicy struct {
	// TTLSeconds specifies the maximum age of a value before it's
	// garbage collected. Only older versions of values are garbage
	// collected. Specifying <=0 mean older versions are never GC'd.
	TTLSeconds           int32    `protobuf:"varint,1,opt,name=ttl_seconds,json=ttlSeconds" json:"ttl_seconds"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GCPolicy) Reset()         { *m = GCPolicy{} }
func (m *GCPolicy) String() string { return proto.CompactTextString(m) }
func (*GCPolicy) ProtoMessage()    {}
func (*GCPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_zone_09a0ac64b8ce7ce1, []int{0}
}
func (m *GCPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GCPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *GCPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GCPolicy.Merge(dst, src)
}
func (m *GCPolicy) XXX_Size() int {
	return m.Size()
}
func (m *GCPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_GCPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_GCPolicy proto.InternalMessageInfo

// Constraint constrains the stores a replica can be stored on.
type Constraint struct {
	Type Constraint_Type `protobuf:"varint,1,opt,name=type,enum=cockroach.config.Constraint_Type" json:"type"`
	// Key is only set if this is a constraint on locality.
	Key string `protobuf:"bytes,2,opt,name=key" json:"key"`
	// Value to constrain to.
	Value                string   `protobuf:"bytes,3,opt,name=value" json:"value"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Constraint) Reset()      { *m = Constraint{} }
func (*Constraint) ProtoMessage() {}
func (*Constraint) Descriptor() ([]byte, []int) {
	return fileDescriptor_zone_09a0ac64b8ce7ce1, []int{1}
}
func (m *Constraint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Constraint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *Constraint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Constraint.Merge(dst, src)
}
func (m *Constraint) XXX_Size() int {
	return m.Size()
}
func (m *Constraint) XXX_DiscardUnknown() {
	xxx_messageInfo_Constraint.DiscardUnknown(m)
}

var xxx_messageInfo_Constraint proto.InternalMessageInfo

// Constraints is a collection of constraints.
type Constraints struct {
	// The number of replicas that should abide by the constraints. If left
	// unspecified (i.e. set to 0), the constraints will be assumed to apply
	// to all replicas of the range.
	// As of v2.0, only REQUIRED constraints are allowed when num_replicas is
	// set to a non-zero value.
	NumReplicas          int32        `protobuf:"varint,7,opt,name=num_replicas,json=numReplicas" json:"num_replicas"`
	Constraints          []Constraint `protobuf:"bytes,6,rep,name=constraints" json:"constraints"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Constraints) Reset()         { *m = Constraints{} }
func (m *Constraints) String() string { return proto.CompactTextString(m) }
func (*Constraints) ProtoMessage()    {}
func (*Constraints) Descriptor() ([]byte, []int) {
	return fileDescriptor_zone_09a0ac64b8ce7ce1, []int{2}
}
func (m *Constraints) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Constraints) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *Constraints) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Constraints.Merge(dst, src)
}
func (m *Constraints) XXX_Size() int {
	return m.Size()
}
func (m *Constraints) XXX_DiscardUnknown() {
	xxx_messageInfo_Constraints.DiscardUnknown(m)
}

var xxx_messageInfo_Constraints proto.InternalMessageInfo

// LeasePreference specifies a preference about where range leases should be
// located.
type LeasePreference struct {
	Constraints          []Constraint `protobuf:"bytes,1,rep,name=constraints" json:"constraints" yaml:"constraints,flow"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *LeasePreference) Reset()         { *m = LeasePreference{} }
func (m *LeasePreference) String() string { return proto.CompactTextString(m) }
func (*LeasePreference) ProtoMessage()    {}
func (*LeasePreference) Descriptor() ([]byte, []int) {
	return fileDescriptor_zone_09a0ac64b8ce7ce1, []int{3}
}
func (m *LeasePreference) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LeasePreference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *LeasePreference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LeasePreference.Merge(dst, src)
}
func (m *LeasePreference) XXX_Size() int {
	return m.Size()
}
func (m *LeasePreference) XXX_DiscardUnknown() {
	xxx_messageInfo_LeasePreference.DiscardUnknown(m)
}

var xxx_messageInfo_LeasePreference proto.InternalMessageInfo

// ZoneConfig holds configuration that applies to one or more ranges.
//
// Note: when adding.removing fields here, be sure to update
// supportedZoneConfigOptions in the sql package, to synchronize
// with the code for ALTER ... CONFIGURE ZONE.
type ZoneConfig struct {
	RangeMinBytes *int64 `protobuf:"varint,2,opt,name=range_min_bytes,json=rangeMinBytes" json:"range_min_bytes,omitempty" yaml:"range_min_bytes"`
	RangeMaxBytes *int64 `protobuf:"varint,3,opt,name=range_max_bytes,json=rangeMaxBytes" json:"range_max_bytes,omitempty" yaml:"range_max_bytes"`
	// If GC policy is not set, uses the next highest, non-null policy
	// in the zone config hierarchy, up to the default policy if necessary.
	GC *GCPolicy `protobuf:"bytes,4,opt,name=gc" json:"gc,omitempty"`
	// NumReplicas specifies the desired number of replicas
	NumReplicas *int32 `protobuf:"varint,5,opt,name=num_replicas,json=numReplicas" json:"num_replicas,omitempty" yaml:"num_replicas"`
	// Constraints constrains which stores the replicas can be stored on. The
	// order in which the constraints are stored is arbitrary and may change.
	// https://github.com/cockroachdb/cockroach/blob/master/docs/RFCS/20160706_expressive_zone_config.md#constraint-system
	//
	// NOTE: The sum of the num_replicas fields of the Constraints must add up to
	// ZoneConfig.num_replicas, or there must be no more than a single Constraints
	// field with num_replicas set to 0.
	Constraints []Constraints `protobuf:"bytes,6,rep,name=constraints" json:"constraints" yaml:"constraints,flow"`
	// InheritedContraints specifies if the value in the Constraints field was
	// inherited from the zone's parent or specified explicitly by the user.
	InheritedConstraints bool `protobuf:"varint,10,opt,name=inherited_constraints,json=inheritedConstraints" json:"inherited_constraints"`
	// LeasePreference stores information about where the user would prefer for
	// range leases to be placed. Leases are allowed to be placed elsewhere if
	// needed, but will follow the provided preference when possible.
	//
	// More than one lease preference is allowed, but they should be ordered from
	// most preferred to lease preferred. The first preference that an existing
	// replica of a range matches will take priority.
	LeasePreferences []LeasePreference `protobuf:"bytes,9,rep,name=lease_preferences,json=leasePreferences" json:"lease_preferences" yaml:"lease_preferences,flow"`
	// InheritedLeasePreferences specifies if the value in the LeasePreferences field
	// was inherited from the zone's parent or specified explicitly by the user.
	InheritedLeasePreferences bool `protobuf:"varint,11,opt,name=inherited_lease_preferences,json=inheritedLeasePreferences" json:"inherited_lease_preferences"`
	// Subzones stores config overrides for "subzones", each of which represents
	// either a SQL table index or a partition of a SQL table index. Subzones are
	// not applicable when the zone does not represent a SQL table (i.e., when the
	// zone represents a database, a special system range, or is itself a
	// subzone.)
	Subzones []Subzone `protobuf:"bytes,8,rep,name=subzones" json:"subzones" yaml:"-"`
	// SubzoneSpans maps each key span in a subzone to the slice index of an entry
	// in SubzoneConfig. Spans are non-overlapping and sorted by start key to
	// allow binary searching. SubzoneSpans can be easily derived from a
	// TableDescriptor, but are denormalized here to make GetZoneConfigForKey
	// lookups efficient.
	SubzoneSpans         []SubzoneSpan `protobuf:"bytes,7,rep,name=subzone_spans,json=subzoneSpans" json:"subzone_spans" yaml:"-"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ZoneConfig) Reset()         { *m = ZoneConfig{} }
func (m *ZoneConfig) String() string { return proto.CompactTextString(m) }
func (*ZoneConfig) ProtoMessage()    {}
func (*ZoneConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_zone_09a0ac64b8ce7ce1, []int{4}
}
func (m *ZoneConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ZoneConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ZoneConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ZoneConfig.Merge(dst, src)
}
func (m *ZoneConfig) XXX_Size() int {
	return m.Size()
}
func (m *ZoneConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ZoneConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ZoneConfig proto.InternalMessageInfo

type Subzone struct {
	// IndexID is the ID of the SQL table index that the subzone represents. It
	// must always be set even though partition names are unique across all of a
	// table's indices.
	IndexID uint32 `protobuf:"varint,1,opt,name=index_id,json=indexId" json:"index_id"`
	// PartitionName is the partition of the SQL table index that the subzone
	// represents. It is empty when the subzone represents the entire index.
	PartitionName string `protobuf:"bytes,2,opt,name=partition_name,json=partitionName" json:"partition_name"`
	// Config stores the ZoneConfig that applies to this Subzone. It never
	// contains nested subzones.
	Config               ZoneConfig `protobuf:"bytes,3,opt,name=config" json:"config"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Subzone) Reset()         { *m = Subzone{} }
func (m *Subzone) String() string { return proto.CompactTextString(m) }
func (*Subzone) ProtoMessage()    {}
func (*Subzone) Descriptor() ([]byte, []int) {
	return fileDescriptor_zone_09a0ac64b8ce7ce1, []int{5}
}
func (m *Subzone) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Subzone) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *Subzone) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subzone.Merge(dst, src)
}
func (m *Subzone) XXX_Size() int {
	return m.Size()
}
func (m *Subzone) XXX_DiscardUnknown() {
	xxx_messageInfo_Subzone.DiscardUnknown(m)
}

var xxx_messageInfo_Subzone proto.InternalMessageInfo

type SubzoneSpan struct {
	// Key stores a key suffix that represents the inclusive lower bound for this
	// span. The SQL table prefix, like /Table/51/, is omitted.
	//
	// Both Key and EndKey, below, are cast to roachpb.Key for convenience, but
	// there's no technical restriction that prevents switching them to []byte or
	// another type that communicates their missing prefix.
	Key github_com_cockroachdb_cockroach_pkg_roachpb.Key `protobuf:"bytes,1,opt,name=key,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.Key" json:"key,omitempty"`
	// EndKey stores a key suffix that represents the exclusive upper bound for
	// this span. Like with Key, the SQL table prefix is omitted. If EndKey is
	// empty, it is assumed to be Key.PrefixEnd().
	EndKey github_com_cockroachdb_cockroach_pkg_roachpb.Key `protobuf:"bytes,2,opt,name=end_key,json=endKey,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.Key" json:"end_key,omitempty"`
	// SubzoneIndex is the slice index of the Subzone this span belongs to in the
	// parent ZoneConfig's Subzones field.
	SubzoneIndex         int32    `protobuf:"varint,3,opt,name=subzone_index,json=subzoneIndex" json:"subzone_index"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SubzoneSpan) Reset()         { *m = SubzoneSpan{} }
func (m *SubzoneSpan) String() string { return proto.CompactTextString(m) }
func (*SubzoneSpan) ProtoMessage()    {}
func (*SubzoneSpan) Descriptor() ([]byte, []int) {
	return fileDescriptor_zone_09a0ac64b8ce7ce1, []int{6}
}
func (m *SubzoneSpan) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SubzoneSpan) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *SubzoneSpan) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubzoneSpan.Merge(dst, src)
}
func (m *SubzoneSpan) XXX_Size() int {
	return m.Size()
}
func (m *SubzoneSpan) XXX_DiscardUnknown() {
	xxx_messageInfo_SubzoneSpan.DiscardUnknown(m)
}

var xxx_messageInfo_SubzoneSpan proto.InternalMessageInfo

func init() {
	proto.RegisterType((*GCPolicy)(nil), "cockroach.config.GCPolicy")
	proto.RegisterType((*Constraint)(nil), "cockroach.config.Constraint")
	proto.RegisterType((*Constraints)(nil), "cockroach.config.Constraints")
	proto.RegisterType((*LeasePreference)(nil), "cockroach.config.LeasePreference")
	proto.RegisterType((*ZoneConfig)(nil), "cockroach.config.ZoneConfig")
	proto.RegisterType((*Subzone)(nil), "cockroach.config.Subzone")
	proto.RegisterType((*SubzoneSpan)(nil), "cockroach.config.SubzoneSpan")
	proto.RegisterEnum("cockroach.config.Constraint_Type", Constraint_Type_name, Constraint_Type_value)
}
func (this *GCPolicy) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GCPolicy)
	if !ok {
		that2, ok := that.(GCPolicy)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TTLSeconds != that1.TTLSeconds {
		return false
	}
	return true
}
func (this *Constraint) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Constraint)
	if !ok {
		that2, ok := that.(Constraint)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *Constraints) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Constraints)
	if !ok {
		that2, ok := that.(Constraints)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NumReplicas != that1.NumReplicas {
		return false
	}
	if len(this.Constraints) != len(that1.Constraints) {
		return false
	}
	for i := range this.Constraints {
		if !this.Constraints[i].Equal(&that1.Constraints[i]) {
			return false
		}
	}
	return true
}
func (this *LeasePreference) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LeasePreference)
	if !ok {
		that2, ok := that.(LeasePreference)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Constraints) != len(that1.Constraints) {
		return false
	}
	for i := range this.Constraints {
		if !this.Constraints[i].Equal(&that1.Constraints[i]) {
			return false
		}
	}
	return true
}
func (this *ZoneConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ZoneConfig)
	if !ok {
		that2, ok := that.(ZoneConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.RangeMinBytes != nil && that1.RangeMinBytes != nil {
		if *this.RangeMinBytes != *that1.RangeMinBytes {
			return false
		}
	} else if this.RangeMinBytes != nil {
		return false
	} else if that1.RangeMinBytes != nil {
		return false
	}
	if this.RangeMaxBytes != nil && that1.RangeMaxBytes != nil {
		if *this.RangeMaxBytes != *that1.RangeMaxBytes {
			return false
		}
	} else if this.RangeMaxBytes != nil {
		return false
	} else if that1.RangeMaxBytes != nil {
		return false
	}
	if !this.GC.Equal(that1.GC) {
		return false
	}
	if this.NumReplicas != nil && that1.NumReplicas != nil {
		if *this.NumReplicas != *that1.NumReplicas {
			return false
		}
	} else if this.NumReplicas != nil {
		return false
	} else if that1.NumReplicas != nil {
		return false
	}
	if len(this.Constraints) != len(that1.Constraints) {
		return false
	}
	for i := range this.Constraints {
		if !this.Constraints[i].Equal(&that1.Constraints[i]) {
			return false
		}
	}
	if this.InheritedConstraints != that1.InheritedConstraints {
		return false
	}
	if len(this.LeasePreferences) != len(that1.LeasePreferences) {
		return false
	}
	for i := range this.LeasePreferences {
		if !this.LeasePreferences[i].Equal(&that1.LeasePreferences[i]) {
			return false
		}
	}
	if this.InheritedLeasePreferences != that1.InheritedLeasePreferences {
		return false
	}
	if len(this.Subzones) != len(that1.Subzones) {
		return false
	}
	for i := range this.Subzones {
		if !this.Subzones[i].Equal(&that1.Subzones[i]) {
			return false
		}
	}
	if len(this.SubzoneSpans) != len(that1.SubzoneSpans) {
		return false
	}
	for i := range this.SubzoneSpans {
		if !this.SubzoneSpans[i].Equal(&that1.SubzoneSpans[i]) {
			return false
		}
	}
	return true
}
func (this *Subzone) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Subzone)
	if !ok {
		that2, ok := that.(Subzone)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.IndexID != that1.IndexID {
		return false
	}
	if this.PartitionName != that1.PartitionName {
		return false
	}
	if !this.Config.Equal(&that1.Config) {
		return false
	}
	return true
}
func (this *SubzoneSpan) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SubzoneSpan)
	if !ok {
		that2, ok := that.(SubzoneSpan)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Key, that1.Key) {
		return false
	}
	if !bytes.Equal(this.EndKey, that1.EndKey) {
		return false
	}
	if this.SubzoneIndex != that1.SubzoneIndex {
		return false
	}
	return true
}
func (m *GCPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.TTLSeconds))
	return i, nil
}

func (m *Constraint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Constraint) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.Type))
	dAtA[i] = 0x12
	i++
	i = encodeVarintZone(dAtA, i, uint64(len(m.Key)))
	i += copy(dAtA[i:], m.Key)
	dAtA[i] = 0x1a
	i++
	i = encodeVarintZone(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	return i, nil
}

func (m *Constraints) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Constraints) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Constraints) > 0 {
		for _, msg := range m.Constraints {
			dAtA[i] = 0x32
			i++
			i = encodeVarintZone(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x38
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.NumReplicas))
	return i, nil
}

func (m *LeasePreference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LeasePreference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Constraints) > 0 {
		for _, msg := range m.Constraints {
			dAtA[i] = 0xa
			i++
			i = encodeVarintZone(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ZoneConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ZoneConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RangeMinBytes != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintZone(dAtA, i, uint64(*m.RangeMinBytes))
	}
	if m.RangeMaxBytes != nil {
		dAtA[i] = 0x18
		i++
		i = encodeVarintZone(dAtA, i, uint64(*m.RangeMaxBytes))
	}
	if m.GC != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintZone(dAtA, i, uint64(m.GC.Size()))
		n1, err := m.GC.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.NumReplicas != nil {
		dAtA[i] = 0x28
		i++
		i = encodeVarintZone(dAtA, i, uint64(*m.NumReplicas))
	}
	if len(m.Constraints) > 0 {
		for _, msg := range m.Constraints {
			dAtA[i] = 0x32
			i++
			i = encodeVarintZone(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.SubzoneSpans) > 0 {
		for _, msg := range m.SubzoneSpans {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintZone(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Subzones) > 0 {
		for _, msg := range m.Subzones {
			dAtA[i] = 0x42
			i++
			i = encodeVarintZone(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.LeasePreferences) > 0 {
		for _, msg := range m.LeasePreferences {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintZone(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x50
	i++
	if m.InheritedConstraints {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x58
	i++
	if m.InheritedLeasePreferences {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *Subzone) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Subzone) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.IndexID))
	dAtA[i] = 0x12
	i++
	i = encodeVarintZone(dAtA, i, uint64(len(m.PartitionName)))
	i += copy(dAtA[i:], m.PartitionName)
	dAtA[i] = 0x1a
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.Config.Size()))
	n2, err := m.Config.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	return i, nil
}

func (m *SubzoneSpan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubzoneSpan) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintZone(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if m.EndKey != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintZone(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	dAtA[i] = 0x18
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.SubzoneIndex))
	return i, nil
}

func encodeVarintZone(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedGCPolicy(r randyZone, easy bool) *GCPolicy {
	this := &GCPolicy{}
	this.TTLSeconds = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.TTLSeconds *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedConstraint(r randyZone, easy bool) *Constraint {
	this := &Constraint{}
	this.Type = Constraint_Type([]int32{0, 1, 2}[r.Intn(3)])
	this.Key = string(randStringZone(r))
	this.Value = string(randStringZone(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedConstraints(r randyZone, easy bool) *Constraints {
	this := &Constraints{}
	if r.Intn(10) != 0 {
		v1 := r.Intn(5)
		this.Constraints = make([]Constraint, v1)
		for i := 0; i < v1; i++ {
			v2 := NewPopulatedConstraint(r, easy)
			this.Constraints[i] = *v2
		}
	}
	this.NumReplicas = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.NumReplicas *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedLeasePreference(r randyZone, easy bool) *LeasePreference {
	this := &LeasePreference{}
	if r.Intn(10) != 0 {
		v3 := r.Intn(5)
		this.Constraints = make([]Constraint, v3)
		for i := 0; i < v3; i++ {
			v4 := NewPopulatedConstraint(r, easy)
			this.Constraints[i] = *v4
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedZoneConfig(r randyZone, easy bool) *ZoneConfig {
	this := &ZoneConfig{}
	if r.Intn(10) != 0 {
		v5 := int64(r.Int63())
		if r.Intn(2) == 0 {
			v5 *= -1
		}
		this.RangeMinBytes = &v5
	}
	if r.Intn(10) != 0 {
		v6 := int64(r.Int63())
		if r.Intn(2) == 0 {
			v6 *= -1
		}
		this.RangeMaxBytes = &v6
	}
	if r.Intn(10) != 0 {
		this.GC = NewPopulatedGCPolicy(r, easy)
	}
	if r.Intn(10) != 0 {
		v7 := int32(r.Int31())
		if r.Intn(2) == 0 {
			v7 *= -1
		}
		this.NumReplicas = &v7
	}
	if r.Intn(10) != 0 {
		v8 := r.Intn(5)
		this.Constraints = make([]Constraints, v8)
		for i := 0; i < v8; i++ {
			v9 := NewPopulatedConstraints(r, easy)
			this.Constraints[i] = *v9
		}
	}
	if r.Intn(10) != 0 {
		v10 := r.Intn(5)
		this.SubzoneSpans = make([]SubzoneSpan, v10)
		for i := 0; i < v10; i++ {
			v11 := NewPopulatedSubzoneSpan(r, easy)
			this.SubzoneSpans[i] = *v11
		}
	}
	if r.Intn(10) == 0 {
		v12 := r.Intn(5)
		this.Subzones = make([]Subzone, v12)
		for i := 0; i < v12; i++ {
			v13 := NewPopulatedSubzone(r, easy)
			this.Subzones[i] = *v13
		}
	}
	if r.Intn(10) != 0 {
		v14 := r.Intn(5)
		this.LeasePreferences = make([]LeasePreference, v14)
		for i := 0; i < v14; i++ {
			v15 := NewPopulatedLeasePreference(r, easy)
			this.LeasePreferences[i] = *v15
		}
	}
	this.InheritedConstraints = bool(bool(r.Intn(2) == 0))
	this.InheritedLeasePreferences = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedSubzone(r randyZone, easy bool) *Subzone {
	this := &Subzone{}
	this.IndexID = uint32(r.Uint32())
	this.PartitionName = string(randStringZone(r))
	v16 := NewPopulatedZoneConfig(r, easy)
	this.Config = *v16
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedSubzoneSpan(r randyZone, easy bool) *SubzoneSpan {
	this := &SubzoneSpan{}
	if r.Intn(10) != 0 {
		v17 := r.Intn(100)
		this.Key = make(github_com_cockroachdb_cockroach_pkg_roachpb.Key, v17)
		for i := 0; i < v17; i++ {
			this.Key[i] = byte(r.Intn(256))
		}
	}
	if r.Intn(10) != 0 {
		v18 := r.Intn(100)
		this.EndKey = make(github_com_cockroachdb_cockroach_pkg_roachpb.Key, v18)
		for i := 0; i < v18; i++ {
			this.EndKey[i] = byte(r.Intn(256))
		}
	}
	this.SubzoneIndex = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.SubzoneIndex *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyZone interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneZone(r randyZone) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringZone(r randyZone) string {
	v19 := r.Intn(100)
	tmps := make([]rune, v19)
	for i := 0; i < v19; i++ {
		tmps[i] = randUTF8RuneZone(r)
	}
	return string(tmps)
}
func randUnrecognizedZone(r randyZone, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldZone(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldZone(dAtA []byte, r randyZone, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateZone(dAtA, uint64(key))
		v20 := r.Int63()
		if r.Intn(2) == 0 {
			v20 *= -1
		}
		dAtA = encodeVarintPopulateZone(dAtA, uint64(v20))
	case 1:
		dAtA = encodeVarintPopulateZone(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateZone(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateZone(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateZone(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateZone(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *GCPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovZone(uint64(m.TTLSeconds))
	return n
}

func (m *Constraint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovZone(uint64(m.Type))
	l = len(m.Key)
	n += 1 + l + sovZone(uint64(l))
	l = len(m.Value)
	n += 1 + l + sovZone(uint64(l))
	return n
}

func (m *Constraints) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Constraints) > 0 {
		for _, e := range m.Constraints {
			l = e.Size()
			n += 1 + l + sovZone(uint64(l))
		}
	}
	n += 1 + sovZone(uint64(m.NumReplicas))
	return n
}

func (m *LeasePreference) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Constraints) > 0 {
		for _, e := range m.Constraints {
			l = e.Size()
			n += 1 + l + sovZone(uint64(l))
		}
	}
	return n
}

func (m *ZoneConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RangeMinBytes != nil {
		n += 1 + sovZone(uint64(*m.RangeMinBytes))
	}
	if m.RangeMaxBytes != nil {
		n += 1 + sovZone(uint64(*m.RangeMaxBytes))
	}
	if m.GC != nil {
		l = m.GC.Size()
		n += 1 + l + sovZone(uint64(l))
	}
	if m.NumReplicas != nil {
		n += 1 + sovZone(uint64(*m.NumReplicas))
	}
	if len(m.Constraints) > 0 {
		for _, e := range m.Constraints {
			l = e.Size()
			n += 1 + l + sovZone(uint64(l))
		}
	}
	if len(m.SubzoneSpans) > 0 {
		for _, e := range m.SubzoneSpans {
			l = e.Size()
			n += 1 + l + sovZone(uint64(l))
		}
	}
	if len(m.Subzones) > 0 {
		for _, e := range m.Subzones {
			l = e.Size()
			n += 1 + l + sovZone(uint64(l))
		}
	}
	if len(m.LeasePreferences) > 0 {
		for _, e := range m.LeasePreferences {
			l = e.Size()
			n += 1 + l + sovZone(uint64(l))
		}
	}
	n += 2
	n += 2
	return n
}

func (m *Subzone) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovZone(uint64(m.IndexID))
	l = len(m.PartitionName)
	n += 1 + l + sovZone(uint64(l))
	l = m.Config.Size()
	n += 1 + l + sovZone(uint64(l))
	return n
}

func (m *SubzoneSpan) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Key != nil {
		l = len(m.Key)
		n += 1 + l + sovZone(uint64(l))
	}
	if m.EndKey != nil {
		l = len(m.EndKey)
		n += 1 + l + sovZone(uint64(l))
	}
	n += 1 + sovZone(uint64(m.SubzoneIndex))
	return n
}

func sovZone(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozZone(x uint64) (n int) {
	return sovZone(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GCPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowZone
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TTLSeconds", wireType)
			}
			m.TTLSeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TTLSeconds |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipZone(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthZone
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Constraint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowZone
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Constraint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Constraint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Constraint_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipZone(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthZone
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Constraints) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowZone
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Constraints: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Constraints: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Constraints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Constraints = append(m.Constraints, Constraint{})
			if err := m.Constraints[len(m.Constraints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumReplicas", wireType)
			}
			m.NumReplicas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumReplicas |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipZone(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthZone
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeasePreference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowZone
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeasePreference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeasePreference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Constraints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Constraints = append(m.Constraints, Constraint{})
			if err := m.Constraints[len(m.Constraints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipZone(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthZone
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ZoneConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowZone
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ZoneConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ZoneConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeMinBytes", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RangeMinBytes = &v
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeMaxBytes", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RangeMaxBytes = &v
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GC", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GC == nil {
				m.GC = &GCPolicy{}
			}
			if err := m.GC.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumReplicas", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NumReplicas = &v
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Constraints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Constraints = append(m.Constraints, Constraints{})
			if err := m.Constraints[len(m.Constraints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubzoneSpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubzoneSpans = append(m.SubzoneSpans, SubzoneSpan{})
			if err := m.SubzoneSpans[len(m.SubzoneSpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subzones", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subzones = append(m.Subzones, Subzone{})
			if err := m.Subzones[len(m.Subzones)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeasePreferences", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LeasePreferences = append(m.LeasePreferences, LeasePreference{})
			if err := m.LeasePreferences[len(m.LeasePreferences)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InheritedConstraints", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.InheritedConstraints = bool(v != 0)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InheritedLeasePreferences", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.InheritedLeasePreferences = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipZone(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthZone
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Subzone) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowZone
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Subzone: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Subzone: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexID", wireType)
			}
			m.IndexID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IndexID |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartitionName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PartitionName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipZone(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthZone
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubzoneSpan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowZone
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubzoneSpan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubzoneSpan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubzoneIndex", wireType)
			}
			m.SubzoneIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SubzoneIndex |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipZone(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthZone
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipZone(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowZone
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowZone
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowZone
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthZone
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowZone
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipZone(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthZone = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowZone   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("config/zone.proto", fileDescriptor_zone_09a0ac64b8ce7ce1) }

var fileDescriptor_zone_09a0ac64b8ce7ce1 = []byte{
	// 843 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xbf, 0x73, 0xe3, 0x44,
	0x14, 0xf6, 0xda, 0x8e, 0xad, 0x7b, 0x76, 0x12, 0xdf, 0xde, 0x71, 0xf1, 0x05, 0xce, 0x32, 0x9a,
	0x61, 0x30, 0xbf, 0x6c, 0x26, 0xd0, 0x60, 0x86, 0x02, 0xd9, 0x26, 0x88, 0xbb, 0xe3, 0x8c, 0x62,
	0x28, 0xae, 0x11, 0xb2, 0xb4, 0x51, 0x34, 0x91, 0x57, 0x1a, 0x49, 0x86, 0x88, 0xa1, 0xa6, 0x63,
	0x86, 0x92, 0x32, 0x25, 0x7f, 0x02, 0x7f, 0x42, 0x86, 0x8a, 0x12, 0x1a, 0x0f, 0x98, 0x86, 0x3a,
	0x25, 0x15, 0xa3, 0xd5, 0x5a, 0x92, 0x9d, 0xe4, 0x06, 0xae, 0xdb, 0xdd, 0xf7, 0xde, 0xf7, 0xde,
	0xfb, 0xf6, 0x7d, 0x0f, 0x6e, 0x1b, 0x2e, 0x3d, 0xb6, 0xad, 0xde, 0x37, 0x2e, 0x25, 0x5d, 0xcf,
	0x77, 0x43, 0x17, 0x37, 0x0c, 0xd7, 0x38, 0xf5, 0x5d, 0xdd, 0x38, 0xe9, 0x26, 0xc6, 0xfd, 0xbb,
	0x96, 0x6b, 0xb9, 0xcc, 0xd8, 0x8b, 0x4f, 0x89, 0x9f, 0xa4, 0x80, 0x70, 0x38, 0x18, 0xbb, 0x8e,
	0x6d, 0x44, 0xf8, 0x1d, 0xa8, 0x85, 0xa1, 0xa3, 0x05, 0xc4, 0x70, 0xa9, 0x19, 0x34, 0x51, 0x1b,
	0x75, 0xb6, 0x64, 0x7c, 0xb1, 0x10, 0x0b, 0xcb, 0x85, 0x08, 0x93, 0xc9, 0xa3, 0xa3, 0xc4, 0xa2,
	0x42, 0x18, 0x3a, 0xfc, 0xdc, 0x17, 0x7e, 0x3e, 0x17, 0xd1, 0xdf, 0xe7, 0x22, 0x92, 0x7e, 0x41,
	0x00, 0x03, 0x97, 0x06, 0xa1, 0xaf, 0xdb, 0x34, 0xc4, 0xef, 0x43, 0x39, 0x8c, 0x3c, 0xc2, 0x60,
	0x76, 0x0e, 0x5e, 0xee, 0x6e, 0x16, 0xd4, 0xcd, 0x7c, 0xbb, 0x93, 0xc8, 0x23, 0x72, 0x39, 0xce,
	0xa4, 0xb2, 0x20, 0x7c, 0x0f, 0x4a, 0xa7, 0x24, 0x6a, 0x16, 0xdb, 0xa8, 0x73, 0x8b, 0x1b, 0xe2,
	0x07, 0xbc, 0x0f, 0x5b, 0x5f, 0xe9, 0xce, 0x9c, 0x34, 0x4b, 0x39, 0x4b, 0xf2, 0x24, 0x7d, 0x00,
	0xe5, 0x18, 0x07, 0xef, 0xc1, 0x9d, 0xe1, 0x68, 0xac, 0x8e, 0x06, 0x1f, 0x4e, 0x46, 0x43, 0x6d,
	0xfc, 0xe4, 0x48, 0x99, 0x28, 0x5f, 0x8c, 0x1a, 0x05, 0x5c, 0x07, 0x41, 0x1d, 0x7d, 0xf6, 0xb9,
	0xa2, 0x8e, 0x86, 0x0d, 0x84, 0x77, 0x00, 0xc6, 0xea, 0x93, 0x8f, 0x15, 0x59, 0x99, 0x8c, 0x86,
	0x8d, 0x62, 0xbf, 0xfe, 0xe3, 0xb9, 0x58, 0x48, 0x9b, 0xf9, 0x0e, 0x41, 0x2d, 0x2b, 0x30, 0xc0,
	0x43, 0xa8, 0x19, 0xd9, 0xb5, 0x59, 0x69, 0x97, 0x3a, 0xb5, 0x83, 0x97, 0x9e, 0xd5, 0x14, 0x2f,
	0x2e, 0x1f, 0x86, 0x5f, 0x85, 0x3a, 0x9d, 0xcf, 0x34, 0x9f, 0x78, 0x8e, 0x6d, 0xe8, 0x41, 0xb3,
	0xca, 0x28, 0xe6, 0x8e, 0x74, 0x3e, 0x53, 0xb9, 0x21, 0xc7, 0xea, 0xb7, 0xb0, 0xfb, 0x88, 0xe8,
	0x01, 0x19, 0xfb, 0xe4, 0x98, 0xf8, 0x84, 0x1a, 0x04, 0x6b, 0xeb, 0xb5, 0xa0, 0xff, 0x50, 0x8b,
	0x18, 0xa7, 0xb8, 0x5c, 0x88, 0x7b, 0x91, 0x3e, 0x73, 0xfa, 0x52, 0x2e, 0xfc, 0xcd, 0x63, 0xc7,
	0xfd, 0x5a, 0x5a, 0x2b, 0x33, 0x97, 0xfd, 0xfb, 0x0a, 0xc0, 0x53, 0x97, 0x92, 0x01, 0x43, 0xc4,
	0x32, 0xec, 0xfa, 0x3a, 0xb5, 0x88, 0x36, 0xb3, 0xa9, 0x36, 0x8d, 0x42, 0x12, 0xb0, 0x2f, 0x2a,
	0xc9, 0xfb, 0x97, 0x0b, 0xf1, 0x5e, 0x82, 0xbd, 0xe1, 0x20, 0xa9, 0xdb, 0xec, 0xe5, 0xb1, 0x4d,
	0xe5, 0xf8, 0x9e, 0xc3, 0xd0, 0xcf, 0x38, 0x46, 0xe9, 0x06, 0x8c, 0x95, 0x43, 0x8a, 0xa1, 0x9f,
	0x25, 0x18, 0x07, 0x50, 0xb4, 0x8c, 0x66, 0xb9, 0x8d, 0x3a, 0xb5, 0x83, 0xfd, 0xab, 0x8d, 0xaf,
	0x26, 0x5a, 0xae, 0x2c, 0x17, 0x62, 0xf1, 0x70, 0xa0, 0x16, 0x2d, 0x03, 0xf7, 0x37, 0xb8, 0xdf,
	0x62, 0xdc, 0xef, 0x5d, 0x2e, 0xc4, 0x3b, 0x49, 0xd2, 0xbc, 0x55, 0x5a, 0xfb, 0x0e, 0xfc, 0xe5,
	0x75, 0xbf, 0xff, 0xe0, 0x59, 0x8c, 0x07, 0xff, 0x8f, 0x72, 0x3c, 0x81, 0xed, 0x60, 0x3e, 0x8d,
	0x05, 0xac, 0x05, 0x9e, 0x4e, 0xe3, 0xd1, 0xb8, 0x21, 0xc7, 0x51, 0xe2, 0x76, 0xe4, 0xe9, 0x54,
	0x6e, 0xf0, 0x1c, 0x42, 0x92, 0xe3, 0x2d, 0x49, 0xad, 0x07, 0x99, 0x39, 0xc0, 0x87, 0x20, 0xf0,
	0x7b, 0xd0, 0x14, 0x18, 0xe0, 0xfd, 0x1b, 0x01, 0xaf, 0x01, 0x4b, 0x83, 0xf1, 0x1c, 0x6e, 0x3b,
	0xf1, 0x14, 0x6a, 0x5e, 0x3a, 0x86, 0x41, 0xf3, 0x16, 0x43, 0xbc, 0x46, 0xd9, 0x1b, 0x03, 0x2b,
	0xbf, 0xc2, 0x91, 0x1f, 0x24, 0xc8, 0x57, 0x90, 0x38, 0x21, 0x0d, 0x67, 0x3d, 0x2e, 0xc0, 0xef,
	0xc1, 0x0b, 0x36, 0x3d, 0x21, 0xbe, 0x1d, 0x12, 0x53, 0xcb, 0xff, 0x00, 0xb4, 0x51, 0x47, 0xe0,
	0xc2, 0xb9, 0x9b, 0xba, 0xac, 0x0b, 0xf6, 0xc5, 0x2c, 0xf4, 0x6a, 0xed, 0xb5, 0x1c, 0xc0, 0xfd,
	0xd4, 0x71, 0xa3, 0xf0, 0x9c, 0x12, 0x3e, 0x29, 0x0b, 0xa8, 0x51, 0x94, 0x7e, 0x42, 0x50, 0xe5,
	0x7c, 0xe1, 0xd7, 0x41, 0xb0, 0xa9, 0x49, 0xce, 0x34, 0xdb, 0x64, 0x4b, 0x6e, 0x5b, 0xde, 0xe5,
	0xbb, 0xb2, 0xaa, 0xc4, 0xef, 0xca, 0x50, 0xad, 0x32, 0x07, 0xc5, 0xc4, 0x6f, 0xc0, 0x8e, 0xa7,
	0xfb, 0xa1, 0x1d, 0xda, 0x2e, 0xd5, 0xa8, 0x3e, 0x23, 0x6b, 0xab, 0x6d, 0x3b, 0xb5, 0x7d, 0xaa,
	0xcf, 0x08, 0xee, 0x43, 0x25, 0x21, 0x92, 0x09, 0xe3, 0x5a, 0x69, 0x67, 0x9a, 0xe4, 0x10, 0x3c,
	0x22, 0x27, 0xdd, 0xdf, 0x11, 0xd4, 0x72, 0xb3, 0x82, 0x3f, 0x4a, 0x56, 0x6a, 0x5c, 0x69, 0x5d,
	0x7e, 0xf7, 0x9f, 0x85, 0xf8, 0xb6, 0x65, 0x87, 0x27, 0xf3, 0x69, 0xd7, 0x70, 0x67, 0xbd, 0x34,
	0x81, 0x39, 0xcd, 0xce, 0x3d, 0xef, 0xd4, 0xea, 0xb1, 0x93, 0x37, 0xed, 0x3e, 0x24, 0x51, 0xb2,
	0x82, 0x1f, 0x43, 0x95, 0x50, 0x53, 0x5b, 0xad, 0xe7, 0xe7, 0xc5, 0xaa, 0x10, 0x6a, 0x3e, 0x24,
	0x11, 0x7e, 0x2d, 0x1b, 0x7c, 0x46, 0x16, 0xeb, 0x79, 0xb5, 0x13, 0x57, 0xd3, 0xcc, 0xf8, 0xcc,
	0x7a, 0x93, 0xdb, 0x17, 0x7f, 0xb6, 0x0a, 0x17, 0xcb, 0x16, 0xfa, 0x75, 0xd9, 0x42, 0xbf, 0x2d,
	0x5b, 0xe8, 0x8f, 0x65, 0x0b, 0xfd, 0xf0, 0x57, 0xab, 0xf0, 0x94, 0xf3, 0xf0, 0x6f, 0x00, 0x00,
	0x00, 0xff, 0xff, 0xe6, 0x8d, 0x9a, 0x18, 0x13, 0x07, 0x00, 0x00,
}
