// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/engine/enginepb/mvcc3.proto

package enginepb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import bytes "bytes"

import encoding_binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// TxnMeta is the metadata of a Transaction record.
type TxnMeta struct {
	// id is a unique UUID value which identifies the transaction.
	// This field is always filled in.
	ID github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=id,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"id"`
	// key is the key which anchors the transaction. This is typically
	// the first key read or written during the transaction and
	// determines which range in the cluster will hold the transaction
	// record.
	Key []byte `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	// Incremented on txn retry.
	Epoch uint32 `protobuf:"varint,4,opt,name=epoch,proto3" json:"epoch,omitempty"`
	// The proposed timestamp for the transaction. This starts as the current wall
	// time on the txn coordinator, and is forwarded by the timestamp cache if the
	// txn attempts to write "beneath" another txn's writes.
	//
	// Writes within the txn are performed using the most up-to-date value of this
	// timestamp that is available. For example, suppose a txn starts at some
	// timestamp, writes a key/value, and has its timestamp forwarded while doing
	// so because a later version already exists at that key. As soon as the txn
	// coordinator learns of the updated timestamp, it will begin performing
	// writes at the updated timestamp. The coordinator may, however, continue
	// issuing writes at the original timestamp before it learns about the
	// forwarded timestamp. The process of resolving the intents when the txn
	// commits will bump any intents written at an older timestamp to the final
	// commit timestamp.
	//
	// Note that reads do not occur at this timestamp; they instead occur at
	// OrigTimestamp, which is tracked in the containing roachpb.Transaction.
	//
	// Writes used to be performed at the txn's original timestamp, which was
	// necessary to avoid lost update anomalies in snapshot isolation mode. We no
	// longer support snapshot isolation mode, and there are now several important
	// reasons that writes are performed at this timestamp instead of the txn's
	// original timestamp:
	//
	//    1. This timestamp is forwarded by the timestamp cache when this
	//       transaction attempts to write beneath a more recent read. Leaving the
	//       intent at the original timestamp would write beneath that read, which
	//       would violate an invariant that time-bound iterators rely on.
	//
	//       For example, consider a client that uses a time-bound iterator to
	//       poll for changes to a key. The client reads (ts5, ts10], sees no
	//       writes, and reports that no changes have occurred up to t10. Then a
	//       txn writes an intent at its original timestamp ts7. The txn's
	//       timestamp is forwarded to ts11 by the timestamp cache thanks to the
	//       client's read. Meanwhile, the client reads (ts10, ts15] and, again
	//       seeing no intents, reports that no changes have occurred to the key
	//       up to t15. Now the txn commits at ts11 and bumps the intent to ts11.
	//       But the client thinks it has seen all changes up to t15, and so never
	//       sees the intent! We avoid this problem by writing intents at the
	//       provisional commit timestamp insteadr. In this example, the intent
	//       would instead be written at ts11 and picked up by the client's next
	//       read from (ts10, ts15].
	//
	//    2. Unnecessary PushTxn roundtrips are avoided. If a transaction is
	//       forwarded from ts5 to ts10, the rest of its intents will be written
	//       at ts10. Reads at t < ts10 that encounter these intents can ignore
	//       them; if the intents had instead been left at ts5, these reads would
	//       have needed to send PushTxn requests just to find out that the txn
	//       had, in fact, been forwarded to a non-conflicting time.
	//
	//    3. Unnecessary intent rewriting is avoided. Writing at the original
	//       timestamp when this timestamp has been forwarded guarantees that the
	//       value will need to be rewritten at the forwarded timestamp if the
	//       transaction commits.
	//
	Timestamp hlc.Timestamp `protobuf:"bytes,5,opt,name=timestamp,proto3" json:"timestamp"`
	Priority  int32         `protobuf:"varint,6,opt,name=priority,proto3" json:"priority,omitempty"`
	// A one-indexed sequence number which is increased on each request
	// sent as part of the transaction. When set in the header of a batch
	// of requests, the value will correspond to the sequence number of the
	// last request. Used to prevent replay and out-of-order application
	// protection (by means of a transaction retry).
	Sequence             int32    `protobuf:"varint,7,opt,name=sequence,proto3" json:"sequence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TxnMeta) Reset()         { *m = TxnMeta{} }
func (m *TxnMeta) String() string { return proto.CompactTextString(m) }
func (*TxnMeta) ProtoMessage()    {}
func (*TxnMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_mvcc3_308ae238b1bf3852, []int{0}
}
func (m *TxnMeta) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TxnMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *TxnMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TxnMeta.Merge(dst, src)
}
func (m *TxnMeta) XXX_Size() int {
	return m.Size()
}
func (m *TxnMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_TxnMeta.DiscardUnknown(m)
}

var xxx_messageInfo_TxnMeta proto.InternalMessageInfo

// MVCCStatsDelta is convertible to MVCCStats, but uses signed variable width
// encodings for most fields that make it more efficient to store negative
// values. This makes the encodings incompatible.
type MVCCStatsDelta struct {
	// TODO(nvanbenschoten): now that we've split MVCCPersistentStats
	// from this MVCCStatsDelta type, we can turn contains_estimates
	// into a three-valued type ('UNCHANGED', 'NO', and 'YES').
	ContainsEstimates    bool     `protobuf:"varint,14,opt,name=contains_estimates,json=containsEstimates,proto3" json:"contains_estimates,omitempty"`
	LastUpdateNanos      int64    `protobuf:"fixed64,1,opt,name=last_update_nanos,json=lastUpdateNanos,proto3" json:"last_update_nanos,omitempty"`
	IntentAge            int64    `protobuf:"fixed64,2,opt,name=intent_age,json=intentAge,proto3" json:"intent_age,omitempty"`
	GCBytesAge           int64    `protobuf:"fixed64,3,opt,name=gc_bytes_age,json=gcBytesAge,proto3" json:"gc_bytes_age,omitempty"`
	LiveBytes            int64    `protobuf:"zigzag64,4,opt,name=live_bytes,json=liveBytes,proto3" json:"live_bytes,omitempty"`
	LiveCount            int64    `protobuf:"zigzag64,5,opt,name=live_count,json=liveCount,proto3" json:"live_count,omitempty"`
	KeyBytes             int64    `protobuf:"zigzag64,6,opt,name=key_bytes,json=keyBytes,proto3" json:"key_bytes,omitempty"`
	KeyCount             int64    `protobuf:"zigzag64,7,opt,name=key_count,json=keyCount,proto3" json:"key_count,omitempty"`
	ValBytes             int64    `protobuf:"zigzag64,8,opt,name=val_bytes,json=valBytes,proto3" json:"val_bytes,omitempty"`
	ValCount             int64    `protobuf:"zigzag64,9,opt,name=val_count,json=valCount,proto3" json:"val_count,omitempty"`
	IntentBytes          int64    `protobuf:"zigzag64,10,opt,name=intent_bytes,json=intentBytes,proto3" json:"intent_bytes,omitempty"`
	IntentCount          int64    `protobuf:"zigzag64,11,opt,name=intent_count,json=intentCount,proto3" json:"intent_count,omitempty"`
	SysBytes             int64    `protobuf:"zigzag64,12,opt,name=sys_bytes,json=sysBytes,proto3" json:"sys_bytes,omitempty"`
	SysCount             int64    `protobuf:"zigzag64,13,opt,name=sys_count,json=sysCount,proto3" json:"sys_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MVCCStatsDelta) Reset()         { *m = MVCCStatsDelta{} }
func (m *MVCCStatsDelta) String() string { return proto.CompactTextString(m) }
func (*MVCCStatsDelta) ProtoMessage()    {}
func (*MVCCStatsDelta) Descriptor() ([]byte, []int) {
	return fileDescriptor_mvcc3_308ae238b1bf3852, []int{1}
}
func (m *MVCCStatsDelta) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MVCCStatsDelta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MVCCStatsDelta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MVCCStatsDelta.Merge(dst, src)
}
func (m *MVCCStatsDelta) XXX_Size() int {
	return m.Size()
}
func (m *MVCCStatsDelta) XXX_DiscardUnknown() {
	xxx_messageInfo_MVCCStatsDelta.DiscardUnknown(m)
}

var xxx_messageInfo_MVCCStatsDelta proto.InternalMessageInfo

// MVCCPersistentStats is convertible to MVCCStats, but uses signed variable
// width encodings for most fields that make it efficient to store positive
// values but inefficient to store negative values. This makes the encodings
// incompatible.
type MVCCPersistentStats struct {
	ContainsEstimates    bool     `protobuf:"varint,14,opt,name=contains_estimates,json=containsEstimates,proto3" json:"contains_estimates,omitempty"`
	LastUpdateNanos      int64    `protobuf:"fixed64,1,opt,name=last_update_nanos,json=lastUpdateNanos,proto3" json:"last_update_nanos,omitempty"`
	IntentAge            int64    `protobuf:"fixed64,2,opt,name=intent_age,json=intentAge,proto3" json:"intent_age,omitempty"`
	GCBytesAge           int64    `protobuf:"fixed64,3,opt,name=gc_bytes_age,json=gcBytesAge,proto3" json:"gc_bytes_age,omitempty"`
	LiveBytes            int64    `protobuf:"varint,4,opt,name=live_bytes,json=liveBytes,proto3" json:"live_bytes,omitempty"`
	LiveCount            int64    `protobuf:"varint,5,opt,name=live_count,json=liveCount,proto3" json:"live_count,omitempty"`
	KeyBytes             int64    `protobuf:"varint,6,opt,name=key_bytes,json=keyBytes,proto3" json:"key_bytes,omitempty"`
	KeyCount             int64    `protobuf:"varint,7,opt,name=key_count,json=keyCount,proto3" json:"key_count,omitempty"`
	ValBytes             int64    `protobuf:"varint,8,opt,name=val_bytes,json=valBytes,proto3" json:"val_bytes,omitempty"`
	ValCount             int64    `protobuf:"varint,9,opt,name=val_count,json=valCount,proto3" json:"val_count,omitempty"`
	IntentBytes          int64    `protobuf:"varint,10,opt,name=intent_bytes,json=intentBytes,proto3" json:"intent_bytes,omitempty"`
	IntentCount          int64    `protobuf:"varint,11,opt,name=intent_count,json=intentCount,proto3" json:"intent_count,omitempty"`
	SysBytes             int64    `protobuf:"varint,12,opt,name=sys_bytes,json=sysBytes,proto3" json:"sys_bytes,omitempty"`
	SysCount             int64    `protobuf:"varint,13,opt,name=sys_count,json=sysCount,proto3" json:"sys_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MVCCPersistentStats) Reset()         { *m = MVCCPersistentStats{} }
func (m *MVCCPersistentStats) String() string { return proto.CompactTextString(m) }
func (*MVCCPersistentStats) ProtoMessage()    {}
func (*MVCCPersistentStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_mvcc3_308ae238b1bf3852, []int{2}
}
func (m *MVCCPersistentStats) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MVCCPersistentStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MVCCPersistentStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MVCCPersistentStats.Merge(dst, src)
}
func (m *MVCCPersistentStats) XXX_Size() int {
	return m.Size()
}
func (m *MVCCPersistentStats) XXX_DiscardUnknown() {
	xxx_messageInfo_MVCCPersistentStats.DiscardUnknown(m)
}

var xxx_messageInfo_MVCCPersistentStats proto.InternalMessageInfo

// RangeAppliedState combines the raft and lease applied indices with
// mvcc stats. These are all persisted on each transition of the Raft
// state machine (i.e. on each Raft application), so they are stored
// in the same RocksDB key for efficiency.
type RangeAppliedState struct {
	// raft_applied_index is the highest (and last) index applied to the Raft
	// state machine.
	RaftAppliedIndex uint64 `protobuf:"varint,1,opt,name=raft_applied_index,json=raftAppliedIndex,proto3" json:"raft_applied_index,omitempty"`
	// lease_applied_index is the highest (and last) lease index applied to the
	// Raft state machine.
	LeaseAppliedIndex uint64 `protobuf:"varint,2,opt,name=lease_applied_index,json=leaseAppliedIndex,proto3" json:"lease_applied_index,omitempty"`
	// range_stats is the set of mvcc stats that accounts for the current value
	// of the Raft state machine.
	RangeStats           MVCCPersistentStats `protobuf:"bytes,3,opt,name=range_stats,json=rangeStats,proto3" json:"range_stats"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *RangeAppliedState) Reset()         { *m = RangeAppliedState{} }
func (m *RangeAppliedState) String() string { return proto.CompactTextString(m) }
func (*RangeAppliedState) ProtoMessage()    {}
func (*RangeAppliedState) Descriptor() ([]byte, []int) {
	return fileDescriptor_mvcc3_308ae238b1bf3852, []int{3}
}
func (m *RangeAppliedState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RangeAppliedState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *RangeAppliedState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RangeAppliedState.Merge(dst, src)
}
func (m *RangeAppliedState) XXX_Size() int {
	return m.Size()
}
func (m *RangeAppliedState) XXX_DiscardUnknown() {
	xxx_messageInfo_RangeAppliedState.DiscardUnknown(m)
}

var xxx_messageInfo_RangeAppliedState proto.InternalMessageInfo

// MVCCWriteValueOp corresponds to a value being written outside of a
// transaction.
type MVCCWriteValueOp struct {
	Key                  []byte        `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Timestamp            hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp"`
	Value                []byte        `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *MVCCWriteValueOp) Reset()         { *m = MVCCWriteValueOp{} }
func (m *MVCCWriteValueOp) String() string { return proto.CompactTextString(m) }
func (*MVCCWriteValueOp) ProtoMessage()    {}
func (*MVCCWriteValueOp) Descriptor() ([]byte, []int) {
	return fileDescriptor_mvcc3_308ae238b1bf3852, []int{4}
}
func (m *MVCCWriteValueOp) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MVCCWriteValueOp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MVCCWriteValueOp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MVCCWriteValueOp.Merge(dst, src)
}
func (m *MVCCWriteValueOp) XXX_Size() int {
	return m.Size()
}
func (m *MVCCWriteValueOp) XXX_DiscardUnknown() {
	xxx_messageInfo_MVCCWriteValueOp.DiscardUnknown(m)
}

var xxx_messageInfo_MVCCWriteValueOp proto.InternalMessageInfo

// MVCCUpdateIntentOp corresponds to an intent being written for a given
// transaction.
type MVCCWriteIntentOp struct {
	TxnID                github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=txn_id,json=txnId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"txn_id"`
	TxnKey               []byte                                              `protobuf:"bytes,2,opt,name=txn_key,json=txnKey,proto3" json:"txn_key,omitempty"`
	Timestamp            hlc.Timestamp                                       `protobuf:"bytes,3,opt,name=timestamp,proto3" json:"timestamp"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *MVCCWriteIntentOp) Reset()         { *m = MVCCWriteIntentOp{} }
func (m *MVCCWriteIntentOp) String() string { return proto.CompactTextString(m) }
func (*MVCCWriteIntentOp) ProtoMessage()    {}
func (*MVCCWriteIntentOp) Descriptor() ([]byte, []int) {
	return fileDescriptor_mvcc3_308ae238b1bf3852, []int{5}
}
func (m *MVCCWriteIntentOp) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MVCCWriteIntentOp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MVCCWriteIntentOp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MVCCWriteIntentOp.Merge(dst, src)
}
func (m *MVCCWriteIntentOp) XXX_Size() int {
	return m.Size()
}
func (m *MVCCWriteIntentOp) XXX_DiscardUnknown() {
	xxx_messageInfo_MVCCWriteIntentOp.DiscardUnknown(m)
}

var xxx_messageInfo_MVCCWriteIntentOp proto.InternalMessageInfo

// MVCCUpdateIntentOp corresponds to an intent being updates at a larger
// timestamp for a given transaction.
type MVCCUpdateIntentOp struct {
	TxnID                github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=txn_id,json=txnId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"txn_id"`
	Timestamp            hlc.Timestamp                                       `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *MVCCUpdateIntentOp) Reset()         { *m = MVCCUpdateIntentOp{} }
func (m *MVCCUpdateIntentOp) String() string { return proto.CompactTextString(m) }
func (*MVCCUpdateIntentOp) ProtoMessage()    {}
func (*MVCCUpdateIntentOp) Descriptor() ([]byte, []int) {
	return fileDescriptor_mvcc3_308ae238b1bf3852, []int{6}
}
func (m *MVCCUpdateIntentOp) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MVCCUpdateIntentOp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MVCCUpdateIntentOp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MVCCUpdateIntentOp.Merge(dst, src)
}
func (m *MVCCUpdateIntentOp) XXX_Size() int {
	return m.Size()
}
func (m *MVCCUpdateIntentOp) XXX_DiscardUnknown() {
	xxx_messageInfo_MVCCUpdateIntentOp.DiscardUnknown(m)
}

var xxx_messageInfo_MVCCUpdateIntentOp proto.InternalMessageInfo

// MVCCCommitIntentOp corresponds to an intent being committed for a given
// transaction.
type MVCCCommitIntentOp struct {
	TxnID                github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=txn_id,json=txnId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"txn_id"`
	Key                  []byte                                              `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	Timestamp            hlc.Timestamp                                       `protobuf:"bytes,3,opt,name=timestamp,proto3" json:"timestamp"`
	Value                []byte                                              `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *MVCCCommitIntentOp) Reset()         { *m = MVCCCommitIntentOp{} }
func (m *MVCCCommitIntentOp) String() string { return proto.CompactTextString(m) }
func (*MVCCCommitIntentOp) ProtoMessage()    {}
func (*MVCCCommitIntentOp) Descriptor() ([]byte, []int) {
	return fileDescriptor_mvcc3_308ae238b1bf3852, []int{7}
}
func (m *MVCCCommitIntentOp) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MVCCCommitIntentOp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MVCCCommitIntentOp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MVCCCommitIntentOp.Merge(dst, src)
}
func (m *MVCCCommitIntentOp) XXX_Size() int {
	return m.Size()
}
func (m *MVCCCommitIntentOp) XXX_DiscardUnknown() {
	xxx_messageInfo_MVCCCommitIntentOp.DiscardUnknown(m)
}

var xxx_messageInfo_MVCCCommitIntentOp proto.InternalMessageInfo

// MVCCAbortIntentOp corresponds to an intent being aborted for a given
// transaction.
//
// This operation does not necessarily indicate that the intent's transaction
// was aborted, just that an intent was removed without being committed. For
// instance, a committed transaction will abort any intents it decided not to
// write in its final epoch.
type MVCCAbortIntentOp struct {
	TxnID                github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=txn_id,json=txnId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"txn_id"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *MVCCAbortIntentOp) Reset()         { *m = MVCCAbortIntentOp{} }
func (m *MVCCAbortIntentOp) String() string { return proto.CompactTextString(m) }
func (*MVCCAbortIntentOp) ProtoMessage()    {}
func (*MVCCAbortIntentOp) Descriptor() ([]byte, []int) {
	return fileDescriptor_mvcc3_308ae238b1bf3852, []int{8}
}
func (m *MVCCAbortIntentOp) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MVCCAbortIntentOp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MVCCAbortIntentOp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MVCCAbortIntentOp.Merge(dst, src)
}
func (m *MVCCAbortIntentOp) XXX_Size() int {
	return m.Size()
}
func (m *MVCCAbortIntentOp) XXX_DiscardUnknown() {
	xxx_messageInfo_MVCCAbortIntentOp.DiscardUnknown(m)
}

var xxx_messageInfo_MVCCAbortIntentOp proto.InternalMessageInfo

// MVCCAbortTxnOp corresponds to an entire transaction being aborted. The
// operation indicates that none of the transaction's intents will ever be
// committed.
type MVCCAbortTxnOp struct {
	TxnID                github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=txn_id,json=txnId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"txn_id"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *MVCCAbortTxnOp) Reset()         { *m = MVCCAbortTxnOp{} }
func (m *MVCCAbortTxnOp) String() string { return proto.CompactTextString(m) }
func (*MVCCAbortTxnOp) ProtoMessage()    {}
func (*MVCCAbortTxnOp) Descriptor() ([]byte, []int) {
	return fileDescriptor_mvcc3_308ae238b1bf3852, []int{9}
}
func (m *MVCCAbortTxnOp) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MVCCAbortTxnOp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MVCCAbortTxnOp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MVCCAbortTxnOp.Merge(dst, src)
}
func (m *MVCCAbortTxnOp) XXX_Size() int {
	return m.Size()
}
func (m *MVCCAbortTxnOp) XXX_DiscardUnknown() {
	xxx_messageInfo_MVCCAbortTxnOp.DiscardUnknown(m)
}

var xxx_messageInfo_MVCCAbortTxnOp proto.InternalMessageInfo

// MVCCLogicalOp is a union of all logical MVCC operation types.
type MVCCLogicalOp struct {
	WriteValue           *MVCCWriteValueOp   `protobuf:"bytes,1,opt,name=write_value,json=writeValue,proto3" json:"write_value,omitempty"`
	WriteIntent          *MVCCWriteIntentOp  `protobuf:"bytes,2,opt,name=write_intent,json=writeIntent,proto3" json:"write_intent,omitempty"`
	UpdateIntent         *MVCCUpdateIntentOp `protobuf:"bytes,3,opt,name=update_intent,json=updateIntent,proto3" json:"update_intent,omitempty"`
	CommitIntent         *MVCCCommitIntentOp `protobuf:"bytes,4,opt,name=commit_intent,json=commitIntent,proto3" json:"commit_intent,omitempty"`
	AbortIntent          *MVCCAbortIntentOp  `protobuf:"bytes,5,opt,name=abort_intent,json=abortIntent,proto3" json:"abort_intent,omitempty"`
	AbortTxn             *MVCCAbortTxnOp     `protobuf:"bytes,6,opt,name=abort_txn,json=abortTxn,proto3" json:"abort_txn,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *MVCCLogicalOp) Reset()         { *m = MVCCLogicalOp{} }
func (m *MVCCLogicalOp) String() string { return proto.CompactTextString(m) }
func (*MVCCLogicalOp) ProtoMessage()    {}
func (*MVCCLogicalOp) Descriptor() ([]byte, []int) {
	return fileDescriptor_mvcc3_308ae238b1bf3852, []int{10}
}
func (m *MVCCLogicalOp) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MVCCLogicalOp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MVCCLogicalOp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MVCCLogicalOp.Merge(dst, src)
}
func (m *MVCCLogicalOp) XXX_Size() int {
	return m.Size()
}
func (m *MVCCLogicalOp) XXX_DiscardUnknown() {
	xxx_messageInfo_MVCCLogicalOp.DiscardUnknown(m)
}

var xxx_messageInfo_MVCCLogicalOp proto.InternalMessageInfo

func init() {
	proto.RegisterType((*TxnMeta)(nil), "cockroach.storage.engine.enginepb.TxnMeta")
	proto.RegisterType((*MVCCStatsDelta)(nil), "cockroach.storage.engine.enginepb.MVCCStatsDelta")
	proto.RegisterType((*MVCCPersistentStats)(nil), "cockroach.storage.engine.enginepb.MVCCPersistentStats")
	proto.RegisterType((*RangeAppliedState)(nil), "cockroach.storage.engine.enginepb.RangeAppliedState")
	proto.RegisterType((*MVCCWriteValueOp)(nil), "cockroach.storage.engine.enginepb.MVCCWriteValueOp")
	proto.RegisterType((*MVCCWriteIntentOp)(nil), "cockroach.storage.engine.enginepb.MVCCWriteIntentOp")
	proto.RegisterType((*MVCCUpdateIntentOp)(nil), "cockroach.storage.engine.enginepb.MVCCUpdateIntentOp")
	proto.RegisterType((*MVCCCommitIntentOp)(nil), "cockroach.storage.engine.enginepb.MVCCCommitIntentOp")
	proto.RegisterType((*MVCCAbortIntentOp)(nil), "cockroach.storage.engine.enginepb.MVCCAbortIntentOp")
	proto.RegisterType((*MVCCAbortTxnOp)(nil), "cockroach.storage.engine.enginepb.MVCCAbortTxnOp")
	proto.RegisterType((*MVCCLogicalOp)(nil), "cockroach.storage.engine.enginepb.MVCCLogicalOp")
}
func (this *TxnMeta) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TxnMeta)
	if !ok {
		that2, ok := that.(TxnMeta)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ID.Equal(that1.ID) {
		return false
	}
	if !bytes.Equal(this.Key, that1.Key) {
		return false
	}
	if this.Epoch != that1.Epoch {
		return false
	}
	if !this.Timestamp.Equal(&that1.Timestamp) {
		return false
	}
	if this.Priority != that1.Priority {
		return false
	}
	if this.Sequence != that1.Sequence {
		return false
	}
	return true
}
func (this *MVCCStatsDelta) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MVCCStatsDelta)
	if !ok {
		that2, ok := that.(MVCCStatsDelta)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ContainsEstimates != that1.ContainsEstimates {
		return false
	}
	if this.LastUpdateNanos != that1.LastUpdateNanos {
		return false
	}
	if this.IntentAge != that1.IntentAge {
		return false
	}
	if this.GCBytesAge != that1.GCBytesAge {
		return false
	}
	if this.LiveBytes != that1.LiveBytes {
		return false
	}
	if this.LiveCount != that1.LiveCount {
		return false
	}
	if this.KeyBytes != that1.KeyBytes {
		return false
	}
	if this.KeyCount != that1.KeyCount {
		return false
	}
	if this.ValBytes != that1.ValBytes {
		return false
	}
	if this.ValCount != that1.ValCount {
		return false
	}
	if this.IntentBytes != that1.IntentBytes {
		return false
	}
	if this.IntentCount != that1.IntentCount {
		return false
	}
	if this.SysBytes != that1.SysBytes {
		return false
	}
	if this.SysCount != that1.SysCount {
		return false
	}
	return true
}
func (this *MVCCPersistentStats) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MVCCPersistentStats)
	if !ok {
		that2, ok := that.(MVCCPersistentStats)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ContainsEstimates != that1.ContainsEstimates {
		return false
	}
	if this.LastUpdateNanos != that1.LastUpdateNanos {
		return false
	}
	if this.IntentAge != that1.IntentAge {
		return false
	}
	if this.GCBytesAge != that1.GCBytesAge {
		return false
	}
	if this.LiveBytes != that1.LiveBytes {
		return false
	}
	if this.LiveCount != that1.LiveCount {
		return false
	}
	if this.KeyBytes != that1.KeyBytes {
		return false
	}
	if this.KeyCount != that1.KeyCount {
		return false
	}
	if this.ValBytes != that1.ValBytes {
		return false
	}
	if this.ValCount != that1.ValCount {
		return false
	}
	if this.IntentBytes != that1.IntentBytes {
		return false
	}
	if this.IntentCount != that1.IntentCount {
		return false
	}
	if this.SysBytes != that1.SysBytes {
		return false
	}
	if this.SysCount != that1.SysCount {
		return false
	}
	return true
}
func (this *RangeAppliedState) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RangeAppliedState)
	if !ok {
		that2, ok := that.(RangeAppliedState)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.RaftAppliedIndex != that1.RaftAppliedIndex {
		return false
	}
	if this.LeaseAppliedIndex != that1.LeaseAppliedIndex {
		return false
	}
	if !this.RangeStats.Equal(&that1.RangeStats) {
		return false
	}
	return true
}
func (m *TxnMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TxnMeta) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.ID.Size()))
	n1, err := m.ID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if len(m.Key) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if m.Epoch != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.Epoch))
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.Timestamp.Size()))
	n2, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if m.Priority != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.Priority))
	}
	if m.Sequence != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.Sequence))
	}
	return i, nil
}

func (m *MVCCStatsDelta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCStatsDelta) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LastUpdateNanos != 0 {
		dAtA[i] = 0x9
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.LastUpdateNanos))
		i += 8
	}
	if m.IntentAge != 0 {
		dAtA[i] = 0x11
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.IntentAge))
		i += 8
	}
	if m.GCBytesAge != 0 {
		dAtA[i] = 0x19
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.GCBytesAge))
		i += 8
	}
	if m.LiveBytes != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.LiveBytes)<<1)^uint64((m.LiveBytes>>63))))
	}
	if m.LiveCount != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.LiveCount)<<1)^uint64((m.LiveCount>>63))))
	}
	if m.KeyBytes != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.KeyBytes)<<1)^uint64((m.KeyBytes>>63))))
	}
	if m.KeyCount != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.KeyCount)<<1)^uint64((m.KeyCount>>63))))
	}
	if m.ValBytes != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.ValBytes)<<1)^uint64((m.ValBytes>>63))))
	}
	if m.ValCount != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.ValCount)<<1)^uint64((m.ValCount>>63))))
	}
	if m.IntentBytes != 0 {
		dAtA[i] = 0x50
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.IntentBytes)<<1)^uint64((m.IntentBytes>>63))))
	}
	if m.IntentCount != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.IntentCount)<<1)^uint64((m.IntentCount>>63))))
	}
	if m.SysBytes != 0 {
		dAtA[i] = 0x60
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.SysBytes)<<1)^uint64((m.SysBytes>>63))))
	}
	if m.SysCount != 0 {
		dAtA[i] = 0x68
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64((uint64(m.SysCount)<<1)^uint64((m.SysCount>>63))))
	}
	if m.ContainsEstimates {
		dAtA[i] = 0x70
		i++
		if m.ContainsEstimates {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *MVCCPersistentStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCPersistentStats) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LastUpdateNanos != 0 {
		dAtA[i] = 0x9
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.LastUpdateNanos))
		i += 8
	}
	if m.IntentAge != 0 {
		dAtA[i] = 0x11
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.IntentAge))
		i += 8
	}
	if m.GCBytesAge != 0 {
		dAtA[i] = 0x19
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.GCBytesAge))
		i += 8
	}
	if m.LiveBytes != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.LiveBytes))
	}
	if m.LiveCount != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.LiveCount))
	}
	if m.KeyBytes != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.KeyBytes))
	}
	if m.KeyCount != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.KeyCount))
	}
	if m.ValBytes != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.ValBytes))
	}
	if m.ValCount != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.ValCount))
	}
	if m.IntentBytes != 0 {
		dAtA[i] = 0x50
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.IntentBytes))
	}
	if m.IntentCount != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.IntentCount))
	}
	if m.SysBytes != 0 {
		dAtA[i] = 0x60
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.SysBytes))
	}
	if m.SysCount != 0 {
		dAtA[i] = 0x68
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.SysCount))
	}
	if m.ContainsEstimates {
		dAtA[i] = 0x70
		i++
		if m.ContainsEstimates {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RangeAppliedState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeAppliedState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RaftAppliedIndex != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.RaftAppliedIndex))
	}
	if m.LeaseAppliedIndex != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.LeaseAppliedIndex))
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.RangeStats.Size()))
	n3, err := m.RangeStats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	return i, nil
}

func (m *MVCCWriteValueOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCWriteValueOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.Timestamp.Size()))
	n4, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	if len(m.Value) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *MVCCWriteIntentOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCWriteIntentOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.TxnID.Size()))
	n5, err := m.TxnID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	if len(m.TxnKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(len(m.TxnKey)))
		i += copy(dAtA[i:], m.TxnKey)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.Timestamp.Size()))
	n6, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	return i, nil
}

func (m *MVCCUpdateIntentOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCUpdateIntentOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.TxnID.Size()))
	n7, err := m.TxnID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	dAtA[i] = 0x12
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.Timestamp.Size()))
	n8, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	return i, nil
}

func (m *MVCCCommitIntentOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCCommitIntentOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.TxnID.Size()))
	n9, err := m.TxnID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	if len(m.Key) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.Timestamp.Size()))
	n10, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	if len(m.Value) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *MVCCAbortIntentOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCAbortIntentOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.TxnID.Size()))
	n11, err := m.TxnID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	return i, nil
}

func (m *MVCCAbortTxnOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCAbortTxnOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMvcc3(dAtA, i, uint64(m.TxnID.Size()))
	n12, err := m.TxnID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	return i, nil
}

func (m *MVCCLogicalOp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCLogicalOp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.WriteValue != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.WriteValue.Size()))
		n13, err := m.WriteValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.WriteIntent != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.WriteIntent.Size()))
		n14, err := m.WriteIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.UpdateIntent != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.UpdateIntent.Size()))
		n15, err := m.UpdateIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.CommitIntent != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.CommitIntent.Size()))
		n16, err := m.CommitIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.AbortIntent != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.AbortIntent.Size()))
		n17, err := m.AbortIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.AbortTxn != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMvcc3(dAtA, i, uint64(m.AbortTxn.Size()))
		n18, err := m.AbortTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	return i, nil
}

func encodeVarintMvcc3(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedTxnMeta(r randyMvcc3, easy bool) *TxnMeta {
	this := &TxnMeta{}
	v1 := github_com_cockroachdb_cockroach_pkg_util_uuid.NewPopulatedUUID(r)
	this.ID = *v1
	v2 := r.Intn(100)
	this.Key = make([]byte, v2)
	for i := 0; i < v2; i++ {
		this.Key[i] = byte(r.Intn(256))
	}
	this.Epoch = uint32(r.Uint32())
	v3 := hlc.NewPopulatedTimestamp(r, easy)
	this.Timestamp = *v3
	this.Priority = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.Priority *= -1
	}
	this.Sequence = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.Sequence *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedMVCCPersistentStats(r randyMvcc3, easy bool) *MVCCPersistentStats {
	this := &MVCCPersistentStats{}
	this.LastUpdateNanos = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.LastUpdateNanos *= -1
	}
	this.IntentAge = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.IntentAge *= -1
	}
	this.GCBytesAge = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.GCBytesAge *= -1
	}
	this.LiveBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.LiveBytes *= -1
	}
	this.LiveCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.LiveCount *= -1
	}
	this.KeyBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.KeyBytes *= -1
	}
	this.KeyCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.KeyCount *= -1
	}
	this.ValBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.ValBytes *= -1
	}
	this.ValCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.ValCount *= -1
	}
	this.IntentBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.IntentBytes *= -1
	}
	this.IntentCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.IntentCount *= -1
	}
	this.SysBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.SysBytes *= -1
	}
	this.SysCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.SysCount *= -1
	}
	this.ContainsEstimates = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedRangeAppliedState(r randyMvcc3, easy bool) *RangeAppliedState {
	this := &RangeAppliedState{}
	this.RaftAppliedIndex = uint64(uint64(r.Uint32()))
	this.LeaseAppliedIndex = uint64(uint64(r.Uint32()))
	v4 := NewPopulatedMVCCPersistentStats(r, easy)
	this.RangeStats = *v4
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyMvcc3 interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneMvcc3(r randyMvcc3) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringMvcc3(r randyMvcc3) string {
	v5 := r.Intn(100)
	tmps := make([]rune, v5)
	for i := 0; i < v5; i++ {
		tmps[i] = randUTF8RuneMvcc3(r)
	}
	return string(tmps)
}
func randUnrecognizedMvcc3(r randyMvcc3, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldMvcc3(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldMvcc3(dAtA []byte, r randyMvcc3, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateMvcc3(dAtA, uint64(key))
		v6 := r.Int63()
		if r.Intn(2) == 0 {
			v6 *= -1
		}
		dAtA = encodeVarintPopulateMvcc3(dAtA, uint64(v6))
	case 1:
		dAtA = encodeVarintPopulateMvcc3(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateMvcc3(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateMvcc3(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateMvcc3(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateMvcc3(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *TxnMeta) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ID.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovMvcc3(uint64(l))
	}
	if m.Epoch != 0 {
		n += 1 + sovMvcc3(uint64(m.Epoch))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	if m.Priority != 0 {
		n += 1 + sovMvcc3(uint64(m.Priority))
	}
	if m.Sequence != 0 {
		n += 1 + sovMvcc3(uint64(m.Sequence))
	}
	return n
}

func (m *MVCCStatsDelta) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LastUpdateNanos != 0 {
		n += 9
	}
	if m.IntentAge != 0 {
		n += 9
	}
	if m.GCBytesAge != 0 {
		n += 9
	}
	if m.LiveBytes != 0 {
		n += 1 + sozMvcc3(uint64(m.LiveBytes))
	}
	if m.LiveCount != 0 {
		n += 1 + sozMvcc3(uint64(m.LiveCount))
	}
	if m.KeyBytes != 0 {
		n += 1 + sozMvcc3(uint64(m.KeyBytes))
	}
	if m.KeyCount != 0 {
		n += 1 + sozMvcc3(uint64(m.KeyCount))
	}
	if m.ValBytes != 0 {
		n += 1 + sozMvcc3(uint64(m.ValBytes))
	}
	if m.ValCount != 0 {
		n += 1 + sozMvcc3(uint64(m.ValCount))
	}
	if m.IntentBytes != 0 {
		n += 1 + sozMvcc3(uint64(m.IntentBytes))
	}
	if m.IntentCount != 0 {
		n += 1 + sozMvcc3(uint64(m.IntentCount))
	}
	if m.SysBytes != 0 {
		n += 1 + sozMvcc3(uint64(m.SysBytes))
	}
	if m.SysCount != 0 {
		n += 1 + sozMvcc3(uint64(m.SysCount))
	}
	if m.ContainsEstimates {
		n += 2
	}
	return n
}

func (m *MVCCPersistentStats) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LastUpdateNanos != 0 {
		n += 9
	}
	if m.IntentAge != 0 {
		n += 9
	}
	if m.GCBytesAge != 0 {
		n += 9
	}
	if m.LiveBytes != 0 {
		n += 1 + sovMvcc3(uint64(m.LiveBytes))
	}
	if m.LiveCount != 0 {
		n += 1 + sovMvcc3(uint64(m.LiveCount))
	}
	if m.KeyBytes != 0 {
		n += 1 + sovMvcc3(uint64(m.KeyBytes))
	}
	if m.KeyCount != 0 {
		n += 1 + sovMvcc3(uint64(m.KeyCount))
	}
	if m.ValBytes != 0 {
		n += 1 + sovMvcc3(uint64(m.ValBytes))
	}
	if m.ValCount != 0 {
		n += 1 + sovMvcc3(uint64(m.ValCount))
	}
	if m.IntentBytes != 0 {
		n += 1 + sovMvcc3(uint64(m.IntentBytes))
	}
	if m.IntentCount != 0 {
		n += 1 + sovMvcc3(uint64(m.IntentCount))
	}
	if m.SysBytes != 0 {
		n += 1 + sovMvcc3(uint64(m.SysBytes))
	}
	if m.SysCount != 0 {
		n += 1 + sovMvcc3(uint64(m.SysCount))
	}
	if m.ContainsEstimates {
		n += 2
	}
	return n
}

func (m *RangeAppliedState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.RaftAppliedIndex != 0 {
		n += 1 + sovMvcc3(uint64(m.RaftAppliedIndex))
	}
	if m.LeaseAppliedIndex != 0 {
		n += 1 + sovMvcc3(uint64(m.LeaseAppliedIndex))
	}
	l = m.RangeStats.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	return n
}

func (m *MVCCWriteValueOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovMvcc3(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovMvcc3(uint64(l))
	}
	return n
}

func (m *MVCCWriteIntentOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.TxnID.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	l = len(m.TxnKey)
	if l > 0 {
		n += 1 + l + sovMvcc3(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	return n
}

func (m *MVCCUpdateIntentOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.TxnID.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	l = m.Timestamp.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	return n
}

func (m *MVCCCommitIntentOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.TxnID.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovMvcc3(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovMvcc3(uint64(l))
	}
	return n
}

func (m *MVCCAbortIntentOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.TxnID.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	return n
}

func (m *MVCCAbortTxnOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.TxnID.Size()
	n += 1 + l + sovMvcc3(uint64(l))
	return n
}

func (m *MVCCLogicalOp) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.WriteValue != nil {
		l = m.WriteValue.Size()
		n += 1 + l + sovMvcc3(uint64(l))
	}
	if m.WriteIntent != nil {
		l = m.WriteIntent.Size()
		n += 1 + l + sovMvcc3(uint64(l))
	}
	if m.UpdateIntent != nil {
		l = m.UpdateIntent.Size()
		n += 1 + l + sovMvcc3(uint64(l))
	}
	if m.CommitIntent != nil {
		l = m.CommitIntent.Size()
		n += 1 + l + sovMvcc3(uint64(l))
	}
	if m.AbortIntent != nil {
		l = m.AbortIntent.Size()
		n += 1 + l + sovMvcc3(uint64(l))
	}
	if m.AbortTxn != nil {
		l = m.AbortTxn.Size()
		n += 1 + l + sovMvcc3(uint64(l))
	}
	return n
}

func sovMvcc3(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMvcc3(x uint64) (n int) {
	return sovMvcc3(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *MVCCLogicalOp) GetValue() interface{} {
	if this.WriteValue != nil {
		return this.WriteValue
	}
	if this.WriteIntent != nil {
		return this.WriteIntent
	}
	if this.UpdateIntent != nil {
		return this.UpdateIntent
	}
	if this.CommitIntent != nil {
		return this.CommitIntent
	}
	if this.AbortIntent != nil {
		return this.AbortIntent
	}
	if this.AbortTxn != nil {
		return this.AbortTxn
	}
	return nil
}

func (this *MVCCLogicalOp) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *MVCCWriteValueOp:
		this.WriteValue = vt
	case *MVCCWriteIntentOp:
		this.WriteIntent = vt
	case *MVCCUpdateIntentOp:
		this.UpdateIntent = vt
	case *MVCCCommitIntentOp:
		this.CommitIntent = vt
	case *MVCCAbortIntentOp:
		this.AbortIntent = vt
	case *MVCCAbortTxnOp:
		this.AbortTxn = vt
	default:
		return false
	}
	return true
}
func (m *TxnMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxnMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxnMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Epoch", wireType)
			}
			m.Epoch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Epoch |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCStatsDelta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCStatsDelta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCStatsDelta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdateNanos", wireType)
			}
			m.LastUpdateNanos = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.LastUpdateNanos = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentAge", wireType)
			}
			m.IntentAge = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentAge = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field GCBytesAge", wireType)
			}
			m.GCBytesAge = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.GCBytesAge = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LiveBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.LiveBytes = int64(v)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LiveCount", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.LiveCount = int64(v)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.KeyBytes = int64(v)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyCount", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.KeyCount = int64(v)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.ValBytes = int64(v)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValCount", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.ValCount = int64(v)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.IntentBytes = int64(v)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentCount", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.IntentCount = int64(v)
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SysBytes", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.SysBytes = int64(v)
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SysCount", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = (v >> 1) ^ uint64((int64(v&1)<<63)>>63)
			m.SysCount = int64(v)
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainsEstimates", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ContainsEstimates = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCPersistentStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCPersistentStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCPersistentStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdateNanos", wireType)
			}
			m.LastUpdateNanos = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.LastUpdateNanos = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentAge", wireType)
			}
			m.IntentAge = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentAge = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field GCBytesAge", wireType)
			}
			m.GCBytesAge = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.GCBytesAge = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LiveBytes", wireType)
			}
			m.LiveBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LiveBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LiveCount", wireType)
			}
			m.LiveCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LiveCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyBytes", wireType)
			}
			m.KeyBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeyBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyCount", wireType)
			}
			m.KeyCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeyCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValBytes", wireType)
			}
			m.ValBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValCount", wireType)
			}
			m.ValCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentBytes", wireType)
			}
			m.IntentBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IntentBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentCount", wireType)
			}
			m.IntentCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IntentCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SysBytes", wireType)
			}
			m.SysBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SysBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SysCount", wireType)
			}
			m.SysCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SysCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainsEstimates", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ContainsEstimates = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeAppliedState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeAppliedState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeAppliedState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftAppliedIndex", wireType)
			}
			m.RaftAppliedIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RaftAppliedIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseAppliedIndex", wireType)
			}
			m.LeaseAppliedIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LeaseAppliedIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RangeStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCWriteValueOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCWriteValueOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCWriteValueOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCWriteIntentOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCWriteIntentOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCWriteIntentOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TxnKey = append(m.TxnKey[:0], dAtA[iNdEx:postIndex]...)
			if m.TxnKey == nil {
				m.TxnKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCUpdateIntentOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCUpdateIntentOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCUpdateIntentOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCCommitIntentOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCCommitIntentOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCCommitIntentOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCAbortIntentOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCAbortIntentOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCAbortIntentOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCAbortTxnOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCAbortTxnOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCAbortTxnOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCLogicalOp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCLogicalOp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCLogicalOp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WriteValue == nil {
				m.WriteValue = &MVCCWriteValueOp{}
			}
			if err := m.WriteValue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WriteIntent == nil {
				m.WriteIntent = &MVCCWriteIntentOp{}
			}
			if err := m.WriteIntent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdateIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpdateIntent == nil {
				m.UpdateIntent = &MVCCUpdateIntentOp{}
			}
			if err := m.UpdateIntent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommitIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommitIntent == nil {
				m.CommitIntent = &MVCCCommitIntentOp{}
			}
			if err := m.CommitIntent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AbortIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AbortIntent == nil {
				m.AbortIntent = &MVCCAbortIntentOp{}
			}
			if err := m.AbortIntent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AbortTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc3
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AbortTxn == nil {
				m.AbortTxn = &MVCCAbortTxnOp{}
			}
			if err := m.AbortTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc3(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc3
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMvcc3(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMvcc3
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMvcc3
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthMvcc3
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMvcc3
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMvcc3(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMvcc3 = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMvcc3   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("storage/engine/enginepb/mvcc3.proto", fileDescriptor_mvcc3_308ae238b1bf3852)
}

var fileDescriptor_mvcc3_308ae238b1bf3852 = []byte{
	// 1023 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x56, 0xcd, 0x6e, 0x23, 0x45,
	0x10, 0xce, 0xfc, 0x38, 0xb1, 0xdb, 0x4e, 0xb0, 0x7b, 0x23, 0x61, 0x05, 0xad, 0xed, 0x35, 0x17,
	0x0b, 0xc1, 0x18, 0x12, 0xe0, 0x90, 0x9b, 0x7f, 0x10, 0xf2, 0xc2, 0x6e, 0x60, 0x70, 0x76, 0x25,
	0x10, 0x1a, 0xb5, 0xc7, 0xcd, 0xb8, 0xe5, 0x71, 0xcf, 0x30, 0xd3, 0xe3, 0xb5, 0x0f, 0xbc, 0x03,
	0x17, 0xee, 0xb9, 0xf0, 0x06, 0x1c, 0x78, 0x84, 0x1c, 0x38, 0x70, 0x44, 0x2b, 0x14, 0x81, 0xb9,
	0xf0, 0x00, 0x5c, 0x91, 0x50, 0x77, 0xcf, 0x8c, 0xed, 0x15, 0x38, 0x7f, 0x22, 0xda, 0x93, 0xbb,
	0xeb, 0xab, 0xfa, 0xaa, 0xbb, 0xbe, 0x9a, 0x6a, 0x83, 0xd7, 0x43, 0xe6, 0x05, 0xc8, 0xc1, 0x4d,
	0x4c, 0x1d, 0x42, 0x93, 0x1f, 0x7f, 0xd0, 0x9c, 0x4c, 0x6d, 0xfb, 0xc8, 0xf0, 0x03, 0x8f, 0x79,
	0xf0, 0x81, 0xed, 0xd9, 0xe3, 0xc0, 0x43, 0xf6, 0xc8, 0x88, 0xdd, 0x0d, 0xe9, 0x67, 0x24, 0xee,
	0x07, 0xe5, 0x88, 0x11, 0xb7, 0x39, 0x72, 0xed, 0x26, 0x23, 0x13, 0x1c, 0x32, 0x34, 0xf1, 0x65,
	0xf0, 0xc1, 0xbe, 0xe3, 0x39, 0x9e, 0x58, 0x36, 0xf9, 0x4a, 0x5a, 0xeb, 0xdf, 0xa9, 0x60, 0xa7,
	0x3f, 0xa3, 0x8f, 0x30, 0x43, 0xf0, 0x53, 0xa0, 0x92, 0x61, 0x59, 0xa9, 0x29, 0x8d, 0x42, 0xbb,
	0x75, 0x7e, 0x51, 0xdd, 0x7a, 0x7e, 0x51, 0x3d, 0x72, 0x08, 0x1b, 0x45, 0x03, 0xc3, 0xf6, 0x26,
	0xcd, 0x34, 0xfb, 0x70, 0xb0, 0x5c, 0x37, 0xfd, 0xb1, 0xd3, 0x14, 0x49, 0xa3, 0x88, 0x0c, 0x8d,
	0xd3, 0xd3, 0x5e, 0x77, 0x71, 0x51, 0x55, 0x7b, 0x5d, 0x53, 0x25, 0x43, 0x58, 0x04, 0xda, 0x18,
	0xcf, 0xcb, 0x1a, 0xe7, 0x34, 0xf9, 0x12, 0xee, 0x83, 0x0c, 0xf6, 0x3d, 0x7b, 0x54, 0xd6, 0x6b,
	0x4a, 0x63, 0xd7, 0x94, 0x1b, 0xd8, 0x02, 0xb9, 0xf4, 0xbc, 0xe5, 0x4c, 0x4d, 0x69, 0xe4, 0x0f,
	0xef, 0x1b, 0xcb, 0xdb, 0x72, 0x7e, 0x63, 0xe4, 0xda, 0x46, 0x3f, 0x71, 0x6a, 0xeb, 0xfc, 0x80,
	0xe6, 0x32, 0x0a, 0x1e, 0x80, 0xac, 0x1f, 0x10, 0x2f, 0x20, 0x6c, 0x5e, 0xde, 0xae, 0x29, 0x8d,
	0x8c, 0x99, 0xee, 0x39, 0x16, 0xe2, 0xaf, 0x23, 0x4c, 0x6d, 0x5c, 0xde, 0x91, 0x58, 0xb2, 0x3f,
	0xce, 0xfe, 0x78, 0x56, 0x55, 0xfe, 0x3c, 0xab, 0x2a, 0x0f, 0xf5, 0xac, 0x5a, 0xd4, 0x1e, 0xea,
	0xd9, 0x6c, 0x31, 0x57, 0xff, 0x4b, 0x03, 0x7b, 0x8f, 0x9e, 0x74, 0x3a, 0x9f, 0x31, 0xc4, 0xc2,
	0x2e, 0x76, 0x19, 0x82, 0x6f, 0x80, 0x92, 0x8b, 0x42, 0x66, 0x45, 0xfe, 0x10, 0x31, 0x6c, 0x51,
	0x44, 0xbd, 0x50, 0x54, 0xab, 0x68, 0xbe, 0xc2, 0x81, 0x53, 0x61, 0x7f, 0xcc, 0xcd, 0xf0, 0x3e,
	0x00, 0x84, 0x32, 0x4c, 0x99, 0x85, 0x1c, 0x5c, 0x56, 0x85, 0x53, 0x4e, 0x5a, 0x5a, 0x0e, 0x86,
	0x6f, 0x83, 0x82, 0x63, 0x5b, 0x83, 0x39, 0xc3, 0xa1, 0x70, 0xe0, 0xf5, 0x29, 0xb6, 0xf7, 0x16,
	0x17, 0x55, 0xf0, 0x61, 0xa7, 0xcd, 0xcd, 0x2d, 0x07, 0x9b, 0xc0, 0xb1, 0x93, 0x35, 0x27, 0x74,
	0xc9, 0x14, 0xcb, 0x18, 0x51, 0x3b, 0x68, 0xe6, 0xb8, 0x45, 0x78, 0xa4, 0xb0, 0xed, 0x45, 0x94,
	0x89, 0x02, 0xc6, 0x70, 0x87, 0x1b, 0xe0, 0x6b, 0x20, 0x37, 0xc6, 0xf3, 0x38, 0x78, 0x5b, 0xa0,
	0xd9, 0x31, 0x9e, 0xcb, 0xd8, 0x18, 0x94, 0xa1, 0x3b, 0x29, 0x98, 0x46, 0x4e, 0x91, 0x1b, 0x47,
	0x66, 0x25, 0x38, 0x45, 0x6e, 0x1a, 0xc9, 0x41, 0x19, 0x99, 0x4b, 0x41, 0x19, 0xf9, 0x00, 0x14,
	0xe2, 0x12, 0xc8, 0x60, 0x20, 0xf0, 0xbc, 0xb4, 0xc9, 0xf8, 0xa5, 0x8b, 0xa4, 0xc8, 0xaf, 0xba,
	0xa4, 0xf9, 0xc3, 0x79, 0x18, 0x53, 0x14, 0x64, 0x8a, 0x70, 0x1e, 0xa6, 0xf9, 0x39, 0x28, 0x83,
	0x77, 0x53, 0x50, 0x46, 0xbe, 0x05, 0xa0, 0xed, 0x51, 0x86, 0x08, 0x0d, 0x2d, 0x1c, 0x32, 0x32,
	0x41, 0x9c, 0x62, 0xaf, 0xa6, 0x34, 0xb2, 0x66, 0x29, 0x41, 0x3e, 0x48, 0x80, 0x63, 0x9d, 0xb7,
	0x40, 0xfd, 0x6f, 0x0d, 0xdc, 0xe3, 0xb2, 0x7f, 0x82, 0x83, 0x90, 0x84, 0xfc, 0x18, 0xa2, 0x01,
	0x5e, 0x36, 0xed, 0xb5, 0xcd, 0xda, 0x6b, 0x1b, 0xb5, 0xd7, 0x36, 0x69, 0xaf, 0x6d, 0xd2, 0x5e,
	0xdb, 0xa4, 0xbd, 0x76, 0x89, 0xf6, 0xda, 0xe5, 0xda, 0x6b, 0x97, 0x68, 0xaf, 0x6d, 0xd2, 0x5e,
	0xbb, 0xb9, 0xf6, 0xe9, 0x08, 0xa8, 0x3f, 0x57, 0x40, 0xc9, 0x44, 0xd4, 0xc1, 0x2d, 0xdf, 0x77,
	0x09, 0x1e, 0x72, 0xf5, 0x31, 0x7c, 0x13, 0xc0, 0x00, 0x7d, 0xc5, 0x2c, 0x24, 0x8d, 0x16, 0xa1,
	0x43, 0x3c, 0x13, 0xf2, 0xeb, 0x66, 0x91, 0x23, 0xb1, 0x77, 0x8f, 0xdb, 0xa1, 0x01, 0xee, 0xb9,
	0x18, 0x85, 0xf8, 0x05, 0x77, 0x55, 0xb8, 0x97, 0x04, 0xb4, 0xe6, 0xff, 0x25, 0xc8, 0x07, 0x3c,
	0xa5, 0x15, 0xf2, 0x56, 0x13, 0xfd, 0x90, 0x3f, 0x7c, 0xdf, 0xb8, 0x74, 0xd6, 0x1b, 0xff, 0xd2,
	0xa8, 0xf1, 0x58, 0x04, 0x82, 0x50, 0x58, 0x56, 0x2e, 0xf7, 0x0d, 0x28, 0xf2, 0x90, 0xa7, 0x01,
	0x61, 0xf8, 0x09, 0x72, 0x23, 0x7c, 0xe2, 0x27, 0x03, 0x5a, 0x59, 0x0e, 0xe8, 0xb5, 0x51, 0xac,
	0xde, 0x68, 0x14, 0xef, 0x83, 0xcc, 0x94, 0xf3, 0xc7, 0x73, 0x5f, 0x6e, 0xea, 0x3f, 0x29, 0xa0,
	0x94, 0xe6, 0xef, 0x09, 0x9d, 0x4f, 0x7c, 0xf8, 0x05, 0xd8, 0x66, 0x33, 0x6a, 0xa5, 0x0f, 0x4f,
	0xf7, 0x76, 0x0f, 0x4f, 0xa6, 0x3f, 0xa3, 0xbd, 0xae, 0x99, 0x61, 0x33, 0xda, 0x1b, 0xc2, 0x57,
	0xc1, 0x0e, 0x27, 0xe7, 0x37, 0x54, 0xc5, 0x51, 0x78, 0xae, 0x8f, 0x5e, 0xbc, 0xa4, 0x76, 0x93,
	0x4b, 0xd6, 0x7f, 0x50, 0x00, 0xe4, 0xd7, 0x91, 0x9f, 0xfe, 0xdd, 0xdc, 0xe7, 0xf6, 0xda, 0xd4,
	0x7f, 0x8d, 0x8f, 0xdd, 0xf1, 0x26, 0x13, 0xc2, 0xee, 0xe6, 0xd8, 0x71, 0x93, 0xa9, 0xff, 0xd1,
	0x64, 0xda, 0xed, 0x9a, 0x4c, 0x5f, 0x6d, 0x32, 0x5f, 0xf6, 0x58, 0x6b, 0xe0, 0x05, 0x77, 0x73,
	0xb9, 0xfa, 0x44, 0xfe, 0x51, 0x10, 0x19, 0xfb, 0x33, 0xfa, 0x7f, 0xa7, 0xfb, 0x5e, 0x07, 0xbb,
	0x3c, 0xdf, 0xc7, 0x9e, 0x43, 0x6c, 0xe4, 0x9e, 0xf8, 0xb0, 0x0f, 0xf2, 0xcf, 0xf8, 0x27, 0x65,
	0xc9, 0x72, 0x28, 0xa2, 0x9a, 0x47, 0x57, 0x9c, 0x1f, 0xab, 0xc3, 0xc0, 0x04, 0xcf, 0xd2, 0x1d,
	0x7c, 0x0a, 0x0a, 0x92, 0x55, 0x4e, 0xe4, 0xb8, 0xdb, 0xde, 0xbd, 0x0e, 0x6d, 0x52, 0x7f, 0x53,
	0x9e, 0x4f, 0x6e, 0xe1, 0xe7, 0x60, 0x37, 0x7e, 0x45, 0x63, 0x66, 0x29, 0xff, 0x7b, 0x57, 0x64,
	0x5e, 0xff, 0xdc, 0xcc, 0x42, 0xb4, 0xb2, 0xe7, 0xdc, 0xb6, 0xe8, 0xeb, 0x84, 0x5b, 0xbf, 0x16,
	0xf7, 0xfa, 0x37, 0x61, 0x16, 0xec, 0x95, 0x3d, 0x2f, 0x08, 0xe2, 0x1a, 0x27, 0xd4, 0x99, 0x6b,
	0x15, 0x64, 0xad, 0x21, 0xcd, 0x3c, 0x5a, 0x6e, 0xe1, 0x63, 0x90, 0x93, 0xc4, 0x6c, 0x46, 0xc5,
	0x03, 0x9d, 0x3f, 0x7c, 0xe7, 0x3a, 0xac, 0xa2, 0xe9, 0xcc, 0x2c, 0x8a, 0xd7, 0xc7, 0xfa, 0xf9,
	0x59, 0x55, 0x69, 0x97, 0xcf, 0x7f, 0xaf, 0x6c, 0x9d, 0x2f, 0x2a, 0xca, 0xcf, 0x8b, 0x8a, 0xf2,
	0xcb, 0xa2, 0xa2, 0xfc, 0xb6, 0xa8, 0x28, 0xdf, 0xfe, 0x51, 0xd9, 0x1a, 0x6c, 0x8b, 0x7f, 0xfe,
	0x47, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0x58, 0x6f, 0xd1, 0x58, 0x73, 0x0c, 0x00, 0x00,
}
