// Package edgeorder implements the Azure ARM Edgeorder service API version 2020-12-01-preview.
//
// Edge Order API's
package edgeorder

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

const (
	// DefaultBaseURI is the default URI used for the service Edgeorder
	DefaultBaseURI = "https://management.azure.com"
)

// BaseClient is the base client for Edgeorder.
type BaseClient struct {
	autorest.Client
	BaseURI        string
	SubscriptionID string
}

// New creates an instance of the BaseClient client.
func New(subscriptionID string) BaseClient {
	return NewWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewWithBaseURI creates an instance of the BaseClient client using a custom endpoint.  Use this when interacting with
// an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return BaseClient{
		Client:         autorest.NewClientWithUserAgent(UserAgent()),
		BaseURI:        baseURI,
		SubscriptionID: subscriptionID,
	}
}

// CancelOrderItem cancel order item.
// Parameters:
// orderItemName - the name of the order item
// resourceGroupName - the name of the resource group. The name is case insensitive.
// cancellationReason - reason for cancellation.
func (client BaseClient) CancelOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, cancellationReason CancellationReason) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.CancelOrderItem")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: cancellationReason,
			Constraints: []validation.Constraint{{Target: "cancellationReason.Reason", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "CancelOrderItem", err.Error())
	}

	req, err := client.CancelOrderItemPreparer(ctx, orderItemName, resourceGroupName, cancellationReason)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "CancelOrderItem", nil, "Failure preparing request")
		return
	}

	resp, err := client.CancelOrderItemSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "CancelOrderItem", resp, "Failure sending request")
		return
	}

	result, err = client.CancelOrderItemResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "CancelOrderItem", resp, "Failure responding to request")
		return
	}

	return
}

// CancelOrderItemPreparer prepares the CancelOrderItem request.
func (client BaseClient) CancelOrderItemPreparer(ctx context.Context, orderItemName string, resourceGroupName string, cancellationReason CancellationReason) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"orderItemName":     autorest.Encode("path", orderItemName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}/cancel", pathParameters),
		autorest.WithJSON(cancellationReason),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CancelOrderItemSender sends the CancelOrderItem request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) CancelOrderItemSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CancelOrderItemResponder handles the response to the CancelOrderItem request. The method always
// closes the http.Response Body.
func (client BaseClient) CancelOrderItemResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// CreateAddress creates a new address with the specified parameters. Existing address cannot be updated with this API
// and should instead be updated with the Update address API.
// Parameters:
// addressName - the name of the address Resource within the specified resource group. address names must be
// between 3 and 24 characters in length and use any alphanumeric and underscore only
// resourceGroupName - the name of the resource group. The name is case insensitive.
// addressResource - address details from request body.
func (client BaseClient) CreateAddress(ctx context.Context, addressName string, resourceGroupName string, addressResource AddressResource) (result CreateAddressFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.CreateAddress")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: addressName,
			Constraints: []validation.Constraint{{Target: "addressName", Name: validation.MaxLength, Rule: 24, Chain: nil},
				{Target: "addressName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "addressName", Name: validation.Pattern, Rule: `^[-\w\.]+$`, Chain: nil}}},
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: addressResource,
			Constraints: []validation.Constraint{{Target: "addressResource.AddressProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "addressResource.AddressProperties.ShippingAddress", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "addressResource.AddressProperties.ShippingAddress.StreetAddress1", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "addressResource.AddressProperties.ShippingAddress.Country", Name: validation.Null, Rule: true, Chain: nil},
					}},
					{Target: "addressResource.AddressProperties.ContactDetails", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "addressResource.AddressProperties.ContactDetails.ContactName", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "addressResource.AddressProperties.ContactDetails.Phone", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "addressResource.AddressProperties.ContactDetails.EmailList", Name: validation.Null, Rule: true, Chain: nil},
						}},
				}}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "CreateAddress", err.Error())
	}

	req, err := client.CreateAddressPreparer(ctx, addressName, resourceGroupName, addressResource)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "CreateAddress", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateAddressSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "CreateAddress", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateAddressPreparer prepares the CreateAddress request.
func (client BaseClient) CreateAddressPreparer(ctx context.Context, addressName string, resourceGroupName string, addressResource AddressResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"addressName":       autorest.Encode("path", addressName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	addressResource.SystemData = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}", pathParameters),
		autorest.WithJSON(addressResource),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateAddressSender sends the CreateAddress request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) CreateAddressSender(req *http.Request) (future CreateAddressFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateAddressResponder handles the response to the CreateAddress request. The method always
// closes the http.Response Body.
func (client BaseClient) CreateAddressResponder(resp *http.Response) (result AddressResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrderItem creates an order item. Existing order item cannot be updated with this api and should instead be
// updated with the Update order item API.
// Parameters:
// orderItemName - the name of the order item
// resourceGroupName - the name of the resource group. The name is case insensitive.
// orderItemResource - order item details from request body.
func (client BaseClient) CreateOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, orderItemResource OrderItemResource) (result CreateOrderItemFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.CreateOrderItem")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: orderItemResource,
			Constraints: []validation.Constraint{{Target: "orderItemResource.OrderItemProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "orderItemResource.OrderItemProperties.OrderItemDetails", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "orderItemResource.OrderItemProperties.OrderItemDetails.ProductDetails", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "orderItemResource.OrderItemProperties.OrderItemDetails.ProductDetails.HierarchyInformation", Name: validation.Null, Rule: true, Chain: nil}}},
					}},
					{Target: "orderItemResource.OrderItemProperties.AddressDetails", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "orderItemResource.OrderItemProperties.AddressDetails.ForwardAddress", Name: validation.Null, Rule: true,
							Chain: []validation.Constraint{{Target: "orderItemResource.OrderItemProperties.AddressDetails.ForwardAddress.ShippingAddress", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "orderItemResource.OrderItemProperties.AddressDetails.ForwardAddress.ShippingAddress.StreetAddress1", Name: validation.Null, Rule: true, Chain: nil},
									{Target: "orderItemResource.OrderItemProperties.AddressDetails.ForwardAddress.ShippingAddress.Country", Name: validation.Null, Rule: true, Chain: nil},
								}},
								{Target: "orderItemResource.OrderItemProperties.AddressDetails.ForwardAddress.ContactDetails", Name: validation.Null, Rule: true,
									Chain: []validation.Constraint{{Target: "orderItemResource.OrderItemProperties.AddressDetails.ForwardAddress.ContactDetails.ContactName", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "orderItemResource.OrderItemProperties.AddressDetails.ForwardAddress.ContactDetails.Phone", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "orderItemResource.OrderItemProperties.AddressDetails.ForwardAddress.ContactDetails.EmailList", Name: validation.Null, Rule: true, Chain: nil},
									}},
							}},
							{Target: "orderItemResource.OrderItemProperties.AddressDetails.ReturnAddress", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "orderItemResource.OrderItemProperties.AddressDetails.ReturnAddress.ShippingAddress", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "orderItemResource.OrderItemProperties.AddressDetails.ReturnAddress.ShippingAddress.StreetAddress1", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "orderItemResource.OrderItemProperties.AddressDetails.ReturnAddress.ShippingAddress.Country", Name: validation.Null, Rule: true, Chain: nil},
									}},
									{Target: "orderItemResource.OrderItemProperties.AddressDetails.ReturnAddress.ContactDetails", Name: validation.Null, Rule: true,
										Chain: []validation.Constraint{{Target: "orderItemResource.OrderItemProperties.AddressDetails.ReturnAddress.ContactDetails.ContactName", Name: validation.Null, Rule: true, Chain: nil},
											{Target: "orderItemResource.OrderItemProperties.AddressDetails.ReturnAddress.ContactDetails.Phone", Name: validation.Null, Rule: true, Chain: nil},
											{Target: "orderItemResource.OrderItemProperties.AddressDetails.ReturnAddress.ContactDetails.EmailList", Name: validation.Null, Rule: true, Chain: nil},
										}},
								}},
						}},
					{Target: "orderItemResource.OrderItemProperties.OrderID", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "CreateOrderItem", err.Error())
	}

	req, err := client.CreateOrderItemPreparer(ctx, orderItemName, resourceGroupName, orderItemResource)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "CreateOrderItem", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrderItemSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "CreateOrderItem", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrderItemPreparer prepares the CreateOrderItem request.
func (client BaseClient) CreateOrderItemPreparer(ctx context.Context, orderItemName string, resourceGroupName string, orderItemResource OrderItemResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"orderItemName":     autorest.Encode("path", orderItemName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	orderItemResource.SystemData = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}", pathParameters),
		autorest.WithJSON(orderItemResource),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrderItemSender sends the CreateOrderItem request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) CreateOrderItemSender(req *http.Request) (future CreateOrderItemFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateOrderItemResponder handles the response to the CreateOrderItem request. The method always
// closes the http.Response Body.
func (client BaseClient) CreateOrderItemResponder(resp *http.Response) (result OrderItemResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteAddressByName deletes an address.
// Parameters:
// addressName - the name of the address Resource within the specified resource group. address names must be
// between 3 and 24 characters in length and use any alphanumeric and underscore only
// resourceGroupName - the name of the resource group. The name is case insensitive.
func (client BaseClient) DeleteAddressByName(ctx context.Context, addressName string, resourceGroupName string) (result DeleteAddressByNameFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.DeleteAddressByName")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: addressName,
			Constraints: []validation.Constraint{{Target: "addressName", Name: validation.MaxLength, Rule: 24, Chain: nil},
				{Target: "addressName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "addressName", Name: validation.Pattern, Rule: `^[-\w\.]+$`, Chain: nil}}},
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "DeleteAddressByName", err.Error())
	}

	req, err := client.DeleteAddressByNamePreparer(ctx, addressName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "DeleteAddressByName", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteAddressByNameSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "DeleteAddressByName", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteAddressByNamePreparer prepares the DeleteAddressByName request.
func (client BaseClient) DeleteAddressByNamePreparer(ctx context.Context, addressName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"addressName":       autorest.Encode("path", addressName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteAddressByNameSender sends the DeleteAddressByName request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) DeleteAddressByNameSender(req *http.Request) (future DeleteAddressByNameFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteAddressByNameResponder handles the response to the DeleteAddressByName request. The method always
// closes the http.Response Body.
func (client BaseClient) DeleteAddressByNameResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteOrderItemByName deletes an order item.
// Parameters:
// orderItemName - the name of the order item
// resourceGroupName - the name of the resource group. The name is case insensitive.
func (client BaseClient) DeleteOrderItemByName(ctx context.Context, orderItemName string, resourceGroupName string) (result DeleteOrderItemByNameFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.DeleteOrderItemByName")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "DeleteOrderItemByName", err.Error())
	}

	req, err := client.DeleteOrderItemByNamePreparer(ctx, orderItemName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "DeleteOrderItemByName", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteOrderItemByNameSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "DeleteOrderItemByName", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteOrderItemByNamePreparer prepares the DeleteOrderItemByName request.
func (client BaseClient) DeleteOrderItemByNamePreparer(ctx context.Context, orderItemName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"orderItemName":     autorest.Encode("path", orderItemName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteOrderItemByNameSender sends the DeleteOrderItemByName request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) DeleteOrderItemByNameSender(req *http.Request) (future DeleteOrderItemByNameFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteOrderItemByNameResponder handles the response to the DeleteOrderItemByName request. The method always
// closes the http.Response Body.
func (client BaseClient) DeleteOrderItemByNameResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetAddressByName gets information about the specified address.
// Parameters:
// addressName - the name of the address Resource within the specified resource group. address names must be
// between 3 and 24 characters in length and use any alphanumeric and underscore only
// resourceGroupName - the name of the resource group. The name is case insensitive.
func (client BaseClient) GetAddressByName(ctx context.Context, addressName string, resourceGroupName string) (result AddressResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetAddressByName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: addressName,
			Constraints: []validation.Constraint{{Target: "addressName", Name: validation.MaxLength, Rule: 24, Chain: nil},
				{Target: "addressName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "addressName", Name: validation.Pattern, Rule: `^[-\w\.]+$`, Chain: nil}}},
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "GetAddressByName", err.Error())
	}

	req, err := client.GetAddressByNamePreparer(ctx, addressName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "GetAddressByName", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAddressByNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "GetAddressByName", resp, "Failure sending request")
		return
	}

	result, err = client.GetAddressByNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "GetAddressByName", resp, "Failure responding to request")
		return
	}

	return
}

// GetAddressByNamePreparer prepares the GetAddressByName request.
func (client BaseClient) GetAddressByNamePreparer(ctx context.Context, addressName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"addressName":       autorest.Encode("path", addressName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAddressByNameSender sends the GetAddressByName request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetAddressByNameSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetAddressByNameResponder handles the response to the GetAddressByName request. The method always
// closes the http.Response Body.
func (client BaseClient) GetAddressByNameResponder(resp *http.Response) (result AddressResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetOrderByName gets an order.
// Parameters:
// orderName - the name of the order
// resourceGroupName - the name of the resource group. The name is case insensitive.
// location - the name of Azure region.
func (client BaseClient) GetOrderByName(ctx context.Context, orderName string, resourceGroupName string, location string) (result OrderResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetOrderByName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: location,
			Constraints: []validation.Constraint{{Target: "location", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "GetOrderByName", err.Error())
	}

	req, err := client.GetOrderByNamePreparer(ctx, orderName, resourceGroupName, location)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "GetOrderByName", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetOrderByNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "GetOrderByName", resp, "Failure sending request")
		return
	}

	result, err = client.GetOrderByNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "GetOrderByName", resp, "Failure responding to request")
		return
	}

	return
}

// GetOrderByNamePreparer prepares the GetOrderByName request.
func (client BaseClient) GetOrderByNamePreparer(ctx context.Context, orderName string, resourceGroupName string, location string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":          autorest.Encode("path", location),
		"orderName":         autorest.Encode("path", orderName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/locations/{location}/orders/{orderName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetOrderByNameSender sends the GetOrderByName request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetOrderByNameSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetOrderByNameResponder handles the response to the GetOrderByName request. The method always
// closes the http.Response Body.
func (client BaseClient) GetOrderByNameResponder(resp *http.Response) (result OrderResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetOrderItemByName gets an order item.
// Parameters:
// orderItemName - the name of the order item
// resourceGroupName - the name of the resource group. The name is case insensitive.
// expand - $expand is supported on device details parameter for order item, which provides details on the
// devices of the product.
func (client BaseClient) GetOrderItemByName(ctx context.Context, orderItemName string, resourceGroupName string, expand string) (result OrderItemResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetOrderItemByName")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "GetOrderItemByName", err.Error())
	}

	req, err := client.GetOrderItemByNamePreparer(ctx, orderItemName, resourceGroupName, expand)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "GetOrderItemByName", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetOrderItemByNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "GetOrderItemByName", resp, "Failure sending request")
		return
	}

	result, err = client.GetOrderItemByNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "GetOrderItemByName", resp, "Failure responding to request")
		return
	}

	return
}

// GetOrderItemByNamePreparer prepares the GetOrderItemByName request.
func (client BaseClient) GetOrderItemByNamePreparer(ctx context.Context, orderItemName string, resourceGroupName string, expand string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"orderItemName":     autorest.Encode("path", orderItemName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetOrderItemByNameSender sends the GetOrderItemByName request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetOrderItemByNameSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetOrderItemByNameResponder handles the response to the GetOrderItemByName request. The method always
// closes the http.Response Body.
func (client BaseClient) GetOrderItemByNameResponder(resp *http.Response) (result OrderItemResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAddressesAtResourceGroupLevel lists all the addresses available under the given resource group.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// filter - $filter is supported to filter based on shipping address properties. Filter supports only equals
// operation.
// skipToken - $skipToken is supported on Get list of addresses, which provides the next page in the list of
// address.
func (client BaseClient) ListAddressesAtResourceGroupLevel(ctx context.Context, resourceGroupName string, filter string, skipToken string) (result AddressResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListAddressesAtResourceGroupLevel")
		defer func() {
			sc := -1
			if result.arl.Response.Response != nil {
				sc = result.arl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "ListAddressesAtResourceGroupLevel", err.Error())
	}

	result.fn = client.listAddressesAtResourceGroupLevelNextResults
	req, err := client.ListAddressesAtResourceGroupLevelPreparer(ctx, resourceGroupName, filter, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListAddressesAtResourceGroupLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAddressesAtResourceGroupLevelSender(req)
	if err != nil {
		result.arl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListAddressesAtResourceGroupLevel", resp, "Failure sending request")
		return
	}

	result.arl, err = client.ListAddressesAtResourceGroupLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListAddressesAtResourceGroupLevel", resp, "Failure responding to request")
		return
	}
	if result.arl.hasNextLink() && result.arl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListAddressesAtResourceGroupLevelPreparer prepares the ListAddressesAtResourceGroupLevel request.
func (client BaseClient) ListAddressesAtResourceGroupLevelPreparer(ctx context.Context, resourceGroupName string, filter string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAddressesAtResourceGroupLevelSender sends the ListAddressesAtResourceGroupLevel request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListAddressesAtResourceGroupLevelSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListAddressesAtResourceGroupLevelResponder handles the response to the ListAddressesAtResourceGroupLevel request. The method always
// closes the http.Response Body.
func (client BaseClient) ListAddressesAtResourceGroupLevelResponder(resp *http.Response) (result AddressResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listAddressesAtResourceGroupLevelNextResults retrieves the next set of results, if any.
func (client BaseClient) listAddressesAtResourceGroupLevelNextResults(ctx context.Context, lastResults AddressResourceList) (result AddressResourceList, err error) {
	req, err := lastResults.addressResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listAddressesAtResourceGroupLevelNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListAddressesAtResourceGroupLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listAddressesAtResourceGroupLevelNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListAddressesAtResourceGroupLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listAddressesAtResourceGroupLevelNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListAddressesAtResourceGroupLevelComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListAddressesAtResourceGroupLevelComplete(ctx context.Context, resourceGroupName string, filter string, skipToken string) (result AddressResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListAddressesAtResourceGroupLevel")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListAddressesAtResourceGroupLevel(ctx, resourceGroupName, filter, skipToken)
	return
}

// ListAddressesAtSubscriptionLevel lists all the addresses available under the subscription.
// Parameters:
// filter - $filter is supported to filter based on shipping address properties. Filter supports only equals
// operation.
// skipToken - $skipToken is supported on Get list of addresses, which provides the next page in the list of
// addresses.
func (client BaseClient) ListAddressesAtSubscriptionLevel(ctx context.Context, filter string, skipToken string) (result AddressResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListAddressesAtSubscriptionLevel")
		defer func() {
			sc := -1
			if result.arl.Response.Response != nil {
				sc = result.arl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "ListAddressesAtSubscriptionLevel", err.Error())
	}

	result.fn = client.listAddressesAtSubscriptionLevelNextResults
	req, err := client.ListAddressesAtSubscriptionLevelPreparer(ctx, filter, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListAddressesAtSubscriptionLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAddressesAtSubscriptionLevelSender(req)
	if err != nil {
		result.arl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListAddressesAtSubscriptionLevel", resp, "Failure sending request")
		return
	}

	result.arl, err = client.ListAddressesAtSubscriptionLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListAddressesAtSubscriptionLevel", resp, "Failure responding to request")
		return
	}
	if result.arl.hasNextLink() && result.arl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListAddressesAtSubscriptionLevelPreparer prepares the ListAddressesAtSubscriptionLevel request.
func (client BaseClient) ListAddressesAtSubscriptionLevelPreparer(ctx context.Context, filter string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/addresses", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAddressesAtSubscriptionLevelSender sends the ListAddressesAtSubscriptionLevel request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListAddressesAtSubscriptionLevelSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListAddressesAtSubscriptionLevelResponder handles the response to the ListAddressesAtSubscriptionLevel request. The method always
// closes the http.Response Body.
func (client BaseClient) ListAddressesAtSubscriptionLevelResponder(resp *http.Response) (result AddressResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listAddressesAtSubscriptionLevelNextResults retrieves the next set of results, if any.
func (client BaseClient) listAddressesAtSubscriptionLevelNextResults(ctx context.Context, lastResults AddressResourceList) (result AddressResourceList, err error) {
	req, err := lastResults.addressResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listAddressesAtSubscriptionLevelNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListAddressesAtSubscriptionLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listAddressesAtSubscriptionLevelNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListAddressesAtSubscriptionLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listAddressesAtSubscriptionLevelNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListAddressesAtSubscriptionLevelComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListAddressesAtSubscriptionLevelComplete(ctx context.Context, filter string, skipToken string) (result AddressResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListAddressesAtSubscriptionLevel")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListAddressesAtSubscriptionLevel(ctx, filter, skipToken)
	return
}

// ListConfigurations this method provides the list of configurations for the given product family, product line and
// product under subscription.
// Parameters:
// configurationsRequest - filters for showing the configurations.
// skipToken - $skipToken is supported on list of configurations, which provides the next page in the list of
// configurations.
func (client BaseClient) ListConfigurations(ctx context.Context, configurationsRequest ConfigurationsRequest, skipToken string) (result ConfigurationsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListConfigurations")
		defer func() {
			sc := -1
			if result.c.Response.Response != nil {
				sc = result.c.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: configurationsRequest,
			Constraints: []validation.Constraint{{Target: "configurationsRequest.ConfigurationFilters", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "configurationsRequest.ConfigurationFilters", Name: validation.UniqueItems, Rule: true, Chain: nil}}},
				{Target: "configurationsRequest.CustomerSubscriptionDetails", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "configurationsRequest.CustomerSubscriptionDetails.QuotaID", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "ListConfigurations", err.Error())
	}

	result.fn = client.listConfigurationsNextResults
	req, err := client.ListConfigurationsPreparer(ctx, configurationsRequest, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListConfigurations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConfigurationsSender(req)
	if err != nil {
		result.c.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListConfigurations", resp, "Failure sending request")
		return
	}

	result.c, err = client.ListConfigurationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListConfigurations", resp, "Failure responding to request")
		return
	}
	if result.c.hasNextLink() && result.c.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListConfigurationsPreparer prepares the ListConfigurations request.
func (client BaseClient) ListConfigurationsPreparer(ctx context.Context, configurationsRequest ConfigurationsRequest, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/listConfigurations", pathParameters),
		autorest.WithJSON(configurationsRequest),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListConfigurationsSender sends the ListConfigurations request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListConfigurationsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListConfigurationsResponder handles the response to the ListConfigurations request. The method always
// closes the http.Response Body.
func (client BaseClient) ListConfigurationsResponder(resp *http.Response) (result Configurations, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listConfigurationsNextResults retrieves the next set of results, if any.
func (client BaseClient) listConfigurationsNextResults(ctx context.Context, lastResults Configurations) (result Configurations, err error) {
	req, err := lastResults.configurationsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listConfigurationsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListConfigurationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listConfigurationsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListConfigurationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listConfigurationsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListConfigurationsComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListConfigurationsComplete(ctx context.Context, configurationsRequest ConfigurationsRequest, skipToken string) (result ConfigurationsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListConfigurations")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListConfigurations(ctx, configurationsRequest, skipToken)
	return
}

// ListOperations this method gets all the operations that are exposed for customer.
func (client BaseClient) ListOperations(ctx context.Context) (result OperationListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListOperations")
		defer func() {
			sc := -1
			if result.olr.Response.Response != nil {
				sc = result.olr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listOperationsNextResults
	req, err := client.ListOperationsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOperations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListOperationsSender(req)
	if err != nil {
		result.olr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOperations", resp, "Failure sending request")
		return
	}

	result.olr, err = client.ListOperationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOperations", resp, "Failure responding to request")
		return
	}
	if result.olr.hasNextLink() && result.olr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListOperationsPreparer prepares the ListOperations request.
func (client BaseClient) ListOperationsPreparer(ctx context.Context) (*http.Request, error) {
	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/providers/Microsoft.EdgeOrder/operations"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListOperationsSender sends the ListOperations request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListOperationsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListOperationsResponder handles the response to the ListOperations request. The method always
// closes the http.Response Body.
func (client BaseClient) ListOperationsResponder(resp *http.Response) (result OperationListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listOperationsNextResults retrieves the next set of results, if any.
func (client BaseClient) listOperationsNextResults(ctx context.Context, lastResults OperationListResult) (result OperationListResult, err error) {
	req, err := lastResults.operationListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOperationsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListOperationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOperationsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListOperationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOperationsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListOperationsComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListOperationsComplete(ctx context.Context) (result OperationListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListOperations")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListOperations(ctx)
	return
}

// ListOrderAtResourceGroupLevel lists order at resource group level.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// skipToken - $skipToken is supported on Get list of order, which provides the next page in the list of order.
func (client BaseClient) ListOrderAtResourceGroupLevel(ctx context.Context, resourceGroupName string, skipToken string) (result OrderResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListOrderAtResourceGroupLevel")
		defer func() {
			sc := -1
			if result.orl.Response.Response != nil {
				sc = result.orl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "ListOrderAtResourceGroupLevel", err.Error())
	}

	result.fn = client.listOrderAtResourceGroupLevelNextResults
	req, err := client.ListOrderAtResourceGroupLevelPreparer(ctx, resourceGroupName, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOrderAtResourceGroupLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListOrderAtResourceGroupLevelSender(req)
	if err != nil {
		result.orl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOrderAtResourceGroupLevel", resp, "Failure sending request")
		return
	}

	result.orl, err = client.ListOrderAtResourceGroupLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOrderAtResourceGroupLevel", resp, "Failure responding to request")
		return
	}
	if result.orl.hasNextLink() && result.orl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListOrderAtResourceGroupLevelPreparer prepares the ListOrderAtResourceGroupLevel request.
func (client BaseClient) ListOrderAtResourceGroupLevelPreparer(ctx context.Context, resourceGroupName string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orders", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListOrderAtResourceGroupLevelSender sends the ListOrderAtResourceGroupLevel request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListOrderAtResourceGroupLevelSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListOrderAtResourceGroupLevelResponder handles the response to the ListOrderAtResourceGroupLevel request. The method always
// closes the http.Response Body.
func (client BaseClient) ListOrderAtResourceGroupLevelResponder(resp *http.Response) (result OrderResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listOrderAtResourceGroupLevelNextResults retrieves the next set of results, if any.
func (client BaseClient) listOrderAtResourceGroupLevelNextResults(ctx context.Context, lastResults OrderResourceList) (result OrderResourceList, err error) {
	req, err := lastResults.orderResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOrderAtResourceGroupLevelNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListOrderAtResourceGroupLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOrderAtResourceGroupLevelNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListOrderAtResourceGroupLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOrderAtResourceGroupLevelNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListOrderAtResourceGroupLevelComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListOrderAtResourceGroupLevelComplete(ctx context.Context, resourceGroupName string, skipToken string) (result OrderResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListOrderAtResourceGroupLevel")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListOrderAtResourceGroupLevel(ctx, resourceGroupName, skipToken)
	return
}

// ListOrderAtSubscriptionLevel lists order at subscription level.
// Parameters:
// skipToken - $skipToken is supported on Get list of order, which provides the next page in the list of order.
func (client BaseClient) ListOrderAtSubscriptionLevel(ctx context.Context, skipToken string) (result OrderResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListOrderAtSubscriptionLevel")
		defer func() {
			sc := -1
			if result.orl.Response.Response != nil {
				sc = result.orl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "ListOrderAtSubscriptionLevel", err.Error())
	}

	result.fn = client.listOrderAtSubscriptionLevelNextResults
	req, err := client.ListOrderAtSubscriptionLevelPreparer(ctx, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOrderAtSubscriptionLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListOrderAtSubscriptionLevelSender(req)
	if err != nil {
		result.orl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOrderAtSubscriptionLevel", resp, "Failure sending request")
		return
	}

	result.orl, err = client.ListOrderAtSubscriptionLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOrderAtSubscriptionLevel", resp, "Failure responding to request")
		return
	}
	if result.orl.hasNextLink() && result.orl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListOrderAtSubscriptionLevelPreparer prepares the ListOrderAtSubscriptionLevel request.
func (client BaseClient) ListOrderAtSubscriptionLevelPreparer(ctx context.Context, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/orders", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListOrderAtSubscriptionLevelSender sends the ListOrderAtSubscriptionLevel request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListOrderAtSubscriptionLevelSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListOrderAtSubscriptionLevelResponder handles the response to the ListOrderAtSubscriptionLevel request. The method always
// closes the http.Response Body.
func (client BaseClient) ListOrderAtSubscriptionLevelResponder(resp *http.Response) (result OrderResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listOrderAtSubscriptionLevelNextResults retrieves the next set of results, if any.
func (client BaseClient) listOrderAtSubscriptionLevelNextResults(ctx context.Context, lastResults OrderResourceList) (result OrderResourceList, err error) {
	req, err := lastResults.orderResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOrderAtSubscriptionLevelNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListOrderAtSubscriptionLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOrderAtSubscriptionLevelNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListOrderAtSubscriptionLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOrderAtSubscriptionLevelNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListOrderAtSubscriptionLevelComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListOrderAtSubscriptionLevelComplete(ctx context.Context, skipToken string) (result OrderResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListOrderAtSubscriptionLevel")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListOrderAtSubscriptionLevel(ctx, skipToken)
	return
}

// ListOrderItemsAtResourceGroupLevel lists order item at resource group level.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// filter - $filter is supported to filter based on order id. Filter supports only equals operation.
// expand - $expand is supported on device details parameter for order item, which provides details on the
// devices of the product.
// skipToken - $skipToken is supported on Get list of order items, which provides the next page in the list of
// order items.
func (client BaseClient) ListOrderItemsAtResourceGroupLevel(ctx context.Context, resourceGroupName string, filter string, expand string, skipToken string) (result OrderItemResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListOrderItemsAtResourceGroupLevel")
		defer func() {
			sc := -1
			if result.oirl.Response.Response != nil {
				sc = result.oirl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "ListOrderItemsAtResourceGroupLevel", err.Error())
	}

	result.fn = client.listOrderItemsAtResourceGroupLevelNextResults
	req, err := client.ListOrderItemsAtResourceGroupLevelPreparer(ctx, resourceGroupName, filter, expand, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOrderItemsAtResourceGroupLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListOrderItemsAtResourceGroupLevelSender(req)
	if err != nil {
		result.oirl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOrderItemsAtResourceGroupLevel", resp, "Failure sending request")
		return
	}

	result.oirl, err = client.ListOrderItemsAtResourceGroupLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOrderItemsAtResourceGroupLevel", resp, "Failure responding to request")
		return
	}
	if result.oirl.hasNextLink() && result.oirl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListOrderItemsAtResourceGroupLevelPreparer prepares the ListOrderItemsAtResourceGroupLevel request.
func (client BaseClient) ListOrderItemsAtResourceGroupLevelPreparer(ctx context.Context, resourceGroupName string, filter string, expand string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListOrderItemsAtResourceGroupLevelSender sends the ListOrderItemsAtResourceGroupLevel request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListOrderItemsAtResourceGroupLevelSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListOrderItemsAtResourceGroupLevelResponder handles the response to the ListOrderItemsAtResourceGroupLevel request. The method always
// closes the http.Response Body.
func (client BaseClient) ListOrderItemsAtResourceGroupLevelResponder(resp *http.Response) (result OrderItemResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listOrderItemsAtResourceGroupLevelNextResults retrieves the next set of results, if any.
func (client BaseClient) listOrderItemsAtResourceGroupLevelNextResults(ctx context.Context, lastResults OrderItemResourceList) (result OrderItemResourceList, err error) {
	req, err := lastResults.orderItemResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOrderItemsAtResourceGroupLevelNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListOrderItemsAtResourceGroupLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOrderItemsAtResourceGroupLevelNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListOrderItemsAtResourceGroupLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOrderItemsAtResourceGroupLevelNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListOrderItemsAtResourceGroupLevelComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListOrderItemsAtResourceGroupLevelComplete(ctx context.Context, resourceGroupName string, filter string, expand string, skipToken string) (result OrderItemResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListOrderItemsAtResourceGroupLevel")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListOrderItemsAtResourceGroupLevel(ctx, resourceGroupName, filter, expand, skipToken)
	return
}

// ListOrderItemsAtSubscriptionLevel lists order at subscription level.
// Parameters:
// filter - $filter is supported to filter based on order id. Filter supports only equals operation.
// skipToken - $skipToken is supported on Get list of orders, which provides the next page in the list of
// order.
func (client BaseClient) ListOrderItemsAtSubscriptionLevel(ctx context.Context, filter string, skipToken string) (result OrderItemResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListOrderItemsAtSubscriptionLevel")
		defer func() {
			sc := -1
			if result.oirl.Response.Response != nil {
				sc = result.oirl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "ListOrderItemsAtSubscriptionLevel", err.Error())
	}

	result.fn = client.listOrderItemsAtSubscriptionLevelNextResults
	req, err := client.ListOrderItemsAtSubscriptionLevelPreparer(ctx, filter, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOrderItemsAtSubscriptionLevel", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListOrderItemsAtSubscriptionLevelSender(req)
	if err != nil {
		result.oirl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOrderItemsAtSubscriptionLevel", resp, "Failure sending request")
		return
	}

	result.oirl, err = client.ListOrderItemsAtSubscriptionLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListOrderItemsAtSubscriptionLevel", resp, "Failure responding to request")
		return
	}
	if result.oirl.hasNextLink() && result.oirl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListOrderItemsAtSubscriptionLevelPreparer prepares the ListOrderItemsAtSubscriptionLevel request.
func (client BaseClient) ListOrderItemsAtSubscriptionLevelPreparer(ctx context.Context, filter string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/orderItems", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListOrderItemsAtSubscriptionLevelSender sends the ListOrderItemsAtSubscriptionLevel request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListOrderItemsAtSubscriptionLevelSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListOrderItemsAtSubscriptionLevelResponder handles the response to the ListOrderItemsAtSubscriptionLevel request. The method always
// closes the http.Response Body.
func (client BaseClient) ListOrderItemsAtSubscriptionLevelResponder(resp *http.Response) (result OrderItemResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listOrderItemsAtSubscriptionLevelNextResults retrieves the next set of results, if any.
func (client BaseClient) listOrderItemsAtSubscriptionLevelNextResults(ctx context.Context, lastResults OrderItemResourceList) (result OrderItemResourceList, err error) {
	req, err := lastResults.orderItemResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOrderItemsAtSubscriptionLevelNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListOrderItemsAtSubscriptionLevelSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOrderItemsAtSubscriptionLevelNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListOrderItemsAtSubscriptionLevelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listOrderItemsAtSubscriptionLevelNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListOrderItemsAtSubscriptionLevelComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListOrderItemsAtSubscriptionLevelComplete(ctx context.Context, filter string, skipToken string) (result OrderItemResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListOrderItemsAtSubscriptionLevel")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListOrderItemsAtSubscriptionLevel(ctx, filter, skipToken)
	return
}

// ListProductFamilies this method provides the list of product families for the given subscription.
// Parameters:
// productFamiliesRequest - filters for showing the product families.
// expand - $expand is supported on configurations parameter for product, which provides details on the
// configurations for the product.
// skipToken - $skipToken is supported on list of product families, which provides the next page in the list of
// product families.
func (client BaseClient) ListProductFamilies(ctx context.Context, productFamiliesRequest ProductFamiliesRequest, expand string, skipToken string) (result ProductFamiliesPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListProductFamilies")
		defer func() {
			sc := -1
			if result.pf.Response.Response != nil {
				sc = result.pf.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: productFamiliesRequest,
			Constraints: []validation.Constraint{{Target: "productFamiliesRequest.FilterableProperties", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "productFamiliesRequest.CustomerSubscriptionDetails", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "productFamiliesRequest.CustomerSubscriptionDetails.QuotaID", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "ListProductFamilies", err.Error())
	}

	result.fn = client.listProductFamiliesNextResults
	req, err := client.ListProductFamiliesPreparer(ctx, productFamiliesRequest, expand, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListProductFamilies", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListProductFamiliesSender(req)
	if err != nil {
		result.pf.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListProductFamilies", resp, "Failure sending request")
		return
	}

	result.pf, err = client.ListProductFamiliesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListProductFamilies", resp, "Failure responding to request")
		return
	}
	if result.pf.hasNextLink() && result.pf.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListProductFamiliesPreparer prepares the ListProductFamilies request.
func (client BaseClient) ListProductFamiliesPreparer(ctx context.Context, productFamiliesRequest ProductFamiliesRequest, expand string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(expand) > 0 {
		queryParameters["$expand"] = autorest.Encode("query", expand)
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/listProductFamilies", pathParameters),
		autorest.WithJSON(productFamiliesRequest),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListProductFamiliesSender sends the ListProductFamilies request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListProductFamiliesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListProductFamiliesResponder handles the response to the ListProductFamilies request. The method always
// closes the http.Response Body.
func (client BaseClient) ListProductFamiliesResponder(resp *http.Response) (result ProductFamilies, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listProductFamiliesNextResults retrieves the next set of results, if any.
func (client BaseClient) listProductFamiliesNextResults(ctx context.Context, lastResults ProductFamilies) (result ProductFamilies, err error) {
	req, err := lastResults.productFamiliesPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listProductFamiliesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListProductFamiliesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listProductFamiliesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListProductFamiliesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listProductFamiliesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListProductFamiliesComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListProductFamiliesComplete(ctx context.Context, productFamiliesRequest ProductFamiliesRequest, expand string, skipToken string) (result ProductFamiliesIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListProductFamilies")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListProductFamilies(ctx, productFamiliesRequest, expand, skipToken)
	return
}

// ListProductFamiliesMetadata this method provides the list of product families metadata for the given subscription.
// Parameters:
// skipToken - $skipToken is supported on list of product families metadata, which provides the next page in
// the list of product families metadata.
func (client BaseClient) ListProductFamiliesMetadata(ctx context.Context, skipToken string) (result ProductFamiliesMetadataPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListProductFamiliesMetadata")
		defer func() {
			sc := -1
			if result.pfm.Response.Response != nil {
				sc = result.pfm.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "ListProductFamiliesMetadata", err.Error())
	}

	result.fn = client.listProductFamiliesMetadataNextResults
	req, err := client.ListProductFamiliesMetadataPreparer(ctx, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListProductFamiliesMetadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListProductFamiliesMetadataSender(req)
	if err != nil {
		result.pfm.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListProductFamiliesMetadata", resp, "Failure sending request")
		return
	}

	result.pfm, err = client.ListProductFamiliesMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ListProductFamiliesMetadata", resp, "Failure responding to request")
		return
	}
	if result.pfm.hasNextLink() && result.pfm.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListProductFamiliesMetadataPreparer prepares the ListProductFamiliesMetadata request.
func (client BaseClient) ListProductFamiliesMetadataPreparer(ctx context.Context, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/productFamiliesMetadata", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListProductFamiliesMetadataSender sends the ListProductFamiliesMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ListProductFamiliesMetadataSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListProductFamiliesMetadataResponder handles the response to the ListProductFamiliesMetadata request. The method always
// closes the http.Response Body.
func (client BaseClient) ListProductFamiliesMetadataResponder(resp *http.Response) (result ProductFamiliesMetadata, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listProductFamiliesMetadataNextResults retrieves the next set of results, if any.
func (client BaseClient) listProductFamiliesMetadataNextResults(ctx context.Context, lastResults ProductFamiliesMetadata) (result ProductFamiliesMetadata, err error) {
	req, err := lastResults.productFamiliesMetadataPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listProductFamiliesMetadataNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListProductFamiliesMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listProductFamiliesMetadataNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListProductFamiliesMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "listProductFamiliesMetadataNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListProductFamiliesMetadataComplete enumerates all values, automatically crossing page boundaries as required.
func (client BaseClient) ListProductFamiliesMetadataComplete(ctx context.Context, skipToken string) (result ProductFamiliesMetadataIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ListProductFamiliesMetadata")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListProductFamiliesMetadata(ctx, skipToken)
	return
}

// ReturnOrderItem return order item.
// Parameters:
// orderItemName - the name of the order item
// resourceGroupName - the name of the resource group. The name is case insensitive.
// returnOrderItemDetails - return order item CurrentStatus.
func (client BaseClient) ReturnOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, returnOrderItemDetails ReturnOrderItemDetails) (result ReturnOrderItemFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ReturnOrderItem")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: returnOrderItemDetails,
			Constraints: []validation.Constraint{{Target: "returnOrderItemDetails.ReturnAddress", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "returnOrderItemDetails.ReturnAddress.ShippingAddress", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "returnOrderItemDetails.ReturnAddress.ShippingAddress.StreetAddress1", Name: validation.Null, Rule: true, Chain: nil},
						{Target: "returnOrderItemDetails.ReturnAddress.ShippingAddress.Country", Name: validation.Null, Rule: true, Chain: nil},
					}},
					{Target: "returnOrderItemDetails.ReturnAddress.ContactDetails", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "returnOrderItemDetails.ReturnAddress.ContactDetails.ContactName", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "returnOrderItemDetails.ReturnAddress.ContactDetails.Phone", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "returnOrderItemDetails.ReturnAddress.ContactDetails.EmailList", Name: validation.Null, Rule: true, Chain: nil},
						}},
				}},
				{Target: "returnOrderItemDetails.ReturnReason", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "ReturnOrderItem", err.Error())
	}

	req, err := client.ReturnOrderItemPreparer(ctx, orderItemName, resourceGroupName, returnOrderItemDetails)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ReturnOrderItem", nil, "Failure preparing request")
		return
	}

	result, err = client.ReturnOrderItemSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "ReturnOrderItem", result.Response(), "Failure sending request")
		return
	}

	return
}

// ReturnOrderItemPreparer prepares the ReturnOrderItem request.
func (client BaseClient) ReturnOrderItemPreparer(ctx context.Context, orderItemName string, resourceGroupName string, returnOrderItemDetails ReturnOrderItemDetails) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"orderItemName":     autorest.Encode("path", orderItemName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}/return", pathParameters),
		autorest.WithJSON(returnOrderItemDetails),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ReturnOrderItemSender sends the ReturnOrderItem request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ReturnOrderItemSender(req *http.Request) (future ReturnOrderItemFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// ReturnOrderItemResponder handles the response to the ReturnOrderItem request. The method always
// closes the http.Response Body.
func (client BaseClient) ReturnOrderItemResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateAddress updates the properties of an existing address.
// Parameters:
// addressName - the name of the address Resource within the specified resource group. address names must be
// between 3 and 24 characters in length and use any alphanumeric and underscore only
// resourceGroupName - the name of the resource group. The name is case insensitive.
// addressUpdateParameter - address update parameters from request body.
// ifMatch - defines the If-Match condition. The patch will be performed only if the ETag of the job on the
// server matches this value.
func (client BaseClient) UpdateAddress(ctx context.Context, addressName string, resourceGroupName string, addressUpdateParameter AddressUpdateParameter, ifMatch string) (result UpdateAddressFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.UpdateAddress")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: addressName,
			Constraints: []validation.Constraint{{Target: "addressName", Name: validation.MaxLength, Rule: 24, Chain: nil},
				{Target: "addressName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "addressName", Name: validation.Pattern, Rule: `^[-\w\.]+$`, Chain: nil}}},
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "UpdateAddress", err.Error())
	}

	req, err := client.UpdateAddressPreparer(ctx, addressName, resourceGroupName, addressUpdateParameter, ifMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "UpdateAddress", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateAddressSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "UpdateAddress", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdateAddressPreparer prepares the UpdateAddress request.
func (client BaseClient) UpdateAddressPreparer(ctx context.Context, addressName string, resourceGroupName string, addressUpdateParameter AddressUpdateParameter, ifMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"addressName":       autorest.Encode("path", addressName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}", pathParameters),
		autorest.WithJSON(addressUpdateParameter),
		autorest.WithQueryParameters(queryParameters))
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateAddressSender sends the UpdateAddress request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) UpdateAddressSender(req *http.Request) (future UpdateAddressFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateAddressResponder handles the response to the UpdateAddress request. The method always
// closes the http.Response Body.
func (client BaseClient) UpdateAddressResponder(resp *http.Response) (result AddressResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateOrderItem updates the properties of an existing order item.
// Parameters:
// orderItemName - the name of the order item
// resourceGroupName - the name of the resource group. The name is case insensitive.
// orderItemUpdateParameter - order item update parameters from request body.
// ifMatch - defines the If-Match condition. The patch will be performed only if the ETag of the order on the
// server matches this value.
func (client BaseClient) UpdateOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, orderItemUpdateParameter OrderItemUpdateParameter, ifMatch string) (result UpdateOrderItemFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.UpdateOrderItem")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("edgeorder.BaseClient", "UpdateOrderItem", err.Error())
	}

	req, err := client.UpdateOrderItemPreparer(ctx, orderItemName, resourceGroupName, orderItemUpdateParameter, ifMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "UpdateOrderItem", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateOrderItemSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "edgeorder.BaseClient", "UpdateOrderItem", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdateOrderItemPreparer prepares the UpdateOrderItem request.
func (client BaseClient) UpdateOrderItemPreparer(ctx context.Context, orderItemName string, resourceGroupName string, orderItemUpdateParameter OrderItemUpdateParameter, ifMatch string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"orderItemName":     autorest.Encode("path", orderItemName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-12-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}", pathParameters),
		autorest.WithJSON(orderItemUpdateParameter),
		autorest.WithQueryParameters(queryParameters))
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateOrderItemSender sends the UpdateOrderItem request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) UpdateOrderItemSender(req *http.Request) (future UpdateOrderItemFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateOrderItemResponder handles the response to the UpdateOrderItem request. The method always
// closes the http.Response Body.
func (client BaseClient) UpdateOrderItemResponder(resp *http.Response) (result OrderItemResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
