package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRepositoryTagV2 invokes the codeup.DeleteRepositoryTagV2 API synchronously
func (client *Client) DeleteRepositoryTagV2(request *DeleteRepositoryTagV2Request) (response *DeleteRepositoryTagV2Response, err error) {
	response = CreateDeleteRepositoryTagV2Response()
	err = client.DoAction(request, response)
	return
}

// DeleteRepositoryTagV2WithChan invokes the codeup.DeleteRepositoryTagV2 API asynchronously
func (client *Client) DeleteRepositoryTagV2WithChan(request *DeleteRepositoryTagV2Request) (<-chan *DeleteRepositoryTagV2Response, <-chan error) {
	responseChan := make(chan *DeleteRepositoryTagV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRepositoryTagV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRepositoryTagV2WithCallback invokes the codeup.DeleteRepositoryTagV2 API asynchronously
func (client *Client) DeleteRepositoryTagV2WithCallback(request *DeleteRepositoryTagV2Request, callback func(response *DeleteRepositoryTagV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRepositoryTagV2Response
		var err error
		defer close(result)
		response, err = client.DeleteRepositoryTagV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRepositoryTagV2Request is the request struct for api DeleteRepositoryTagV2
type DeleteRepositoryTagV2Request struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	TagName        string           `position:"Query" name:"TagName"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// DeleteRepositoryTagV2Response is the response struct for api DeleteRepositoryTagV2
type DeleteRepositoryTagV2Response struct {
	*responses.BaseResponse
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Result       Result `json:"Result" xml:"Result"`
}

// CreateDeleteRepositoryTagV2Request creates a request to invoke DeleteRepositoryTagV2 API
func CreateDeleteRepositoryTagV2Request() (request *DeleteRepositoryTagV2Request) {
	request = &DeleteRepositoryTagV2Request{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "DeleteRepositoryTagV2", "/api/v3/projects/[ProjectId]/repository/tag/delete", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteRepositoryTagV2Response creates a response to parse from DeleteRepositoryTagV2 response
func CreateDeleteRepositoryTagV2Response() (response *DeleteRepositoryTagV2Response) {
	response = &DeleteRepositoryTagV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
