package petadata

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySecurityIPs invokes the petadata.ModifySecurityIPs API synchronously
// api document: https://help.aliyun.com/api/petadata/modifysecurityips.html
func (client *Client) ModifySecurityIPs(request *ModifySecurityIPsRequest) (response *ModifySecurityIPsResponse, err error) {
	response = CreateModifySecurityIPsResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySecurityIPsWithChan invokes the petadata.ModifySecurityIPs API asynchronously
// api document: https://help.aliyun.com/api/petadata/modifysecurityips.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySecurityIPsWithChan(request *ModifySecurityIPsRequest) (<-chan *ModifySecurityIPsResponse, <-chan error) {
	responseChan := make(chan *ModifySecurityIPsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySecurityIPs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySecurityIPsWithCallback invokes the petadata.ModifySecurityIPs API asynchronously
// api document: https://help.aliyun.com/api/petadata/modifysecurityips.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySecurityIPsWithCallback(request *ModifySecurityIPsRequest, callback func(response *ModifySecurityIPsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySecurityIPsResponse
		var err error
		defer close(result)
		response, err = client.ModifySecurityIPs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySecurityIPsRequest is the request struct for api ModifySecurityIPs
type ModifySecurityIPsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId         requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ModifyMode              string           `position:"Query" name:"ModifyMode"`
	ResourceOwnerAccount    string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount            string           `position:"Query" name:"OwnerAccount"`
	SecurityIPListAttribute string           `position:"Query" name:"SecurityIPListAttribute"`
	OwnerId                 requests.Integer `position:"Query" name:"OwnerId"`
	SecurityIPList          string           `position:"Query" name:"SecurityIPList"`
	InstanceId              string           `position:"Query" name:"InstanceId"`
	SecurityToken           string           `position:"Query" name:"SecurityToken"`
	SecurityIPListName      string           `position:"Query" name:"SecurityIPListName"`
}

// ModifySecurityIPsResponse is the response struct for api ModifySecurityIPs
type ModifySecurityIPsResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	InstanceId     string `json:"InstanceId" xml:"InstanceId"`
	SecurityIPList string `json:"SecurityIPList" xml:"SecurityIPList"`
}

// CreateModifySecurityIPsRequest creates a request to invoke ModifySecurityIPs API
func CreateModifySecurityIPsRequest() (request *ModifySecurityIPsRequest) {
	request = &ModifySecurityIPsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PetaData", "2016-01-01", "ModifySecurityIPs", "petadata", "openAPI")
	return
}

// CreateModifySecurityIPsResponse creates a response to parse from ModifySecurityIPs response
func CreateModifySecurityIPsResponse() (response *ModifySecurityIPsResponse) {
	response = &ModifySecurityIPsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
