package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTLSCipherPolicy invokes the slb.CreateTLSCipherPolicy API synchronously
func (client *Client) CreateTLSCipherPolicy(request *CreateTLSCipherPolicyRequest) (response *CreateTLSCipherPolicyResponse, err error) {
	response = CreateCreateTLSCipherPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTLSCipherPolicyWithChan invokes the slb.CreateTLSCipherPolicy API asynchronously
func (client *Client) CreateTLSCipherPolicyWithChan(request *CreateTLSCipherPolicyRequest) (<-chan *CreateTLSCipherPolicyResponse, <-chan error) {
	responseChan := make(chan *CreateTLSCipherPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTLSCipherPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTLSCipherPolicyWithCallback invokes the slb.CreateTLSCipherPolicy API asynchronously
func (client *Client) CreateTLSCipherPolicyWithCallback(request *CreateTLSCipherPolicyRequest, callback func(response *CreateTLSCipherPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTLSCipherPolicyResponse
		var err error
		defer close(result)
		response, err = client.CreateTLSCipherPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTLSCipherPolicyRequest is the request struct for api CreateTLSCipherPolicy
type CreateTLSCipherPolicyRequest struct {
	*requests.RpcRequest
	AccessKeyId          string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Ciphers              *[]string        `position:"Query" name:"Ciphers"  type:"Repeated"`
	TLSVersions          *[]string        `position:"Query" name:"TLSVersions"  type:"Repeated"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Name                 string           `position:"Query" name:"Name"`
}

// CreateTLSCipherPolicyResponse is the response struct for api CreateTLSCipherPolicy
type CreateTLSCipherPolicyResponse struct {
	*responses.BaseResponse
	TLSCipherPolicyId string `json:"TLSCipherPolicyId" xml:"TLSCipherPolicyId"`
	RequestId         string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateTLSCipherPolicyRequest creates a request to invoke CreateTLSCipherPolicy API
func CreateCreateTLSCipherPolicyRequest() (request *CreateTLSCipherPolicyRequest) {
	request = &CreateTLSCipherPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "CreateTLSCipherPolicy", "Slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTLSCipherPolicyResponse creates a response to parse from CreateTLSCipherPolicy response
func CreateCreateTLSCipherPolicyResponse() (response *CreateTLSCipherPolicyResponse) {
	response = &CreateTLSCipherPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
