package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSagStaticRoute invokes the smartag.DeleteSagStaticRoute API synchronously
func (client *Client) DeleteSagStaticRoute(request *DeleteSagStaticRouteRequest) (response *DeleteSagStaticRouteResponse, err error) {
	response = CreateDeleteSagStaticRouteResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSagStaticRouteWithChan invokes the smartag.DeleteSagStaticRoute API asynchronously
func (client *Client) DeleteSagStaticRouteWithChan(request *DeleteSagStaticRouteRequest) (<-chan *DeleteSagStaticRouteResponse, <-chan error) {
	responseChan := make(chan *DeleteSagStaticRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSagStaticRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSagStaticRouteWithCallback invokes the smartag.DeleteSagStaticRoute API asynchronously
func (client *Client) DeleteSagStaticRouteWithCallback(request *DeleteSagStaticRouteRequest, callback func(response *DeleteSagStaticRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSagStaticRouteResponse
		var err error
		defer close(result)
		response, err = client.DeleteSagStaticRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSagStaticRouteRequest is the request struct for api DeleteSagStaticRoute
type DeleteSagStaticRouteRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Vlan                 string           `position:"Query" name:"Vlan"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
	PortName             string           `position:"Query" name:"PortName"`
	DestinationCidr      string           `position:"Query" name:"DestinationCidr"`
}

// DeleteSagStaticRouteResponse is the response struct for api DeleteSagStaticRoute
type DeleteSagStaticRouteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSagStaticRouteRequest creates a request to invoke DeleteSagStaticRoute API
func CreateDeleteSagStaticRouteRequest() (request *DeleteSagStaticRouteRequest) {
	request = &DeleteSagStaticRouteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DeleteSagStaticRoute", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSagStaticRouteResponse creates a response to parse from DeleteSagStaticRoute response
func CreateDeleteSagStaticRouteResponse() (response *DeleteSagStaticRouteResponse) {
	response = &DeleteSagStaticRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
