// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// GlobalBase Global Base
//
// # HAProxy global configuration
//
// swagger:model global_base
type GlobalBase struct {

	// CPU maps
	CPUMaps []*CPUMap `json:"cpu_maps,omitempty"`

	// h1 case adjusts
	H1CaseAdjusts []*H1CaseAdjust `json:"h1_case_adjust,omitempty"`

	// runtime a p is
	RuntimeAPIs []*RuntimeAPI `json:"runtime_apis,omitempty"`

	// set var fmts
	SetVarFmts []*SetVarFmt `json:"set_var_fmt,omitempty"`

	// set vars
	SetVars []*SetVar `json:"set_var,omitempty"`

	// thread group lines
	ThreadGroupLines []*ThreadGroup `json:"thread_group_lines,omitempty"`

	// chroot
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Chroot string `json:"chroot,omitempty"`

	// close spread time
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	CloseSpreadTime *int64 `json:"close_spread_time,omitempty"`

	// cluster secret
	ClusterSecret string `json:"cluster_secret,omitempty"`

	// daemon
	Daemon bool `json:"daemon,omitempty"`

	// debug options
	DebugOptions *DebugOptions `json:"debug_options,omitempty"`

	// default path
	DefaultPath *GlobalDefaultPath `json:"default_path,omitempty"`

	// description
	Description string `json:"description,omitempty"`

	// device atlas options
	DeviceAtlasOptions *DeviceAtlasOptions `json:"device_atlas_options,omitempty"`

	// environment options
	EnvironmentOptions *EnvironmentOptions `json:"environment_options,omitempty"`

	// expose experimental directives
	ExposeExperimentalDirectives bool `json:"expose_experimental_directives,omitempty"`

	// external check
	ExternalCheck bool `json:"external_check,omitempty"`

	// fifty one degrees options
	FiftyOneDegreesOptions *FiftyOneDegreesOptions `json:"fifty_one_degrees_options,omitempty"`

	// gid
	Gid int64 `json:"gid,omitempty"`

	// grace
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	Grace *int64 `json:"grace,omitempty"`

	// group
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Group string `json:"group,omitempty"`

	// h1 accept payload with any method
	H1AcceptPayloadWithAnyMethod bool `json:"h1_accept_payload_with_any_method,omitempty"`

	// h1 case adjust file
	H1CaseAdjustFile string `json:"h1_case_adjust_file,omitempty"`

	// h1 do not close on insecure transfer encoding
	H1DoNotCloseOnInsecureTransferEncoding bool `json:"h1_do_not_close_on_insecure_transfer_encoding,omitempty"`

	// h2 workaround bogus websocket clients
	H2WorkaroundBogusWebsocketClients bool `json:"h2_workaround_bogus_websocket_clients,omitempty"`

	// hard stop after
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	HardStopAfter *int64 `json:"hard_stop_after,omitempty"`

	// harden
	Harden *GlobalHarden `json:"harden,omitempty"`

	// http client options
	HTTPClientOptions *HTTPClientOptions `json:"http_client_options,omitempty"`

	// http err codes
	HTTPErrCodes []*HTTPCodes `json:"http_err_codes,omitempty"`

	// http fail codes
	HTTPFailCodes []*HTTPCodes `json:"http_fail_codes,omitempty"`

	// insecure fork wanted
	InsecureForkWanted bool `json:"insecure_fork_wanted,omitempty"`

	// insecure setuid wanted
	InsecureSetuidWanted bool `json:"insecure_setuid_wanted,omitempty"`

	// limited quic
	LimitedQuic bool `json:"limited_quic,omitempty"`

	// localpeer
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Localpeer string `json:"localpeer,omitempty"`

	// log send hostname
	LogSendHostname *GlobalLogSendHostname `json:"log_send_hostname,omitempty"`

	// lua options
	LuaOptions *LuaOptions `json:"lua_options,omitempty"`

	// master worker
	MasterWorker bool `json:"master-worker,omitempty"`

	// mworker max reloads
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	MworkerMaxReloads *int64 `json:"mworker_max_reloads,omitempty"`

	// nbthread
	Nbthread int64 `json:"nbthread,omitempty"`

	// no quic
	NoQuic bool `json:"no_quic,omitempty"`

	// node
	Node string `json:"node,omitempty"`

	// numa cpu mapping
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	NumaCPUMapping string `json:"numa_cpu_mapping,omitempty"`

	// ocsp update options
	OcspUpdateOptions *OcspUpdateOptions `json:"ocsp_update_options,omitempty"`

	// performance options
	PerformanceOptions *PerformanceOptions `json:"performance_options,omitempty"`

	// pidfile
	Pidfile string `json:"pidfile,omitempty"`

	// pp2 never send local
	Pp2NeverSendLocal bool `json:"pp2_never_send_local,omitempty"`

	// prealloc fd
	PreallocFd bool `json:"prealloc_fd,omitempty"`

	// set dumpable
	SetDumpable bool `json:"set_dumpable,omitempty"`

	// setcap
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Setcap string `json:"setcap,omitempty"`

	// ssl options
	SslOptions *SslOptions `json:"ssl_options,omitempty"`

	// stats file
	StatsFile string `json:"stats_file,omitempty"`

	// stats maxconn
	StatsMaxconn *int64 `json:"stats_maxconn,omitempty"`

	// stats timeout
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	StatsTimeout *int64 `json:"stats_timeout,omitempty"`

	// strict limits
	StrictLimits bool `json:"strict_limits,omitempty"`

	// thread groups
	ThreadGroups int64 `json:"thread_groups,omitempty"`

	// tune buffer options
	TuneBufferOptions *TuneBufferOptions `json:"tune_buffer_options,omitempty"`

	// tune lua options
	TuneLuaOptions *TuneLuaOptions `json:"tune_lua_options,omitempty"`

	// tune options
	TuneOptions *TuneOptions `json:"tune_options,omitempty"`

	// tune quic options
	TuneQuicOptions *TuneQuicOptions `json:"tune_quic_options,omitempty"`

	// tune ssl options
	TuneSslOptions *TuneSslOptions `json:"tune_ssl_options,omitempty"`

	// tune vars options
	TuneVarsOptions *TuneVarsOptions `json:"tune_vars_options,omitempty"`

	// tune zlib options
	TuneZlibOptions *TuneZlibOptions `json:"tune_zlib_options,omitempty"`

	// uid
	UID int64 `json:"uid,omitempty"`

	// ulimit n
	Ulimitn int64 `json:"ulimit_n,omitempty"`

	// user
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	User string `json:"user,omitempty"`

	// wurfl options
	WurflOptions *WurflOptions `json:"wurfl_options,omitempty"`
}

// Validate validates this global base
func (m *GlobalBase) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCPUMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateH1CaseAdjusts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRuntimeAPIs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSetVarFmts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSetVars(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThreadGroupLines(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateChroot(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloseSpreadTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDebugOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDefaultPath(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeviceAtlasOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEnvironmentOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFiftyOneDegreesOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGrace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHardStopAfter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHarden(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPClientOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPErrCodes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHTTPFailCodes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocalpeer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogSendHostname(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLuaOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMworkerMaxReloads(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNumaCPUMapping(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOcspUpdateOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePerformanceOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSetcap(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatsTimeout(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTuneBufferOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTuneLuaOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTuneOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTuneQuicOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTuneSslOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTuneVarsOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTuneZlibOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUser(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWurflOptions(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GlobalBase) validateCPUMaps(formats strfmt.Registry) error {
	if swag.IsZero(m.CPUMaps) { // not required
		return nil
	}

	for i := 0; i < len(m.CPUMaps); i++ {
		if swag.IsZero(m.CPUMaps[i]) { // not required
			continue
		}

		if m.CPUMaps[i] != nil {
			if err := m.CPUMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cpu_maps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("cpu_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) validateH1CaseAdjusts(formats strfmt.Registry) error {
	if swag.IsZero(m.H1CaseAdjusts) { // not required
		return nil
	}

	for i := 0; i < len(m.H1CaseAdjusts); i++ {
		if swag.IsZero(m.H1CaseAdjusts[i]) { // not required
			continue
		}

		if m.H1CaseAdjusts[i] != nil {
			if err := m.H1CaseAdjusts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("h1_case_adjust" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("h1_case_adjust" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) validateRuntimeAPIs(formats strfmt.Registry) error {
	if swag.IsZero(m.RuntimeAPIs) { // not required
		return nil
	}

	for i := 0; i < len(m.RuntimeAPIs); i++ {
		if swag.IsZero(m.RuntimeAPIs[i]) { // not required
			continue
		}

		if m.RuntimeAPIs[i] != nil {
			if err := m.RuntimeAPIs[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("runtime_apis" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("runtime_apis" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) validateSetVarFmts(formats strfmt.Registry) error {
	if swag.IsZero(m.SetVarFmts) { // not required
		return nil
	}

	for i := 0; i < len(m.SetVarFmts); i++ {
		if swag.IsZero(m.SetVarFmts[i]) { // not required
			continue
		}

		if m.SetVarFmts[i] != nil {
			if err := m.SetVarFmts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("set_var_fmt" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("set_var_fmt" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) validateSetVars(formats strfmt.Registry) error {
	if swag.IsZero(m.SetVars) { // not required
		return nil
	}

	for i := 0; i < len(m.SetVars); i++ {
		if swag.IsZero(m.SetVars[i]) { // not required
			continue
		}

		if m.SetVars[i] != nil {
			if err := m.SetVars[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("set_var" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("set_var" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) validateThreadGroupLines(formats strfmt.Registry) error {
	if swag.IsZero(m.ThreadGroupLines) { // not required
		return nil
	}

	for i := 0; i < len(m.ThreadGroupLines); i++ {
		if swag.IsZero(m.ThreadGroupLines[i]) { // not required
			continue
		}

		if m.ThreadGroupLines[i] != nil {
			if err := m.ThreadGroupLines[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("thread_group_lines" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("thread_group_lines" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) validateChroot(formats strfmt.Registry) error {
	if swag.IsZero(m.Chroot) { // not required
		return nil
	}

	if err := validate.Pattern("chroot", "body", m.Chroot, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *GlobalBase) validateCloseSpreadTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CloseSpreadTime) { // not required
		return nil
	}

	if err := validate.MinimumInt("close_spread_time", "body", *m.CloseSpreadTime, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *GlobalBase) validateDebugOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.DebugOptions) { // not required
		return nil
	}

	if m.DebugOptions != nil {
		if err := m.DebugOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("debug_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("debug_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateDefaultPath(formats strfmt.Registry) error {
	if swag.IsZero(m.DefaultPath) { // not required
		return nil
	}

	if m.DefaultPath != nil {
		if err := m.DefaultPath.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("default_path")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("default_path")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateDeviceAtlasOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.DeviceAtlasOptions) { // not required
		return nil
	}

	if m.DeviceAtlasOptions != nil {
		if err := m.DeviceAtlasOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("device_atlas_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("device_atlas_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateEnvironmentOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.EnvironmentOptions) { // not required
		return nil
	}

	if m.EnvironmentOptions != nil {
		if err := m.EnvironmentOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("environment_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("environment_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateFiftyOneDegreesOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.FiftyOneDegreesOptions) { // not required
		return nil
	}

	if m.FiftyOneDegreesOptions != nil {
		if err := m.FiftyOneDegreesOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fifty_one_degrees_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("fifty_one_degrees_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateGrace(formats strfmt.Registry) error {
	if swag.IsZero(m.Grace) { // not required
		return nil
	}

	if err := validate.MinimumInt("grace", "body", *m.Grace, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *GlobalBase) validateGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Group) { // not required
		return nil
	}

	if err := validate.Pattern("group", "body", m.Group, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *GlobalBase) validateHardStopAfter(formats strfmt.Registry) error {
	if swag.IsZero(m.HardStopAfter) { // not required
		return nil
	}

	if err := validate.MinimumInt("hard_stop_after", "body", *m.HardStopAfter, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *GlobalBase) validateHarden(formats strfmt.Registry) error {
	if swag.IsZero(m.Harden) { // not required
		return nil
	}

	if m.Harden != nil {
		if err := m.Harden.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("harden")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("harden")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateHTTPClientOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPClientOptions) { // not required
		return nil
	}

	if m.HTTPClientOptions != nil {
		if err := m.HTTPClientOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("http_client_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("http_client_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateHTTPErrCodes(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPErrCodes) { // not required
		return nil
	}

	for i := 0; i < len(m.HTTPErrCodes); i++ {
		if swag.IsZero(m.HTTPErrCodes[i]) { // not required
			continue
		}

		if m.HTTPErrCodes[i] != nil {
			if err := m.HTTPErrCodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("http_err_codes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("http_err_codes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) validateHTTPFailCodes(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTPFailCodes) { // not required
		return nil
	}

	for i := 0; i < len(m.HTTPFailCodes); i++ {
		if swag.IsZero(m.HTTPFailCodes[i]) { // not required
			continue
		}

		if m.HTTPFailCodes[i] != nil {
			if err := m.HTTPFailCodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("http_fail_codes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("http_fail_codes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) validateLocalpeer(formats strfmt.Registry) error {
	if swag.IsZero(m.Localpeer) { // not required
		return nil
	}

	if err := validate.Pattern("localpeer", "body", m.Localpeer, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *GlobalBase) validateLogSendHostname(formats strfmt.Registry) error {
	if swag.IsZero(m.LogSendHostname) { // not required
		return nil
	}

	if m.LogSendHostname != nil {
		if err := m.LogSendHostname.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("log_send_hostname")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("log_send_hostname")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateLuaOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.LuaOptions) { // not required
		return nil
	}

	if m.LuaOptions != nil {
		if err := m.LuaOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lua_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("lua_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateMworkerMaxReloads(formats strfmt.Registry) error {
	if swag.IsZero(m.MworkerMaxReloads) { // not required
		return nil
	}

	if err := validate.MinimumInt("mworker_max_reloads", "body", *m.MworkerMaxReloads, 0, false); err != nil {
		return err
	}

	return nil
}

var globalBaseTypeNumaCPUMappingPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		globalBaseTypeNumaCPUMappingPropEnum = append(globalBaseTypeNumaCPUMappingPropEnum, v)
	}
}

const (

	// GlobalBaseNumaCPUMappingEnabled captures enum value "enabled"
	GlobalBaseNumaCPUMappingEnabled string = "enabled"

	// GlobalBaseNumaCPUMappingDisabled captures enum value "disabled"
	GlobalBaseNumaCPUMappingDisabled string = "disabled"
)

// prop value enum
func (m *GlobalBase) validateNumaCPUMappingEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, globalBaseTypeNumaCPUMappingPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *GlobalBase) validateNumaCPUMapping(formats strfmt.Registry) error {
	if swag.IsZero(m.NumaCPUMapping) { // not required
		return nil
	}

	// value enum
	if err := m.validateNumaCPUMappingEnum("numa_cpu_mapping", "body", m.NumaCPUMapping); err != nil {
		return err
	}

	return nil
}

func (m *GlobalBase) validateOcspUpdateOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.OcspUpdateOptions) { // not required
		return nil
	}

	if m.OcspUpdateOptions != nil {
		if err := m.OcspUpdateOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ocsp_update_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ocsp_update_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validatePerformanceOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.PerformanceOptions) { // not required
		return nil
	}

	if m.PerformanceOptions != nil {
		if err := m.PerformanceOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("performance_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("performance_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateSetcap(formats strfmt.Registry) error {
	if swag.IsZero(m.Setcap) { // not required
		return nil
	}

	if err := validate.Pattern("setcap", "body", m.Setcap, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *GlobalBase) validateSslOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.SslOptions) { // not required
		return nil
	}

	if m.SslOptions != nil {
		if err := m.SslOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ssl_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ssl_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateStatsTimeout(formats strfmt.Registry) error {
	if swag.IsZero(m.StatsTimeout) { // not required
		return nil
	}

	if err := validate.MinimumInt("stats_timeout", "body", *m.StatsTimeout, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *GlobalBase) validateTuneBufferOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.TuneBufferOptions) { // not required
		return nil
	}

	if m.TuneBufferOptions != nil {
		if err := m.TuneBufferOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tune_buffer_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tune_buffer_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateTuneLuaOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.TuneLuaOptions) { // not required
		return nil
	}

	if m.TuneLuaOptions != nil {
		if err := m.TuneLuaOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tune_lua_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tune_lua_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateTuneOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.TuneOptions) { // not required
		return nil
	}

	if m.TuneOptions != nil {
		if err := m.TuneOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tune_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tune_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateTuneQuicOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.TuneQuicOptions) { // not required
		return nil
	}

	if m.TuneQuicOptions != nil {
		if err := m.TuneQuicOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tune_quic_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tune_quic_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateTuneSslOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.TuneSslOptions) { // not required
		return nil
	}

	if m.TuneSslOptions != nil {
		if err := m.TuneSslOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tune_ssl_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tune_ssl_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateTuneVarsOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.TuneVarsOptions) { // not required
		return nil
	}

	if m.TuneVarsOptions != nil {
		if err := m.TuneVarsOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tune_vars_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tune_vars_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateTuneZlibOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.TuneZlibOptions) { // not required
		return nil
	}

	if m.TuneZlibOptions != nil {
		if err := m.TuneZlibOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tune_zlib_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tune_zlib_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) validateUser(formats strfmt.Registry) error {
	if swag.IsZero(m.User) { // not required
		return nil
	}

	if err := validate.Pattern("user", "body", m.User, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *GlobalBase) validateWurflOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.WurflOptions) { // not required
		return nil
	}

	if m.WurflOptions != nil {
		if err := m.WurflOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("wurfl_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("wurfl_options")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this global base based on the context it is used
func (m *GlobalBase) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCPUMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateH1CaseAdjusts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRuntimeAPIs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSetVarFmts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSetVars(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThreadGroupLines(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDebugOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDefaultPath(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDeviceAtlasOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnvironmentOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFiftyOneDegreesOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHarden(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHTTPClientOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHTTPErrCodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHTTPFailCodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogSendHostname(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLuaOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOcspUpdateOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePerformanceOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSslOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTuneBufferOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTuneLuaOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTuneOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTuneQuicOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTuneSslOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTuneVarsOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTuneZlibOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWurflOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GlobalBase) contextValidateCPUMaps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.CPUMaps); i++ {

		if m.CPUMaps[i] != nil {

			if swag.IsZero(m.CPUMaps[i]) { // not required
				return nil
			}

			if err := m.CPUMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cpu_maps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("cpu_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) contextValidateH1CaseAdjusts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.H1CaseAdjusts); i++ {

		if m.H1CaseAdjusts[i] != nil {

			if swag.IsZero(m.H1CaseAdjusts[i]) { // not required
				return nil
			}

			if err := m.H1CaseAdjusts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("h1_case_adjust" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("h1_case_adjust" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) contextValidateRuntimeAPIs(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.RuntimeAPIs); i++ {

		if m.RuntimeAPIs[i] != nil {

			if swag.IsZero(m.RuntimeAPIs[i]) { // not required
				return nil
			}

			if err := m.RuntimeAPIs[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("runtime_apis" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("runtime_apis" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) contextValidateSetVarFmts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SetVarFmts); i++ {

		if m.SetVarFmts[i] != nil {

			if swag.IsZero(m.SetVarFmts[i]) { // not required
				return nil
			}

			if err := m.SetVarFmts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("set_var_fmt" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("set_var_fmt" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) contextValidateSetVars(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SetVars); i++ {

		if m.SetVars[i] != nil {

			if swag.IsZero(m.SetVars[i]) { // not required
				return nil
			}

			if err := m.SetVars[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("set_var" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("set_var" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) contextValidateThreadGroupLines(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ThreadGroupLines); i++ {

		if m.ThreadGroupLines[i] != nil {

			if swag.IsZero(m.ThreadGroupLines[i]) { // not required
				return nil
			}

			if err := m.ThreadGroupLines[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("thread_group_lines" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("thread_group_lines" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) contextValidateDebugOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.DebugOptions != nil {

		if swag.IsZero(m.DebugOptions) { // not required
			return nil
		}

		if err := m.DebugOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("debug_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("debug_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateDefaultPath(ctx context.Context, formats strfmt.Registry) error {

	if m.DefaultPath != nil {

		if swag.IsZero(m.DefaultPath) { // not required
			return nil
		}

		if err := m.DefaultPath.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("default_path")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("default_path")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateDeviceAtlasOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.DeviceAtlasOptions != nil {

		if swag.IsZero(m.DeviceAtlasOptions) { // not required
			return nil
		}

		if err := m.DeviceAtlasOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("device_atlas_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("device_atlas_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateEnvironmentOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.EnvironmentOptions != nil {

		if swag.IsZero(m.EnvironmentOptions) { // not required
			return nil
		}

		if err := m.EnvironmentOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("environment_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("environment_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateFiftyOneDegreesOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.FiftyOneDegreesOptions != nil {

		if swag.IsZero(m.FiftyOneDegreesOptions) { // not required
			return nil
		}

		if err := m.FiftyOneDegreesOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("fifty_one_degrees_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("fifty_one_degrees_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateHarden(ctx context.Context, formats strfmt.Registry) error {

	if m.Harden != nil {

		if swag.IsZero(m.Harden) { // not required
			return nil
		}

		if err := m.Harden.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("harden")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("harden")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateHTTPClientOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.HTTPClientOptions != nil {

		if swag.IsZero(m.HTTPClientOptions) { // not required
			return nil
		}

		if err := m.HTTPClientOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("http_client_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("http_client_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateHTTPErrCodes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.HTTPErrCodes); i++ {

		if m.HTTPErrCodes[i] != nil {

			if swag.IsZero(m.HTTPErrCodes[i]) { // not required
				return nil
			}

			if err := m.HTTPErrCodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("http_err_codes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("http_err_codes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) contextValidateHTTPFailCodes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.HTTPFailCodes); i++ {

		if m.HTTPFailCodes[i] != nil {

			if swag.IsZero(m.HTTPFailCodes[i]) { // not required
				return nil
			}

			if err := m.HTTPFailCodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("http_fail_codes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("http_fail_codes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *GlobalBase) contextValidateLogSendHostname(ctx context.Context, formats strfmt.Registry) error {

	if m.LogSendHostname != nil {

		if swag.IsZero(m.LogSendHostname) { // not required
			return nil
		}

		if err := m.LogSendHostname.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("log_send_hostname")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("log_send_hostname")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateLuaOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.LuaOptions != nil {

		if swag.IsZero(m.LuaOptions) { // not required
			return nil
		}

		if err := m.LuaOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lua_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("lua_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateOcspUpdateOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.OcspUpdateOptions != nil {

		if swag.IsZero(m.OcspUpdateOptions) { // not required
			return nil
		}

		if err := m.OcspUpdateOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ocsp_update_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ocsp_update_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidatePerformanceOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.PerformanceOptions != nil {

		if swag.IsZero(m.PerformanceOptions) { // not required
			return nil
		}

		if err := m.PerformanceOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("performance_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("performance_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateSslOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.SslOptions != nil {

		if swag.IsZero(m.SslOptions) { // not required
			return nil
		}

		if err := m.SslOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ssl_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ssl_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateTuneBufferOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.TuneBufferOptions != nil {

		if swag.IsZero(m.TuneBufferOptions) { // not required
			return nil
		}

		if err := m.TuneBufferOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tune_buffer_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tune_buffer_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateTuneLuaOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.TuneLuaOptions != nil {

		if swag.IsZero(m.TuneLuaOptions) { // not required
			return nil
		}

		if err := m.TuneLuaOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tune_lua_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tune_lua_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateTuneOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.TuneOptions != nil {

		if swag.IsZero(m.TuneOptions) { // not required
			return nil
		}

		if err := m.TuneOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tune_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tune_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateTuneQuicOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.TuneQuicOptions != nil {

		if swag.IsZero(m.TuneQuicOptions) { // not required
			return nil
		}

		if err := m.TuneQuicOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tune_quic_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tune_quic_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateTuneSslOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.TuneSslOptions != nil {

		if swag.IsZero(m.TuneSslOptions) { // not required
			return nil
		}

		if err := m.TuneSslOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tune_ssl_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tune_ssl_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateTuneVarsOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.TuneVarsOptions != nil {

		if swag.IsZero(m.TuneVarsOptions) { // not required
			return nil
		}

		if err := m.TuneVarsOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tune_vars_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tune_vars_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateTuneZlibOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.TuneZlibOptions != nil {

		if swag.IsZero(m.TuneZlibOptions) { // not required
			return nil
		}

		if err := m.TuneZlibOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tune_zlib_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("tune_zlib_options")
			}
			return err
		}
	}

	return nil
}

func (m *GlobalBase) contextValidateWurflOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.WurflOptions != nil {

		if swag.IsZero(m.WurflOptions) { // not required
			return nil
		}

		if err := m.WurflOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("wurfl_options")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("wurfl_options")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GlobalBase) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GlobalBase) UnmarshalBinary(b []byte) error {
	var res GlobalBase
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CPUMap CPU map
//
// swagger:model CPUMap
type CPUMap struct {

	// cpu set
	// Required: true
	CPUSet *string `json:"cpu_set"`

	// process
	// Required: true
	Process *string `json:"process"`
}

// Validate validates this CPU map
func (m *CPUMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCPUSet(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProcess(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CPUMap) validateCPUSet(formats strfmt.Registry) error {

	if err := validate.Required("cpu_set", "body", m.CPUSet); err != nil {
		return err
	}

	return nil
}

func (m *CPUMap) validateProcess(formats strfmt.Registry) error {

	if err := validate.Required("process", "body", m.Process); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this CPU map based on context it is used
func (m *CPUMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *CPUMap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CPUMap) UnmarshalBinary(b []byte) error {
	var res CPUMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GlobalDefaultPath global default path
//
// swagger:model GlobalDefaultPath
type GlobalDefaultPath struct {
	// path
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Path string `json:"path,omitempty"`

	// type
	// Required: true
	// Enum: ["current","config","parent","origin"]
	// +kubebuilder:validation:Enum="current","config","parent","origin";
	Type string `json:"type"`
}

// Validate validates this global default path
func (m *GlobalDefaultPath) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePath(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GlobalDefaultPath) validatePath(formats strfmt.Registry) error {
	if swag.IsZero(m.Path) { // not required
		return nil
	}

	if err := validate.Pattern("default_path"+"."+"path", "body", m.Path, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var globalDefaultPathTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["current","config","parent","origin"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		globalDefaultPathTypeTypePropEnum = append(globalDefaultPathTypeTypePropEnum, v)
	}
}

const (

	// GlobalDefaultPathTypeCurrent captures enum value "current"
	GlobalDefaultPathTypeCurrent string = "current"

	// GlobalDefaultPathTypeConfig captures enum value "config"
	GlobalDefaultPathTypeConfig string = "config"

	// GlobalDefaultPathTypeParent captures enum value "parent"
	GlobalDefaultPathTypeParent string = "parent"

	// GlobalDefaultPathTypeOrigin captures enum value "origin"
	GlobalDefaultPathTypeOrigin string = "origin"
)

// prop value enum
func (m *GlobalDefaultPath) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, globalDefaultPathTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *GlobalDefaultPath) validateType(formats strfmt.Registry) error {

	if err := validate.RequiredString("default_path"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	// value enum
	if err := m.validateTypeEnum("default_path"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this global default path based on context it is used
func (m *GlobalDefaultPath) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *GlobalDefaultPath) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GlobalDefaultPath) UnmarshalBinary(b []byte) error {
	var res GlobalDefaultPath
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// H1CaseAdjust h1 case adjust
//
// swagger:model H1CaseAdjust
type H1CaseAdjust struct {

	// from
	// Required: true
	From *string `json:"from"`

	// to
	// Required: true
	To *string `json:"to"`
}

// Validate validates this h1 case adjust
func (m *H1CaseAdjust) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTo(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *H1CaseAdjust) validateFrom(formats strfmt.Registry) error {

	if err := validate.Required("from", "body", m.From); err != nil {
		return err
	}

	return nil
}

func (m *H1CaseAdjust) validateTo(formats strfmt.Registry) error {

	if err := validate.Required("to", "body", m.To); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this h1 case adjust based on context it is used
func (m *H1CaseAdjust) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *H1CaseAdjust) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *H1CaseAdjust) UnmarshalBinary(b []byte) error {
	var res H1CaseAdjust
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GlobalHarden global harden
//
// swagger:model GlobalHarden
type GlobalHarden struct {

	// reject privileged ports
	RejectPrivilegedPorts *GlobalHardenRejectPrivilegedPorts `json:"reject_privileged_ports,omitempty"`
}

// Validate validates this global harden
func (m *GlobalHarden) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRejectPrivilegedPorts(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GlobalHarden) validateRejectPrivilegedPorts(formats strfmt.Registry) error {
	if swag.IsZero(m.RejectPrivilegedPorts) { // not required
		return nil
	}

	if m.RejectPrivilegedPorts != nil {
		if err := m.RejectPrivilegedPorts.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("harden" + "." + "reject_privileged_ports")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("harden" + "." + "reject_privileged_ports")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this global harden based on the context it is used
func (m *GlobalHarden) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRejectPrivilegedPorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *GlobalHarden) contextValidateRejectPrivilegedPorts(ctx context.Context, formats strfmt.Registry) error {

	if m.RejectPrivilegedPorts != nil {

		if swag.IsZero(m.RejectPrivilegedPorts) { // not required
			return nil
		}

		if err := m.RejectPrivilegedPorts.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("harden" + "." + "reject_privileged_ports")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("harden" + "." + "reject_privileged_ports")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *GlobalHarden) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GlobalHarden) UnmarshalBinary(b []byte) error {
	var res GlobalHarden
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GlobalHardenRejectPrivilegedPorts global harden reject privileged ports
//
// swagger:model GlobalHardenRejectPrivilegedPorts
type GlobalHardenRejectPrivilegedPorts struct {
	// quic
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Quic string `json:"quic,omitempty"`

	// tcp
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	TCP string `json:"tcp,omitempty"`
}

// Validate validates this global harden reject privileged ports
func (m *GlobalHardenRejectPrivilegedPorts) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateQuic(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTCP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var globalHardenRejectPrivilegedPortsTypeQuicPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		globalHardenRejectPrivilegedPortsTypeQuicPropEnum = append(globalHardenRejectPrivilegedPortsTypeQuicPropEnum, v)
	}
}

const (

	// GlobalHardenRejectPrivilegedPortsQuicEnabled captures enum value "enabled"
	GlobalHardenRejectPrivilegedPortsQuicEnabled string = "enabled"

	// GlobalHardenRejectPrivilegedPortsQuicDisabled captures enum value "disabled"
	GlobalHardenRejectPrivilegedPortsQuicDisabled string = "disabled"
)

// prop value enum
func (m *GlobalHardenRejectPrivilegedPorts) validateQuicEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, globalHardenRejectPrivilegedPortsTypeQuicPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *GlobalHardenRejectPrivilegedPorts) validateQuic(formats strfmt.Registry) error {
	if swag.IsZero(m.Quic) { // not required
		return nil
	}

	// value enum
	if err := m.validateQuicEnum("harden"+"."+"reject_privileged_ports"+"."+"quic", "body", m.Quic); err != nil {
		return err
	}

	return nil
}

var globalHardenRejectPrivilegedPortsTypeTCPPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		globalHardenRejectPrivilegedPortsTypeTCPPropEnum = append(globalHardenRejectPrivilegedPortsTypeTCPPropEnum, v)
	}
}

const (

	// GlobalHardenRejectPrivilegedPortsTCPEnabled captures enum value "enabled"
	GlobalHardenRejectPrivilegedPortsTCPEnabled string = "enabled"

	// GlobalHardenRejectPrivilegedPortsTCPDisabled captures enum value "disabled"
	GlobalHardenRejectPrivilegedPortsTCPDisabled string = "disabled"
)

// prop value enum
func (m *GlobalHardenRejectPrivilegedPorts) validateTCPEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, globalHardenRejectPrivilegedPortsTypeTCPPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *GlobalHardenRejectPrivilegedPorts) validateTCP(formats strfmt.Registry) error {
	if swag.IsZero(m.TCP) { // not required
		return nil
	}

	// value enum
	if err := m.validateTCPEnum("harden"+"."+"reject_privileged_ports"+"."+"tcp", "body", m.TCP); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this global harden reject privileged ports based on context it is used
func (m *GlobalHardenRejectPrivilegedPorts) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *GlobalHardenRejectPrivilegedPorts) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GlobalHardenRejectPrivilegedPorts) UnmarshalBinary(b []byte) error {
	var res GlobalHardenRejectPrivilegedPorts
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// GlobalLogSendHostname global log send hostname
//
// swagger:model GlobalLogSendHostname
type GlobalLogSendHostname struct {
	// enabled
	// Required: true
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum="enabled","disabled";
	Enabled *string `json:"enabled"`

	// param
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Param string `json:"param,omitempty"`
}

// Validate validates this global log send hostname
func (m *GlobalLogSendHostname) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEnabled(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParam(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var globalLogSendHostnameTypeEnabledPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		globalLogSendHostnameTypeEnabledPropEnum = append(globalLogSendHostnameTypeEnabledPropEnum, v)
	}
}

const (

	// GlobalLogSendHostnameEnabledEnabled captures enum value "enabled"
	GlobalLogSendHostnameEnabledEnabled string = "enabled"

	// GlobalLogSendHostnameEnabledDisabled captures enum value "disabled"
	GlobalLogSendHostnameEnabledDisabled string = "disabled"
)

// prop value enum
func (m *GlobalLogSendHostname) validateEnabledEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, globalLogSendHostnameTypeEnabledPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *GlobalLogSendHostname) validateEnabled(formats strfmt.Registry) error {

	if err := validate.Required("log_send_hostname"+"."+"enabled", "body", m.Enabled); err != nil {
		return err
	}

	// value enum
	if err := m.validateEnabledEnum("log_send_hostname"+"."+"enabled", "body", *m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *GlobalLogSendHostname) validateParam(formats strfmt.Registry) error {
	if swag.IsZero(m.Param) { // not required
		return nil
	}

	if err := validate.Pattern("log_send_hostname"+"."+"param", "body", m.Param, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this global log send hostname based on context it is used
func (m *GlobalLogSendHostname) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *GlobalLogSendHostname) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *GlobalLogSendHostname) UnmarshalBinary(b []byte) error {
	var res GlobalLogSendHostname
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// RuntimeAPI runtime API
//
// swagger:model RuntimeAPI
type RuntimeAPI struct {
	BindParams `json:",inline"`

	// address
	// Required: true
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Address *string `json:"address"`
}

// UnmarshalJSON unmarshals this object from a JSON structure
func (m *RuntimeAPI) UnmarshalJSON(raw []byte) error {
	// AO0
	var aO0 BindParams
	if err := swag.ReadJSON(raw, &aO0); err != nil {
		return err
	}
	m.BindParams = aO0

	// AO1
	var dataAO1 struct {
		Address *string `json:"address"`
	}
	if err := swag.ReadJSON(raw, &dataAO1); err != nil {
		return err
	}

	m.Address = dataAO1.Address

	return nil
}

// MarshalJSON marshals this object to a JSON structure
func (m RuntimeAPI) MarshalJSON() ([]byte, error) {
	_parts := make([][]byte, 0, 2)

	aO0, err := swag.WriteJSON(m.BindParams)
	if err != nil {
		return nil, err
	}
	_parts = append(_parts, aO0)
	var dataAO1 struct {
		Address *string `json:"address"`
	}

	dataAO1.Address = m.Address

	jsonDataAO1, errAO1 := swag.WriteJSON(dataAO1)
	if errAO1 != nil {
		return nil, errAO1
	}
	_parts = append(_parts, jsonDataAO1)
	return swag.ConcatJSON(_parts...), nil
}

// Validate validates this runtime API
func (m *RuntimeAPI) Validate(formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with BindParams
	if err := m.BindParams.Validate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RuntimeAPI) validateAddress(formats strfmt.Registry) error {

	if err := validate.Required("address", "body", m.Address); err != nil {
		return err
	}

	if err := validate.Pattern("address", "body", *m.Address, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this runtime API based on the context it is used
func (m *RuntimeAPI) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	// validation for a type composition with BindParams
	if err := m.BindParams.ContextValidate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *RuntimeAPI) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RuntimeAPI) UnmarshalBinary(b []byte) error {
	var res RuntimeAPI
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SetVarFmt set var fmt
//
// swagger:model SetVarFmt
type SetVarFmt struct {

	// format
	// Required: true
	Format *string `json:"format"`

	// name
	// Required: true
	Name *string `json:"name"`
}

// Validate validates this set var fmt
func (m *SetVarFmt) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SetVarFmt) validateFormat(formats strfmt.Registry) error {

	if err := validate.Required("format", "body", m.Format); err != nil {
		return err
	}

	return nil
}

func (m *SetVarFmt) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this set var fmt based on context it is used
func (m *SetVarFmt) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SetVarFmt) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SetVarFmt) UnmarshalBinary(b []byte) error {
	var res SetVarFmt
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SetVar set var
//
// swagger:model SetVar
type SetVar struct {

	// expr
	// Required: true
	Expr *string `json:"expr"`

	// name
	// Required: true
	Name *string `json:"name"`
}

// Validate validates this set var
func (m *SetVar) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExpr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SetVar) validateExpr(formats strfmt.Registry) error {

	if err := validate.Required("expr", "body", m.Expr); err != nil {
		return err
	}

	return nil
}

func (m *SetVar) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this set var based on context it is used
func (m *SetVar) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SetVar) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SetVar) UnmarshalBinary(b []byte) error {
	var res SetVar
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ThreadGroup thread group
//
// swagger:model ThreadGroup
type ThreadGroup struct {

	// group
	// Required: true
	Group *string `json:"group"`

	// num or range
	// Required: true
	NumOrRange *string `json:"num_or_range"`
}

// Validate validates this thread group
func (m *ThreadGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNumOrRange(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ThreadGroup) validateGroup(formats strfmt.Registry) error {

	if err := validate.Required("group", "body", m.Group); err != nil {
		return err
	}

	return nil
}

func (m *ThreadGroup) validateNumOrRange(formats strfmt.Registry) error {

	if err := validate.Required("num_or_range", "body", m.NumOrRange); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this thread group based on context it is used
func (m *ThreadGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ThreadGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ThreadGroup) UnmarshalBinary(b []byte) error {
	var res ThreadGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
