//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

extern "C" {
    /// CFError domain for CTFontManager errors
    ///
    /// CFErrors with this domain will have error codes corresponding to one of the CTFontManagerErrors above.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontmanagererrordomain?language=objc)
    pub static kCTFontManagerErrorDomain: &'static CFString;
}

extern "C" {
    /// User info key to be used with CFError references returned from registration functions.
    ///
    /// The value associated with this key in the user info dictionary of a CFError is a CFArray of font URLs that failed with given error.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontmanagererrorfonturlskey?language=objc)
    pub static kCTFontManagerErrorFontURLsKey: &'static CFString;
}

extern "C" {
    /// User info key to be used with CFError references returned from registration functions.
    ///
    /// The value associated with this key in the user info dictionary of a CFError is a CFArray of font descriptors that failed with given error.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontmanagererrorfontdescriptorskey?language=objc)
    pub static kCTFontManagerErrorFontDescriptorsKey: &'static CFString;
}

extern "C" {
    /// User info key to be used with CFError references returned from registration functions.
    ///
    /// The value associated with this key in the user info dictionary of a CFError is a CFArray of font asset name strings that failed with given error.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/kctfontmanagererrorfontassetnamekey?language=objc)
    pub static kCTFontManagerErrorFontAssetNameKey: &'static CFString;
}

/// Font registration errors
///
/// Errors that would prevent registration of fonts for a specified font file URL.
///
/// The file does not exist at the specified URL.
///
/// Cannot access the file due to insufficient permissions.
///
/// The file is not a recognized or supported font file format.
///
/// The file contains invalid font data that could cause system problems.
///
/// The file has already been registered in the specified scope.
///
/// Errors that would prevent un-registration of fonts for a specified font file URL.
///
/// The file is not registered in the specified scope.
///
/// The font file is actively in use and cannot be unregistered.
///
/// The file is required by the system and cannot be unregistered.
///
/// The file could not be processed due to an unexpected FontProvider error.
///
/// The file could not be processed because the provider does not have a necessary entitlement.
///
/// The font descriptor does not have information to specify a font file.
///
/// The operation was cancelled by the user.
///
/// The file could not be registered because of a duplicated font name.
///
/// The file is not in an allowed location. It must be either in the application's bundle or an on-demand resource.
///
/// The operation failed due to a system limitation.
///
/// The specified scope is not supported.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coretext/ctfontmanagererror?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CTFontManagerError(pub CFIndex);
impl CTFontManagerError {
    #[doc(alias = "kCTFontManagerErrorFileNotFound")]
    pub const FileNotFound: Self = Self(101);
    #[doc(alias = "kCTFontManagerErrorInsufficientPermissions")]
    pub const InsufficientPermissions: Self = Self(102);
    #[doc(alias = "kCTFontManagerErrorUnrecognizedFormat")]
    pub const UnrecognizedFormat: Self = Self(103);
    #[doc(alias = "kCTFontManagerErrorInvalidFontData")]
    pub const InvalidFontData: Self = Self(104);
    #[doc(alias = "kCTFontManagerErrorAlreadyRegistered")]
    pub const AlreadyRegistered: Self = Self(105);
    #[doc(alias = "kCTFontManagerErrorExceededResourceLimit")]
    pub const ExceededResourceLimit: Self = Self(106);
    #[doc(alias = "kCTFontManagerErrorAssetNotFound")]
    pub const AssetNotFound: Self = Self(107);
    #[doc(alias = "kCTFontManagerErrorNotRegistered")]
    pub const NotRegistered: Self = Self(201);
    #[doc(alias = "kCTFontManagerErrorInUse")]
    pub const InUse: Self = Self(202);
    #[doc(alias = "kCTFontManagerErrorSystemRequired")]
    pub const SystemRequired: Self = Self(203);
    #[doc(alias = "kCTFontManagerErrorRegistrationFailed")]
    pub const RegistrationFailed: Self = Self(301);
    #[doc(alias = "kCTFontManagerErrorMissingEntitlement")]
    pub const MissingEntitlement: Self = Self(302);
    #[doc(alias = "kCTFontManagerErrorInsufficientInfo")]
    pub const InsufficientInfo: Self = Self(303);
    #[doc(alias = "kCTFontManagerErrorCancelledByUser")]
    pub const CancelledByUser: Self = Self(304);
    #[doc(alias = "kCTFontManagerErrorDuplicatedName")]
    pub const DuplicatedName: Self = Self(305);
    #[doc(alias = "kCTFontManagerErrorInvalidFilePath")]
    pub const InvalidFilePath: Self = Self(306);
    #[doc(alias = "kCTFontManagerErrorUnsupportedScope")]
    pub const UnsupportedScope: Self = Self(307);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CTFontManagerError {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CTFontManagerError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}
