//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-quartz-core")]
#[cfg(not(target_os = "watchos"))]
use objc2_quartz_core::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidatepickermode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIDatePickerMode(pub NSInteger);
impl UIDatePickerMode {
    /// Displays hour, minute, and optionally AM/PM designation depending on the locale setting (e.g. 6 | 53 | PM)
    #[doc(alias = "UIDatePickerModeTime")]
    pub const Time: Self = Self(0);
    /// Displays month, day, and year depending on the locale setting (e.g. November | 15 | 2007)
    #[doc(alias = "UIDatePickerModeDate")]
    pub const Date: Self = Self(1);
    /// Displays date, hour, minute, and optionally AM/PM designation depending on the locale setting (e.g. Wed Nov 15 | 6 | 53 | PM)
    #[doc(alias = "UIDatePickerModeDateAndTime")]
    pub const DateAndTime: Self = Self(2);
    /// Displays hour and minute (e.g. 1 | 53); only supported in `UIDatePickerStyleWheels`
    #[doc(alias = "UIDatePickerModeCountDownTimer")]
    pub const CountDownTimer: Self = Self(3);
    /// Displays year and month depending on the locale setting (e.g. March | 2024); only supported in `UIDatePickerStyleWheels`
    #[doc(alias = "UIDatePickerModeYearAndMonth")]
    pub const YearAndMonth: Self = Self(4);
}

unsafe impl Encode for UIDatePickerMode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIDatePickerMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidatepickerstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIDatePickerStyle(pub NSInteger);
impl UIDatePickerStyle {
    /// Automatically pick the best style available for the current platform
    /// &
    /// mode.
    #[doc(alias = "UIDatePickerStyleAutomatic")]
    pub const Automatic: Self = Self(0);
    /// Use the wheels (UIPickerView) style. Editing occurs inline.
    #[doc(alias = "UIDatePickerStyleWheels")]
    pub const Wheels: Self = Self(1);
    /// Use a compact style for the date picker. Editing occurs in an overlay.
    #[doc(alias = "UIDatePickerStyleCompact")]
    pub const Compact: Self = Self(2);
    /// Use a style for the date picker that allows editing in place.
    #[doc(alias = "UIDatePickerStyleInline")]
    pub const Inline: Self = Self(3);
}

unsafe impl Encode for UIDatePickerStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIDatePickerStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidatepicker?language=objc)
    #[unsafe(super(UIControl, UIView, UIResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
    pub struct UIDatePicker;
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UIView",
    feature = "objc2-quartz-core"
))]
#[cfg(not(target_os = "watchos"))]
extern_conformance!(
    unsafe impl CALayerDelegate for UIDatePicker {}
);

#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl NSCoding for UIDatePicker {}
);

#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIDatePicker {}
);

#[cfg(all(
    feature = "UIAppearance",
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIAppearance for UIDatePicker {}
);

#[cfg(all(
    feature = "UIAppearance",
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIAppearanceContainer for UIDatePicker {}
);

#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UICoordinateSpace for UIDatePicker {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIDynamicBehavior",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIDynamicItem for UIDatePicker {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusEnvironment for UIDatePicker {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusItem for UIDatePicker {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusItemContainer for UIDatePicker {}
);

#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UIDatePicker {}
);

#[cfg(all(
    feature = "UIControl",
    feature = "UIResponder",
    feature = "UITraitCollection",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITraitEnvironment for UIDatePicker {}
);

#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
impl UIDatePicker {
    extern_methods!(
        #[unsafe(method(datePickerMode))]
        #[unsafe(method_family = none)]
        pub fn datePickerMode(&self) -> UIDatePickerMode;

        /// Setter for [`datePickerMode`][Self::datePickerMode].
        #[unsafe(method(setDatePickerMode:))]
        #[unsafe(method_family = none)]
        pub fn setDatePickerMode(&self, date_picker_mode: UIDatePickerMode);

        #[unsafe(method(locale))]
        #[unsafe(method_family = none)]
        pub fn locale(&self) -> Option<Retained<NSLocale>>;

        /// Setter for [`locale`][Self::locale].
        #[unsafe(method(setLocale:))]
        #[unsafe(method_family = none)]
        pub fn setLocale(&self, locale: Option<&NSLocale>);

        #[unsafe(method(calendar))]
        #[unsafe(method_family = none)]
        pub fn calendar(&self) -> Retained<NSCalendar>;

        /// Setter for [`calendar`][Self::calendar].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setCalendar:))]
        #[unsafe(method_family = none)]
        pub fn setCalendar(&self, calendar: Option<&NSCalendar>);

        #[unsafe(method(timeZone))]
        #[unsafe(method_family = none)]
        pub fn timeZone(&self) -> Option<Retained<NSTimeZone>>;

        /// Setter for [`timeZone`][Self::timeZone].
        #[unsafe(method(setTimeZone:))]
        #[unsafe(method_family = none)]
        pub fn setTimeZone(&self, time_zone: Option<&NSTimeZone>);

        #[unsafe(method(date))]
        #[unsafe(method_family = none)]
        pub fn date(&self) -> Retained<NSDate>;

        /// Setter for [`date`][Self::date].
        #[unsafe(method(setDate:))]
        #[unsafe(method_family = none)]
        pub fn setDate(&self, date: &NSDate);

        #[unsafe(method(minimumDate))]
        #[unsafe(method_family = none)]
        pub fn minimumDate(&self) -> Option<Retained<NSDate>>;

        /// Setter for [`minimumDate`][Self::minimumDate].
        #[unsafe(method(setMinimumDate:))]
        #[unsafe(method_family = none)]
        pub fn setMinimumDate(&self, minimum_date: Option<&NSDate>);

        #[unsafe(method(maximumDate))]
        #[unsafe(method_family = none)]
        pub fn maximumDate(&self) -> Option<Retained<NSDate>>;

        /// Setter for [`maximumDate`][Self::maximumDate].
        #[unsafe(method(setMaximumDate:))]
        #[unsafe(method_family = none)]
        pub fn setMaximumDate(&self, maximum_date: Option<&NSDate>);

        #[unsafe(method(countDownDuration))]
        #[unsafe(method_family = none)]
        pub fn countDownDuration(&self) -> NSTimeInterval;

        /// Setter for [`countDownDuration`][Self::countDownDuration].
        #[unsafe(method(setCountDownDuration:))]
        #[unsafe(method_family = none)]
        pub fn setCountDownDuration(&self, count_down_duration: NSTimeInterval);

        #[unsafe(method(minuteInterval))]
        #[unsafe(method_family = none)]
        pub fn minuteInterval(&self) -> NSInteger;

        /// Setter for [`minuteInterval`][Self::minuteInterval].
        #[unsafe(method(setMinuteInterval:))]
        #[unsafe(method_family = none)]
        pub fn setMinuteInterval(&self, minute_interval: NSInteger);

        #[unsafe(method(setDate:animated:))]
        #[unsafe(method_family = none)]
        pub fn setDate_animated(&self, date: &NSDate, animated: bool);

        /// Request a style for the date picker. If the style changed, then the date picker may need to be resized and will generate a layout pass to display correctly.
        #[unsafe(method(preferredDatePickerStyle))]
        #[unsafe(method_family = none)]
        pub fn preferredDatePickerStyle(&self) -> UIDatePickerStyle;

        /// Setter for [`preferredDatePickerStyle`][Self::preferredDatePickerStyle].
        #[unsafe(method(setPreferredDatePickerStyle:))]
        #[unsafe(method_family = none)]
        pub fn setPreferredDatePickerStyle(&self, preferred_date_picker_style: UIDatePickerStyle);

        /// The style that the date picker is using for its layout. This property always returns a concrete style (never automatic).
        #[unsafe(method(datePickerStyle))]
        #[unsafe(method_family = none)]
        pub fn datePickerStyle(&self) -> UIDatePickerStyle;

        /// When this property is YES,
        /// `date`will always round to the
        /// `minuteInterval,`and
        /// only emit dates that are aligned with the
        /// `minuteInterval.`Otherwise, any changes
        /// to
        /// `date`will ignore the
        /// `minuteInterval`property. Default is
        /// `YES.`
        #[unsafe(method(roundsToMinuteInterval))]
        #[unsafe(method_family = none)]
        pub fn roundsToMinuteInterval(&self) -> bool;

        /// Setter for [`roundsToMinuteInterval`][Self::roundsToMinuteInterval].
        #[unsafe(method(setRoundsToMinuteInterval:))]
        #[unsafe(method_family = none)]
        pub fn setRoundsToMinuteInterval(&self, rounds_to_minute_interval: bool);
    );
}

/// Methods declared on superclass `UIControl`.
#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
impl UIDatePicker {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame: CGRect) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[cfg(all(
            feature = "UIAction",
            feature = "UIMenuElement",
            feature = "objc2-core-foundation"
        ))]
        /// Initializes the control and adds primaryAction for the UIControlEventPrimaryActionTriggered control event. Subclasses of UIControl may alter or add behaviors around the usage of primaryAction, see subclass documentation of this initializer for additional information.
        #[unsafe(method(initWithFrame:primaryAction:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame_primaryAction(
            this: Allocated<Self>,
            frame: CGRect,
            primary_action: Option<&UIAction>,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `UIView`.
#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
impl UIDatePicker {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "UIControl", feature = "UIResponder", feature = "UIView"))]
impl UIDatePicker {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
