/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;

public class DOTExporter<V, E> {
    private VertexNameProvider<V> vertexIDProvider;
    private VertexNameProvider<V> vertexLabelProvider;
    private EdgeNameProvider<E> edgeLabelProvider;

    public DOTExporter() {
        this(new IntegerNameProvider(), null, null);
    }

    public DOTExporter(VertexNameProvider<V> vertexNameProvider, VertexNameProvider<V> vertexNameProvider2, EdgeNameProvider<E> edgeNameProvider) {
        this.vertexIDProvider = vertexNameProvider;
        this.vertexLabelProvider = vertexNameProvider2;
        this.edgeLabelProvider = edgeNameProvider;
    }

    public void export(Writer writer, Graph<V, E> graph) {
        String string;
        PrintWriter printWriter = new PrintWriter(writer);
        String string2 = "  ";
        if (graph instanceof DirectedGraph) {
            printWriter.println("digraph G {");
            string = " -> ";
        } else {
            printWriter.println("graph G {");
            string = " -- ";
        }
        for (Object object : graph.vertexSet()) {
            printWriter.print(string2 + this.vertexIDProvider.getVertexName(object));
            if (this.vertexLabelProvider != null) {
                printWriter.print(" [label = \"" + this.vertexLabelProvider.getVertexName(object) + "\"]");
            }
            printWriter.println(";");
        }
        for (Object object : graph.edgeSet()) {
            String string3 = this.vertexIDProvider.getVertexName(graph.getEdgeSource(object));
            String string4 = this.vertexIDProvider.getVertexName(graph.getEdgeTarget(object));
            printWriter.print(string2 + string3 + string + string4);
            if (this.edgeLabelProvider != null) {
                printWriter.print(" [label = \"" + this.edgeLabelProvider.getEdgeName(object) + "\"]");
            }
            printWriter.println(";");
        }
        printWriter.println("}");
        printWriter.flush();
    }
}

