/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Visitor;

public class AnnotationEntry
implements Node,
Constants,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int type_index;
    private final ConstantPool constant_pool;
    private final boolean isRuntimeVisible;
    private List<ElementValuePair> element_value_pairs;

    public static AnnotationEntry read(DataInputStream file, ConstantPool constant_pool, boolean isRuntimeVisible) throws IOException {
        AnnotationEntry annotationEntry = new AnnotationEntry(file.readUnsignedShort(), constant_pool, isRuntimeVisible);
        int num_element_value_pairs = file.readUnsignedShort();
        annotationEntry.element_value_pairs = new ArrayList<ElementValuePair>();
        for (int i = 0; i < num_element_value_pairs; ++i) {
            annotationEntry.element_value_pairs.add(new ElementValuePair(file.readUnsignedShort(), ElementValue.readElementValue(file, constant_pool), constant_pool));
        }
        return annotationEntry;
    }

    public AnnotationEntry(int type_index, ConstantPool constant_pool, boolean isRuntimeVisible) {
        this.type_index = type_index;
        this.constant_pool = constant_pool;
        this.isRuntimeVisible = isRuntimeVisible;
    }

    public int getTypeIndex() {
        return this.type_index;
    }

    public ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    public void accept(Visitor v) {
    }

    public String getAnnotationType() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.type_index, (byte)1);
        return c.getBytes();
    }

    public int getAnnotationTypeIndex() {
        return this.type_index;
    }

    public final int getNumElementValuePairs() {
        return this.element_value_pairs.size();
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.element_value_pairs.toArray(new ElementValuePair[this.element_value_pairs.size()]);
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.type_index);
        dos.writeShort(this.element_value_pairs.size());
        for (int i = 0; i < this.element_value_pairs.size(); ++i) {
            ElementValuePair envp = this.element_value_pairs.get(i);
            envp.dump(dos);
        }
    }

    public void addElementNameValuePair(ElementValuePair elementNameValuePair) {
        this.element_value_pairs.add(elementNameValuePair);
    }

    public String toShortString() {
        StringBuilder result = new StringBuilder();
        result.append("@");
        result.append(this.getAnnotationType());
        if (this.getElementValuePairs().length > 0) {
            result.append("(");
            for (int i = 0; i < this.getElementValuePairs().length; ++i) {
                ElementValuePair element = this.getElementValuePairs()[i];
                result.append(element.toShortString());
            }
            result.append(")");
        }
        return result.toString();
    }
}

