/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.binding;

import com.dlsc.gemsfx.binding.AbstractChangeTracker;
import java.util.function.Consumer;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;

public class NestedListChangeTracker<T>
extends AbstractChangeTracker<ObservableList<T>> {
    private final ListChangeListener<T> innerListListener = change -> {
        while (change.next()) {
            if (!change.wasAdded() && !change.wasRemoved()) continue;
            this.notifyChange();
            break;
        }
    };
    private final WeakListChangeListener<T> weakInnerListListener = new WeakListChangeListener(this.innerListListener);

    public NestedListChangeTracker(ObservableList<ObservableList<T>> source) {
        this(source, (Consumer<ObservableList<ObservableList<T>>>)null);
    }

    public NestedListChangeTracker(ObservableList<ObservableList<T>> source, Consumer<ObservableList<ObservableList<T>>> onChanged) {
        super(source, onChanged);
        this.initOuterListener();
    }

    @Override
    protected void safeAddListener(ObservableList<T> value) {
        if (value != null) {
            value.addListener(this.weakInnerListListener);
        }
    }

    @Override
    protected void safeRemoveListener(ObservableList<T> value) {
        if (value != null) {
            value.removeListener(this.weakInnerListListener);
        }
    }
}

