/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.AvatarView;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import org.apache.commons.lang3.StringUtils;

public class AvatarViewSkin
extends SkinBase<AvatarView> {
    private final StackPane imageWrapper;
    private final StackPane textWrapper;
    private final StackPane iconWrapper;
    private final ChangeListener<Number> progressChangeListener = (ob, ov, nv) -> {
        if (nv.intValue() == 1) {
            this.updateView();
        }
    };

    public AvatarViewSkin(AvatarView avatar) {
        super((Control)avatar);
        Region icon = new Region();
        icon.getStyleClass().add((Object)"icon");
        this.iconWrapper = this.createWrapperStackPane((Node)icon);
        this.iconWrapper.getStyleClass().add((Object)"icon-wrapper");
        ImageView imageView = new ImageView();
        imageView.getStyleClass().add((Object)"inner-image");
        imageView.imageProperty().bind(avatar.imageProperty());
        imageView.setSmooth(true);
        imageView.setPreserveRatio(true);
        DoubleBinding scale = Bindings.createDoubleBinding(() -> {
            Image image = avatar.getImage();
            if (image != null) {
                return avatar.getSize() / Math.min(image.getWidth(), image.getHeight());
            }
            return 1.0;
        }, (Observable[])new Observable[]{avatar.sizeProperty(), avatar.imageProperty()});
        imageView.scaleXProperty().bind((ObservableValue)scale);
        imageView.scaleYProperty().bind((ObservableValue)scale);
        Group imageGroup = new Group(new Node[]{imageView});
        this.imageWrapper = this.createWrapperStackPane((Node)imageGroup);
        this.imageWrapper.getStyleClass().add((Object)"image-wrapper");
        Text initialsText = new Text();
        initialsText.getStyleClass().add((Object)"initials-text");
        initialsText.textProperty().bind((ObservableValue)avatar.initialsProperty());
        this.textWrapper = this.createWrapperStackPane((Node)initialsText);
        this.textWrapper.getStyleClass().add((Object)"text-wrapper");
        ChangeListener imageChangeListener = (ob, oldImage, newImage) -> {
            if (oldImage != null) {
                oldImage.progressProperty().removeListener(this.progressChangeListener);
            }
            if (newImage != null) {
                newImage.progressProperty().addListener(this.progressChangeListener);
            }
            this.updateView();
        };
        avatar.imageProperty().addListener(imageChangeListener);
        Image image = avatar.getImage();
        if (image != null && image.isBackgroundLoading()) {
            image.progressProperty().addListener(this.progressChangeListener);
        }
        InvalidationListener updateViewListener = it -> this.updateView();
        avatar.imageProperty().addListener(updateViewListener);
        avatar.initialsProperty().addListener(updateViewListener);
        this.createClipBinding((Node)this.iconWrapper);
        this.createClipBinding((Node)this.textWrapper);
        this.createClipBinding((Node)this.imageWrapper);
        this.updateView();
    }

    private StackPane createWrapperStackPane(Node child) {
        AvatarView avatar = (AvatarView)this.getSkinnable();
        StackPane stackPane = new StackPane(new Node[]{child});
        stackPane.getStyleClass().add((Object)"wrapper-stack-pane");
        stackPane.prefWidthProperty().bind((ObservableValue)avatar.sizeProperty());
        stackPane.prefWidthProperty().bind((ObservableValue)avatar.sizeProperty());
        stackPane.minWidthProperty().bind((ObservableValue)avatar.sizeProperty());
        stackPane.minHeightProperty().bind((ObservableValue)avatar.sizeProperty());
        stackPane.maxWidthProperty().bind((ObservableValue)avatar.sizeProperty());
        stackPane.maxHeightProperty().bind((ObservableValue)avatar.sizeProperty());
        return stackPane;
    }

    private void createClipBinding(Node node) {
        AvatarView avatarView = (AvatarView)this.getSkinnable();
        node.clipProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            AvatarView.AvatarShape shape = avatarView.getAvatarShape();
            if (shape == AvatarView.AvatarShape.ROUND) {
                DoubleBinding sizeBinding = avatarView.sizeProperty().divide(2);
                Circle clipShape = new Circle();
                clipShape.centerXProperty().bind((ObservableValue)sizeBinding);
                clipShape.centerYProperty().bind((ObservableValue)sizeBinding);
                clipShape.radiusProperty().bind((ObservableValue)sizeBinding);
                return clipShape;
            }
            Rectangle rectangle = new Rectangle();
            rectangle.widthProperty().bind((ObservableValue)avatarView.widthProperty());
            rectangle.heightProperty().bind((ObservableValue)avatarView.heightProperty());
            rectangle.arcWidthProperty().bind((ObservableValue)avatarView.arcSizeProperty());
            rectangle.arcHeightProperty().bind((ObservableValue)avatarView.arcSizeProperty());
            return rectangle;
        }, (Observable[])new Observable[]{avatarView.avatarShapeProperty()}));
    }

    private void updateView() {
        AvatarView avatarView = (AvatarView)this.getSkinnable();
        Image image = avatarView.getImage();
        if (image != null && (!image.isBackgroundLoading() || image.getProgress() >= 1.0)) {
            this.getChildren().setAll((Object[])new Node[]{this.imageWrapper});
        } else if (StringUtils.isNotBlank((CharSequence)avatarView.getInitials())) {
            this.getChildren().setAll((Object[])new Node[]{this.textWrapper});
        } else {
            this.getChildren().setAll((Object[])new Node[]{this.iconWrapper});
        }
    }
}

