/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.treeview.link;

import com.dlsc.gemsfx.treeview.TreeNodeView;
import com.dlsc.gemsfx.treeview.link.AbstractLinkStrategy;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public class ClockHandLinkStrategy<T>
extends AbstractLinkStrategy<T> {
    @Override
    protected ArrayList<Node> drawLink(TreeNodeView.LayoutDirection direction, double maxDimensionInLine, double startX, double startY, double endX, double endY, double vgap, double hgap) {
        Path path = new Path();
        path.getStyleClass().add((Object)"link-path");
        double tailCircleRadius = 4.0;
        double startWidth = 2.5;
        double endWidth = 0.5;
        Circle tailCircle = new Circle(startX, startY, tailCircleRadius);
        tailCircle.getStyleClass().add((Object)"link-circle");
        double angle = this.calculateAngle();
        double startOffsetX = startWidth * Math.sin(Math.toRadians(angle));
        double startOffsetY = -startWidth * Math.cos(Math.toRadians(angle));
        double endOffsetX = endWidth * Math.sin(Math.toRadians(angle));
        double endOffsetY = -endWidth * Math.cos(Math.toRadians(angle));
        path.getElements().add((Object)new MoveTo(startX + startOffsetX, startY + startOffsetY));
        path.getElements().add((Object)new LineTo(endX + endOffsetX, endY + endOffsetY));
        path.getElements().add((Object)new LineTo(endX - endOffsetX, endY - endOffsetY));
        path.getElements().add((Object)new LineTo(startX - startOffsetX, startY - startOffsetY));
        path.getElements().add((Object)new ClosePath());
        return new ArrayList<Path>(List.of(tailCircle, path));
    }
}

