/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.util;

import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceBundleManager {
    private static final Logger LOG = Logger.getLogger(ResourceBundleManager.class.getName());
    private static final Map<String, ResourceBundle> BUNDLES = new ConcurrentHashMap<String, ResourceBundle>();
    private static Locale currentLocale = Locale.getDefault();

    private ResourceBundleManager() {
    }

    public static ResourceBundle getBundle(String baseName) {
        return BUNDLES.computeIfAbsent(ResourceBundleManager.key(baseName, currentLocale), k -> ResourceBundle.getBundle(baseName, currentLocale, ResourceBundleManager.class.getClassLoader()));
    }

    public static void setLocale(Locale locale) {
        if (!locale.equals(currentLocale)) {
            currentLocale = locale;
            BUNDLES.clear();
        }
    }

    private static String key(String baseName, Locale locale) {
        return baseName + "_" + locale.toString();
    }

    public static String getString(String baseName, String key) {
        try {
            ResourceBundle bundle = ResourceBundleManager.getBundle(baseName);
            return bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            LOG.log(Level.WARNING, "Missing resource key: " + key, ex);
            return key;
        }
    }

    public static String getString(Type type, String key) {
        return ResourceBundleManager.getString(type.getBaseName(), key);
    }

    public static enum Type {
        INFO_CENTER_VIEW("info-center-view"),
        NOTIFICATION_VIEW("notification-view");

        private final String baseName;

        private Type(String baseName) {
            this.baseName = baseName;
        }

        public String getBaseName() {
            return this.baseName;
        }
    }
}

