/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;

class AccumulatingStream<T, U>
extends EventStreamBase<U> {
    private final EventStream<T> input;
    private final Function<? super T, ? extends U> initialTransformation;
    private final BiFunction<? super U, ? super T, ? extends U> reduction;
    private boolean hasEvent = false;
    private U event = null;

    public AccumulatingStream(EventStream<T> input, Function<? super T, ? extends U> initial, BiFunction<? super U, ? super T, ? extends U> reduction) {
        this.input = input;
        this.initialTransformation = initial;
        this.reduction = reduction;
    }

    @Override
    protected final Subscription observeInputs() {
        return this.input.subscribe(i -> {
            this.event = this.hasEvent ? this.reduction.apply(this.event, i) : this.initialTransformation.apply(i);
            this.hasEvent = true;
            this.emit(this.event);
        });
    }
}

