/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import javafx.beans.value.ObservableValue;
import org.reactfx.Subscription;
import org.reactfx.collection.LiveListBase;
import org.reactfx.collection.UnmodifiableByDefaultLiveList;
import org.reactfx.util.Lists;
import org.reactfx.value.Val;

class ValAsList<T>
extends LiveListBase<T>
implements UnmodifiableByDefaultLiveList<T> {
    private final ObservableValue<T> underlying;

    ValAsList(ObservableValue<T> underlying) {
        this.underlying = underlying;
    }

    @Override
    public int size() {
        return this.underlying.getValue() == null ? 0 : 1;
    }

    @Override
    public T get(int index) {
        Lists.checkIndex(index, this.size());
        return (T)this.underlying.getValue();
    }

    @Override
    protected Subscription observeInputs() {
        return Val.observeChanges(this.underlying, (obs, oldVal, newVal) -> {
            if (oldVal == null) {
                assert (newVal != null);
                this.fireElemInsertion(0);
            } else if (newVal == null) {
                assert (oldVal != null);
                this.fireElemRemoval(0, oldVal);
            } else {
                this.fireElemReplacement(0, oldVal);
            }
        });
    }
}

