/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.transports;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.SASL;
import org.freedesktop.dbus.connections.config.SaslConfig;
import org.freedesktop.dbus.exceptions.AuthenticationException;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.spi.message.IMessageReader;
import org.freedesktop.dbus.spi.message.IMessageWriter;
import org.freedesktop.dbus.spi.message.ISocketProvider;
import org.freedesktop.dbus.spi.message.InputStreamMessageReader;
import org.freedesktop.dbus.spi.message.OutputStreamMessageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransport
implements Closeable {
    private final ServiceLoader<ISocketProvider> spiLoader = ServiceLoader.load(ISocketProvider.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BusAddress address;
    private IMessageReader inputReader;
    private IMessageWriter outputWriter;
    private boolean fileDescriptorSupported;
    private final SaslConfig saslConfig;
    private Consumer<AbstractTransport> preConnectCallback;

    protected AbstractTransport(BusAddress _address) {
        this.address = _address;
        this.saslConfig = new SaslConfig();
        if (_address.isListeningSocket()) {
            this.saslConfig.setMode(SASL.SaslMode.SERVER);
        } else {
            this.saslConfig.setMode(SASL.SaslMode.CLIENT);
        }
        this.saslConfig.setAuthMode(0);
        this.saslConfig.setGuid(this.address.getGuid());
    }

    public void writeMessage(Message _msg) throws IOException {
        if (!this.fileDescriptorSupported && 104 == _msg.getType()) {
            throw new IllegalArgumentException("File descriptors are not supported!");
        }
        if (this.outputWriter == null || this.outputWriter.isClosed()) {
            throw new IOException("OutputWriter already closed or null");
        }
        this.outputWriter.writeMessage(_msg);
    }

    public Message readMessage() throws IOException, DBusException {
        if (this.inputReader != null && !this.inputReader.isClosed()) {
            return this.inputReader.readMessage();
        }
        throw new IOException("InputReader already closed or null");
    }

    public synchronized boolean isConnected() {
        return this.outputWriter != null && !this.outputWriter.isClosed() && this.inputReader != null && !this.inputReader.isClosed();
    }

    protected abstract boolean hasFileDescriptorSupport();

    @Deprecated(forRemoval=true, since="4.2.0 - 2022-07-18")
    protected abstract boolean isAbstractAllowed();

    protected abstract SocketChannel connectImpl() throws IOException;

    public final SocketChannel connect() throws IOException {
        if (this.preConnectCallback != null) {
            this.preConnectCallback.accept(this);
        }
        SocketChannel channel = this.connectImpl();
        this.authenticate(channel);
        this.setInputOutput(channel);
        return channel;
    }

    public void setPreConnectCallback(Consumer<AbstractTransport> _run) {
        this.preConnectCallback = _run;
    }

    private void authenticate(SocketChannel _sock) throws IOException {
        SASL sasl = new SASL(this.hasFileDescriptorSupport());
        try {
            if (!sasl.auth(this.saslConfig, _sock, this)) {
                throw new AuthenticationException("Failed to authenticate");
            }
        }
        catch (IOException e) {
            _sock.close();
            throw e;
        }
        this.fileDescriptorSupported = sasl.isFileDescriptorSupported();
    }

    private void setInputOutput(SocketChannel _socket) {
        try {
            for (ISocketProvider provider : this.spiLoader) {
                this.logger.debug("Found ISocketProvider {}", (Object)provider);
                provider.setFileDescriptorSupport(this.hasFileDescriptorSupport() && this.fileDescriptorSupported);
                this.inputReader = provider.createReader(_socket);
                this.outputWriter = provider.createWriter(_socket);
                if (this.inputReader == null || this.outputWriter == null) continue;
                this.logger.debug("Using ISocketProvider {}", (Object)provider);
                break;
            }
        }
        catch (ServiceConfigurationError _ex) {
            this.logger.error("Could not initialize service provider", (Throwable)_ex);
        }
        catch (IOException _ex) {
            this.logger.error("Could not initialize alternative message reader/writer", (Throwable)_ex);
        }
        if (this.inputReader == null || this.outputWriter == null) {
            this.logger.debug("No alternative ISocketProvider found, using built-in implementation");
            this.inputReader = new InputStreamMessageReader(_socket);
            this.outputWriter = new OutputStreamMessageWriter(_socket);
            this.fileDescriptorSupported = false;
        }
    }

    protected BusAddress getAddress() {
        return this.address;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected SaslConfig getSaslConfig() {
        return this.saslConfig;
    }

    @Deprecated(since="4.2.0 - 2022-07-22", forRemoval=true)
    protected int getSaslAuthMode() {
        return this.getSaslConfig().getAuthMode();
    }

    @Deprecated(since="4.2.0 - 2022-07-22", forRemoval=true)
    protected SASL.SaslMode getSaslMode() {
        return this.getSaslConfig().getMode();
    }

    @Deprecated(since="4.2.0 - 2022-07-22", forRemoval=true)
    protected void setSaslMode(SASL.SaslMode _saslMode) {
        this.getSaslConfig().setMode(_saslMode);
    }

    @Deprecated(since="4.2.0 - 2022-07-22", forRemoval=true)
    protected void setSaslAuthMode(int _mode) {
        this.getSaslConfig().setAuthMode(_mode);
    }

    @Override
    public void close() throws IOException {
        if (this.inputReader != null) {
            this.inputReader.close();
            this.inputReader = null;
        }
        if (this.outputWriter != null) {
            this.outputWriter.close();
            this.outputWriter = null;
        }
    }
}

