/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.distribution.Distribution;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.application.CreateStartScripts;
import org.gradle.util.GradleVersion;
import org.javamodularity.moduleplugin.extensions.PatchModuleContainer;
import org.javamodularity.moduleplugin.extensions.RunModuleOptions;
import org.javamodularity.moduleplugin.internal.TaskOption;
import org.javamodularity.moduleplugin.tasks.AbstractExecutionMutator;

public class StartScriptsMutator
extends AbstractExecutionMutator {
    private static final Logger LOGGER = Logging.getLogger(StartScriptsMutator.class);
    private static final String LIBS_PLACEHOLDER = "APP_HOME_LIBS_PLACEHOLDER";
    private static final String PATCH_LIBS_PLACEHOLDER = "APP_HOME_PATCH_LIBS_PLACEHOLDER";
    private static final Pattern APP_OPTS_VARIABLE_NAME = Pattern.compile("(?s).*\\$DEFAULT_JVM_OPTS \\$JAVA_OPTS \\$(\\w+).*");

    public StartScriptsMutator(JavaExec execTask, Project project) {
        super(execTask, project);
    }

    public void updateStartScriptsTask(String taskStartScriptsName) {
        CreateStartScripts startScriptsTask = this.helper().task(taskStartScriptsName, CreateStartScripts.class);
        this.updateStartScriptsTask(startScriptsTask);
    }

    public void updateStartScriptsTask(final CreateStartScripts startScriptsTask) {
        startScriptsTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                StartScriptsMutator.this.configureStartScriptsDoFirst(startScriptsTask);
            }
        });
        startScriptsTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                StartScriptsMutator.this.configureStartScriptsDoLast((CreateStartScripts)task);
            }
        });
    }

    private void configureStartScriptsDoLast(CreateStartScripts startScriptsTask) {
        this.replaceLibsPlaceHolders(startScriptsTask);
        this.removeClasspathArgs(startScriptsTask);
    }

    private void configureStartScriptsDoFirst(CreateStartScripts startScriptsTask) {
        List<String> jvmArgs = this.buildStartScriptsJvmArgs(startScriptsTask);
        startScriptsTask.setDefaultJvmOpts(jvmArgs);
        startScriptsTask.setClasspath((FileCollection)this.project.files(new Object[0]));
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) < 0 && "<undefined>".equals(startScriptsTask.getMainClassName())) {
            startScriptsTask.setMainClassName(this.execTask.getMain());
        }
    }

    private List<String> buildStartScriptsJvmArgs(CreateStartScripts startScriptsTask) {
        ArrayList<String> jvmArgs = new ArrayList<String>();
        RunModuleOptions moduleOptions = (RunModuleOptions)this.execTask.getExtensions().getByType(RunModuleOptions.class);
        moduleOptions.mutateArgs(jvmArgs);
        PatchModuleContainer patchModuleContainer = this.helper().modularityExtension().optionContainer().getPatchModuleContainer();
        patchModuleContainer.mutator(jarName -> "APP_HOME_PATCH_LIBS_PLACEHOLDER/" + jarName).mutateArgs(jvmArgs);
        startScriptsTask.getDefaultJvmOpts().forEach(jvmArgs::add);
        new TaskOption("--module-path", LIBS_PLACEHOLDER).mutateArgs(jvmArgs);
        new TaskOption("--module", this.getMainClassName()).mutateArgs(jvmArgs);
        return jvmArgs;
    }

    private void replaceLibsPlaceHolders(CreateStartScripts startScriptsTask) {
        Path outputDir = startScriptsTask.getOutputDir().toPath();
        Path bashScript = outputDir.resolve(startScriptsTask.getApplicationName());
        StartScriptsMutator.replaceLibsPlaceHolder(bashScript, "\\$APP_HOME/lib", "\\$APP_HOME/patchlibs");
        Path batFile = outputDir.resolve(startScriptsTask.getApplicationName() + ".bat");
        StartScriptsMutator.replaceLibsPlaceHolder(batFile, "%APP_HOME%\\\\lib", "%APP_HOME%\\\\patchlibs");
    }

    public void movePatchedLibs() {
        List<String> patchedJarNames = this.helper().modularityExtension().optionContainer().getPatchModuleContainer().patchedJarNames();
        if (patchedJarNames.isEmpty()) {
            return;
        }
        Distribution mainDistribution = (Distribution)this.helper().extension("distributions", DistributionContainer.class).getByName("main");
        mainDistribution.contents(copySpec -> copySpec.filesMatching((Iterable)patchedJarNames, this::updateRelativePath));
    }

    private void updateRelativePath(FileCopyDetails fileCopyDetails) {
        RelativePath updatedRelativePath = fileCopyDetails.getRelativePath().getParent().getParent().append(true, new String[]{"patchlibs", fileCopyDetails.getName()});
        fileCopyDetails.setRelativePath(updatedRelativePath);
    }

    private void removeClasspathArgs(CreateStartScripts startScriptsTask) {
        Path outputDir = startScriptsTask.getOutputDir().toPath();
        Path bashScript = outputDir.resolve(startScriptsTask.getApplicationName());
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.2")) < 0) {
            StartScriptsMutator.replaceScriptContent(bashScript, "eval set -- \\$DEFAULT_JVM_OPTS \\$JAVA_OPTS \\$(\\S+).*", "eval set -- \\$JAVA_OPTS \\$$1 \\$DEFAULT_JVM_OPTS \\\"\\$APP_ARGS\\\"");
        } else {
            StartScriptsMutator.replaceScriptContent(bashScript, "app_path=\\$0", "app_path=\\$0\nAPP_ARGS=`echo \"\\$@\"`");
            String appOpts = StartScriptsMutator.getAppOptsVariableName(bashScript);
            StartScriptsMutator.replaceScriptContent(bashScript, "exec \"\\$JAVACMD\" \"\\$@\"", "eval set -- \\$JAVA_OPTS " + appOpts + " \\$DEFAULT_JVM_OPTS \\\"\\$APP_ARGS\\\"\nexec \"\\$JAVACMD\" \"\\$@\"");
        }
        Path batFile = outputDir.resolve(startScriptsTask.getApplicationName() + ".bat");
        StartScriptsMutator.replaceScriptContent(batFile, "\"%JAVA_EXE%\" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %(\\S+)%.*", "\"%JAVA_EXE%\" %JAVA_OPTS% %$1% %DEFAULT_JVM_OPTS% %*");
    }

    private static void replaceLibsPlaceHolder(Path path, String libText, String patchLibText) {
        try {
            String content = StartScriptsMutator.getContent(path);
            String updatedScriptContent = content.replaceAll(LIBS_PLACEHOLDER, libText).replaceAll(PATCH_LIBS_PLACEHOLDER, patchLibText);
            Files.writeString(path, (CharSequence)updatedScriptContent, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new GradleException("Couldn't replace placeholder in " + path, (Throwable)e);
        }
    }

    private static String getContent(Path path) {
        try {
            return Files.readString(path);
        }
        catch (IOException e) {
            try {
                Charset cs = Charset.forName(System.getProperty("file.encoding"));
                return Files.readString(path, cs);
            }
            catch (Exception ex) {
                throw new GradleException("Cannot read the content of " + path, (Throwable)ex);
            }
        }
    }

    private static String getAppOptsVariableName(Path path) {
        try {
            Matcher m = APP_OPTS_VARIABLE_NAME.matcher(Files.readString(path));
            if (m.matches()) {
                return "\\$" + m.group(1);
            }
        }
        catch (IOException e) {
            throw new GradleException("Couldn't read run script in " + path);
        }
        return "";
    }

    private static void replaceScriptContent(Path path, String regex, String replacement) {
        try {
            String updatedScriptContent = Files.readString(path).replaceAll(regex, replacement);
            Files.writeString(path, (CharSequence)updatedScriptContent, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new GradleException("Couldn't update run script in " + path);
        }
    }
}

