//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// The alert styles used by the `alertStyle` property on instances of `NSAlert`.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsalertstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSAlertStyle(pub NSUInteger);
impl NSAlertStyle {
    /// An alert style to be used to warn the user about a current or impending event.
    /// This style should be used when the alert’s content is more severe than `NSAlertStyleInformational` but less than `NSAlertStyleCritical`.
    /// This is the default alert style.
    #[doc(alias = "NSAlertStyleWarning")]
    pub const Warning: Self = Self(0);
    /// An alert style to be used to inform the user about a current or impending event.
    /// - Note: Currently, there is no visual difference between informational and warning alerts.
    #[doc(alias = "NSAlertStyleInformational")]
    pub const Informational: Self = Self(1);
    /// An alert style to be used to inform the user about a critical event.
    /// Causes the alert’s icon to be badged with a caution icon.
    /// The critical (or “caution”) style should be used sparingly. Using it too frequently diminishes its significance. Use the symbol only when extra attention is really needed, as when confirming an action that might result in unexpected loss of data. Don’t use the symbol for tasks whose only purpose is to overwrite or remove data, such as a save or empty trash.
    #[doc(alias = "NSAlertStyleCritical")]
    pub const Critical: Self = Self(2);
}

unsafe impl Encode for NSAlertStyle {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSAlertStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsalertfirstbuttonreturn?language=objc)
#[cfg(feature = "NSApplication")]
pub static NSAlertFirstButtonReturn: NSModalResponse = 1000;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsalertsecondbuttonreturn?language=objc)
#[cfg(feature = "NSApplication")]
pub static NSAlertSecondButtonReturn: NSModalResponse = 1001;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsalertthirdbuttonreturn?language=objc)
#[cfg(feature = "NSApplication")]
pub static NSAlertThirdButtonReturn: NSModalResponse = 1002;

extern_class!(
    /// A modal dialog or sheet attached to a document window.
    /// The `NSAlert` class is not designed for subclassing.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsalert?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSAlert;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSAlert {}
);

impl NSAlert {
    extern_methods!(
        /// Returns an alert initialized from information in an error object.
        /// - Parameter error: Error information to display.
        /// - Returns: An initialized alert.
        /// - Note: The `NSAlert` class extracts the localized error description, recovery suggestion, and recovery options from the error parameter and uses them as the alert’s message text, informative text, and button titles, respectively.
        #[unsafe(method(alertWithError:))]
        #[unsafe(method_family = none)]
        pub fn alertWithError(error: &NSError, mtm: MainThreadMarker) -> Retained<NSAlert>;

        /// The text that is displayed prominently in the alert.
        /// - Note: Use this string to get the user’s attention and communicate the reason for displaying the alert.
        #[unsafe(method(messageText))]
        #[unsafe(method_family = none)]
        pub fn messageText(&self) -> Retained<NSString>;

        /// Setter for [`messageText`][Self::messageText].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setMessageText:))]
        #[unsafe(method_family = none)]
        pub fn setMessageText(&self, message_text: &NSString);

        /// The descriptive text that provides more details about the reason for the alert.
        /// - Note: The informative text string is displayed below the message text and is less prominent. Use this string to provide additional context about the reason for the alert or about the actions that the user might take.
        #[unsafe(method(informativeText))]
        #[unsafe(method_family = none)]
        pub fn informativeText(&self) -> Retained<NSString>;

        /// Setter for [`informativeText`][Self::informativeText].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setInformativeText:))]
        #[unsafe(method_family = none)]
        pub fn setInformativeText(&self, informative_text: &NSString);

        #[cfg(feature = "NSImage")]
        /// The custom icon displayed in the alert.
        /// By default, the image used in an alert is the app icon (`NSApplicationIcon`). If this property’s value is set, the specified custom image is used in place of the app icon.
        /// If a custom alert icon had been set, it can be cleared by setting this property’s value to `nil`, which restores use of the app icon for the alert.
        #[unsafe(method(icon))]
        #[unsafe(method_family = none)]
        pub fn icon(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`icon`][Self::icon].
        ///
        /// # Safety
        ///
        /// `icon` might not allow `None`.
        #[unsafe(method(setIcon:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setIcon(&self, icon: Option<&NSImage>);

        #[cfg(all(
            feature = "NSButton",
            feature = "NSControl",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        /// Adds a button with a given title to the alert.
        ///
        /// Buttons should be added from most-to-least prominent. The exact visual arrangement of the buttons is determined by `NSAlert` internally. In general, they are arranged from trailing-to-leading edge when laid out horizontally, and top-to-bottom when laid out vertically, with some exceptions for buttons like “Cancel”.
        ///
        /// The first three buttons are identified by the order in which they are added (not the order in which they may appear visually) as `NSAlertFirstButtonReturn`, `NSAlertSecondButtonReturn`, `NSAlertThirdButtonReturn` in the return-code parameter. Subsequent buttons are identified as `NSAlertThirdButtonReturn` + *n*, where *n* is an integer.
        ///
        /// By default, the first button has a key equivalent of Return, any button with a title of “Cancel” has a key equivalent of Escape, and any button with the title “Don’t Save” has a key equivalent of Command-D (but only if it’s not the first button). You can also assign different key equivalents for the buttons using the `keyEquivalent` method of the `NSButton` class. In addition, you can use the `tag` property of the `NSButton` class to set the alert presentation’s return-code. The framework reserves the use of the button’s `target` and `action`.
        ///
        /// - Parameter title: Title of the button to add to the alert.
        /// - Returns: The button that was added to the alert.
        #[unsafe(method(addButtonWithTitle:))]
        #[unsafe(method_family = none)]
        pub fn addButtonWithTitle(&self, title: &NSString) -> Retained<NSButton>;

        #[cfg(all(
            feature = "NSButton",
            feature = "NSControl",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        /// The array of response buttons for the alert.
        /// The buttons are in the order in which they were added, and do not necessarily reflect the order they are arranged visually. The array does not include the default “OK” button that is shown in an alert presented without any buttons added with `-addButtonWithTitle:`.
        #[unsafe(method(buttons))]
        #[unsafe(method_family = none)]
        pub fn buttons(&self) -> Retained<NSArray<NSButton>>;

        /// Indicates the alert’s severity level. See the `NSAlertStyle` enumeration for the list of alert style constants.
        #[unsafe(method(alertStyle))]
        #[unsafe(method_family = none)]
        pub fn alertStyle(&self) -> NSAlertStyle;

        /// Setter for [`alertStyle`][Self::alertStyle].
        #[unsafe(method(setAlertStyle:))]
        #[unsafe(method_family = none)]
        pub fn setAlertStyle(&self, alert_style: NSAlertStyle);

        /// Specifies whether the alert has a help button.
        ///
        /// Set this property’s value to `YES` to specify that the alert has a help button, or `NO` to specify it does not.
        ///
        /// When a user clicks an alert’s help button, the alert delegate (`delegate`) receives an `alertShowHelp:` message. The delegate is responsible for displaying the help information related to this particular alert.
        ///
        /// Clicking an alert’s help button can alternately cause the `-openHelpAnchor:inBook:` message to be sent to the app’s help manager with a `nil` book and the anchor specified by the `helpAnchor` property, if any of the following conditions are true:
        /// - There is no alert delegate.
        /// - The alert delegate does not implement `-alertShowHelp:`.
        /// - The alert delegate implements `-alertShowHelp:` but returns `NO`. When this is the case, an exception is raised if no help anchor is set.
        #[unsafe(method(showsHelp))]
        #[unsafe(method_family = none)]
        pub fn showsHelp(&self) -> bool;

        /// Setter for [`showsHelp`][Self::showsHelp].
        #[unsafe(method(setShowsHelp:))]
        #[unsafe(method_family = none)]
        pub fn setShowsHelp(&self, shows_help: bool);

        #[cfg(feature = "NSHelpManager")]
        /// The alert’s HTML help anchor used when the user clicks the alert’s help button
        #[unsafe(method(helpAnchor))]
        #[unsafe(method_family = none)]
        pub fn helpAnchor(&self) -> Option<Retained<NSHelpAnchorName>>;

        #[cfg(feature = "NSHelpManager")]
        /// Setter for [`helpAnchor`][Self::helpAnchor].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setHelpAnchor:))]
        #[unsafe(method_family = none)]
        pub fn setHelpAnchor(&self, help_anchor: Option<&NSHelpAnchorName>);

        /// The delegate of the receiver, currently only allows for custom help behavior of the alert.
        /// For apps linked against 10.12, this property has zeroing weak memory semantics. When linked against an older SDK this back to having `retain` semantics, matching legacy behavior.
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSAlertDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn NSAlertDelegate>>);

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        /// The accessory view displayed in the alert, placed between the informative text or suppression checkbox (if present) and the response buttons. Before changing the location of the accessory view, first call the `-layout` method.
        #[unsafe(method(accessoryView))]
        #[unsafe(method_family = none)]
        pub fn accessoryView(&self) -> Option<Retained<NSView>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        /// Setter for [`accessoryView`][Self::accessoryView].
        #[unsafe(method(setAccessoryView:))]
        #[unsafe(method_family = none)]
        pub fn setAccessoryView(&self, accessory_view: Option<&NSView>);

        /// Specifies that the alert must do immediate layout instead of lazily just before display.
        /// Used to indicate that the alert panel should do immediate layout, overriding the default behavior of laying out lazily just before showing panel. Only call this method if wanting to do custom layout after it returns. Call this method only after the alert’s other customization, including setting message and informative text, and adding buttons and an accessory view if needed. Layout changes can be made after this method returns, in particular to adjust the frame of an accessory view. Note that the standard layout of the alert may change in the future, so layout customization should be done with caution.
        #[unsafe(method(layout))]
        #[unsafe(method_family = none)]
        pub fn layout(&self);

        #[cfg(feature = "NSApplication")]
        /// Runs the alert as an app-modal dialog and returns the constant that identifies the button clicked.
        #[unsafe(method(runModal))]
        #[unsafe(method_family = none)]
        pub fn runModal(&self) -> NSModalResponse;

        /// Specifies whether the alert includes a suppression checkbox, which can be employed to allow a user to opt out of seeing the alert again.
        /// The default value of this property is `NO`, which specifies the absence of a suppression checkbox in the alert. Set the value to `YES` to show a suppression checkbox in the alert.
        /// By default, a suppression checkbox has the title, “Do not show this message again.” In macOS 11.0 and later, if the alert displays multiple buttons that prompt the user to make a choice, the title is “Do not ask again.” To customize it, use the checkbox’s title property, as follows:
        ///
        /// myAlert.suppressionButton.title =
        /// "
        /// Do not show this warning again";
        ///
        /// To create an alert that responds to the selection state of the suppression checkbox, check `myAlert.suppressionButton.state`.
        #[unsafe(method(showsSuppressionButton))]
        #[unsafe(method_family = none)]
        pub fn showsSuppressionButton(&self) -> bool;

        /// Setter for [`showsSuppressionButton`][Self::showsSuppressionButton].
        #[unsafe(method(setShowsSuppressionButton:))]
        #[unsafe(method_family = none)]
        pub fn setShowsSuppressionButton(&self, shows_suppression_button: bool);

        #[cfg(all(
            feature = "NSButton",
            feature = "NSControl",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        /// The alert’s suppression checkbox. The checkbox may be customized, including the title and the initial state. Additionally, use this method to get the state of the button after the alert is dismissed, which may be stored in user defaults and checked before showing the alert again. In order to show the suppression button in the alert panel, you must set `showsSuppressionButton` to `YES`.
        #[unsafe(method(suppressionButton))]
        #[unsafe(method_family = none)]
        pub fn suppressionButton(&self) -> Option<Retained<NSButton>>;

        #[cfg(all(
            feature = "NSApplication",
            feature = "NSResponder",
            feature = "NSWindow",
            feature = "block2"
        ))]
        /// Runs the alert modally as a sheet attached to the specified window.
        /// - Parameters:
        /// - sheetWindow: The window on which to display the sheet.
        /// - handler: The completion handler that gets called when the sheet’s modal session ends.
        ///
        /// This method uses the `NSWindow` sheet methods to display the alert. If the alert has an alert style of `NSCriticalAlertStyle`, it is presented as a critical sheet, which means that it can display on top of other sheets that might already be attached to the window. Otherwise, it is presented--or queued for presentation--as a standard sheet.
        /// Note that `-orderOut:` no longer needs to be called in the completion handler. If the alert isn’t  don’t dismiss the alert, it will be done for you after the completion handler finishes.
        #[unsafe(method(beginSheetModalForWindow:completionHandler:))]
        #[unsafe(method_family = none)]
        pub fn beginSheetModalForWindow_completionHandler(
            &self,
            sheet_window: &NSWindow,
            handler: Option<&block2::DynBlock<dyn Fn(NSModalResponse)>>,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSWindow"))]
        /// The app-modal panel or document-modal sheet that corresponds to the alert
        #[unsafe(method(window))]
        #[unsafe(method_family = none)]
        pub fn window(&self) -> Retained<NSWindow>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSAlert {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// A set of optional methods implemented by the delegate of an `NSAlert` object to respond to a user’s request for help.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsalertdelegate?language=objc)
    pub unsafe trait NSAlertDelegate: NSObjectProtocol + MainThreadOnly {
        /// Sent to the delegate when the user clicks the alert’s help button. The delegate causes help to be displayed for an alert, directly or indirectly.
        /// - Returns: `YES` when the delegate displayed help directly, `NO` otherwise. When `NO` and the alert has a help anchor (`helpAnchor`), the application’s help manager displays help using the help anchor.
        /// - Discussion: The delegate implements this method only to override the help-anchor lookup behavior.
        #[optional]
        #[unsafe(method(alertShowHelp:))]
        #[unsafe(method_family = none)]
        fn alertShowHelp(&self, alert: &NSAlert) -> bool;
    }
);

/// NSAlertDeprecated.
impl NSAlert {
    extern_methods!(
        #[cfg(all(feature = "NSResponder", feature = "NSWindow"))]
        /// # Safety
        ///
        /// - `delegate` should be of the correct type.
        /// - `did_end_selector` must be a valid selector.
        /// - `context_info` must be a valid pointer or null.
        #[deprecated = "Use -beginSheetModalForWindow:completionHandler: instead"]
        #[unsafe(method(beginSheetModalForWindow:modalDelegate:didEndSelector:contextInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn beginSheetModalForWindow_modalDelegate_didEndSelector_contextInfo(
            &self,
            window: &NSWindow,
            delegate: Option<&AnyObject>,
            did_end_selector: Option<Sel>,
            context_info: *mut c_void,
        );
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nswarningalertstyle?language=objc)
#[deprecated]
pub static NSWarningAlertStyle: NSAlertStyle = NSAlertStyle(NSAlertStyle::Warning.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsinformationalalertstyle?language=objc)
#[deprecated]
pub static NSInformationalAlertStyle: NSAlertStyle = NSAlertStyle(NSAlertStyle::Informational.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscriticalalertstyle?language=objc)
#[deprecated]
pub static NSCriticalAlertStyle: NSAlertStyle = NSAlertStyle(NSAlertStyle::Critical.0);
