/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import net.sf.samtools.util.BlockCompressedInputStream;

public class ParseFactory {
    public static BaseParse NewParse(String string) {
        boolean bl = ParseFactory.isText(string);
        if (ParseFactory.isBAM(string)) {
            return new BAMParse(string);
        }
        if (bl && ParseFactory.isSAM(string)) {
            return new SAMParse(string);
        }
        if (ParseFactory.isVCF(string)) {
            return new VCFParse(string);
        }
        if (bl && ParseFactory.isFASTQ(string)) {
            if (ParseFactory.isCASAVA(string)) {
                return new CASAVA_FASTQ(string);
            }
            return new FASTQParse(string);
        }
        if (ParseFactory.isSFF(string)) {
            return new SFFParse(string);
        }
        return null;
    }

    public static boolean isText(String string) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            byte[] byArray = new byte[1024];
            int n = bufferedInputStream.read(byArray);
            for (int i = 0; i < n; ++i) {
                char c = (char)byArray[i];
                if (c >= ' ' && c <= '~' || Character.isWhitespace(c)) continue;
                bufferedInputStream.close();
                return false;
            }
            bufferedInputStream.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isSFF(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            char[] cArray = new char[8];
            bufferedReader.read(cArray, 0, 8);
            String string2 = new String(cArray);
            bufferedReader.close();
            return string2.equals(".sff\u0000\u0000\u0000\u0001");
        }
        catch (Exception exception) {}
        finally {
            return false;
        }
    }

    public static boolean isBAM(String string) {
        try {
            BlockCompressedInputStream blockCompressedInputStream = new BlockCompressedInputStream(new File(string));
            blockCompressedInputStream.seek(0L);
            byte[] byArray = new byte[4];
            blockCompressedInputStream.read(byArray);
            String string2 = new String(byArray);
            blockCompressedInputStream.close();
            return string2.equals("BAM\u0001");
        }
        catch (Exception exception) {}
        finally {
            return false;
        }
    }

    public static boolean isSAM(String string) {
        try {
            String[] stringArray;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null && ((stringArray = string2.substring(0, 3)).equals("@HD") || stringArray.equals("@SQ") || stringArray.equals("@RG") || stringArray.equals("@PG") || stringArray.equals("@CO"))) {
            }
            bufferedReader.close();
            if (string2 == null) {
                return true;
            }
            stringArray = string2.split("\\t");
            if (stringArray.length < 11) {
                return false;
            }
            if (stringArray[10].equals("*") || stringArray[10].length() == stringArray[9].length()) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public static boolean isVCF(String string) {
        try {
            LargeFileReader largeFileReader = new LargeFileReader(string);
            String string2 = largeFileReader.readLine();
            largeFileReader.close();
            if (string2 != null && string2.indexOf("##fileformat=") >= 0) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public static boolean isFASTQ(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3 = string2.substring(0, 1);
                if (string3.equals("#")) continue;
                if (!string3.equals("@") || (string2 = bufferedReader.readLine()) == null) break;
                while ((string2 = bufferedReader.readLine()) != null && string2.matches("[ACTGNacgtnURYSWKMBDHVN.-]*")) {
                }
                if (!string2.substring(0, 1).equals("+")) break;
                return true;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public static boolean isCASAVA(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = "";
            String string3 = "";
            while ((string2 = bufferedReader.readLine()) != null && (string3 = string2.substring(0, 1)).equals("#")) {
            }
            bufferedReader.close();
            if (!string3.equals("@")) {
                return false;
            }
            String[] stringArray = string2.split(" ");
            if (stringArray.length == 2) {
                String[] stringArray2 = stringArray[0].split(":");
                String[] stringArray3 = stringArray[1].split(":");
                if (stringArray2.length == 7 && stringArray3.length >= 3) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }
}

