/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nativecerts.mac;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.platform.mac.CoreFoundation;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.nativecerts.NativeTrustedRootsInternalUtils;
import org.jetbrains.nativecerts.mac.CoreFoundationExt;
import org.jetbrains.nativecerts.mac.CoreFoundationExtUtil;
import org.jetbrains.nativecerts.mac.SecurityFramework;

public class SecurityFrameworkUtil {
    private static final Logger LOGGER = Logger.getLogger(SecurityFrameworkUtil.class.getName());
    static final String SECURITY_FRAMEWORK_LIBRARY_NAME = "Security";

    private SecurityFrameworkUtil() {
    }

    public static List<X509Certificate> getTrustedRoots(SecurityFramework.SecTrustSettingsDomain domain) {
        List<X509Certificate> result = SecurityFrameworkUtil.copyMatchingCertificates(domain, cert -> SecurityFrameworkUtil.isTrustedRoot(domain, cert));
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder();
            message.append("Received ").append(result.size()).append(" certificates from trust settings domain ").append((Object)domain);
            for (X509Certificate certificate : result) {
                message.append("\n  ").append(certificate.getSubjectX500Principal());
            }
            LOGGER.fine(message.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<X509Certificate> copyMatchingCertificates(SecurityFramework.SecTrustSettingsDomain domain, Predicate<SecurityFramework.SecCertificateRef> predicate) {
        CoreFoundationExt.CFArrayRefByReference returnedCertArray = new CoreFoundationExt.CFArrayRefByReference();
        CoreFoundationExt.CFArrayRefByReference searchDomainArray = new CoreFoundationExt.CFArrayRefByReference();
        SecurityFramework.SecKeychainRefByReference keychain = new SecurityFramework.SecKeychainRefByReference();
        CoreFoundation.CFArrayRef searchDomainList = null;
        CoreFoundation.CFArrayRef certArray = null;
        boolean systemDomain = domain.equals((Object)SecurityFramework.SecTrustSettingsDomain.system);
        CoreFoundation.CFDictionaryRef query = null;
        try {
            SecurityFramework.OSStatus rc;
            if (systemDomain) {
                rc = SecurityFramework.INSTANCE.SecKeychainOpen("/System/Library/Keychains/SystemRootCertificates.keychain", keychain);
                if (!SecurityFramework.OSStatus.errSecSuccess.equals((Object)rc)) {
                    throw new IllegalStateException("Failed to read system keychain: " + rc);
                }
                searchDomainList = CoreFoundation.INSTANCE.CFArrayCreate(null, keychain.getPointer(), new CoreFoundation.CFIndex(1L), null);
            } else {
                rc = SecurityFramework.INSTANCE.SecKeychainCopyDomainSearchList(domain, searchDomainArray);
                if (!SecurityFramework.OSStatus.errSecSuccess.equals((Object)rc)) {
                    throw new IllegalStateException("SecKeychainCopyDomainSearchList failed: " + rc);
                }
                searchDomainList = searchDomainArray.getArray();
            }
            if (searchDomainList == null) {
                throw new IllegalStateException("Unexpected null search domain list");
            }
            query = CoreFoundationExtUtil.createDictionary(Map.of(SecurityFramework.kSecClass, SecurityFramework.kSecClassCertificate, SecurityFramework.kSecMatchLimit, SecurityFramework.kSecMatchLimitAll, SecurityFramework.kSecReturnRef, CoreFoundationExt.kCFBooleanTrue, SecurityFramework.kSecMatchSearchList, searchDomainList));
            rc = SecurityFramework.INSTANCE.SecItemCopyMatching(query, returnedCertArray);
            if (!SecurityFramework.OSStatus.errSecSuccess.equals((Object)rc)) {
                throw new IllegalStateException("SecItemCopyMatching failed: " + rc);
            }
            certArray = returnedCertArray.getArray();
            if (certArray == null) {
                List<X509Certificate> list = Collections.emptyList();
                return list;
            }
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
            for (int i = 0; i < certArray.getCount(); ++i) {
                String certificateDescription;
                SecurityFramework.SecCertificateRef secCertificateRef;
                block22: {
                    secCertificateRef = new SecurityFramework.SecCertificateRef(certArray.getValueAtIndex(i));
                    if (!systemDomain) {
                        try {
                            if (!predicate.test(secCertificateRef)) {
                            }
                            break block22;
                        }
                        catch (Throwable predicateError) {
                            certificateDescription = CoreFoundation.INSTANCE.CFCopyDescription((CoreFoundation.CFTypeRef)secCertificateRef).stringValue();
                            LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to check certificate '" + certificateDescription + "'", predicateError));
                        }
                        continue;
                    }
                }
                try {
                    result.add(SecurityFrameworkUtil.getX509Certificate(secCertificateRef));
                    continue;
                }
                catch (Throwable parsingError) {
                    certificateDescription = CoreFoundation.INSTANCE.CFCopyDescription((CoreFoundation.CFTypeRef)secCertificateRef).stringValue();
                    LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to parse certificate '" + certificateDescription + "'", parsingError));
                }
            }
            ArrayList<X509Certificate> arrayList = result;
            return arrayList;
        }
        finally {
            SecurityFramework.SecKeychainRef secKeychainRef;
            if (query != null) {
                query.release();
            }
            if (certArray != null) {
                certArray.release();
            }
            if (searchDomainList != null) {
                searchDomainList.release();
            }
            if ((secKeychainRef = keychain.getSecKeychainRef()) != null) {
                secKeychainRef.release();
            }
        }
    }

    private static X509Certificate getX509Certificate(SecurityFramework.SecCertificateRef secCertificateRef) {
        CoreFoundation.CFDataRef data = SecurityFramework.INSTANCE.SecCertificateCopyData(secCertificateRef);
        try {
            byte[] bytes = data.getBytePtr().getByteArray(0L, data.getLength());
            X509Certificate x509Certificate = NativeTrustedRootsInternalUtils.parseCertificate(bytes);
            return x509Certificate;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            data.release();
        }
    }

    static boolean isSelfSignedCertificate(X509Certificate certificate) {
        if (!certificate.getSubjectX500Principal().equals(certificate.getIssuerX500Principal())) {
            return false;
        }
        try {
            certificate.verify(certificate.getPublicKey());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean validateCertificate(SecurityFramework.SecCertificateRef certificateRef) {
        SecurityFramework.SecPolicyRef policy = null;
        SecurityFramework.SecTrustRefByReference secTrustRefByReference = null;
        CoreFoundation.CFArrayRef subjCerts = null;
        try {
            subjCerts = CoreFoundationExtUtil.createArray(new CoreFoundation.CFTypeRef[]{certificateRef});
            secTrustRefByReference = new SecurityFramework.SecTrustRefByReference();
            policy = SecurityFramework.INSTANCE.SecPolicyCreateSSL(false, null);
            SecurityFramework.OSStatus rc = SecurityFramework.INSTANCE.SecTrustCreateWithCertificates(subjCerts, policy, secTrustRefByReference);
            if (!SecurityFramework.OSStatus.errSecSuccess.equals((Object)rc)) {
                LOGGER.warning("Failed to create trust object: " + rc);
                boolean bl = false;
                return bl;
            }
            boolean bl = SecurityFramework.INSTANCE.SecTrustEvaluateWithError(secTrustRefByReference.getSecTrustRef(), null);
            return bl;
        }
        finally {
            SecurityFramework.SecTrustRef secTrustRef;
            if (policy != null) {
                policy.release();
            }
            if (secTrustRefByReference != null && (secTrustRef = secTrustRefByReference.getSecTrustRef()) != null) {
                secTrustRef.release();
            }
            if (subjCerts != null) {
                subjCerts.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTrustedRoot(SecurityFramework.SecTrustSettingsDomain domain, SecurityFramework.SecCertificateRef certificateRef) {
        boolean selfSignedCertificate = SecurityFrameworkUtil.isSelfSignedCertificate(SecurityFrameworkUtil.getX509Certificate(certificateRef));
        CoreFoundationExt.CFArrayRefByReference trustedSettingsRef = new CoreFoundationExt.CFArrayRefByReference();
        CoreFoundation.CFStringRef descriptionRef = null;
        try {
            SecurityFramework.OSStatus rc = SecurityFramework.INSTANCE.SecTrustSettingsCopyTrustSettings(certificateRef, domain, trustedSettingsRef);
            descriptionRef = CoreFoundation.INSTANCE.CFCopyDescription((CoreFoundation.CFTypeRef)certificateRef);
            String certificateDescription = descriptionRef.stringValue();
            CoreFoundation.CFArrayRef trustedSettingsArray = trustedSettingsRef.getArray();
            if (!SecurityFramework.OSStatus.errSecSuccess.equals((Object)rc) && !SecurityFramework.OSStatus.errSecItemNotFound.equals((Object)rc)) {
                LOGGER.fine("Failed to get trust settings for certificate '" + certificateDescription + "': " + rc);
                boolean bl = false;
                return bl;
            }
            if (trustedSettingsArray == null) {
                boolean valid = SecurityFrameworkUtil.validateCertificate(certificateRef);
                if (valid) {
                    boolean array = true;
                    return array;
                }
                LOGGER.fine("Certificate '" + certificateDescription + "' has no trust settings and failed to validate against trusted roots");
                boolean array = false;
                return array;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                try {
                    CoreFoundation.CFStringRef cfStringRef = CoreFoundation.INSTANCE.CFCopyDescription((CoreFoundation.CFTypeRef)trustedSettingsArray);
                    LOGGER.fine("Certificate '" + certificateDescription + "' trust settings:\n" + cfStringRef.stringValue());
                }
                catch (Throwable t) {
                    LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to describe certificate trusted settings", t));
                }
            }
            if (trustedSettingsArray.getCount() == 0) {
                boolean t = true;
                return t;
            }
            for (int i = 0; i < trustedSettingsArray.getCount(); ++i) {
                SecurityFramework.SecTrustSettingsResult result;
                CoreFoundation.CFDictionaryRef constraints = new CoreFoundation.CFDictionaryRef(trustedSettingsArray.getValueAtIndex(i));
                CoreFoundation.CFIndex constraintsCount = CoreFoundationExt.INSTANCE.CFDictionaryGetCount(constraints);
                int processedConstrains = 0;
                Pointer value = constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsResult);
                if (value == null) {
                    result = SecurityFramework.SecTrustSettingsResult.kSecTrustSettingsResultTrustRoot;
                } else {
                    CoreFoundation.CFNumberRef resultNumber = new CoreFoundation.CFNumberRef(value);
                    result = new SecurityFramework.SecTrustSettingsResult(resultNumber.longValue());
                    ++processedConstrains;
                }
                if (!result.equals((Object)SecurityFramework.SecTrustSettingsResult.kSecTrustSettingsResultTrustRoot)) continue;
                if (!selfSignedCertificate) {
                    LOGGER.warning("Certificate '" + certificateDescription + "' is not self-signed, skipping");
                    continue;
                }
                if (constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsAllowedError) != null) {
                    ++processedConstrains;
                }
                if (constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsPolicyName) != null) {
                    ++processedConstrains;
                }
                if ((value = constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsPolicy)) != null) {
                    SecurityFramework.SecPolicyRef secPolicyRef = new SecurityFramework.SecPolicyRef(value);
                    CoreFoundation.CFDictionaryRef policyDictionaryRef = SecurityFramework.INSTANCE.SecPolicyCopyProperties(secPolicyRef);
                    try {
                        CoreFoundation.CFStringRef policyOidStringRef;
                        Pointer policyOid = policyDictionaryRef.getValue((PointerType)SecurityFramework.kSecPolicyOid);
                        if (policyOid == null || !CoreFoundationExt.INSTANCE.CFEqual((CoreFoundation.CFTypeRef)SecurityFramework.kSecPolicyAppleSSL, (CoreFoundation.CFTypeRef)(policyOidStringRef = new CoreFoundation.CFStringRef(policyOid)))) {
                            continue;
                        }
                    }
                    finally {
                        policyDictionaryRef.release();
                    }
                    ++processedConstrains;
                }
                if (constraintsCount.longValue() != (long)processedConstrains) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            CoreFoundation.CFArrayRef array;
            if (descriptionRef != null) {
                descriptionRef.release();
            }
            if ((array = trustedSettingsRef.getArray()) != null) {
                array.release();
            }
        }
    }
}

