/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.ui.settings.QodanaCloudSettingsView;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0014B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/qodana/ui/settings/QodanaCloudSettingsPanel;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "view", "Lorg/jetbrains/qodana/ui/settings/QodanaCloudSettingsView;", "isModified", "", "apply", "", "getId", "", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "Companion", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaCloudSettingsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaCloudSettingsPanel.kt\norg/jetbrains/qodana/ui/settings/QodanaCloudSettingsPanel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,63:1\n25#2:64\n*S KotlinDebug\n*F\n+ 1 QodanaCloudSettingsPanel.kt\norg/jetbrains/qodana/ui/settings/QodanaCloudSettingsPanel\n*L\n37#1:64\n*E\n"})
public final class QodanaCloudSettingsPanel
extends BoundConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private QodanaCloudSettingsView view;

    public QodanaCloudSettingsPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = QodanaBundle.message("configurable.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, null);
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public boolean isModified() {
        QodanaCloudSettingsView qodanaCloudSettingsView = this.view;
        if (qodanaCloudSettingsView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"view");
            qodanaCloudSettingsView = null;
        }
        return qodanaCloudSettingsView.getViewModel().getAreSettingsModified();
    }

    public void apply() {
        QodanaCloudSettingsView qodanaCloudSettingsView = this.view;
        if (qodanaCloudSettingsView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"view");
            qodanaCloudSettingsView = null;
        }
        qodanaCloudSettingsView.getViewModel().finish();
    }

    @NotNull
    public String getId() {
        return "settings.qodana";
    }

    @NotNull
    public DialogPanel createPanel() {
        Disposable myDisposable = this.getDisposable();
        if (myDisposable == null) {
            QodanaCloudSettingsPanel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(QodanaCloudSettingsPanel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("Can't create Qodana Settings Panel: disposable is `null`");
            return BuilderKt.panel(QodanaCloudSettingsPanel::createPanel$lambda$0);
        }
        this.view = new QodanaCloudSettingsView(this.project);
        QodanaCloudSettingsView qodanaCloudSettingsView = this.view;
        if (qodanaCloudSettingsView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"view");
            qodanaCloudSettingsView = null;
        }
        Disposer.register((Disposable)myDisposable, (Disposable)qodanaCloudSettingsView);
        return BuilderKt.panel(arg_0 -> QodanaCloudSettingsPanel.createPanel$lambda$2(this, arg_0));
    }

    private static final Unit createPanel$lambda$0(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$2$lambda$1(QodanaCloudSettingsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        QodanaCloudSettingsView qodanaCloudSettingsView = this$0.view;
        if (qodanaCloudSettingsView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"view");
            qodanaCloudSettingsView = null;
        }
        $this$row.cell((JComponent)qodanaCloudSettingsView.getView()).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$2(QodanaCloudSettingsPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> QodanaCloudSettingsPanel.createPanel$lambda$2$lambda$1(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/qodana/ui/settings/QodanaCloudSettingsPanel$Companion;", "", "<init>", "()V", "openSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        public final void openSettings(@Nullable Project project) {
            ShowSettingsUtil.getInstance().showSettingsDialog(project, QodanaCloudSettingsPanel.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

