/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.outputs.impl;

import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.outputs.NotebookLazyOutputComponent;
import com.intellij.notebooks.visualization.outputs.action.NotebookOutputCollapseSingleInCellAction;
import com.intellij.notebooks.visualization.outputs.impl.CollapsingComponentBorder;
import com.intellij.notebooks.visualization.r.inlays.ResizeController;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0001:B2\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0011\u0010\b\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010 \u001a\u00020\u0013J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0006\u00105\u001a\u000202J\b\u00106\u001a\u00020\u0013H\u0016J\b\u00107\u001a\u00020\u0007H\u0002J\b\u00108\u001a\u000202H\u0016J\u0006\u00109\u001a\u000202R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\b\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0019\u001a\u0004\u0018\u00010\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u0017R\u001a\u0010\u001c\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0011\"\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0011R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&R\u0011\u0010)\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010/\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010\u0011\"\u0004\b0\u0010\u001f\u00a8\u0006;"}, d2={"Lcom/intellij/notebooks/visualization/outputs/impl/CollapsingComponent;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "child", "Ljavax/swing/JComponent;", "resizable", "", "collapsedTextSupplier", "Lkotlin/Function0;", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Ljavax/swing/JComponent;ZLkotlin/jvm/functions/Function0;)V", "getEditor$intellij_notebooks_visualization", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getResizable$intellij_notebooks_visualization", "()Z", "initialSize", "Ljava/awt/Dimension;", "getInitialSize", "()Ljava/awt/Dimension;", "setInitialSize", "(Ljava/awt/Dimension;)V", "value", "customSize", "getCustomSize", "setCustomSize", "maximized", "getMaximized", "setMaximized", "(Z)V", "calculateInnerSize", "hasBeenManuallyResized", "getHasBeenManuallyResized", "resizeController", "Lcom/intellij/notebooks/visualization/r/inlays/ResizeController;", "getResizeController", "()Lcom/intellij/notebooks/visualization/r/inlays/ResizeController;", "resizeController$delegate", "Lkotlin/Lazy;", "mainComponent", "getMainComponent", "()Ljavax/swing/JComponent;", "stubComponent", "Lkotlin/Lazy;", "Lcom/intellij/notebooks/visualization/outputs/impl/CollapsingComponent$StubComponent;", "isSeen", "setSeen", "remove", "", "index", "", "resetCustomHeight", "getPreferredSize", "shouldUseInitialSize", "doLayout", "updateStubIfCollapsed", "StubComponent", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nCollapsingComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollapsingComponent.kt\ncom/intellij/notebooks/visualization/outputs/impl/CollapsingComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,176:1\n1#2:177\n25#3:178\n*S KotlinDebug\n*F\n+ 1 CollapsingComponent.kt\ncom/intellij/notebooks/visualization/outputs/impl/CollapsingComponent\n*L\n100#1:178\n*E\n"})
public class CollapsingComponent
extends JPanel {
    @NotNull
    private final EditorImpl editor;
    private final boolean resizable;
    @NotNull
    private final Function0<String> collapsedTextSupplier;
    @Nullable
    private Dimension initialSize;
    @Nullable
    private Dimension customSize;
    private boolean maximized;
    @NotNull
    private final Lazy resizeController$delegate;
    @NotNull
    private final JComponent mainComponent;
    @NotNull
    private final Lazy<StubComponent> stubComponent;

    public CollapsingComponent(@NotNull EditorImpl editor, @NotNull JComponent child, boolean resizable, @NotNull Function0<String> collapsedTextSupplier) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter(collapsedTextSupplier, (String)"collapsedTextSupplier");
        super(null);
        this.editor = editor;
        this.resizable = resizable;
        this.collapsedTextSupplier = collapsedTextSupplier;
        this.resizeController$delegate = LazyKt.lazy(() -> CollapsingComponent.resizeController_delegate$lambda$7(this));
        this.mainComponent = child;
        this.stubComponent = LazyKt.lazy(() -> CollapsingComponent.stubComponent$lambda$8(this));
        this.add(child);
        this.setBorder(this.resizable ? (Border)new CollapsingComponentBorder((Editor)this.editor) : null);
        this.setSeen(true);
        this.setOpaque(false);
    }

    @NotNull
    public final EditorImpl getEditor$intellij_notebooks_visualization() {
        return this.editor;
    }

    public final boolean getResizable$intellij_notebooks_visualization() {
        return this.resizable;
    }

    @Nullable
    public final Dimension getInitialSize() {
        return this.initialSize;
    }

    public final void setInitialSize(@Nullable Dimension dimension) {
        this.initialSize = dimension;
    }

    @Nullable
    public final Dimension getCustomSize() {
        return this.customSize;
    }

    public final void setCustomSize(@Nullable Dimension value) {
        if (!Intrinsics.areEqual((Object)this.customSize, (Object)value)) {
            this.customSize = value;
            this.revalidate();
        }
    }

    public final boolean getMaximized() {
        return this.maximized;
    }

    public final void setMaximized(boolean bl) {
        this.maximized = bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Dimension calculateInnerSize() {
        void $this$calculateInnerSize_u24lambda_u242_u24lambda_u241;
        Insets $this$calculateInnerSize_u24lambda_u242_u24lambda_u240;
        Dimension it = this.getSize();
        boolean bl = false;
        Insets insets = this.getInsets();
        int n = it.width;
        boolean bl2 = false;
        int n2 = $this$calculateInnerSize_u24lambda_u242_u24lambda_u240.left + $this$calculateInnerSize_u24lambda_u242_u24lambda_u240.right;
        int n3 = n - n2;
        $this$calculateInnerSize_u24lambda_u242_u24lambda_u240 = this.getInsets();
        n2 = it.height;
        n = n3;
        boolean bl3 = false;
        int n4 = $this$calculateInnerSize_u24lambda_u242_u24lambda_u241.top + $this$calculateInnerSize_u24lambda_u242_u24lambda_u241.bottom;
        int n5 = n2 - n4;
        int n6 = n;
        return new Dimension(n6, n5);
    }

    public final boolean getHasBeenManuallyResized() {
        return this.customSize != null;
    }

    private final ResizeController getResizeController() {
        Lazy lazy = this.resizeController$delegate;
        return (ResizeController)lazy.getValue();
    }

    @NotNull
    public final JComponent getMainComponent() {
        return this.mainComponent;
    }

    public final boolean isSeen() {
        return this.mainComponent.isVisible();
    }

    public final void setSeen(boolean value) {
        this.mainComponent.setVisible(value);
        if (this.stubComponent.isInitialized()) {
            ((StubComponent)this.stubComponent.getValue()).setVisible(!value);
        }
        if (this.resizable) {
            if (value) {
                this.addMouseListener(this.getResizeController());
                this.addMouseMotionListener(this.getResizeController());
            } else {
                this.removeMouseListener(this.getResizeController());
                this.removeMouseMotionListener(this.getResizeController());
            }
        }
        if (!value) {
            ((StubComponent)this.stubComponent.getValue()).setText((String)this.collapsedTextSupplier.invoke());
        }
    }

    @Override
    public void remove(int index) {
        CollapsingComponent $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CollapsingComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("Components should not be deleted from " + this, new Throwable());
        super.remove(index);
    }

    public final void resetCustomHeight() {
        this.revalidate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Dimension getPreferredSize() {
        void $this$getPreferredSize_u24lambda_u2411_u24lambda_u2410;
        Insets $this$getPreferredSize_u24lambda_u2411_u24lambda_u249;
        Dimension result;
        Dimension dimension;
        if (!this.isSeen()) {
            dimension = ((StubComponent)this.stubComponent.getValue()).getPreferredSize();
        } else if (this.maximized) {
            dimension = this.mainComponent.getPreferredSize();
        } else if (this.customSize != null) {
            Dimension dimension2 = this.customSize;
            dimension = dimension2;
            Intrinsics.checkNotNull((Object)dimension2);
        } else if (this.shouldUseInitialSize()) {
            dimension = this.initialSize;
            if (dimension == null) {
                dimension = this.mainComponent.getPreferredSize();
            }
        } else {
            dimension = this.mainComponent.getPreferredSize();
        }
        Dimension it = result = dimension;
        boolean bl = false;
        Insets insets = this.getInsets();
        int n = it.width;
        boolean bl2 = false;
        int n2 = $this$getPreferredSize_u24lambda_u2411_u24lambda_u249.left + $this$getPreferredSize_u24lambda_u2411_u24lambda_u249.right;
        int n3 = n + n2;
        $this$getPreferredSize_u24lambda_u2411_u24lambda_u249 = this.getInsets();
        n2 = it.height;
        n = n3;
        boolean bl3 = false;
        int n4 = $this$getPreferredSize_u24lambda_u2411_u24lambda_u2410.top + $this$getPreferredSize_u24lambda_u2411_u24lambda_u2410.bottom;
        int n5 = n2 + n4;
        int n6 = n;
        return new Dimension(n6, n5);
    }

    private final boolean shouldUseInitialSize() {
        JComponent jComponent = this.mainComponent;
        NotebookLazyOutputComponent notebookLazyOutputComponent = jComponent instanceof NotebookLazyOutputComponent ? (NotebookLazyOutputComponent)((Object)jComponent) : null;
        return notebookLazyOutputComponent != null ? !notebookLazyOutputComponent.getReady() : false;
    }

    @Override
    public void doLayout() {
        Dimension size = this.calculateInnerSize();
        if (!this.isSeen()) {
            ((StubComponent)this.stubComponent.getValue()).setBounds(0, 0, size.width, size.height);
        } else {
            this.mainComponent.setBounds(0, 0, size.width, size.height);
        }
    }

    public final void updateStubIfCollapsed() {
        if (!this.isSeen()) {
            ((StubComponent)this.stubComponent.getValue()).setText((String)this.collapsedTextSupplier.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit resizeController_delegate$lambda$7$lambda$4(CollapsingComponent this$0, int n, int dy) {
        void it;
        Dimension dimension = this$0.customSize;
        if (dimension == null) {
            dimension = this$0.calculateInnerSize();
        }
        Dimension dimension2 = dimension;
        CollapsingComponent collapsingComponent2 = this$0;
        boolean bl = false;
        collapsingComponent2.setCustomSize(new Dimension(it.width, Integer.max(it.height + dy, this$0.editor.getLineHeight())));
        return Unit.INSTANCE;
    }

    private static final void resizeController_delegate$lambda$7$lambda$6$lambda$5(CollapsingComponent this$0, ResizeController.ResizeState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Border border = this$0.getBorder();
        CollapsingComponentBorder collapsingComponentBorder = border instanceof CollapsingComponentBorder ? (CollapsingComponentBorder)border : null;
        if (collapsingComponentBorder != null) {
            collapsingComponentBorder.setResized(state != ResizeController.ResizeState.NONE);
        }
        this$0.repaint();
    }

    private static final ResizeController resizeController_delegate$lambda$7(CollapsingComponent this$0) {
        ResizeController resizeController;
        ResizeController $this$resizeController_delegate_u24lambda_u247_u24lambda_u246 = resizeController = new ResizeController(this$0, (Editor)this$0.editor, (Function2<? super Integer, ? super Integer, Unit>)((Function2)(arg_0, arg_1) -> CollapsingComponent.resizeController_delegate$lambda$7$lambda$4(this$0, arg_0, arg_1)));
        boolean bl = false;
        $this$resizeController_delegate_u24lambda_u247_u24lambda_u246.getResizeStateDispatcher().addListener(arg_0 -> CollapsingComponent.resizeController_delegate$lambda$7$lambda$6$lambda$5(this$0, arg_0));
        return resizeController;
    }

    private static final StubComponent stubComponent$lambda$8(CollapsingComponent this$0) {
        StubComponent result = new StubComponent(this$0.editor);
        this$0.add(result);
        return result;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/notebooks/visualization/outputs/impl/CollapsingComponent$StubComponent;", "Ljavax/swing/JLabel;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "updateUI", "", "onClick", "e", "Ljava/awt/event/MouseEvent;", "updateUIFromEditor", "intellij.notebooks.visualization"})
    private static final class StubComponent
    extends JLabel {
        @NotNull
        private final EditorImpl editor;

        public StubComponent(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super("...");
            this.editor = editor;
            this.setOpaque(true);
            this.setBorder(IdeBorderFactory.createEmptyBorder((Insets)((Insets)JBUI.insets((int)7, (int)0))));
            this.updateUIFromEditor();
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.onClick(e);
                }
            });
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.editor != null) {
                this.updateUIFromEditor();
            }
        }

        private final void onClick(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            Container container = this.getParent();
            CollapsingComponent collapsingComponent2 = container instanceof CollapsingComponent ? (CollapsingComponent)container : null;
            if (collapsingComponent2 == null) {
                return;
            }
            CollapsingComponent parent = collapsingComponent2;
            ActionManager actionManager = ActionManager.getInstance();
            AnAction anAction = actionManager.getAction(NotebookOutputCollapseSingleInCellAction.class.getSimpleName());
            Intrinsics.checkNotNull((Object)anAction);
            AnAction action2 = anAction;
            if (actionManager.tryToExecute(action2, (InputEvent)e, (Component)parent, null, true).isProcessed()) {
                e.consume();
            }
        }

        private final void updateUIFromEditor() {
            TextAttributes textAttributes = this.editor.getColorsScheme().getAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES);
            int fontType = textAttributes != null ? textAttributes.getFontType() : 0;
            this.setForeground(JBUI.CurrentTheme.ActionsList.MNEMONIC_FOREGROUND);
            NotebookEditorAppearance notebookEditorAppearance = NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor);
            EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
            this.setBackground(notebookEditorAppearance.getTextOutputBackground(editorColorsScheme));
            String string = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.setFont(EditorUtil.fontForChar((char)StringsKt.first((CharSequence)string), (int)fontType, (Editor)((Editor)this.editor)).getFont());
        }
    }
}

