/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.vcs.log.Hash;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgNameWithHashInfo;

public class HgRepoInfo {
    @NotNull
    private final String myCurrentBranch;
    @Nullable
    private final String myTipRevision;
    @Nullable
    private final String myCurrentRevision;
    @NotNull
    private final Repository.State myState;
    @Nullable
    private final String myCurrentBookmark;
    @NotNull
    private final Map<String, LinkedHashSet<Hash>> myBranches;
    @NotNull
    private final Set<HgNameWithHashInfo> myBookmarks;
    @NotNull
    private final Set<HgNameWithHashInfo> myTags;
    @NotNull
    private final Set<HgNameWithHashInfo> myLocalTags;
    @NotNull
    private final Set<HgNameWithHashInfo> mySubrepos;
    @NotNull
    private final List<HgNameWithHashInfo> myMQApplied;
    @NotNull
    private final List<String> myMqNames;

    public HgRepoInfo(@NotNull String currentBranch, @Nullable String currentRevision, @Nullable String currentTipRevision, @NotNull Repository.State state, @NotNull Map<String, LinkedHashSet<Hash>> branches, @NotNull Collection<HgNameWithHashInfo> bookmarks, @Nullable String currentBookmark, @NotNull Collection<HgNameWithHashInfo> tags, @NotNull Collection<HgNameWithHashInfo> localTags, @NotNull Collection<HgNameWithHashInfo> subrepos, @NotNull List<HgNameWithHashInfo> mqApplied, @NotNull List<String> mqNames) {
        if (currentBranch == null) {
            HgRepoInfo.$$$reportNull$$$0(0);
        }
        if (state == null) {
            HgRepoInfo.$$$reportNull$$$0(1);
        }
        if (branches == null) {
            HgRepoInfo.$$$reportNull$$$0(2);
        }
        if (bookmarks == null) {
            HgRepoInfo.$$$reportNull$$$0(3);
        }
        if (tags == null) {
            HgRepoInfo.$$$reportNull$$$0(4);
        }
        if (localTags == null) {
            HgRepoInfo.$$$reportNull$$$0(5);
        }
        if (subrepos == null) {
            HgRepoInfo.$$$reportNull$$$0(6);
        }
        if (mqApplied == null) {
            HgRepoInfo.$$$reportNull$$$0(7);
        }
        if (mqNames == null) {
            HgRepoInfo.$$$reportNull$$$0(8);
        }
        this.myCurrentBranch = currentBranch;
        this.myCurrentRevision = currentRevision;
        this.myTipRevision = currentTipRevision;
        this.myState = state;
        this.myBranches = branches;
        this.myBookmarks = new LinkedHashSet<HgNameWithHashInfo>(bookmarks);
        this.myCurrentBookmark = currentBookmark;
        this.myTags = new LinkedHashSet<HgNameWithHashInfo>(tags);
        this.myLocalTags = new LinkedHashSet<HgNameWithHashInfo>(localTags);
        this.mySubrepos = new HashSet<HgNameWithHashInfo>(subrepos);
        this.myMQApplied = mqApplied;
        this.myMqNames = mqNames;
    }

    @NotNull
    public String getCurrentBranch() {
        String string = this.myCurrentBranch;
        if (string == null) {
            HgRepoInfo.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public Map<String, LinkedHashSet<Hash>> getBranches() {
        Map<String, LinkedHashSet<Hash>> map = this.myBranches;
        if (map == null) {
            HgRepoInfo.$$$reportNull$$$0(10);
        }
        return map;
    }

    @NotNull
    public Collection<HgNameWithHashInfo> getBookmarks() {
        Set<HgNameWithHashInfo> set = this.myBookmarks;
        if (set == null) {
            HgRepoInfo.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    public Collection<HgNameWithHashInfo> getTags() {
        Set<HgNameWithHashInfo> set = this.myTags;
        if (set == null) {
            HgRepoInfo.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public Collection<HgNameWithHashInfo> getLocalTags() {
        Set<HgNameWithHashInfo> set = this.myLocalTags;
        if (set == null) {
            HgRepoInfo.$$$reportNull$$$0(13);
        }
        return set;
    }

    @Nullable
    public String getTipRevision() {
        return this.myTipRevision;
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myCurrentRevision;
    }

    @Nullable
    public String getCurrentBookmark() {
        return this.myCurrentBookmark;
    }

    @NotNull
    public Repository.State getState() {
        Repository.State state = this.myState;
        if (state == null) {
            HgRepoInfo.$$$reportNull$$$0(14);
        }
        return state;
    }

    @NotNull
    public List<HgNameWithHashInfo> getMQApplied() {
        List<HgNameWithHashInfo> list = this.myMQApplied;
        if (list == null) {
            HgRepoInfo.$$$reportNull$$$0(15);
        }
        return list;
    }

    public List<String> getMqPatchNames() {
        return this.myMqNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgRepoInfo info = (HgRepoInfo)o;
        if (this.myState != info.myState) {
            return false;
        }
        if (this.myTipRevision != null ? !this.myTipRevision.equals(info.myTipRevision) : info.myTipRevision != null) {
            return false;
        }
        if (this.myCurrentRevision != null ? !this.myCurrentRevision.equals(info.myCurrentRevision) : info.myCurrentRevision != null) {
            return false;
        }
        if (!this.myCurrentBranch.equals(info.myCurrentBranch)) {
            return false;
        }
        if (this.myCurrentBookmark != null ? !this.myCurrentBookmark.equals(info.myCurrentBookmark) : info.myCurrentBookmark != null) {
            return false;
        }
        if (!this.myBranches.equals(info.myBranches)) {
            return false;
        }
        if (!this.myBookmarks.equals(info.myBookmarks)) {
            return false;
        }
        if (!this.myTags.equals(info.myTags)) {
            return false;
        }
        if (!this.myLocalTags.equals(info.myLocalTags)) {
            return false;
        }
        if (!this.mySubrepos.equals(info.mySubrepos)) {
            return false;
        }
        if (!this.myMQApplied.equals(info.myMQApplied)) {
            return false;
        }
        return this.myMqNames.equals(info.myMqNames);
    }

    public int hashCode() {
        return Objects.hash(this.myCurrentBranch, this.myCurrentRevision, this.myTipRevision, this.myCurrentBookmark, this.myState, this.myBranches, this.myBookmarks, this.myTags, this.myLocalTags, this.mySubrepos, this.myMQApplied, this.myMqNames);
    }

    @NonNls
    @NotNull
    public String toString() {
        String string = String.format("HgRepository{myCurrentBranch=%s, myCurrentRevision='%s', myState=%s}", this.myCurrentBranch, this.myCurrentRevision, this.myState);
        if (string == null) {
            HgRepoInfo.$$$reportNull$$$0(16);
        }
        return string;
    }

    public boolean hasSubrepos() {
        return !this.mySubrepos.isEmpty();
    }

    @NotNull
    public Collection<HgNameWithHashInfo> getSubrepos() {
        Set<HgNameWithHashInfo> set = this.mySubrepos;
        if (set == null) {
            HgRepoInfo.$$$reportNull$$$0(17);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentBranch";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bookmarks";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTags";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subrepos";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mqApplied";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mqNames";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/repo/HgRepoInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/repo/HgRepoInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranch";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranches";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBookmarks";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalTags";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMQApplied";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubrepos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

