/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

final class EnterInPropertiesFileHandler
extends EnterHandlerDelegateAdapter {
    EnterInPropertiesFileHandler() {
    }

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            EnterInPropertiesFileHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EnterInPropertiesFileHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            EnterInPropertiesFileHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            EnterInPropertiesFileHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            EnterInPropertiesFileHandler.$$$reportNull$$$0(4);
        }
        if (file instanceof PropertiesFile) {
            int caretOffset = (Integer)caretOffsetRef.get();
            Document document = editor.getDocument();
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            PsiElement psiAtOffset = file.findElementAt(caretOffset);
            EnterInPropertiesFileHandler.handleEnterInPropertiesFile(editor, document, psiAtOffset, caretOffset);
            return EnterHandlerDelegate.Result.Stop;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static void handleEnterInPropertiesFile(Editor editor, Document document, PsiElement psiAtOffset, int caretOffset) {
        String toInsert;
        String text = document.getText();
        String line = text.substring(0, caretOffset);
        int i = line.lastIndexOf(10);
        if (i > 0) {
            line = line.substring(i);
        }
        if (PropertiesUtil.isUnescapedBackSlashAtTheEnd((String)line)) {
            toInsert = "\n  ";
        } else {
            IElementType elementType;
            IElementType iElementType = elementType = psiAtOffset == null ? null : psiAtOffset.getNode().getElementType();
            toInsert = elementType == PropertiesTokenTypes.VALUE_CHARACTERS ? (text.charAt(caretOffset) == ' ' || text.charAt(caretOffset) == '\t' ? "\\\n  \\" : "\\\n  ") : (elementType == PropertiesTokenTypes.END_OF_LINE_COMMENT && "#!".indexOf(document.getText().charAt(caretOffset)) == -1 ? "\n#" : "\n");
        }
        document.insertString(caretOffset, (CharSequence)toInsert);
        editor.getCaretModel().moveToOffset(caretOffset += toInsert.length());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/properties/EnterInPropertiesFileHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

