/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_bg extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Средно гринуичко време",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Апия – стандартно време",
               "",
               "Апия – лятно часово време",
               "",
               "Апия",
               "",
            };
        final String[] Cook = new String[] {
               "Острови Кук – стандартно време",
               "",
               "Острови Кук – лятно часово време",
               "",
               "Острови Кук",
               "",
            };
        final String[] Cuba = new String[] {
               "Кубинско стандартно време",
               "CST",
               "Кубинско лятно часово време",
               "CDT",
               "Кубинско време",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Фиджийско стандартно време",
               "",
               "Фиджийско лятно часово време",
               "",
               "Фиджийско време",
               "",
            };
        final String[] Gulf = new String[] {
               "Персийски залив",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ховдско стандартно време",
               "",
               "Ховдско лятно часово време",
               "",
               "Ховдско време",
               "",
            };
        final String[] Iran = new String[] {
               "Иранско стандартно време",
               "",
               "Иранско лятно часово време",
               "",
               "Иранско време",
               "",
            };
        final String[] Niue = new String[] {
               "Ниуе",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Омско стандартно време",
               "",
               "Омско лятно часово време",
               "",
               "Омско време",
               "",
            };
        final String[] Peru = new String[] {
               "Перуанско стандартно време",
               "",
               "Перуанско лятно часово време",
               "",
               "Перуанско време",
               "",
            };
        final String[] Truk = new String[] {
               "Чуюк",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Остров Уейк",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Чилийско стандартно време",
               "",
               "Чилийско лятно часово време",
               "",
               "Чилийско време",
               "",
            };
        final String[] China = new String[] {
               "Китайско стандартно време",
               "CST",
               "Китайско лятно часово време",
               "CDT",
               "Китайско време",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Кокосови острови",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Дейвис",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Индийско време",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Японско стандартно време",
               "JST",
               "Японско лятно часово време",
               "JDT",
               "Японско време",
               "JT",
            };
        final String[] Korea = new String[] {
               "Корейско стандартно време",
               "KST",
               "Корейско лятно часово време",
               "KST",
               "Корейско време",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Науру",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Непалско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Палау",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Самоанско стандартно време",
               "SST",
               "Самоанско лятно часово време",
               "SST",
               "Самоанско време",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Шова",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Тонга – стандартно време",
               "",
               "Тонга – лятно часово време",
               "",
               "Тонга",
               "",
            };
        final String[] Yukon = new String[] {
               "Юкон",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Аляска – стандартно време",
               "AKST",
               "Аляска – лятно часово време",
               "AKDT",
               "Аляска",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Амазонско стандартно време",
               "",
               "Амазонско лятно часово време",
               "",
               "Амазонско време",
               "",
            };
        final String[] Anadyr = new String[] {
               "Анадир – стандартно време",
               "",
               "Анадир – лятно часово време",
               "",
               "Анадир време",
               "",
            };
        final String[] Azores = new String[] {
               "Азорски острови – стандартно време",
               "",
               "Азорски острови – лятно часово време",
               "",
               "Азорски острови",
               "",
            };
        final String[] Bhutan = new String[] {
               "Бутанско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Бруней Даруссалам",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Великденски остров – стандартно време",
               "",
               "Великденски остров – лятно часово време",
               "",
               "Великденски остров",
               "",
            };
        final String[] Guyana = new String[] {
               "Гаяна",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Израелско стандартно време",
               "IST",
               "Израелско лятно часово време",
               "IDT",
               "Израелско време",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Кошрай",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Моусън",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Московско стандартно време",
               "MSK",
               "Московско лятно часово време",
               "MSK",
               "Московско време",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Понапе",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Самара – стандартно време",
               "",
               "Самара – лятно часово време",
               "",
               "Самара време",
               "",
            };
        final String[] Tahiti = new String[] {
               "Таитянско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Тайпе – стандартно време",
               "CST",
               "Тайпе – лятно часово време",
               "CDT",
               "Тайпе",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Тувалу",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Восток",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Уолис и Футуна",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Арабско стандартно време",
               "",
               "Арабско лятно часово време",
               "",
               "Арабско време",
               "",
            };
        final String[] Armenia = new String[] {
               "Арменско стандартно време",
               "",
               "Арменско лятно часово време",
               "",
               "Арменско време",
               "",
            };
        final String[] Bolivia = new String[] {
               "Боливийско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Чатъмско стандартно време",
               "",
               "Чатъмско лятно часово време",
               "",
               "Чатъмско време",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Координирано универсално време",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Еквадорско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Гамбие",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Грузинско стандартно време",
               "",
               "Грузинско лятно часово време",
               "",
               "Грузинско време",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Иркутско стандартно време",
               "",
               "Иркутско лятно часово време",
               "",
               "Иркутско време",
               "",
            };
        final String[] Magadan = new String[] {
               "Магаданско стандартно време",
               "",
               "Магаданско лятно часово време",
               "",
               "Магаданско време",
               "",
            };
        final String[] Myanmar = new String[] {
               "Мианмарско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Норфолкско стандартно време",
               "",
               "Норфолкско лятно часово време",
               "",
               "Норфолкско време",
               "",
            };
        final String[] Noronha = new String[] {
               "Фернандо де Нороня – стандартно време",
               "",
               "Фернандо де Нороня – лятно часово време",
               "",
               "Фернандо де Нороня",
               "",
            };
        final String[] Reunion = new String[] {
               "Реюнион",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ротера",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Соломонови острови",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Токелау",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Уругвайско стандартно време",
               "",
               "Уругвайско лятно часово време",
               "",
               "Уругвайско време",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Вануату – стандартно време",
               "",
               "Вануату – лятно часово време",
               "",
               "Вануату",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Якутскско стандартно време",
               "",
               "Якутскско лятно часово време",
               "",
               "Якутско време",
               "",
            };
        final String[] Atlantic = new String[] {
               "Северноамериканско атлантическо стандартно време",
               "AST",
               "Северноамериканско атлантическо лятно часово време",
               "AST",
               "Северноамериканско атлантическо време",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Бразилско стандартно време",
               "",
               "Бразилско лятно часово време",
               "",
               "Бразилско време",
               "",
            };
        final String[] Chamorro = new String[] {
               "Чаморско време",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Колумбийско стандартно време",
               "",
               "Колумбийско лятно часово време",
               "",
               "Колумбийско време",
               "",
            };
        final String[] Falkland = new String[] {
               "Фолклендски острови – стандартно време",
               "",
               "Фолклендски острови – лятно часово време",
               "",
               "Фолклендски острови",
               "",
            };
        final String[] Malaysia = new String[] {
               "Малайзийско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Малдивско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Уланбаторско стандартно време",
               "",
               "Уланбаторско лятно часово време",
               "",
               "Уланбаторско време",
               "",
            };
        final String[] Pakistan = new String[] {
               "Пакистанско стандартно време",
               "PKT",
               "Пакистанско лятно часово време",
               "PKST",
               "Пакистанско време",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Парагвайско стандартно време",
               "",
               "Парагвайско лятно часово време",
               "",
               "Парагвайско време",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Питкерн",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Сахалинско стандартно време",
               "",
               "Сахалинско лятно часово време",
               "",
               "Сахалинско време",
               "",
            };
        final String[] Suriname = new String[] {
               "Суринамско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Аржентинско стандартно време",
               "",
               "Аржентинско лятно часово време",
               "",
               "Аржентинско време",
               "",
            };
        final String[] Christmas = new String[] {
               "Остров Рождество",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Галапагоско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Хонконгско стандартно време",
               "HKT",
               "Хонконгско лятно часово време",
               "HKST",
               "Хонконгско време",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Индокитайско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Петропавловск-Камчатски стандартно време",
               "",
               "Петропавловск-Камчатски – лятно часово време",
               "",
               "Петропавловск-Камчатски време",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Киргизстанско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Лорд Хау – стандартно време",
               "",
               "Лорд Хау – лятно часово време",
               "",
               "Лорд Хау",
               "",
            };
        final String[] Marquesas = new String[] {
               "Маркизки острови",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Мавриций – стандартно време",
               "",
               "Мавриций – лятно часово време",
               "",
               "Мавриций",
               "",
            };
        final String[] Singapore = new String[] {
               "Сингапурско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Венецуелско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Волгоградско стандартно време",
               "MSK",
               "Волгоградско лятно часово време",
               "MSK",
               "Волгоградско време",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Азербайджанско стандартно време",
               "",
               "Азербайджанско лятно часово време",
               "",
               "Азербайджанско време",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Бангладешко стандартно време",
               "",
               "Бангладешко лятно часово време",
               "",
               "Бангладешко време",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Кабо Верде – стандартно време",
               "",
               "Кабо Верде – лятно часово време",
               "",
               "Кабо Верде",
               "",
            };
        final String[] East_Timor = new String[] {
               "Източнотиморско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Казахстанско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Сейшели",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Таджикистанско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Узбекистанско стандартно време",
               "",
               "Узбекистанско лятно часово време",
               "",
               "Узбекистанско време",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Афганистанско време",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Красноярско стандартно време",
               "",
               "Красноярско лятно часово време",
               "",
               "Красноярско време",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Новозеландско стандартно време",
               "NZST",
               "Новозеландско лятно часово време",
               "NZDT",
               "Новозеландско време",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Новосибирско стандартно време",
               "",
               "Новосибирско лятно часово време",
               "",
               "Новосибирско време",
               "",
            };
        final String[] Philippines = new String[] {
               "Филипинско стандартно време",
               "PST",
               "Филипинско лятно часово време",
               "PDT",
               "Филипинско време",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Владивостокско стандартно време",
               "",
               "Владивостокско лятно часово време",
               "",
               "Владивостокско време",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Индийски океан",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Екваториални острови",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Нюфаундлендско стандартно време",
               "NST",
               "Нюфаундлендско лятно часово време",
               "NDT",
               "Нюфаундлендско време",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Туркменистанско стандартно време",
               "",
               "Туркменистанско лятно часово време",
               "",
               "Туркменистанско време",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Френска Гвиана",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Новокаледонско стандартно време",
               "",
               "Новокаледонско лятно часово време",
               "",
               "Новокаледонско време",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Южна Джорджия",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Екатеринбургско стандартно време",
               "",
               "Екатеринбургско лятно часово време",
               "",
               "Екатеринбургско време",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Централноафриканско време",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Източноафриканско време",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Западноафриканско стандартно време",
               "WAT",
               "Западноафриканско лятно часово време",
               "WAT",
               "Западноафриканско време",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Дюмон Дюрвил",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Централноевропейско стандартно време",
               "CET",
               "Централноевропейско лятно часово време",
               "CEST",
               "Централноевропейско време",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Източноевропейско стандартно време",
               "EET",
               "Източноевропейско лятно часово време",
               "EEST",
               "Източноевропейско време",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Западноевропейско стандартно време",
               "WET",
               "Западноевропейско лятно време",
               "WEST",
               "Западноевропейско време",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Мексиканско тихоокеанско стандартно време",
               "MST",
               "Мексиканско тихоокеанско лятно часово време",
               "MDT",
               "Мексиканско тихоокеанско време",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Южноафриканско време",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Северноамериканско централно стандартно време",
               "CST",
               "Северноамериканско централно лятно часово време",
               "CDT",
               "Северноамериканско централно време",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Северноамериканско източно стандартно време",
               "EST",
               "Северноамериканско източно лятно часово време",
               "EST",
               "Северноамериканско източно време",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Северноамериканско тихоокеанско стандартно време",
               "PST",
               "Северноамериканско тихоокеанско лятно часово време",
               "PDT",
               "Северноамериканско тихоокеанско време",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Френски южни и антарктически територии",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Острови Гилбърт",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Хавайско-алеутско стандартно време",
               "HST",
               "Хавайско-алеутско лятно часово време",
               "HST",
               "Хавайско-алеутско време",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Острови Феникс",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Сен Пиер и Микелон – стандартно време",
               "",
               "Сен Пиер и Микелон – лятно часово време",
               "",
               "Сен Пиер и Микелон",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Северноамериканско планинско стандартно време",
               "MST",
               "Северноамериканско планинско лятно часово време",
               "MST",
               "Северноамериканско планинско време",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Маршалови острови",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Папуа Нова Гвинея",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Централноавстралийско стандартно време",
               "ACST",
               "Централноавстралийско лятно часово време",
               "ACDT",
               "Централноавстралийско време",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Източноавстралийско стандартно време",
               "AEST",
               "Източноавстралийско лятно часово време",
               "AEDT",
               "Източноавстралийско време",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Западноавстралийско стандартно време",
               "AWST",
               "Западноавстралийско лятно часово време",
               "AWDT",
               "Западноавстралийско време",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Централноиндонезийско време",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Източноиндонезийско време",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Западноиндонезийско време",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Австралия – западно централно стандартно време",
               "",
               "Австралия – западно централно лятно часово време",
               "",
               "Австралия – западно централно време",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Средно гринуичко време",
                    "GMT",
                    "Британско лятно часово време",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Координирано универсално време",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Средно гринуичко време",
                    "GMT",
                    "Ирландско стандартно време",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Координирано универсално време",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Координирано универсално време",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Средно гринуичко време",
                    "GMT",
                    "Британско лятно часово време",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Координирано универсално време",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Координирано универсално време",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Координирано универсално време",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Средно гринуичко време",
                    "GMT",
                    "Ирландско стандартно време",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Средно гринуичко време",
                    "GMT",
                    "Британско лятно часово време",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Средно гринуичко време",
                    "GMT",
                    "Британско лятно часово време",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Средно гринуичко време",
                    "GMT",
                    "Британско лятно часово време",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Средно гринуичко време",
                    "GMT",
                    "Британско лятно часово време",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Средно гринуичко време",
                    "GMT",
                    "Британско лятно часово време",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Аден" },
            { "timezone.excity.Asia/Baku", "Баку" },
            { "timezone.excity.Asia/Dili", "Дили" },
            { "timezone.excity.Asia/Gaza", "Газа" },
            { "timezone.excity.Asia/Hovd", "Ховд" },
            { "timezone.excity.Asia/Omsk", "Омск" },
            { "timezone.excity.Asia/Oral", "Арал" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Аман" },
            { "timezone.excity.Asia/Aqtau", "Актау" },
            { "timezone.excity.Asia/Chita", "Чита" },
            { "timezone.excity.Asia/Dhaka", "Дака" },
            { "timezone.excity.Asia/Dubai", "Дубай" },
            { "timezone.excity.Asia/Kabul", "Кабул" },
            { "timezone.excity.Asia/Macau", "Макао" },
            { "timezone.excity.Asia/Qatar", "Катар" },
            { "timezone.excity.Asia/Seoul", "Сеул" },
            { "timezone.excity.Asia/Tokyo", "Токио" },
            { "timezone.excity.Asia/Tomsk", "Томск" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Джуба" },
            { "timezone.excity.Africa/Lome", "Ломе" },
            { "timezone.excity.Asia/Almaty", "Алмати" },
            { "timezone.excity.Asia/Anadyr", "Анадир" },
            { "timezone.excity.Asia/Aqtobe", "Актобе" },
            { "timezone.excity.Asia/Atyrau", "Атърау" },
            { "timezone.excity.Asia/Beirut", "Бейрут" },
            { "timezone.excity.Asia/Brunei", "Бруней" },
            { "timezone.excity.Asia/Hebron", "Хеброн" },
            { "timezone.excity.Asia/Kuwait", "Кувейт" },
            { "timezone.excity.Asia/Manila", "Манила" },
            { "timezone.excity.Asia/Muscat", "Мускат" },
            { "timezone.excity.Asia/Riyadh", "Рияд" },
            { "timezone.excity.Asia/Saigon", "Хошимин" },
            { "timezone.excity.Asia/Taipei", "Тайпе" },
            { "timezone.excity.Asia/Tehran", "Техеран" },
            { "timezone.excity.Asia/Urumqi", "Урумчи" },
            { "timezone.excity.Etc/Unknown", "неизвестен град" },
            { "timezone.excity.Europe/Kiev", "Киев" },
            { "timezone.excity.Europe/Oslo", "Осло" },
            { "timezone.excity.Europe/Riga", "Рига" },
            { "timezone.excity.Europe/Rome", "Рим" },
            { "timezone.excity.Indian/Mahe", "Мае" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Акра" },
            { "timezone.excity.Africa/Cairo", "Кайро" },
            { "timezone.excity.Africa/Ceuta", "Сеута" },
            { "timezone.excity.Africa/Dakar", "Дакар" },
            { "timezone.excity.Africa/Lagos", "Лагос" },
            { "timezone.excity.Africa/Tunis", "Тунис" },
            { "timezone.excity.America/Adak", "Адак" },
            { "timezone.excity.America/Lima", "Лима" },
            { "timezone.excity.America/Nome", "Ноум" },
            { "timezone.excity.Asia/Baghdad", "Багдад" },
            { "timezone.excity.Asia/Bahrain", "Бахрейн" },
            { "timezone.excity.Asia/Bangkok", "Банкок" },
            { "timezone.excity.Asia/Barnaul", "Барнаул" },
            { "timezone.excity.Asia/Bishkek", "Бишкек" },
            { "timezone.excity.Asia/Colombo", "Коломбо" },
            { "timezone.excity.Asia/Irkutsk", "Иркутск" },
            { "timezone.excity.Asia/Jakarta", "Джакарта" },
            { "timezone.excity.Asia/Karachi", "Карачи" },
            { "timezone.excity.Asia/Kuching", "Кучин" },
            { "timezone.excity.Asia/Magadan", "Магадан" },
            { "timezone.excity.Asia/Nicosia", "Никозия" },
            { "timezone.excity.Asia/Rangoon", "Рангун" },
            { "timezone.excity.Asia/Tbilisi", "Тбилиси" },
            { "timezone.excity.Asia/Thimphu", "Тхимпху" },
            { "timezone.excity.Asia/Yakutsk", "Якутск" },
            { "timezone.excity.Asia/Yerevan", "Ереван" },
            { "timezone.excity.Europe/Kirov", "Киров" },
            { "timezone.excity.Europe/Malta", "Малта" },
            { "timezone.excity.Europe/Minsk", "Минск" },
            { "timezone.excity.Europe/Paris", "Париж" },
            { "timezone.excity.Europe/Sofia", "София" },
            { "timezone.excity.Europe/Vaduz", "Вадуц" },
            { "timezone.excity.Indian/Cocos", "Кокосови острови" },
            { "timezone.excity.Pacific/Apia", "Апия" },
            { "timezone.excity.Pacific/Fiji", "Фиджи" },
            { "timezone.excity.Pacific/Guam", "Гуам" },
            { "timezone.excity.Pacific/Niue", "Ниуе" },
            { "timezone.excity.Pacific/Truk", "Чуюк" },
            { "timezone.excity.Pacific/Wake", "Уейк" },
            { "timezone.excity.Africa/Asmera", "Асмара" },
            { "timezone.excity.Africa/Bamako", "Бамако" },
            { "timezone.excity.Africa/Bangui", "Бангуи" },
            { "timezone.excity.Africa/Banjul", "Банджул" },
            { "timezone.excity.Africa/Bissau", "Бисау" },
            { "timezone.excity.Africa/Douala", "Дуала" },
            { "timezone.excity.Africa/Harare", "Хараре" },
            { "timezone.excity.Africa/Kigali", "Кигали" },
            { "timezone.excity.Africa/Luanda", "Луанда" },
            { "timezone.excity.Africa/Lusaka", "Лусака" },
            { "timezone.excity.Africa/Malabo", "Малабо" },
            { "timezone.excity.Africa/Maputo", "Мапуто" },
            { "timezone.excity.Africa/Maseru", "Масеру" },
            { "timezone.excity.Africa/Niamey", "Ниамей" },
            { "timezone.excity.America/Aruba", "Аруба" },
            { "timezone.excity.America/Bahia", "Баия" },
            { "timezone.excity.America/Belem", "Белем" },
            { "timezone.excity.America/Boise", "Бойси" },
            { "timezone.excity.America/Jujuy", "Хухуй" },
            { "timezone.excity.America/Sitka", "Ситка" },
            { "timezone.excity.America/Thule", "Туле" },
            { "timezone.excity.Asia/Ashgabat", "Ашхабад" },
            { "timezone.excity.Asia/Calcutta", "Колката" },
            { "timezone.excity.Asia/Damascus", "Дамаск" },
            { "timezone.excity.Asia/Dushanbe", "Душанбе" },
            { "timezone.excity.Asia/Jayapura", "Джаяпура" },
            { "timezone.excity.Asia/Katmandu", "Катманду" },
            { "timezone.excity.Asia/Khandyga", "Хандига" },
            { "timezone.excity.Asia/Makassar", "Макасар" },
            { "timezone.excity.Asia/Qostanay", "Костанай" },
            { "timezone.excity.Asia/Sakhalin", "Сахалин" },
            { "timezone.excity.Asia/Shanghai", "Шанхай" },
            { "timezone.excity.Asia/Tashkent", "Ташкент" },
            { "timezone.excity.Asia/Ust-Nera", "Уст-Нера" },
            { "timezone.excity.Europe/Athens", "Атина" },
            { "timezone.excity.Europe/Berlin", "Берлин" },
            { "timezone.excity.Europe/Dublin", "Дъблин" },
            { "timezone.excity.Europe/Jersey", "Джърси" },
            { "timezone.excity.Europe/Lisbon", "Лисабон" },
            { "timezone.excity.Europe/London", "Лондон" },
            { "timezone.excity.Europe/Madrid", "Мадрид" },
            { "timezone.excity.Europe/Monaco", "Монако" },
            { "timezone.excity.Europe/Moscow", "Москва" },
            { "timezone.excity.Europe/Prague", "Прага" },
            { "timezone.excity.Europe/Samara", "Самара" },
            { "timezone.excity.Europe/Skopje", "Скопие" },
            { "timezone.excity.Europe/Tirane", "Тирана" },
            { "timezone.excity.Europe/Vienna", "Виена" },
            { "timezone.excity.Europe/Warsaw", "Варшава" },
            { "timezone.excity.Europe/Zagreb", "Загреб" },
            { "timezone.excity.Europe/Zurich", "Цюрих" },
            { "timezone.excity.Indian/Chagos", "Чагос" },
            { "timezone.excity.Indian/Comoro", "Коморски острови" },
            { "timezone.excity.Pacific/Efate", "Ефате" },
            { "timezone.excity.Pacific/Nauru", "Науру" },
            { "timezone.excity.Pacific/Palau", "Палау" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Абиджан" },
            { "timezone.excity.Africa/Algiers", "Алжир" },
            { "timezone.excity.Africa/Conakry", "Конакри" },
            { "timezone.excity.Africa/Kampala", "Кампала" },
            { "timezone.excity.Africa/Mbabane", "Мбабане" },
            { "timezone.excity.Africa/Nairobi", "Найроби" },
            { "timezone.excity.Africa/Tripoli", "Триполи" },
            { "timezone.excity.America/Belize", "Белиз" },
            { "timezone.excity.America/Bogota", "Богота" },
            { "timezone.excity.America/Cancun", "Канкун" },
            { "timezone.excity.America/Cayman", "Кайманови острови" },
            { "timezone.excity.America/Cuiaba", "Чуяба" },
            { "timezone.excity.America/Dawson", "Доусън" },
            { "timezone.excity.America/Denver", "Денвър" },
            { "timezone.excity.America/Guyana", "Гаяна" },
            { "timezone.excity.America/Havana", "Хавана" },
            { "timezone.excity.America/Inuvik", "Инувик" },
            { "timezone.excity.America/Juneau", "Джуно" },
            { "timezone.excity.America/La_Paz", "Ла Пас" },
            { "timezone.excity.America/Maceio", "Масейо" },
            { "timezone.excity.America/Manaus", "Манаус" },
            { "timezone.excity.America/Merida", "Мерида" },
            { "timezone.excity.America/Nassau", "Насау" },
            { "timezone.excity.America/Panama", "Панама" },
            { "timezone.excity.America/Recife", "Ресифе" },
            { "timezone.excity.America/Regina", "Риджайна" },
            { "timezone.excity.Asia/Famagusta", "Фамагуста" },
            { "timezone.excity.Asia/Hong_Kong", "Хонконг" },
            { "timezone.excity.Asia/Jerusalem", "Йерусалим" },
            { "timezone.excity.Asia/Kamchatka", "Камчатка" },
            { "timezone.excity.Asia/Pontianak", "Понтианак" },
            { "timezone.excity.Asia/Pyongyang", "Пхенян" },
            { "timezone.excity.Asia/Qyzylorda", "Къзълорда" },
            { "timezone.excity.Asia/Samarkand", "Самарканд" },
            { "timezone.excity.Asia/Singapore", "Сингапур" },
            { "timezone.excity.Asia/Vientiane", "Виентян" },
            { "timezone.excity.Europe/Andorra", "Андора" },
            { "timezone.excity.Europe/Saratov", "Саратов" },
            { "timezone.excity.Europe/Tallinn", "Талин" },
            { "timezone.excity.Europe/Vatican", "Ватикан" },
            { "timezone.excity.Europe/Vilnius", "Вилнюс" },
            { "timezone.excity.Indian/Mayotte", "Майот" },
            { "timezone.excity.Indian/Reunion", "Реюнион" },
            { "timezone.excity.Pacific/Easter", "Великденски остров" },
            { "timezone.excity.Pacific/Kanton", "Кантон" },
            { "timezone.excity.Pacific/Kosrae", "Кошрай" },
            { "timezone.excity.Pacific/Majuro", "Маджуро" },
            { "timezone.excity.Pacific/Midway", "Мидуей" },
            { "timezone.excity.Pacific/Noumea", "Нумеа" },
            { "timezone.excity.Pacific/Ponape", "Понпей" },
            { "timezone.excity.Pacific/Saipan", "Сайпан" },
            { "timezone.excity.Pacific/Tahiti", "Таити" },
            { "timezone.excity.Pacific/Tarawa", "Тарауа" },
            { "timezone.excity.Pacific/Wallis", "Уолис" },
            { "timezone.excity.Africa/Blantyre", "Блантайър" },
            { "timezone.excity.Africa/Djibouti", "Джибути" },
            { "timezone.excity.Africa/El_Aaiun", "Ел Аюн" },
            { "timezone.excity.Africa/Freetown", "Фрийтаун" },
            { "timezone.excity.Africa/Gaborone", "Габороне" },
            { "timezone.excity.Africa/Khartoum", "Хартум" },
            { "timezone.excity.Africa/Kinshasa", "Киншаса" },
            { "timezone.excity.Africa/Monrovia", "Монровия" },
            { "timezone.excity.Africa/Ndjamena", "Нджамена" },
            { "timezone.excity.Africa/Sao_Tome", "Сао Томе" },
            { "timezone.excity.Africa/Windhoek", "Виндхук" },
            { "timezone.excity.America/Antigua", "Антигуа" },
            { "timezone.excity.America/Caracas", "Каракас" },
            { "timezone.excity.America/Cayenne", "Кайен" },
            { "timezone.excity.America/Chicago", "Чикаго" },
            { "timezone.excity.America/Cordoba", "Кордоба" },
            { "timezone.excity.America/Creston", "Крестън" },
            { "timezone.excity.America/Curacao", "Кюрасао" },
            { "timezone.excity.America/Detroit", "Детройт" },
            { "timezone.excity.America/Godthab", "Нуук" },
            { "timezone.excity.America/Grenada", "Гренада" },
            { "timezone.excity.America/Halifax", "Халифакс" },
            { "timezone.excity.America/Iqaluit", "Иквалуит" },
            { "timezone.excity.America/Jamaica", "Ямайка" },
            { "timezone.excity.America/Managua", "Манагуа" },
            { "timezone.excity.America/Marigot", "Мариго" },
            { "timezone.excity.America/Mendoza", "Мендоса" },
            { "timezone.excity.America/Moncton", "Монктон" },
            { "timezone.excity.America/Noronha", "Нороня" },
            { "timezone.excity.America/Ojinaga", "Охинага" },
            { "timezone.excity.America/Phoenix", "Финикс" },
            { "timezone.excity.America/Tijuana", "Тихуана" },
            { "timezone.excity.America/Toronto", "Торонто" },
            { "timezone.excity.America/Tortola", "Тортола" },
            { "timezone.excity.America/Yakutat", "Якутат" },
            { "timezone.excity.Asia/Phnom_Penh", "Пном Пен" },
            { "timezone.excity.Atlantic/Azores", "Азорски острови" },
            { "timezone.excity.Atlantic/Canary", "Канарски острови" },
            { "timezone.excity.Atlantic/Faeroe", "Фарьорски острови" },
            { "timezone.excity.Australia/Eucla", "Юкла" },
            { "timezone.excity.Australia/Perth", "Пърт" },
            { "timezone.excity.Europe/Belgrade", "Белград" },
            { "timezone.excity.Europe/Brussels", "Брюксел" },
            { "timezone.excity.Europe/Budapest", "Будапеща" },
            { "timezone.excity.Europe/Busingen", "Бюзинген" },
            { "timezone.excity.Europe/Chisinau", "Кишинев" },
            { "timezone.excity.Europe/Guernsey", "Гърнзи" },
            { "timezone.excity.Europe/Helsinki", "Хелзинки" },
            { "timezone.excity.Europe/Istanbul", "Истанбул" },
            { "timezone.excity.Europe/Sarajevo", "Сараево" },
            { "timezone.excity.Indian/Maldives", "Малдиви" },
            { "timezone.excity.Pacific/Chatham", "Чатам" },
            { "timezone.excity.Pacific/Fakaofo", "Факаофо" },
            { "timezone.excity.Pacific/Gambier", "Гамбие" },
            { "timezone.excity.Pacific/Norfolk", "Норфолк" },
            { "timezone.excity.Africa/Bujumbura", "Бужумбура" },
            { "timezone.excity.Africa/Mogadishu", "Могадишу" },
            { "timezone.excity.America/Anguilla", "Ангуила" },
            { "timezone.excity.America/Asuncion", "Асунсион" },
            { "timezone.excity.America/Barbados", "Барбадос" },
            { "timezone.excity.America/Dominica", "Доминика" },
            { "timezone.excity.America/Edmonton", "Едмънтън" },
            { "timezone.excity.America/Eirunepe", "Ейрунепе" },
            { "timezone.excity.America/Mazatlan", "Масатлан" },
            { "timezone.excity.America/Miquelon", "Микелон" },
            { "timezone.excity.America/New_York", "Ню Йорк" },
            { "timezone.excity.America/Resolute", "Резолют" },
            { "timezone.excity.America/Santarem", "Сантарем" },
            { "timezone.excity.America/Santiago", "Сантяго" },
            { "timezone.excity.America/St_Johns", "Сейнт Джонс" },
            { "timezone.excity.America/St_Kitts", "Сейнт Китс" },
            { "timezone.excity.America/St_Lucia", "Сейнт Лусия" },
            { "timezone.excity.America/Winnipeg", "Уинипег" },
            { "timezone.excity.Antarctica/Casey", "Кейси" },
            { "timezone.excity.Antarctica/Davis", "Дейвис" },
            { "timezone.excity.Antarctica/Syowa", "Шова" },
            { "timezone.excity.Antarctica/Troll", "Трол" },
            { "timezone.excity.Asia/Krasnoyarsk", "Красноярск" },
            { "timezone.excity.Asia/Novosibirsk", "Новосибирск" },
            { "timezone.excity.Asia/Ulaanbaatar", "Улан Батор" },
            { "timezone.excity.Asia/Vladivostok", "Владивосток" },
            { "timezone.excity.Atlantic/Bermuda", "Бермудски острови" },
            { "timezone.excity.Atlantic/Madeira", "Мадейра" },
            { "timezone.excity.Atlantic/Stanley", "Стенли" },
            { "timezone.excity.Australia/Darwin", "Дарвин" },
            { "timezone.excity.Australia/Hobart", "Хобарт" },
            { "timezone.excity.Australia/Sydney", "Сидни" },
            { "timezone.excity.Europe/Amsterdam", "Амстердам" },
            { "timezone.excity.Europe/Astrakhan", "Астрахан" },
            { "timezone.excity.Europe/Bucharest", "Букурещ" },
            { "timezone.excity.Europe/Gibraltar", "Гибралтар" },
            { "timezone.excity.Europe/Ljubljana", "Любляна" },
            { "timezone.excity.Europe/Mariehamn", "Мариехамн" },
            { "timezone.excity.Europe/Podgorica", "Подгорица" },
            { "timezone.excity.Europe/Stockholm", "Стокхолм" },
            { "timezone.excity.Europe/Ulyanovsk", "Уляновск" },
            { "timezone.excity.Europe/Volgograd", "Волгоград" },
            { "timezone.excity.Indian/Christmas", "Рождество" },
            { "timezone.excity.Indian/Kerguelen", "Кергелен" },
            { "timezone.excity.Indian/Mauritius", "Мавриций" },
            { "timezone.excity.Pacific/Auckland", "Окланд" },
            { "timezone.excity.Pacific/Funafuti", "Фунафути" },
            { "timezone.excity.Pacific/Honolulu", "Хонолулу" },
            { "timezone.excity.Pacific/Pitcairn", "Питкерн" },
            { "timezone.excity.Africa/Casablanca", "Казабланка" },
            { "timezone.excity.Africa/Libreville", "Либревил" },
            { "timezone.excity.Africa/Lubumbashi", "Лубумбаши" },
            { "timezone.excity.Africa/Nouakchott", "Нуакшот" },
            { "timezone.excity.Africa/Porto-Novo", "Порто Ново" },
            { "timezone.excity.America/Anchorage", "Анкъридж" },
            { "timezone.excity.America/Araguaina", "Арагуайна" },
            { "timezone.excity.America/Boa_Vista", "Боа Виста" },
            { "timezone.excity.America/Catamarca", "Катамарка" },
            { "timezone.excity.America/Chihuahua", "Чиуауа" },
            { "timezone.excity.America/Fortaleza", "Форталеза" },
            { "timezone.excity.America/Glace_Bay", "Глейс Бей" },
            { "timezone.excity.America/Goose_Bay", "Гус Бей" },
            { "timezone.excity.America/Guatemala", "Гватемала" },
            { "timezone.excity.America/Guayaquil", "Гуаякил" },
            { "timezone.excity.America/Matamoros", "Матаморос" },
            { "timezone.excity.America/Menominee", "Меномини" },
            { "timezone.excity.America/Monterrey", "Монтерей" },
            { "timezone.excity.America/Sao_Paulo", "Сао Пауло" },
            { "timezone.excity.America/St_Thomas", "Сейнт Томас" },
            { "timezone.excity.America/Vancouver", "Ванкувър" },
            { "timezone.excity.Antarctica/Mawson", "Моусън" },
            { "timezone.excity.Antarctica/Palmer", "Палмър" },
            { "timezone.excity.Antarctica/Vostok", "Восток" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Куала Лумпур" },
            { "timezone.excity.Asia/Novokuznetsk", "Новокузнецк" },
            { "timezone.excity.Europe/Bratislava", "Братислава" },
            { "timezone.excity.Europe/Copenhagen", "Копенхаген" },
            { "timezone.excity.Europe/Luxembourg", "Люксембург" },
            { "timezone.excity.Europe/San_Marino", "Сан Марино" },
            { "timezone.excity.Europe/Simferopol", "Симферопол" },
            { "timezone.excity.Pacific/Enderbury", "Ендърбъри" },
            { "timezone.excity.Pacific/Galapagos", "Галапагос" },
            { "timezone.excity.Pacific/Kwajalein", "Куаджалин" },
            { "timezone.excity.Pacific/Marquesas", "Маркизки острови" },
            { "timezone.excity.Pacific/Pago_Pago", "Паго Паго" },
            { "timezone.excity.Pacific/Rarotonga", "Раротонга" },
            { "timezone.excity.Pacific/Tongatapu", "Тонгатапу" },
            { "timezone.excity.Africa/Addis_Ababa", "Адис Абеба" },
            { "timezone.excity.Africa/Brazzaville", "Бразавил" },
            { "timezone.excity.Africa/Ouagadougou", "Уагадугу" },
            { "timezone.excity.America/Costa_Rica", "Коста Рика" },
            { "timezone.excity.America/Grand_Turk", "Гранд Търк" },
            { "timezone.excity.America/Guadeloupe", "Гваделупа" },
            { "timezone.excity.America/Hermosillo", "Ермосильо" },
            { "timezone.excity.America/Kralendijk", "Кралендейк" },
            { "timezone.excity.America/Louisville", "Луисвил" },
            { "timezone.excity.America/Martinique", "Мартиника" },
            { "timezone.excity.America/Metlakatla", "Метлакатла" },
            { "timezone.excity.America/Montevideo", "Монтевидео" },
            { "timezone.excity.America/Montserrat", "Монтсерат" },
            { "timezone.excity.America/Paramaribo", "Парамарибо" },
            { "timezone.excity.America/Rio_Branco", "Рио Бранко" },
            { "timezone.excity.America/St_Vincent", "Сейнт Винсънт" },
            { "timezone.excity.America/Whitehorse", "Уайтхорс" },
            { "timezone.excity.Antarctica/McMurdo", "Макмърдо" },
            { "timezone.excity.Antarctica/Rothera", "Ротера" },
            { "timezone.excity.Asia/Srednekolymsk", "Среднеколимск" },
            { "timezone.excity.Asia/Yekaterinburg", "Екатеринбург" },
            { "timezone.excity.Atlantic/Reykjavik", "Рейкявик" },
            { "timezone.excity.Atlantic/St_Helena", "Света Елена" },
            { "timezone.excity.Australia/Adelaide", "Аделаида" },
            { "timezone.excity.Australia/Brisbane", "Бризбейн" },
            { "timezone.excity.Australia/Lindeman", "Линдеман" },
            { "timezone.excity.Europe/Isle_of_Man", "остров Ман" },
            { "timezone.excity.Europe/Kaliningrad", "Калининград" },
            { "timezone.excity.Pacific/Kiritimati", "Киритимати" },
            { "timezone.excity.Africa/Johannesburg", "Йоханесбург" },
            { "timezone.excity.America/El_Salvador", "Салвадор" },
            { "timezone.excity.America/Fort_Nelson", "Форт Нелсън" },
            { "timezone.excity.America/Los_Angeles", "Лос Анджелис" },
            { "timezone.excity.America/Mexico_City", "Мексико Сити" },
            { "timezone.excity.America/Porto_Velho", "Порто Вельо" },
            { "timezone.excity.America/Puerto_Rico", "Пуерто Рико" },
            { "timezone.excity.America/Tegucigalpa", "Тегусигалпа" },
            { "timezone.excity.Arctic/Longyearbyen", "Лонгирбюен" },
            { "timezone.excity.Atlantic/Cape_Verde", "Кабо Верде" },
            { "timezone.excity.Australia/Lord_Howe", "Лорд Хау" },
            { "timezone.excity.Australia/Melbourne", "Мелбърн" },
            { "timezone.excity.Indian/Antananarivo", "Антананариво" },
            { "timezone.excity.Pacific/Guadalcanal", "Гуадалканал" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Дар ес Салам" },
            { "timezone.excity.America/Blanc-Sablon", "Блан-Саблон" },
            { "timezone.excity.America/Buenos_Aires", "Буенос Айрес" },
            { "timezone.excity.America/Campo_Grande", "Кампо Гранде" },
            { "timezone.excity.America/Danmarkshavn", "Данмарксхавн" },
            { "timezone.excity.America/Dawson_Creek", "Доусън Крийк" },
            { "timezone.excity.America/Indiana/Knox", "Нокс" },
            { "timezone.excity.America/Indianapolis", "Индианаполис" },
            { "timezone.excity.America/Punta_Arenas", "Пунта Аренас" },
            { "timezone.excity.America/Rankin_Inlet", "Ранкин Инлет" },
            { "timezone.excity.America/Scoresbysund", "Сгорсбисон" },
            { "timezone.excity.Antarctica/Macquarie", "Маккуори" },
            { "timezone.excity.Pacific/Bougainville", "Бугенвил" },
            { "timezone.excity.Pacific/Port_Moresby", "Порт Морсби" },
            { "timezone.excity.America/Cambridge_Bay", "Кеймбридж Бей" },
            { "timezone.excity.America/Ciudad_Juarez", "Сиудад Хуарес" },
            { "timezone.excity.America/Coral_Harbour", "Атикокан" },
            { "timezone.excity.America/Indiana/Vevay", "Виви" },
            { "timezone.excity.America/Lower_Princes", "Лоуър принсес куотър" },
            { "timezone.excity.America/Port_of_Spain", "Порт ъф Спейн" },
            { "timezone.excity.America/Santo_Domingo", "Санто Доминго" },
            { "timezone.excity.America/St_Barthelemy", "Сен Бартелеми" },
            { "timezone.excity.America/Swift_Current", "Суифт Кърент" },
            { "timezone.excity.Australia/Broken_Hill", "Броукън Хил" },
            { "timezone.excity.America/Bahia_Banderas", "Баия де Бандерас" },
            { "timezone.excity.America/Port-au-Prince", "Порт-о-Пренс" },
            { "timezone.excity.Atlantic/South_Georgia", "Южна Джорджия" },
            { "timezone.excity.America/Argentina/Salta", "Салта" },
            { "timezone.excity.America/Indiana/Marengo", "Маренго" },
            { "timezone.excity.America/Indiana/Winamac", "Уинамак" },
            { "timezone.excity.America/Argentina/Tucuman", "Тукуман" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ушуая" },
            { "timezone.excity.America/Indiana/Tell_City", "Тел Сити" },
            { "timezone.excity.America/Indiana/Vincennes", "Винсенс" },
            { "timezone.excity.Antarctica/DumontDUrville", "Дюмон Дюрвил" },
            { "timezone.excity.America/Argentina/La_Rioja", "Ла Риоха" },
            { "timezone.excity.America/Argentina/San_Juan", "Сан Хуан" },
            { "timezone.excity.America/Argentina/San_Luis", "Сан Луис" },
            { "timezone.excity.America/Indiana/Petersburg", "Питърсбърг" },
            { "timezone.excity.America/Kentucky/Monticello", "Монтичело" },
            { "timezone.excity.America/North_Dakota/Beulah", "Бюла" },
            { "timezone.excity.America/North_Dakota/Center", "Сентър" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Рио Галегос" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Ню Сейлъм" },
        };
        return data;
    }
}
