//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cFlamer.cpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cFlamer.hpp"
#include "cParticleSystem.hpp"
#include "cWorld.hpp"
#include "Debug.hpp"
#include "cMixer.hpp"
#include "cTextureManager.hpp"
#include "cFlameSystem.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================
		
void 
cFlamer::Update (Uint32 deltaTime)
{
	cWeapon::Update (deltaTime);
	
  
  	if ( IsFiring () ){
		mLighter->SetEmitDelay (7);
	} else
		mLighter->SetEmitDelay (0);
}


//! Constructor
cFlamer::cFlamer (void):
cWeapon (50, 100, 3000),
mSound (cMixer::GetInstance ().LoadSound ("flamer.wav")),
mChannel (-2)
{
	
	SetAmmo (50, 2);

	mFlame = new cFlameSystem;
	mFlame->SetParent (this);
	cWorld::GetInstance ().SpawnObject (mFlame);
	
	mLighter = new cParticleSystem (10);
	mLighter->SetAngleVariation (4.0f);
	mLighter->SetSpeed (0.4f, 0.3f);
	mLighter->SetBlending ();
	mLighter->SetSize (1.0f, 6.0f);
	mLighter->SetEnergy (70, 0.3f);
	mLighter->SetEmitDelay (0);
	mLighter->SetStartColor (0.0f, 0.0f, 1.0f, 1.0f);
	mLighter->SetEndColor (0.0f, 0.0f, 1.0f, 0.0f);
	mLighter->SetParent (this);
	cWorld::GetInstance ().SpawnObject (mLighter);
};

//! Destructor
cFlamer::~cFlamer (void)
{
	// Empty
};

void 
cFlamer::OnSetActive (void)
{
	if ( !mFlame->IsAlive () )
		cWorld::GetInstance ().SpawnObject (mFlame);
	if ( !mLighter->IsAlive () )
		cWorld::GetInstance ().SpawnObject (mLighter);

	mFlame->SetEmitter (GetShooter ());
	mFlame->SetOwner (GetOwner ());
	mLighter->SetEmitter (GetShooter ());
	
	if ( !IsActive () )
	{
		EndFiring ();
		mFlame->SetEmitDelay (0);
	  	mLighter->SetEmitDelay (0);
	}
}

void 
cFlamer::BeginFiring (void)
{
	if ( mChannel < 0 )
		mChannel = cMixer::GetInstance ().PlaySound (mSound,-1);
	mFlame->SetEmitDelay (7);
}

void 
cFlamer::EndFiring (void)
{
	if ( mChannel >= 0 )
	{
		cMixer::GetInstance ().StopSound (mChannel,400);
		mChannel = -2;
	}
	mFlame->SetEmitDelay (0);
}

//==============================================================================
// EOF
//==============================================================================
