/*
 * Decompiled with CFR 0.152.
 */
package gogoHID.extension;

import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.api.Reporter;
import org.nlogo.app.App;
import org.nlogo.app.App$;
import org.nlogo.awt.UserCancelException;
import org.nlogo.core.LogoList;
import org.nlogo.core.Primitive;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;
import org.nlogo.swing.BrowserLauncher;
import org.nlogo.swing.FileDialog;
import org.nlogo.swing.OptionDialog;

public class HIDGogoExtension
extends DefaultClassManager {
    static final String javaLocationPropertyKey = "netlogo.extensions.gogo.javaexecutable";
    private boolean shownErrorMessage = false;
    private OutputStream os = null;
    private InputStream is = null;
    private InputStream err = null;
    private Process proc = null;
    private boolean stillRunning = false;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    private void alertToNewGogoBoards(String primitiveName) throws ExtensionException {
        if (!this.shownErrorMessage) {
            int choice;
            while ((choice = OptionDialog.showMessage((Component)App.app().frame(), (String)"GoGo Extension has been updated!", (String)("This model is using a primitive (gogo:" + primitiveName + ") from the old version of the GoGo extension.  Use gogo-serial for older GoGo boards."), (Object[])new String[]{"More Information", "Close"})) != 1) {
                URI uri = null;
                try {
                    uri = new URI("https://github.com/NetLogo/NetLogo/wiki/GoGo-Upgrade");
                }
                catch (URISyntaxException ex) {
                    System.getProperties().put("org.nlogo.gogo.shownErrorMessage", "");
                    throw new ExtensionException("Could not create GoGo upgrade URI?");
                }
                BrowserLauncher.openURI((Component)App.app().frame(), (URI)uri);
            }
            System.getProperties().put("org.nlogo.gogo.shownErrorMessage", "");
            this.shownErrorMessage = true;
        }
    }

    public void load(PrimitiveManager pm) throws ExtensionException {
        this.shownErrorMessage = System.getProperties().containsKey("org.nlogo.gogo.shownErrorMessage");
        pm.addPrimitive("primitives", (Primitive)new Prims());
        pm.addPrimitive("beep", (Primitive)new Beep());
        pm.addPrimitive("read-sensors", (Primitive)new ReadSensors());
        pm.addPrimitive("read-sensor", (Primitive)new ReadSensorNumber());
        pm.addPrimitive("led", (Primitive)new LED());
        pm.addPrimitive("talk-to-output-ports", (Primitive)new TalkToOutputPort());
        pm.addPrimitive("set-output-port-power", (Primitive)new SetOutputPortPower());
        pm.addPrimitive("output-port-on", (Primitive)new OutputPortOn());
        pm.addPrimitive("output-port-off", (Primitive)new OutputPortOff());
        pm.addPrimitive("output-port-clockwise", (Primitive)new OutputPortClockwise());
        pm.addPrimitive("output-port-counterclockwise", (Primitive)new OutputPortCounterClockwise());
        pm.addPrimitive("set-servo", (Primitive)new SetServo());
        pm.addPrimitive("read-all", (Primitive)new ReadAll());
        pm.addPrimitive("send-bytes", (Primitive)new SendBytes());
        pm.addPrimitive("howmany-gogos", (Primitive)new Enumerate());
        pm.addPrimitive("ports", (Primitive)new OldReporter("ports", SyntaxJ.reporterSyntax((int)Syntax.ListType())));
        pm.addPrimitive("burst-value", (Primitive)new OldReporter("burst-value", SyntaxJ.reporterSyntax((int[])new int[]{Syntax.NumberType()}, (int)Syntax.NumberType())));
        pm.addPrimitive("close", (Primitive)new OldCommand("close", SyntaxJ.commandSyntax()));
        pm.addPrimitive("install", (Primitive)new OldCommand("install", SyntaxJ.commandSyntax()));
        pm.addPrimitive("led-off", (Primitive)new OldCommand("led-off", SyntaxJ.commandSyntax()));
        pm.addPrimitive("led-on", (Primitive)new OldCommand("led-on", SyntaxJ.commandSyntax()));
        pm.addPrimitive("open", (Primitive)new OldCommand("open", SyntaxJ.commandSyntax((int[])new int[]{Syntax.StringType()})));
        pm.addPrimitive("open?", (Primitive)new OldReporter("open?", SyntaxJ.reporterSyntax((int)Syntax.BooleanType())));
        pm.addPrimitive("output-port-coast", (Primitive)new OldCommand("output-port-coast", SyntaxJ.commandSyntax()));
        pm.addPrimitive("output-port-reverse", (Primitive)new OldCommand("output-port-reverse", SyntaxJ.commandSyntax()));
        pm.addPrimitive("output-port-thatway", (Primitive)new OldCommand("output-port-thatway", SyntaxJ.commandSyntax()));
        pm.addPrimitive("output-port-thisway", (Primitive)new OldCommand("output-port-thisway", SyntaxJ.commandSyntax()));
        pm.addPrimitive("ping", (Primitive)new OldReporter("ping", SyntaxJ.reporterSyntax((int)Syntax.BooleanType())));
        pm.addPrimitive("sensor", (Primitive)new OldReporter("sensor", SyntaxJ.reporterSyntax((int[])new int[]{Syntax.NumberType()}, (int)Syntax.NumberType())));
        pm.addPrimitive("set-burst-mode", (Primitive)new OldCommand("set-burst-mode", SyntaxJ.commandSyntax((int[])new int[]{Syntax.ListType(), Syntax.BooleanType()})));
        pm.addPrimitive("stop-burst-mode", (Primitive)new OldCommand("stop-burst-mode", SyntaxJ.commandSyntax()));
        try {
            this.bootHIDDaemon();
        }
        catch (Exception e) {
            System.err.println("FAILED TO BOOT DAEMON");
            e.printStackTrace();
            throw new ExtensionException("Error in loading HID services");
        }
    }

    public void unload(ExtensionManager pm) throws ExtensionException {
        if (this.proc == null && !this.proc.isAlive()) {
            System.err.println("Daemon process was not alive, not attempting to shut it down.");
            return;
        }
        System.err.println("Unloading GoGo extension, shutting down daemon.");
        try {
            this.os.write(88);
            this.os.flush();
            this.proc.waitFor(5L, TimeUnit.SECONDS);
            this.os.close();
            this.is.close();
            this.err.close();
        }
        catch (IOException e) {
            System.err.println("Failed to close GoGo extension resources.");
            e.printStackTrace();
            throw new ExtensionException("Failed to close GoGo extension resources");
        }
        catch (InterruptedException e) {
            System.err.println("Interrupted while closing GoGo extension resources.");
            e.printStackTrace();
            throw new ExtensionException("Interrupted while closing GoGo extension resources.");
        }
        this.proc.destroy();
    }

    private String userJavaPath(String defaultJava) {
        int exit = 1;
        try {
            List<String> command = Arrays.asList(defaultJava, "-version");
            Process javaCheck = new ProcessBuilder(command).start();
            exit = javaCheck.waitFor();
        }
        catch (Exception e) {
            System.err.println("Was not able to run java default: " + e.toString());
        }
        if (App$.MODULE$ != null && App$.MODULE$.app() != null && exit != 0) {
            try {
                return FileDialog.showFiles((Frame)App$.MODULE$.app().frame(), (String)"Please locate your java executable", (int)0);
            }
            catch (UserCancelException e) {
                System.out.println("User canceled java location, using default java");
            }
        } else {
            System.out.println("NetLogo is headless, using default java");
        }
        return defaultJava;
    }

    private String javaExecutablePath() {
        String osName = System.getProperty("os.name").toLowerCase();
        System.err.println(osName);
        if (osName.contains("mac")) {
            return this.userJavaPath("/usr/bin/java");
        }
        if (osName.contains("windows")) {
            return this.userJavaPath("java.exe");
        }
        return this.userJavaPath("java");
    }

    private void bootHIDDaemon() throws ExtensionException {
        System.out.println("looking for system java, override by setting property netlogo.extensions.gogo.javaexecutable");
        String executable = System.getProperty(javaLocationPropertyKey);
        if (executable == null) {
            executable = this.javaExecutablePath();
        }
        File gogoFile = new File(HIDGogoExtension.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        Path gogoParentPath = gogoFile.toPath().getParent();
        String gogoExtensionPath = gogoParentPath.toString() + File.separator;
        System.out.println("gogoExtensionPath: " + gogoExtensionPath);
        try {
            String classpath = new File(gogoExtensionPath + "gogo-daemon.jar").getCanonicalPath() + File.pathSeparator + new File(gogoExtensionPath + "hid4java.jar").getCanonicalPath() + File.pathSeparator + new File(gogoExtensionPath + "jna.jar").getCanonicalPath();
            List<String> command = Arrays.asList(executable, "-classpath", classpath, "-showversion", "gogoHID.daemon.HIDGogoDaemon");
            System.out.println("running: " + Arrays.toString(command.toArray()));
            this.proc = new ProcessBuilder(command).start();
            System.setProperty(javaLocationPropertyKey, executable);
            this.stillRunning = true;
            this.os = this.proc.getOutputStream();
            this.is = this.proc.getInputStream();
            this.err = this.proc.getErrorStream();
            System.out.println("Booted daemon!");
            new Thread(){

                @Override
                public void run() {
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(HIDGogoExtension.this.err));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            System.err.println(line);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    try {
                        HIDGogoExtension.this.proc.waitFor();
                        HIDGogoExtension.this.stillRunning = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
        catch (Exception e) {
            System.out.println("ERROR BOOTING DAEMON:");
            System.out.println(e.getClass());
            System.out.println(e.getMessage());
            e.printStackTrace();
            throw new ExtensionException("Couldn't boot daemon");
        }
    }

    private void sendMessage(byte[] bytes) throws ExtensionException {
        try {
            if (!this.stillRunning) {
                this.bootHIDDaemon();
            }
            this.os.write(83);
            this.os.write(bytes.length);
            this.os.write(bytes);
            this.os.flush();
        }
        catch (IOException e) {
            throw new ExtensionException("Couldn't write message to daemon");
        }
    }

    private byte[] receiveMessage(int numBytes) throws ExtensionException, UnsuccessfulReadOperation {
        try {
            if (!this.stillRunning) {
                this.bootHIDDaemon();
            }
            this.os.write(82);
            this.os.write(numBytes);
            this.os.flush();
            byte[] data = new byte[numBytes];
            this.is.read(data);
            return data;
        }
        catch (IOException e) {
            throw new ExtensionException("Couldn't write message to daemon");
        }
    }

    private int numAttached() throws ExtensionException {
        try {
            if (!this.stillRunning) {
                this.bootHIDDaemon();
            }
            this.os.write(78);
            this.os.flush();
            return this.is.read();
        }
        catch (IOException e) {
            throw new ExtensionException("Couldn't write message to daemon");
        }
    }

    public String byteToHex(byte b) {
        char[] hexChars = new char[2];
        int v = b & 0xFF;
        hexChars[0] = hexArray[v >>> 4];
        hexChars[1] = hexArray[v & 0xF];
        return new String(hexChars);
    }

    private class Enumerate
    implements Reporter {
        private Enumerate() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.NumberType());
        }

        public Object report(Argument[] arg0, Context arg1) throws ExtensionException, LogoException {
            return (double)HIDGogoExtension.this.numAttached();
        }
    }

    private class ReadAll
    implements Reporter {
        private ReadAll() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.ListType());
        }

        public Object report(Argument[] arg0, Context arg1) throws ExtensionException, LogoException {
            LogoListBuilder llb = new LogoListBuilder();
            try {
                byte[] data = HIDGogoExtension.this.receiveMessage(64);
                for (int i = 0; i < data.length; ++i) {
                    llb.add((Object)HIDGogoExtension.this.byteToHex(data[i]));
                }
            }
            catch (UnsuccessfulReadOperation e) {
                System.err.println("Couldn't read from gogo board");
            }
            return llb.toLogoList();
        }
    }

    private class SendBytes
    implements Command {
        private SendBytes() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.ListType()});
        }

        public void perform(Argument[] args, Context ctx) throws ExtensionException, LogoException {
            LogoList messageList = args[0].getList();
            byte[] message = new byte[64];
            for (int i = 0; i < messageList.size() && i < 64; ++i) {
                Object val = messageList.get(i);
                int v = (Integer)val;
                message[i] = (byte)v;
            }
            HIDGogoExtension.this.sendMessage(message);
        }
    }

    private class SetServo
    implements Command {
        private SetServo() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.NumberType()});
        }

        public void perform(Argument[] args, Context ctx) throws ExtensionException, LogoException {
            int dutyLevel = args[0].getIntValue();
            byte[] message = new byte[64];
            message[0] = 0;
            message[1] = 9;
            message[2] = 0;
            message[3] = 0;
            message[4] = (byte)dutyLevel;
            HIDGogoExtension.this.sendMessage(message);
        }
    }

    private class OutputPortCounterClockwise
    implements Command {
        private OutputPortCounterClockwise() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax();
        }

        public void perform(Argument[] arg0, Context arg1) throws ExtensionException, LogoException {
            byte[] message = new byte[64];
            message[0] = 0;
            message[1] = 3;
            message[2] = 0;
            message[3] = 0;
            HIDGogoExtension.this.sendMessage(message);
        }
    }

    private class OutputPortClockwise
    implements Command {
        private OutputPortClockwise() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax();
        }

        public void perform(Argument[] arg0, Context arg1) throws ExtensionException, LogoException {
            byte[] message = new byte[64];
            message[0] = 0;
            message[1] = 3;
            message[2] = 0;
            message[3] = 1;
            HIDGogoExtension.this.sendMessage(message);
        }
    }

    private class OutputPortOff
    implements Command {
        private OutputPortOff() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax();
        }

        public void perform(Argument[] args, Context ctx) throws ExtensionException, LogoException {
            byte[] message = new byte[64];
            message[0] = 0;
            message[1] = 2;
            message[2] = 0;
            message[3] = 0;
            HIDGogoExtension.this.sendMessage(message);
        }
    }

    private class OutputPortOn
    implements Command {
        private OutputPortOn() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax();
        }

        public void perform(Argument[] args, Context ctx) throws ExtensionException, LogoException {
            byte[] message = new byte[64];
            message[0] = 0;
            message[1] = 2;
            message[2] = 0;
            message[3] = 1;
            HIDGogoExtension.this.sendMessage(message);
        }
    }

    private class SetOutputPortPower
    implements Command {
        private SetOutputPortPower() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.NumberType()});
        }

        public void perform(Argument[] args, Context ctx) throws ExtensionException, LogoException {
            int outputPortPowerVal = args[0].getIntValue();
            byte[] message = new byte[64];
            message[0] = 0;
            message[1] = 6;
            message[2] = 0;
            message[3] = 0;
            message[4] = (byte)outputPortPowerVal;
            HIDGogoExtension.this.sendMessage(message);
        }
    }

    private class TalkToOutputPort
    implements Command {
        private TalkToOutputPort() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.ListType()});
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            Iterator iter = args[0].getList().javaIterator();
            int outputPortMask = 0;
            while (iter.hasNext()) {
                Object val = iter.next();
                switch (val.toString().toLowerCase().charAt(0)) {
                    case 'A': 
                    case 'a': {
                        outputPortMask |= 1;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        outputPortMask |= 2;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        outputPortMask |= 4;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        outputPortMask |= 8;
                    }
                }
            }
            byte[] message = new byte[64];
            message[0] = 0;
            message[1] = 7;
            message[2] = (byte)outputPortMask;
            message[3] = 0;
            HIDGogoExtension.this.sendMessage(message);
        }
    }

    private class LED
    implements Command {
        private LED() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.NumberType()});
        }

        public void perform(Argument[] args, Context arg1) throws ExtensionException, LogoException {
            byte[] message = new byte[64];
            boolean turnOn = args[0].getIntValue() == 1;
            message[0] = 0;
            message[1] = 10;
            message[2] = 0;
            message[3] = turnOn ? (byte)1 : 0;
            HIDGogoExtension.this.sendMessage(message);
        }
    }

    private class Beep
    implements Command {
        private Beep() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax();
        }

        public void perform(Argument[] arg0, Context arg1) throws ExtensionException, LogoException {
            byte[] message = new byte[64];
            message[0] = 0;
            message[1] = 11;
            message[2] = 0;
            message[3] = 0;
            HIDGogoExtension.this.sendMessage(message);
        }
    }

    private class ReadSensorNumber
    implements Reporter {
        private ReadSensorNumber() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.NumberType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context arg1) throws ExtensionException, LogoException {
            int sensorNumber = args[0].getIntValue();
            if (sensorNumber > 8 || sensorNumber < 1) {
                throw new ExtensionException("Sensor Number must be between 1 and 8 (inclusive).  You entered " + sensorNumber);
            }
            Short sensorReading = 0;
            try {
                byte[] data = HIDGogoExtension.this.receiveMessage(64);
                ByteBuffer bb = ByteBuffer.wrap(data, 2 * (sensorNumber - 1) + 1, 2);
                bb.order(ByteOrder.BIG_ENDIAN);
                sensorReading = bb.getShort();
            }
            catch (UnsuccessfulReadOperation e) {
                System.err.println("Couldn't read from gogo board");
            }
            return sensorReading.doubleValue();
        }
    }

    private class ReadSensors
    implements Reporter {
        private ReadSensors() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.ListType());
        }

        public Object report(Argument[] arg0, Context arg1) throws ExtensionException, LogoException {
            short[] sensors = new short[8];
            try {
                byte[] data = HIDGogoExtension.this.receiveMessage(64);
                for (int index = 0; index < 8; ++index) {
                    ByteBuffer bb = ByteBuffer.wrap(data, 2 * index + 1, 2);
                    bb.order(ByteOrder.BIG_ENDIAN);
                    sensors[index] = bb.getShort();
                }
            }
            catch (UnsuccessfulReadOperation e) {
                System.err.println("Couldn't read from gogo board");
            }
            LogoListBuilder llb = new LogoListBuilder();
            for (int i = 0; i < sensors.length; ++i) {
                llb.add((Object)sensors[i]);
            }
            return llb.toLogoList();
        }
    }

    private class Prims
    implements Reporter {
        private Prims() {
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.ListType());
        }

        public Object report(Argument[] arg0, Context arg1) throws ExtensionException, LogoException {
            LogoListBuilder llb = new LogoListBuilder();
            llb.add((Object)"primitives <this command, returns prims listing>");
            llb.add((Object)"----reading (inputs)---");
            llb.add((Object)"read-sensors {returns all 8 sensor values in a list}");
            llb.add((Object)"read-sensor <number> {number should be between 1 and 8 inclusive}");
            llb.add((Object)"----writing (outputs)---");
            llb.add((Object)"beep");
            llb.add((Object)"led <0 off 1 on> {refers to the user LED (yellow)");
            llb.add((Object)"talk-to-output-ports <List of output letter(s) to talk to> {e.g, [\"A\"] for port A, [\"A\" \"B\" \"D\" ] for ports A, B, and D}");
            llb.add((Object)"set-output-port-power <power value 0-100 for current output-port (see talk-to-output-ports)> {0 = full off; 100 = full on.  Sets board value to <power>% of 255.}");
            llb.add((Object)"output-port-on {turns current output-port (see talk-to-output-ports) on}");
            llb.add((Object)"output-port-off {turns current output-port (see talk-to-output-ports) off}");
            llb.add((Object)"output-port-clockwise {makes current output-port (see talk-to-output-ports) go clockwise}");
            llb.add((Object)"output-port-counterclockwise {makes current output-port (see talk-to-output-ports) go counterclockwise}");
            llb.add((Object)"set-servo <position> {makes current servo (see talk-to-output-ports) move to position <position> 0-255}");
            llb.add((Object)"----utility functions---");
            llb.add((Object)"read-all <returns entire byte sequence of HID device's status message> {converts to byte digits to hex strings}");
            llb.add((Object)"send-bytes <sends any byte sequence to the gogo> {list of integers will get padded out with zeroes.}");
            llb.add((Object)"howmany-gogos <returns number of HID gogos currently connected>");
            return llb.toLogoList();
        }
    }

    private class OldCommand
    implements Command {
        private Syntax syntax;
        private String primitiveName;

        private OldCommand(String primitiveName, Syntax syntax) {
            this.syntax = syntax;
            this.primitiveName = primitiveName;
        }

        public Syntax getSyntax() {
            return this.syntax;
        }

        public void perform(Argument[] args, Context context) throws ExtensionException {
            HIDGogoExtension.this.alertToNewGogoBoards(this.primitiveName);
        }
    }

    private class OldReporter
    implements Reporter {
        private Syntax syntax;
        private String primitiveName;

        private OldReporter(String primitiveName, Syntax syntax) {
            this.syntax = syntax;
            this.primitiveName = primitiveName;
        }

        public Syntax getSyntax() {
            return this.syntax;
        }

        public Object report(Argument[] args, Context context) throws ExtensionException {
            HIDGogoExtension.this.alertToNewGogoBoards(this.primitiveName);
            return null;
        }
    }

    private class UnsuccessfulReadOperation
    extends Exception {
        private UnsuccessfulReadOperation() {
        }
    }
}

