/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.openimaj.audio.AudioStream;
import org.openimaj.content.animation.animator.LinearTimeBasedIntegerValueAnimator;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.Image;
import org.openimaj.video.Video;
import org.openimaj.video.VideoDisplay;
import org.openimaj.video.VideoDisplayListener;
import org.openimaj.video.VideoDisplayStateListener;
import org.openimaj.video.VideoPlayer;
import org.openimaj.video.timecode.HrsMinSecFrameTimecode;

public class VideoPlayer<T extends Image<?, T>>
extends VideoDisplay<T>
implements VideoDisplayStateListener {
    private JFrame frame = null;
    private VideoPlayerComponent component = null;

    public VideoPlayer(Video<T> v) {
        this(v, null, new DisplayUtilities.ImageComponent());
    }

    public VideoPlayer(Video<T> v, AudioStream audio) {
        this(v, audio, new DisplayUtilities.ImageComponent());
    }

    protected VideoPlayer(Video<T> v, AudioStream audio, DisplayUtilities.ImageComponent screen) {
        super(v, audio, screen);
        screen.setSize(v.getWidth(), v.getHeight());
        screen.setPreferredSize(new Dimension(v.getWidth(), v.getHeight()));
        screen.setAllowZoom(false);
        screen.setAllowPanning(false);
        screen.setTransparencyGrid(false);
        screen.setShowPixelColours(false);
        screen.setShowXYPosition(false);
        this.component = new VideoPlayerComponent(screen);
        this.component.setShowButtons(false);
        this.addVideoDisplayStateListener(this);
    }

    public static <T extends Image<?, T>> VideoPlayer<T> createVideoPlayer(Video<T> video) {
        VideoPlayer<T> vp = new VideoPlayer<T>(video);
        new Thread(vp).start();
        return vp;
    }

    public static <T extends Image<?, T>> VideoPlayer<T> createVideoPlayer(Video<T> video, AudioStream audio) {
        VideoPlayer<T> vp = new VideoPlayer<T>(video, audio);
        new Thread(vp).start();
        return vp;
    }

    public JFrame showFrame() {
        if (this.frame == null) {
            this.frame = new JFrame();
            this.frame.add(this.component);
            this.frame.pack();
        }
        this.frame.setVisible(true);
        return this.frame;
    }

    public JPanel getVideoPlayerPanel() {
        return this.component;
    }

    public void play() {
        this.setMode(VideoDisplay.Mode.PLAY);
    }

    public void stop() {
        this.setMode(VideoDisplay.Mode.STOP);
    }

    public void pause() {
        this.setMode(VideoDisplay.Mode.PAUSE);
    }

    public void stepBack() {
    }

    public void stepForward() {
    }

    @Override
    public void videoStopped(VideoDisplay<?> v) {
        this.component.updateButtonStates();
    }

    @Override
    public void videoPlaying(VideoDisplay<?> v) {
        this.component.updateButtonStates();
    }

    @Override
    public void videoPaused(VideoDisplay<?> v) {
        this.component.updateButtonStates();
    }

    @Override
    public void videoStateChanged(VideoDisplay.Mode mode, VideoDisplay<?> v) {
    }

    public void setButtons(String[] buttons) {
        this.component.bp.setButtons(buttons);
    }

    protected class VideoPlayerComponent
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private org.openimaj.video.VideoPlayer$VideoPlayerComponent.ButtonsPanel bp = null;
        private boolean showButtons = true;
        private VideoDisplay.Mode currentMode = VideoDisplay.Mode.PLAY;
        private LinearTimeBasedIntegerValueAnimator animator = null;
        private org.openimaj.video.VideoPlayer$VideoPlayerComponent.AnimatorThread animatorThread = null;

        public VideoPlayerComponent(DisplayUtilities.ImageComponent ic) {
            try {
                this.init(ic);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }

        private void init(DisplayUtilities.ImageComponent ic) throws SecurityException, NoSuchMethodException {
            this.setLayout(null);
            this.bp = new ButtonsPanel();
            this.add((Component)this.bp);
            this.add((Component)ic);
            this.setPreferredSize(ic.getSize());
            this.setSize(ic.getSize());
            this.bp.setBounds(0, this.getHeight() - this.bp.getSize().height, this.getWidth(), this.bp.getSize().height);
            this.showButtons = true;
            MouseAdapter ma = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    VideoPlayerComponent.this.setShowButtons(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!VideoPlayerComponent.this.getVisibleRect().contains(e.getPoint())) {
                        VideoPlayerComponent.this.setShowButtons(false);
                    }
                }
            };
            ic.addMouseListener((MouseListener)ma);
            this.bp.addMouseListener(ma);
        }

        public void updateButtonStates() {
            if (this.currentMode != VideoPlayer.this.getMode()) {
                this.showButtons = true;
                switch (VideoPlayer.this.getMode()) {
                    case PLAY: {
                        break;
                    }
                    case STOP: {
                        break;
                    }
                    case PAUSE: {
                        break;
                    }
                }
                this.currentMode = VideoPlayer.this.getMode();
            }
        }

        public void setShowButtons(boolean tf) {
            if (tf != this.showButtons) {
                if (this.animatorThread != null) {
                    this.animatorThread.stopNow = true;
                    this.animatorThread = null;
                }
                this.animator = new LinearTimeBasedIntegerValueAnimator(this.bp.getBounds().y, this.getHeight() - (tf ? this.bp.getSize().height : 0), 500L);
                this.animatorThread = new AnimatorThread(tf);
                new Thread((Runnable)this.animatorThread).start();
                this.showButtons = tf;
            }
        }

        public class AnimatorThread
        implements Runnable {
            public boolean stopNow = false;
            public boolean buttonValue;

            public AnimatorThread(boolean tf) {
                this.buttonValue = tf;
            }

            @Override
            public void run() {
                while (!this.stopNow && VideoPlayerComponent.this.animator != null && !VideoPlayerComponent.this.animator.isComplete()) {
                    VideoPlayerComponent.this.bp.setBounds(((VideoPlayerComponent)VideoPlayerComponent.this).bp.getBounds().x, (Integer)VideoPlayerComponent.this.animator.nextValue(), ((VideoPlayerComponent)VideoPlayerComponent.this).bp.getBounds().width, ((VideoPlayerComponent)VideoPlayerComponent.this).bp.getBounds().height);
                    try {
                        Thread.sleep(40L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.stopNow) {
                    VideoPlayerComponent.this.showButtons = this.buttonValue;
                }
            }
        }

        protected class ButtonsPanel
        extends JPanel
        implements VideoDisplayListener<T> {
            private static final long serialVersionUID = 1L;
            private static final String PLAY = "/play.png";
            private static final String STOP = "/stop.png";
            private static final String PAUSE = "/pause.png";
            private static final String STEP_BACK = "/step-backward.png";
            private static final String STEP_FORWARD = "/step-forward.png";
            private final Map<String, String> buttonsMap = new HashMap<String, String>();
            private String[] buttons = null;
            private Method[] methods = null;
            private final int inset = 2;
            private final JProgressBar progress = new JProgressBar(0, 100);
            private BufferedImage img = null;
            private final JLabel label = new JLabel("0:00:00/0:00:00");

            public ButtonsPanel() {
                this.buttonsMap.put("play", PLAY);
                this.buttonsMap.put("stop", STOP);
                this.buttonsMap.put("pause", PAUSE);
                this.buttonsMap.put("stepBack", STEP_BACK);
                this.buttonsMap.put("stepForward", STEP_FORWARD);
                try {
                    this.img = ImageIO.read(this.getClass().getResource("/brushed-metal.png"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.setButtons(new String[]{"pause", "play", "stop"});
                this.setPreferredSize(new Dimension((100 + this.inset) * this.buttons.length, 100 + this.inset));
                this.setSize(this.getPreferredSize());
                VideoPlayer.this.addVideoListener(this);
            }

            public void setButtons(String[] buttons) {
                this.buttons = buttons;
                ArrayList<Method> methodsList = new ArrayList<Method>();
                for (String button : buttons) {
                    if (this.buttonsMap.get(button) == null) continue;
                    try {
                        methodsList.add(VideoPlayer.this.getClass().getMethod(button, new Class[0]));
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                }
                this.methods = methodsList.toArray(new Method[0]);
                this.init();
            }

            private void init() {
                this.removeAll();
                this.setLayout(new GridBagLayout());
                this.setOpaque(false);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.fill = 2;
                gbc.weighty = 0.0;
                gbc.weightx = 0.0;
                gbc.gridy = 1;
                gbc.gridx = 1;
                gbc.insets = new Insets(this.inset, this.inset, this.inset, this.inset);
                gbc.gridy = 0;
                gbc.weightx = 1.0;
                gbc.gridwidth = this.buttons.length;
                this.add((Component)this.progress, gbc);
                this.progress.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        System.out.println("Clicked at " + e.getX());
                        VideoPlayer.this.setPosition(e.getX() * 100 / ButtonsPanel.this.getWidth());
                    }
                });
                JPanel buttonsPanel = new JPanel(new GridBagLayout());
                buttonsPanel.setBorder(BorderFactory.createEmptyBorder());
                buttonsPanel.setOpaque(false);
                gbc.weighty = 0.0;
                gbc.weightx = 0.0;
                gbc.gridy = 1;
                gbc.gridx = 1;
                gbc.gridwidth = 1;
                int i = 0;
                while (i < this.buttons.length) {
                    String b = this.buttons[i];
                    ImageIcon buttonIcon = new ImageIcon(this.getClass().getResource(this.buttonsMap.get(b)));
                    final JLabel button = new JLabel(buttonIcon);
                    button.setBorder(BorderFactory.createEmptyBorder());
                    final int j = i++;
                    button.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            try {
                                ButtonsPanel.this.methods[j].invoke((Object)VideoPlayer.this, new Object[0]);
                            }
                            catch (IllegalArgumentException e1) {
                                e1.printStackTrace();
                            }
                            catch (IllegalAccessException e1) {
                                e1.printStackTrace();
                            }
                            catch (InvocationTargetException e1) {
                                e1.printStackTrace();
                            }
                        }

                        @Override
                        public void mouseEntered(MouseEvent e) {
                            button.setBorder(BorderFactory.createLineBorder(Color.yellow));
                        }

                        @Override
                        public void mouseExited(MouseEvent e) {
                            button.setBorder(BorderFactory.createEmptyBorder());
                        }
                    });
                    buttonsPanel.add((Component)button, gbc);
                    ++gbc.gridx;
                }
                buttonsPanel.add((Component)this.label, gbc);
                gbc.gridy = 2;
                gbc.gridx = 1;
                this.add((Component)buttonsPanel, gbc);
            }

            @Override
            public void paint(Graphics g) {
                g.drawImage(this.img, 0, 0, null);
                super.paint(g);
            }

            public void setProgress(double pc) {
                this.progress.setValue((int)pc);
            }

            @Override
            public void afterUpdate(VideoDisplay<T> display) {
                this.setProgress(display.getPosition());
                HrsMinSecFrameTimecode end = new HrsMinSecFrameTimecode(VideoPlayer.this.getVideo().countFrames(), VideoPlayer.this.getVideo().getFPS());
                HrsMinSecFrameTimecode current = new HrsMinSecFrameTimecode(VideoPlayer.this.getVideo().currentFrame, VideoPlayer.this.getVideo().getFPS());
                this.label.setText(current.toString() + " / " + end.toString());
            }

            @Override
            public void beforeUpdate(T frame) {
            }
        }
    }
}

