/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.layout;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import net.sourceforge.jeuclid.layout.GraphicsObject;

public class LineObject
implements GraphicsObject {
    private final float x1;
    private final float y1;
    private final float x2;
    private final float y2;
    private final float width;
    private final Color col;
    private final boolean dash;

    public LineObject(float f, float f2, float f3, float f4, float f5, Color color) {
        this.x1 = f;
        this.y1 = f2;
        this.x2 = f3;
        this.y2 = f4;
        this.width = f5;
        this.col = color;
        this.dash = false;
    }

    public LineObject(float f, float f2, float f3, float f4, float f5, Color color, boolean bl) {
        this.x1 = f;
        this.y1 = f2;
        this.x2 = f3;
        this.y2 = f4;
        this.width = f5;
        this.col = color;
        this.dash = bl;
    }

    public void paint(float f, float f2, Graphics2D graphics2D) {
        graphics2D.setColor(this.col);
        Stroke stroke = graphics2D.getStroke();
        if (this.dash) {
            float f3 = 3.0f * this.width;
            graphics2D.setStroke(new BasicStroke(this.width, 2, 2, this.width, new float[]{f3, f3}, 0.0f));
        } else {
            graphics2D.setStroke(new BasicStroke(this.width));
        }
        graphics2D.draw(new Line2D.Float(f + this.x1, f2 + this.y1, f + this.x2, f2 + this.y2));
        graphics2D.setStroke(stroke);
    }
}

